/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modulesclient;

import mcjty.rftools.api.screens.IClientScreenModule;
import mcjty.rftools.api.screens.IModuleRenderHelper;
import mcjty.rftools.api.screens.ModuleRenderInfo;
import mcjty.rftools.blocks.screens.modules.ItemStackScreenModule;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemStackClientScreenModule
implements IClientScreenModule<ItemStackScreenModule.ModuleDataStacks> {
    private int slot1 = -1;
    private int slot2 = -1;
    private int slot3 = -1;
    private int slot4 = -1;

    @Override
    public IClientScreenModule.TransformMode getTransformMode() {
        return IClientScreenModule.TransformMode.ITEM;
    }

    @Override
    public int getHeight() {
        return 22;
    }

    @Override
    public void render(IModuleRenderHelper renderHelper, FontRenderer fontRenderer, int currenty, ItemStackScreenModule.ModuleDataStacks screenData, ModuleRenderInfo renderInfo) {
        if (screenData == null) {
            return;
        }
        RenderHelper.enableGUIStandardItemLighting();
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.depthMask((boolean)true);
        GlStateManager.enableLighting();
        GlStateManager.enableDepth();
        GlStateManager.pushMatrix();
        float f3 = 0.0075f;
        GlStateManager.translate((float)-0.5f, (float)0.5f, (float)0.06f);
        float factor = renderInfo.factor;
        GlStateManager.scale((float)(f3 * factor), (float)(-f3 * factor), (float)1.0E-4f);
        int x = 10;
        x = this.renderSlot(currenty, screenData, this.slot1, 0, x);
        x = this.renderSlot(currenty, screenData, this.slot2, 1, x);
        x = this.renderSlot(currenty, screenData, this.slot3, 2, x);
        this.renderSlot(currenty, screenData, this.slot4, 3, x);
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)-0.5f, (float)0.5f, (float)0.08f);
        GlStateManager.scale((float)(f3 * factor), (float)(-f3 * factor), (float)1.0E-4f);
        x = 10;
        x = this.renderSlotOverlay(fontRenderer, currenty, screenData, this.slot1, 0, x);
        x = this.renderSlotOverlay(fontRenderer, currenty, screenData, this.slot2, 1, x);
        x = this.renderSlotOverlay(fontRenderer, currenty, screenData, this.slot3, 2, x);
        this.renderSlotOverlay(fontRenderer, currenty, screenData, this.slot4, 3, x);
        GlStateManager.popMatrix();
        GlStateManager.disableLighting();
        RenderHelper.enableStandardItemLighting();
    }

    @Override
    public void mouseClick(World world, int x, int y, boolean clicked) {
    }

    private int renderSlot(int currenty, ItemStackScreenModule.ModuleDataStacks screenData, int slot, int index, int x) {
        if (slot != -1) {
            ItemStack itm = ItemStack.EMPTY;
            try {
                itm = screenData.getStack(index);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!itm.isEmpty()) {
                RenderItem itemRender = Minecraft.getMinecraft().getRenderItem();
                itemRender.renderItemAndEffectIntoGUI(itm, x, currenty);
            }
            x += 30;
        }
        return x;
    }

    private int renderSlotOverlay(FontRenderer fontRenderer, int currenty, ItemStackScreenModule.ModuleDataStacks screenData, int slot, int index, int x) {
        if (slot != -1) {
            ItemStack itm = screenData.getStack(index);
            if (!itm.isEmpty()) {
                ItemStackClientScreenModule.renderItemOverlayIntoGUI(fontRenderer, itm, x, currenty);
            }
            x += 30;
        }
        return x;
    }

    private static void renderItemOverlayIntoGUI(FontRenderer fontRenderer, ItemStack itemStack, int x, int y) {
        if (!itemStack.isEmpty()) {
            int size = itemStack.getCount();
            if (size > 1) {
                String s1 = size < 10000 ? String.valueOf(size) : (size < 1000000 ? String.valueOf(size / 1000) + "k" : (size < 1000000000 ? String.valueOf(size / 1000000) + "m" : String.valueOf(size / 1000000000) + "g"));
                GlStateManager.disableLighting();
                GlStateManager.disableBlend();
                fontRenderer.drawString(s1, x + 19 - 2 - fontRenderer.getStringWidth(s1), y + 6 + 3, 0xFFFFFF);
                GlStateManager.enableLighting();
            }
            if (itemStack.getItem().showDurabilityBar(itemStack)) {
                double health = itemStack.getItem().getDurabilityForDisplay(itemStack);
                int j1 = (int)Math.round(13.0 - health * 13.0);
                int k = (int)Math.round(255.0 - health * 255.0);
                GlStateManager.disableLighting();
                GlStateManager.disableTexture2D();
                GlStateManager.disableAlpha();
                GlStateManager.disableBlend();
                Tessellator tessellator = Tessellator.getInstance();
                int l = 255 - k << 16 | k << 8;
                int i1 = (255 - k) / 4 << 16 | 0x3F00;
                ItemStackClientScreenModule.renderQuad(tessellator, x + 2, y + 13, 13, 2, 0, 0.0);
                ItemStackClientScreenModule.renderQuad(tessellator, x + 2, y + 13, 12, 1, i1, 0.02);
                ItemStackClientScreenModule.renderQuad(tessellator, x + 2, y + 13, j1, 1, l, 0.04);
                GlStateManager.enableAlpha();
                GlStateManager.enableTexture2D();
                GlStateManager.enableLighting();
                GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    private static void renderQuad(Tessellator tessellator, int x, int y, int width, int height, int color, double offset) {
        BufferBuilder buffer = tessellator.getBuffer();
        buffer.begin(7, DefaultVertexFormats.POSITION);
        buffer.pos((double)x, (double)y, offset);
        buffer.pos((double)x, (double)(y + height), offset);
        buffer.pos((double)(x + width), (double)(y + height), offset);
        buffer.pos((double)(x + width), (double)y, offset);
        tessellator.draw();
    }

    @Override
    public void setupFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        if (tagCompound != null) {
            if (tagCompound.hasKey("slot1")) {
                this.slot1 = tagCompound.getInteger("slot1");
            }
            if (tagCompound.hasKey("slot2")) {
                this.slot2 = tagCompound.getInteger("slot2");
            }
            if (tagCompound.hasKey("slot3")) {
                this.slot3 = tagCompound.getInteger("slot3");
            }
            if (tagCompound.hasKey("slot4")) {
                this.slot4 = tagCompound.getInteger("slot4");
            }
        }
    }

    @Override
    public boolean needsServerData() {
        return true;
    }
}

