/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modulesclient;

import mcjty.rftools.api.screens.IClientScreenModule;
import mcjty.rftools.api.screens.IModuleRenderHelper;
import mcjty.rftools.api.screens.ITextRenderHelper;
import mcjty.rftools.api.screens.ModuleRenderInfo;
import mcjty.rftools.api.screens.TextAlign;
import mcjty.rftools.api.screens.data.IModuleDataInteger;
import mcjty.rftools.blocks.screens.modulesclient.helper.ScreenTextHelper;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RedstoneClientScreenModule
implements IClientScreenModule<IModuleDataInteger> {
    private String line = "";
    private String yestext = "on";
    private String notext = "off";
    private int color = 0xFFFFFF;
    private int yescolor = 0xFFFFFF;
    private int nocolor = 0xFFFFFF;
    private int dim = 0;
    private boolean analog = false;
    private ITextRenderHelper labelCache = new ScreenTextHelper();

    @Override
    public IClientScreenModule.TransformMode getTransformMode() {
        return IClientScreenModule.TransformMode.TEXT;
    }

    @Override
    public int getHeight() {
        return 10;
    }

    @Override
    public void render(IModuleRenderHelper renderHelper, FontRenderer fontRenderer, int currenty, IModuleDataInteger screenData, ModuleRenderInfo renderInfo) {
        int col;
        String text;
        int xoffset;
        GlStateManager.disableLighting();
        if (!this.line.isEmpty()) {
            this.labelCache.setup(this.line, 160, renderInfo);
            this.labelCache.renderText(0, currenty, this.color, renderInfo);
            xoffset = 47;
        } else {
            xoffset = 7;
        }
        if (screenData != null) {
            boolean rs;
            int power = screenData.get();
            boolean bl = rs = power > 0;
            text = this.analog ? Integer.toString(power) : (rs ? this.yestext : this.notext);
            col = rs ? this.yescolor : this.nocolor;
        } else {
            text = "<invalid>";
            col = 0xFF0000;
        }
        renderHelper.renderText(xoffset, currenty, col, renderInfo, text);
    }

    @Override
    public void mouseClick(World world, int x, int y, boolean clicked) {
    }

    @Override
    public void setupFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        if (tagCompound != null) {
            this.line = tagCompound.getString("text");
            if (tagCompound.hasKey("yestext")) {
                this.yestext = tagCompound.getString("yestext");
            }
            if (tagCompound.hasKey("notext")) {
                this.notext = tagCompound.getString("notext");
            }
            this.color = tagCompound.hasKey("color") ? tagCompound.getInteger("color") : 0xFFFFFF;
            this.yescolor = tagCompound.hasKey("yescolor") ? tagCompound.getInteger("yescolor") : 0xFFFFFF;
            this.nocolor = tagCompound.hasKey("nocolor") ? tagCompound.getInteger("nocolor") : 0xFFFFFF;
            if (tagCompound.hasKey("align")) {
                String alignment = tagCompound.getString("align");
                this.labelCache.align(TextAlign.get(alignment));
            } else {
                this.labelCache.align(TextAlign.ALIGN_LEFT);
            }
            this.analog = tagCompound.getBoolean("analog");
        }
    }

    @Override
    public boolean needsServerData() {
        return true;
    }
}

