/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modulesclient.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mcjty.lib.gui.events.BlockRenderEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.ColorSelector;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.rftools.api.screens.FormatStyle;
import mcjty.rftools.api.screens.IModuleGuiBuilder;
import mcjty.rftools.blocks.screens.IModuleGuiChanged;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ScreenModuleGuiBuilder
implements IModuleGuiBuilder {
    private Minecraft mc;
    private Gui gui;
    private NBTTagCompound currentData;
    private IModuleGuiChanged moduleGuiChanged;
    private Panel panel;
    private List<Widget<?>> row = new ArrayList();

    public ScreenModuleGuiBuilder(Minecraft mc, Gui gui, NBTTagCompound currentData, IModuleGuiChanged moduleGuiChanged) {
        this.gui = gui;
        this.mc = mc;
        this.moduleGuiChanged = moduleGuiChanged;
        this.currentData = currentData;
        this.panel = new Panel(mc, gui).setLayout((Layout)((VerticalLayout)new VerticalLayout().setVerticalMargin(3)).setSpacing(1));
    }

    @Override
    public NBTTagCompound getCurrentData() {
        return this.currentData;
    }

    @Override
    public World getWorld() {
        return this.mc.player.getEntityWorld();
    }

    public Panel build() {
        this.nl();
        return this.panel;
    }

    @Override
    public ScreenModuleGuiBuilder label(String text) {
        Label label = (Label)new Label(this.mc, this.gui).setText(text);
        this.row.add((Widget<?>)label);
        return this;
    }

    @Override
    public ScreenModuleGuiBuilder leftLabel(String text) {
        Label label = (Label)((Label)new Label(this.mc, this.gui).setText(text)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        this.row.add((Widget<?>)label);
        return this;
    }

    @Override
    public ScreenModuleGuiBuilder text(String tagname, String ... tooltip) {
        TextField textField = ((TextField)((TextField)new TextField(this.mc, this.gui).setDesiredHeight(15)).setTooltips(tooltip)).addTextEvent((parent, newText) -> {
            this.currentData.setString(tagname, newText);
            this.moduleGuiChanged.updateData();
        });
        this.row.add((Widget<?>)textField);
        if (this.currentData != null) {
            textField.setText(this.currentData.getString(tagname));
        }
        return this;
    }

    @Override
    public ScreenModuleGuiBuilder integer(String tagname, String ... tooltip) {
        TextField textField = ((TextField)((TextField)new TextField(this.mc, this.gui).setDesiredHeight(15)).setTooltips(tooltip)).addTextEvent((parent, newText) -> {
            int value;
            try {
                value = Integer.parseInt(newText);
            }
            catch (NumberFormatException e) {
                value = 0;
            }
            this.currentData.setInteger(tagname, value);
            this.moduleGuiChanged.updateData();
        });
        this.row.add((Widget<?>)textField);
        if (this.currentData != null && this.currentData.hasKey(tagname)) {
            int dd = this.currentData.getInteger(tagname);
            textField.setText(Integer.toString(dd));
        }
        return this;
    }

    @Override
    public ScreenModuleGuiBuilder toggle(String tagname, String label, String ... tooltip) {
        ToggleButton toggleButton = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.mc, this.gui).setText(label)).setTooltips(tooltip)).setDesiredHeight(14)).setCheckMarker(true);
        toggleButton.addButtonEvent(parent -> {
            this.currentData.setBoolean(tagname, toggleButton.isPressed());
            this.moduleGuiChanged.updateData();
        });
        this.row.add((Widget<?>)toggleButton);
        if (this.currentData != null) {
            toggleButton.setPressed(this.currentData.getBoolean(tagname));
        }
        return this;
    }

    @Override
    public ScreenModuleGuiBuilder toggleNegative(String tagname, String label, String ... tooltip) {
        ToggleButton toggleButton = ((ToggleButton)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.mc, this.gui).setText(label)).setTooltips(tooltip)).setDesiredHeight(14)).setDesiredWidth(36)).setCheckMarker(true);
        toggleButton.addButtonEvent(parent -> {
            this.currentData.setBoolean(tagname, !toggleButton.isPressed());
            this.moduleGuiChanged.updateData();
        });
        this.row.add((Widget<?>)toggleButton);
        if (this.currentData != null) {
            toggleButton.setPressed(!this.currentData.getBoolean(tagname));
        } else {
            toggleButton.setPressed(true);
        }
        return this;
    }

    @Override
    public ScreenModuleGuiBuilder color(String tagname, String ... tooltip) {
        int currentColor;
        ColorSelector colorSelector = ((ColorSelector)((ColorSelector)((ColorSelector)new ColorSelector(this.mc, this.gui).setTooltips(tooltip)).setDesiredWidth(20)).setDesiredHeight(14)).addChoiceEvent((parent, newColor) -> {
            this.currentData.setInteger(tagname, newColor.intValue());
            this.moduleGuiChanged.updateData();
        });
        this.row.add((Widget<?>)colorSelector);
        if (this.currentData != null && (currentColor = this.currentData.getInteger(tagname)) != 0) {
            colorSelector.setCurrentColor(Integer.valueOf(currentColor));
        }
        return this;
    }

    @Override
    public IModuleGuiBuilder choices(String tagname, String tooltip, String ... choices) {
        String currentChoice;
        ChoiceLabel choiceLabel = (ChoiceLabel)((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.mc, this.gui).setTooltips(new String[]{tooltip})).setDesiredWidth(50)).setDesiredHeight(14);
        for (String s : choices) {
            choiceLabel.addChoices(new String[]{s});
        }
        choiceLabel.addChoiceEvent((parent, newChoice) -> {
            this.currentData.setString(tagname, newChoice);
            this.moduleGuiChanged.updateData();
        });
        this.row.add((Widget<?>)choiceLabel);
        if (this.currentData != null && !(currentChoice = this.currentData.getString(tagname)).isEmpty()) {
            choiceLabel.setChoice(currentChoice);
        }
        return this;
    }

    @Override
    public IModuleGuiBuilder choices(String tagname, IModuleGuiBuilder.Choice ... choices) {
        int currentChoice;
        ChoiceLabel choiceLabel = (ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.mc, this.gui).setDesiredWidth(50)).setDesiredHeight(14);
        HashMap<String, Integer> choicesMap = new HashMap<String, Integer>(choices.length);
        for (int i = 0; i < choices.length; ++i) {
            IModuleGuiBuilder.Choice c = choices[i];
            String name = c.getName();
            choicesMap.put(name, i);
            choiceLabel.addChoices(new String[]{name});
            choiceLabel.setChoiceTooltip(name, c.getTooltips());
        }
        choiceLabel.addChoiceEvent((parent, newChoice) -> {
            this.currentData.setInteger(tagname, ((Integer)choicesMap.get(newChoice)).intValue());
            this.moduleGuiChanged.updateData();
        });
        this.row.add((Widget<?>)choiceLabel);
        if (this.currentData != null && (currentChoice = this.currentData.getInteger(tagname)) < choices.length && currentChoice >= 0) {
            choiceLabel.setChoice(choices[currentChoice].getName());
        }
        return this;
    }

    @Override
    public ScreenModuleGuiBuilder format(String tagname) {
        ChoiceLabel label = ScreenModuleGuiBuilder.setupFormatCombo(this.mc, this.gui, tagname, this.currentData, this.moduleGuiChanged);
        this.row.add((Widget<?>)label);
        return this;
    }

    @Override
    public ScreenModuleGuiBuilder mode(String componentName) {
        ChoiceLabel label = ScreenModuleGuiBuilder.setupModeCombo(this.mc, this.gui, componentName, this.currentData, this.moduleGuiChanged);
        this.row.add((Widget<?>)label);
        return this;
    }

    @Override
    public ScreenModuleGuiBuilder block(String tagnamePos) {
        String monitoring;
        if (this.currentData.hasKey(tagnamePos + "x")) {
            int dim = this.currentData.hasKey(tagnamePos + "dim") ? this.currentData.getInteger(tagnamePos + "dim") : this.currentData.getInteger("dim");
            World world = this.getWorld();
            if (dim == world.provider.getDimension()) {
                int x = this.currentData.getInteger(tagnamePos + "x");
                int y = this.currentData.getInteger(tagnamePos + "y");
                int z = this.currentData.getInteger(tagnamePos + "z");
                monitoring = this.currentData.getString(tagnamePos + "name");
                Block block = world.getBlockState(new BlockPos(x, y, z)).getBlock();
                this.row.add((Widget<?>)new BlockRender(this.mc, this.gui).setRenderItem((Object)block).setDesiredWidth(20));
                this.row.add((Widget<?>)((Label)((Label)new Label(this.mc, this.gui).setText(x + "," + y + "," + z)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setDesiredWidth(150));
            } else {
                monitoring = "<unreachable>";
            }
        } else {
            monitoring = "<not set>";
        }
        this.row.add((Widget<?>)new Label(this.mc, this.gui).setText(monitoring));
        return this;
    }

    @Override
    public IModuleGuiBuilder ghostStack(final String tagname) {
        ItemStack stack = ItemStack.EMPTY;
        if (this.currentData.hasKey(tagname)) {
            stack = new ItemStack(this.currentData.getCompoundTag(tagname));
        }
        final BlockRender blockRender = (BlockRender)((BlockRender)((BlockRender)((BlockRender)new BlockRender(this.mc, this.gui).setRenderItem((Object)stack).setDesiredWidth(18)).setDesiredHeight(18)).setFilledRectThickness(1)).setFilledBackground(-11184811);
        this.row.add((Widget<?>)blockRender);
        blockRender.addSelectionEvent(new BlockRenderEvent(){

            public void select(Widget<?> widget) {
                ItemStack holding = Minecraft.getMinecraft().player.inventory.getItemStack();
                if (holding.isEmpty()) {
                    ScreenModuleGuiBuilder.this.currentData.removeTag(tagname);
                    blockRender.setRenderItem(null);
                } else {
                    ItemStack copy = holding.copy();
                    copy.setCount(1);
                    blockRender.setRenderItem((Object)copy);
                    NBTTagCompound tc = new NBTTagCompound();
                    copy.writeToNBT(tc);
                    ScreenModuleGuiBuilder.this.currentData.setTag(tagname, (NBTBase)tc);
                }
                ScreenModuleGuiBuilder.this.moduleGuiChanged.updateData();
            }

            public void doubleClick(Widget<?> widget) {
            }
        });
        return this;
    }

    @Override
    public ScreenModuleGuiBuilder nl() {
        if (this.row.size() == 1) {
            this.panel.addChild(this.row.get(0).setDesiredHeight(16));
            this.row.clear();
        } else if (!this.row.isEmpty()) {
            Panel rowPanel = (Panel)new Panel(this.mc, this.gui).setLayout((Layout)new HorizontalLayout()).setDesiredHeight(16);
            for (Widget<?> widget : this.row) {
                rowPanel.addChild(widget);
            }
            this.panel.addChild((Widget)rowPanel);
            this.row.clear();
        }
        return this;
    }

    private static ChoiceLabel setupFormatCombo(Minecraft mc, Gui gui, String tagname, NBTTagCompound currentData, IModuleGuiChanged moduleGuiChanged) {
        String modeFull = FormatStyle.MODE_FULL.getName();
        String modeCompact = FormatStyle.MODE_COMPACT.getName();
        String modeCommas = FormatStyle.MODE_COMMAS.getName();
        ChoiceLabel modeButton = ((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(mc, gui).setDesiredWidth(58)).setDesiredHeight(14)).addChoices(new String[]{modeFull, modeCompact, modeCommas}).setChoiceTooltip(modeFull, new String[]{"Full format: 3123555"}).setChoiceTooltip(modeCompact, new String[]{"Compact format: 3.1M"}).setChoiceTooltip(modeCommas, new String[]{"Comma format: 3,123,555"}).addChoiceEvent((parent, newChoice) -> {
            currentData.setString(tagname, FormatStyle.getStyle(newChoice).getName());
            moduleGuiChanged.updateData();
        });
        FormatStyle currentFormat = FormatStyle.getStyle(currentData.getString(tagname));
        modeButton.setChoice(currentFormat.getName());
        return modeButton;
    }

    private static ChoiceLabel setupModeCombo(Minecraft mc, Gui gui, String componentName, NBTTagCompound currentData, IModuleGuiChanged moduleGuiChanged) {
        String modeNone = "None";
        String modePertick = componentName + "/t";
        String modePct = componentName + "%";
        ChoiceLabel modeButton = ((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(mc, gui).setDesiredWidth(50)).setDesiredHeight(14)).addChoices(new String[]{modeNone, componentName, modePertick, modePct}).setChoiceTooltip(modeNone, new String[]{"No text is shown"}).setChoiceTooltip(componentName, new String[]{"Show the amount of " + componentName}).setChoiceTooltip(modePertick, new String[]{"Show the average " + componentName + "/tick", "gain or loss"}).setChoiceTooltip(modePct, new String[]{"Show the amount of " + componentName, "as a percentage"}).addChoiceEvent((parent, newChoice) -> {
            if (componentName.equals(newChoice)) {
                currentData.setBoolean("showdiff", false);
                currentData.setBoolean("showpct", false);
                currentData.setBoolean("hidetext", false);
            } else if (modePertick.equals(newChoice)) {
                currentData.setBoolean("showdiff", true);
                currentData.setBoolean("showpct", false);
                currentData.setBoolean("hidetext", false);
            } else if (modePct.equals(newChoice)) {
                currentData.setBoolean("showdiff", false);
                currentData.setBoolean("showpct", true);
                currentData.setBoolean("hidetext", false);
            } else {
                currentData.setBoolean("showdiff", false);
                currentData.setBoolean("showpct", false);
                currentData.setBoolean("hidetext", true);
            }
            moduleGuiChanged.updateData();
        });
        if (currentData.getBoolean("hidetext")) {
            modeButton.setChoice(modeNone);
        } else if (currentData.getBoolean("showdiff")) {
            modeButton.setChoice(modePertick);
        } else if (currentData.getBoolean("showpct")) {
            modeButton.setChoice(modePct);
        } else {
            modeButton.setChoice(componentName);
        }
        return modeButton;
    }
}

