/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modulesclient.helper;

import mcjty.rftools.api.screens.ITextRenderHelper;
import mcjty.rftools.api.screens.ModuleRenderInfo;
import mcjty.rftools.api.screens.TextAlign;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class ScreenTextHelper
implements ITextRenderHelper {
    private boolean large = false;
    private TextAlign align = TextAlign.ALIGN_LEFT;
    private boolean dirty = true;
    private int textx;
    private String text;
    private boolean truetype = false;

    public int getTextx() {
        return this.textx;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setDirty() {
        this.dirty = true;
    }

    @Override
    public boolean isLarge() {
        return this.large;
    }

    @Override
    public ITextRenderHelper large(boolean large) {
        this.dirty = true;
        this.large = large;
        return this;
    }

    @Override
    public TextAlign getAlign() {
        return this.align;
    }

    @Override
    public ITextRenderHelper align(TextAlign align) {
        this.dirty = true;
        this.align = align;
        return this;
    }

    @Override
    public void setup(String line, int width, ModuleRenderInfo renderInfo) {
        if (!this.dirty && this.truetype == (renderInfo.font != null)) {
            return;
        }
        this.dirty = false;
        boolean bl = this.truetype = renderInfo.font != null;
        if (renderInfo.font != null) {
            this.textx = this.large ? 3 : 7;
            this.text = renderInfo.font.trimStringToWidth(line, (this.large ? width / 2 : width) - this.textx);
            int w = this.large ? (int)((float)width / 2.13f) : (int)((float)width / 1.084f);
            switch (this.align) {
                case ALIGN_LEFT: {
                    break;
                }
                case ALIGN_CENTER: {
                    this.textx += (int)(((float)(w - this.textx) - renderInfo.font.getWidth(this.text)) / 2.0f) / 4;
                    break;
                }
                case ALIGN_RIGHT: {
                    this.textx += (int)((float)(w - this.textx) - renderInfo.font.getWidth(this.text)) / 4;
                }
            }
        } else {
            this.textx = this.large ? 4 : 7;
            FontRenderer fontRenderer = Minecraft.getMinecraft().fontRenderer;
            this.text = fontRenderer.trimStringToWidth(line, (this.large ? width / 8 : width / 4) - this.textx);
            int w = this.large ? (int)((float)width / 8.8f) : (int)((float)width / 4.45f);
            switch (this.align) {
                case ALIGN_LEFT: {
                    break;
                }
                case ALIGN_CENTER: {
                    this.textx += (w - fontRenderer.getStringWidth(this.text)) / 2;
                    break;
                }
                case ALIGN_RIGHT: {
                    this.textx += w - fontRenderer.getStringWidth(this.text);
                }
            }
        }
    }

    @Override
    public void renderText(int x, int y, int color, ModuleRenderInfo renderInfo) {
        if (renderInfo.font != null) {
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            renderInfo.font.drawString((float)(this.textx + x), (float)(128 - y), this.text, 0.25f, 0.25f, -552.0f, new float[]{r, g, b, 1.0f});
        } else {
            FontRenderer fontRenderer = Minecraft.getMinecraft().fontRenderer;
            fontRenderer.drawString(this.text, this.textx + x, y, color);
        }
    }
}

