/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.security;

import java.util.List;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.security.OrphaningCardItem;
import mcjty.rftools.items.GenericRFToolsItem;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.setup.CommandHandler;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class SecurityCardItem
extends GenericRFToolsItem {
    public static String channelNameFromServer = "";
    private static long lastTime = 0L;

    public SecurityCardItem() {
        super("security_card");
        this.setMaxStackSize(1);
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.getTagCompound();
        int channel = -1;
        if (tagCompound != null && tagCompound.hasKey("channel")) {
            channel = tagCompound.getInteger("channel");
        }
        if (channel != -1) {
            if (System.currentTimeMillis() - lastTime > 250L) {
                lastTime = System.currentTimeMillis();
                RFToolsMessages.sendToServer("getSecurityName", TypedMap.builder().put(CommandHandler.PARAM_ID, (Object)channel));
            }
            list.add(TextFormatting.YELLOW + "Channel: " + channel + " (" + channelNameFromServer + ")");
        } else {
            list.add(TextFormatting.YELLOW + "Channel is not set!");
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "Manage security channels in the Security Manager");
            list.add(TextFormatting.WHITE + "and link this card to a channel. Sneak right-click");
            list.add(TextFormatting.WHITE + "a block to link the channel to that block.");
            list.add(TextFormatting.WHITE + "If you want to copy the channel from a block to");
            list.add(TextFormatting.WHITE + "a card you can right click with an unlinked card");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public EnumActionResult onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.getHeldItem(hand);
        if (!world.isRemote) {
            TileEntity te = world.getTileEntity(pos);
            if (te instanceof GenericTileEntity) {
                GenericTileEntity genericTileEntity = (GenericTileEntity)te;
                if (genericTileEntity.getOwnerUUID() == null) {
                    Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "This block has no owner!"));
                } else if (OrphaningCardItem.isPrivileged(player, world) || this.isOwner(player, genericTileEntity)) {
                    NBTTagCompound tagCompound = stack.getTagCompound();
                    if (tagCompound == null || !tagCompound.hasKey("channel")) {
                        int blockSecurity = genericTileEntity.getSecurityChannel();
                        if (blockSecurity == -1) {
                            Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "This security card is not setup correctly!"));
                        } else {
                            if (tagCompound == null) {
                                tagCompound = new NBTTagCompound();
                                stack.setTagCompound(tagCompound);
                            }
                            tagCompound.setInteger("channel", blockSecurity);
                            Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Copied security channel from block to card!"));
                        }
                    } else {
                        int channel = tagCompound.getInteger("channel");
                        this.toggleSecuritySettings(player, genericTileEntity, channel);
                    }
                } else {
                    Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "You cannot change security settings of a block you don't own!"));
                }
            } else {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.RED + "Security is not supported on this block!"));
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.SUCCESS;
    }

    private boolean isOwner(EntityPlayer player, GenericTileEntity genericTileEntity) {
        return genericTileEntity.getOwnerUUID().equals(player.getPersistentID());
    }

    private void toggleSecuritySettings(EntityPlayer player, GenericTileEntity genericTileEntity, int channel) {
        int sec = genericTileEntity.getSecurityChannel();
        if (sec == channel) {
            genericTileEntity.setSecurityChannel(-1);
            Logging.message((EntityPlayer)player, (String)"Security settings cleared from block!");
        } else {
            genericTileEntity.setSecurityChannel(channel);
            Logging.message((EntityPlayer)player, (String)"Security settings applied on block!");
        }
    }
}

