/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.security;

import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.container.SlotType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.rftools.blocks.security.SecurityChannels;
import mcjty.rftools.blocks.security.SecuritySetup;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class SecurityManagerTileEntity
extends GenericTileEntity
implements DefaultSidedInventory {
    public static final String CMD_SETCHANNELNAME = "security.setChannelName";
    public static final Key<String> PARAM_NAME = new Key("name", Type.STRING);
    public static final String CMD_SETMODE = "security.setMode";
    public static final Key<Boolean> PARAM_WHITELIST = new Key("whitelist", Type.BOOLEAN);
    public static final String CMD_ADDPLAYER = "security.addPlayer";
    public static final String CMD_DELPLAYER = "security.delPlayer";
    public static final Key<String> PARAM_PLAYER = new Key("player", Type.STRING);
    public static final int SLOT_CARD = 0;
    public static final int SLOT_LINKER = 1;
    public static final int SLOT_BUFFER = 2;
    public static final ContainerFactory CONTAINER_FACTORY = new ContainerFactory(){

        protected void setup() {
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_SPECIFICITEM, new ItemStack[]{new ItemStack((Item)SecuritySetup.securityCardItem)}), "container", 0, 10, 7, 1, 18, 1, 18);
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_SPECIFICITEM, new ItemStack[]{new ItemStack((Item)SecuritySetup.securityCardItem)}), "container", 1, 42, 7, 1, 18, 1, 18);
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_SPECIFICITEM, new ItemStack[]{new ItemStack((Item)SecuritySetup.securityCardItem)}), "container", 2, 10, 124, 3, 18, 4, 18);
            this.layoutPlayerInventorySlots(74, 124);
        }
    };
    public static final int BUFFER_SIZE = 12;
    public static final int SLOT_PLAYERINV = 14;
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, CONTAINER_FACTORY, 14);

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    private NBTTagCompound getOrCreateNBT(ItemStack cardStack) {
        NBTTagCompound tagCompound = cardStack.getTagCompound();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            cardStack.setTagCompound(tagCompound);
        }
        return tagCompound;
    }

    private void updateCard(ItemStack cardStack) {
        if (this.getWorld().isRemote) {
            return;
        }
        if (cardStack.isEmpty()) {
            return;
        }
        NBTTagCompound tagCompound = this.getOrCreateNBT(cardStack);
        if (!tagCompound.hasKey("channel")) {
            SecurityChannels securityChannels = SecurityChannels.getChannels(this.getWorld());
            int id = securityChannels.newChannel();
            tagCompound.setInteger("channel", id);
            securityChannels.save();
            this.markDirtyClient();
        }
    }

    private void updateLinkedCard() {
        if (this.getWorld().isRemote) {
            return;
        }
        ItemStack masterCard = this.inventoryHelper.getStackInSlot(0);
        if (masterCard.isEmpty()) {
            return;
        }
        ItemStack linkerCard = this.inventoryHelper.getStackInSlot(1);
        if (linkerCard.isEmpty()) {
            return;
        }
        NBTTagCompound masterNBT = masterCard.getTagCompound();
        if (masterNBT == null) {
            return;
        }
        NBTTagCompound linkerNBT = this.getOrCreateNBT(linkerCard);
        linkerNBT.setInteger("channel", masterNBT.getInteger("channel"));
        this.markDirtyClient();
    }

    private void addPlayer(String player) {
        NBTTagCompound tagCompound = this.getCardInfo();
        if (tagCompound == null) {
            return;
        }
        if (tagCompound.hasKey("channel")) {
            SecurityChannels securityChannels = SecurityChannels.getChannels(this.getWorld());
            int id = tagCompound.getInteger("channel");
            SecurityChannels.SecurityChannel channel = securityChannels.getOrCreateChannel(id);
            channel.addPlayer(player);
            securityChannels.save();
            this.markDirtyClient();
        }
    }

    private void delPlayer(String player) {
        NBTTagCompound tagCompound = this.getCardInfo();
        if (tagCompound == null) {
            return;
        }
        if (tagCompound.hasKey("channel")) {
            SecurityChannels securityChannels = SecurityChannels.getChannels(this.getWorld());
            int id = tagCompound.getInteger("channel");
            SecurityChannels.SecurityChannel channel = securityChannels.getOrCreateChannel(id);
            channel.delPlayer(player);
            securityChannels.save();
            this.markDirtyClient();
        }
    }

    private void setWhiteListMode(boolean whitelist) {
        NBTTagCompound tagCompound = this.getCardInfo();
        if (tagCompound == null) {
            return;
        }
        if (tagCompound.hasKey("channel")) {
            SecurityChannels securityChannels = SecurityChannels.getChannels(this.getWorld());
            int id = tagCompound.getInteger("channel");
            SecurityChannels.SecurityChannel channel = securityChannels.getOrCreateChannel(id);
            channel.setWhitelist(whitelist);
            securityChannels.save();
            this.markDirtyClient();
        }
    }

    private void setChannelName(String name) {
        NBTTagCompound tagCompound = this.getCardInfo();
        if (tagCompound == null) {
            return;
        }
        if (tagCompound.hasKey("channel")) {
            SecurityChannels securityChannels = SecurityChannels.getChannels(this.getWorld());
            int id = tagCompound.getInteger("channel");
            SecurityChannels.SecurityChannel channel = securityChannels.getOrCreateChannel(id);
            channel.setName(name);
            securityChannels.save();
            this.markDirtyClient();
        }
    }

    private NBTTagCompound getCardInfo() {
        ItemStack cardStack = this.inventoryHelper.getStackInSlot(0);
        if (cardStack.isEmpty()) {
            return null;
        }
        return this.getOrCreateNBT(cardStack);
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public void setInventorySlotContents(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.getInventoryStackLimit(), index, stack);
        if (index == 0) {
            this.updateCard(stack);
            this.updateLinkedCard();
        } else if (index == 1) {
            this.updateLinkedCard();
        }
    }

    public int getInventoryStackLimit() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return ((Object)((Object)SecuritySetup.securityCardItem)).equals(stack.getItem());
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_SETCHANNELNAME.equals(command)) {
            this.setChannelName((String)params.get(PARAM_NAME));
            return true;
        }
        if (CMD_SETMODE.equals(command)) {
            this.setWhiteListMode((Boolean)params.get(PARAM_WHITELIST));
            return true;
        }
        if (CMD_ADDPLAYER.equals(command)) {
            this.addPlayer((String)params.get(PARAM_PLAYER));
            return true;
        }
        if (CMD_DELPLAYER.equals(command)) {
            this.delPlayer((String)params.get(PARAM_PLAYER));
            return true;
        }
        return false;
    }
}

