/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shaper;

import java.awt.Rectangle;
import java.io.IOException;
import mcjty.lib.base.ModBase;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.shaper.ComposerTileEntity;
import mcjty.rftools.blocks.shaper.ShapeGuiTools;
import mcjty.rftools.items.builder.GuiShapeCard;
import mcjty.rftools.items.builder.ShapeCardItem;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.setup.GuiProxy;
import mcjty.rftools.shapes.IShapeParentGui;
import mcjty.rftools.shapes.PacketSendComposerData;
import mcjty.rftools.shapes.ShapeID;
import mcjty.rftools.shapes.ShapeModifier;
import mcjty.rftools.shapes.ShapeOperation;
import mcjty.rftools.shapes.ShapeRenderer;
import mcjty.rftools.shapes.ShapeRotation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Mouse;

public class GuiComposer
extends GenericGuiContainer<ComposerTileEntity>
implements IShapeParentGui {
    public static final int SIDEWIDTH = 80;
    public static final int SHAPER_WIDTH = 256;
    public static final int SHAPER_HEIGHT = 238;
    private static final ResourceLocation sideBackground = new ResourceLocation("rftools", "textures/gui/sidegui.png");
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/composer.png");
    private static final ResourceLocation guiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");
    private ChoiceLabel[] operationLabels = new ChoiceLabel[9];
    private ChoiceLabel[] rotationLabels = new ChoiceLabel[9];
    private ToggleButton[] flipButtons = new ToggleButton[9];
    private Button[] configButton = new Button[9];
    private Button outConfigButton;
    private ToggleButton showAxis;
    private ToggleButton showOuter;
    private ToggleButton showScan;
    private ShapeRenderer shapeRenderer = null;
    private Window sideWindow;

    public GuiComposer(ComposerTileEntity composerTileEntity, GenericContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)composerTileEntity, (Container)container, GuiProxy.GUI_MANUAL_SHAPE, "composer");
        this.xSize = 256;
        this.ySize = 238;
    }

    private ShapeRenderer getShapeRenderer() {
        if (this.shapeRenderer == null) {
            this.shapeRenderer = new ShapeRenderer(this.getShapeID());
        }
        return this.shapeRenderer;
    }

    private ShapeID getShapeID() {
        Slot slot = this.inventorySlots.getSlot(0);
        ItemStack stack = slot.getHasStack() ? slot.getStack() : ItemStack.EMPTY;
        return new ShapeID(((ComposerTileEntity)this.tileEntity).getWorld().provider.getDimension(), ((ComposerTileEntity)this.tileEntity).getPos(), ShapeCardItem.getScanId(stack), false, ShapeCardItem.isSolid(stack));
    }

    public void initGui() {
        int i;
        int i2;
        super.initGui();
        Panel toplevel = ((Panel)new Panel(this.mc, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout());
        this.getShapeRenderer().initView(this.getPreviewLeft(), this.guiTop + 100);
        ShapeModifier[] modifiers = ((ComposerTileEntity)this.tileEntity).getModifiers();
        this.operationLabels[0] = null;
        for (i2 = 0; i2 < 9; ++i2) {
            this.operationLabels[i2] = new ChoiceLabel(this.mc, (Gui)this).addChoices(new String[]{ShapeOperation.UNION.getCode(), ShapeOperation.SUBTRACT.getCode(), ShapeOperation.INTERSECT.getCode()});
            for (ShapeOperation operation : ShapeOperation.values()) {
                this.operationLabels[i2].setChoiceTooltip(operation.getCode(), new String[]{operation.getDescription()});
            }
            this.operationLabels[i2].setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(55, 7 + i2 * 18, 26, 16));
            this.operationLabels[i2].setChoice(modifiers[i2].getOperation().getCode());
            this.operationLabels[i2].addChoiceEvent((parent, newChoice) -> this.update());
            toplevel.addChild((Widget)this.operationLabels[i2]);
        }
        this.operationLabels[0].setEnabled(false);
        for (i2 = 0; i2 < 9; ++i2) {
            this.configButton[i2] = (Button)((Button)new Button(this.mc, (Gui)this).setText("?")).setChannel("config" + i2);
            this.configButton[i2].setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(3, 7 + i2 * 18 + 2, 13, 12));
            this.configButton[i2].setTooltips(new String[]{"Click to open the card gui"});
            toplevel.addChild((Widget)this.configButton[i2]);
        }
        this.outConfigButton = (Button)((Button)new Button(this.mc, (Gui)this).setText("?")).setChannel("outconfig");
        this.outConfigButton.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(3, 202, 13, 12));
        this.outConfigButton.setTooltips(new String[]{"Click to open the card gui"});
        toplevel.addChild((Widget)this.outConfigButton);
        this.showAxis = ShapeGuiTools.createAxisButton((Gui)this, toplevel, 5, 176);
        this.showOuter = ShapeGuiTools.createBoxButton((Gui)this, toplevel, 31, 176);
        this.showScan = ShapeGuiTools.createScanButton((Gui)this, toplevel, 57, 176);
        toplevel.setBounds(new Rectangle(this.guiLeft, this.guiTop, this.xSize, this.ySize));
        Panel sidePanel = (Panel)new Panel(this.mc, (Gui)this).setLayout((Layout)new PositionalLayout()).setBackground(sideBackground);
        String[] tt = new String[]{"Drag left mouse button to rotate", "Shift drag left mouse to pan", "Use mouse wheel to zoom in/out", "Use middle click to reset rotation"};
        sidePanel.addChild(((Label)((Label)((Label)new Label(this.mc, (Gui)this).setText("E")).setColor(-65536)).setTooltips(tt)).setLayoutHint(5, 175, 15, 15));
        sidePanel.addChild(((Label)((Label)((Label)new Label(this.mc, (Gui)this).setText("W")).setColor(-65536)).setTooltips(tt)).setLayoutHint(40, 175, 15, 15));
        sidePanel.addChild(((Label)((Label)((Label)new Label(this.mc, (Gui)this).setText("U")).setColor(-16729344)).setTooltips(tt)).setLayoutHint(5, 190, 15, 15));
        sidePanel.addChild(((Label)((Label)((Label)new Label(this.mc, (Gui)this).setText("D")).setColor(-16729344)).setTooltips(tt)).setLayoutHint(40, 190, 15, 15));
        sidePanel.addChild(((Label)((Label)((Label)new Label(this.mc, (Gui)this).setText("N")).setColor(-16776961)).setTooltips(tt)).setLayoutHint(5, 205, 15, 15));
        sidePanel.addChild(((Label)((Label)((Label)new Label(this.mc, (Gui)this).setText("S")).setColor(-16776961)).setTooltips(tt)).setLayoutHint(40, 205, 15, 15));
        for (i = 0; i < 9; ++i) {
            ToggleButton flip = (ToggleButton)((ToggleButton)new ToggleButton(this.mc, (Gui)this).setText("Flip")).setCheckMarker(true).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(6, 7 + i * 18, 35, 16));
            flip.setPressed(modifiers[i].isFlipY());
            flip.addButtonEvent(parent -> this.update());
            sidePanel.addChild((Widget)flip);
            this.flipButtons[i] = flip;
            ChoiceLabel rot = (ChoiceLabel)new ChoiceLabel(this.mc, (Gui)this).addChoices(new String[]{"None", "X", "Y", "Z"}).setChoice("None").setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(45, 7 + i * 18, 35, 16));
            rot.setChoice(modifiers[i].getRotation().getCode());
            rot.addChoiceEvent((parent, newChoice) -> this.update());
            sidePanel.addChild((Widget)rot);
            this.rotationLabels[i] = rot;
        }
        sidePanel.setBounds(new Rectangle(this.guiLeft - 80, this.guiTop, 80, this.ySize));
        this.sideWindow = new Window((GuiScreen)this, (AbstractContainerWidget)sidePanel);
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
        for (i = 0; i < 9; ++i) {
            int finalI1 = i;
            this.window.event("config" + i, (source, params) -> this.openCardGui(finalI1));
        }
        this.window.event("outconfig", (source, params) -> this.openCardGui(-1));
    }

    protected void registerWindows(WindowManager mgr) {
        super.registerWindows(mgr);
        mgr.addWindow(this.sideWindow);
    }

    @Override
    public int getPreviewLeft() {
        return this.getGuiLeft();
    }

    @Override
    public int getPreviewTop() {
        return this.getGuiTop();
    }

    private void openCardGui(int i) {
        int slot = i == -1 ? 0 : 1 + i;
        ItemStack cardStack = this.inventorySlots.getSlot(slot).getStack();
        if (!cardStack.isEmpty()) {
            EntityPlayerSP player = Minecraft.getMinecraft().player;
            GuiShapeCard.fromTEPos = ((ComposerTileEntity)this.tileEntity).getPos();
            GuiShapeCard.fromTEStackSlot = slot;
            GuiShapeCard.returnGui = this;
            player.openGui((Object)RFTools.instance, GuiProxy.GUI_SHAPECARD_COMPOSER, player.getEntityWorld(), (int)player.posX, (int)player.posY, (int)player.posZ);
        }
    }

    private void update() {
        ShapeModifier[] modifiers = new ShapeModifier[9];
        for (int i = 0; i < 9; ++i) {
            ShapeOperation op = ShapeOperation.getByName(this.operationLabels[i].getCurrentChoice());
            ShapeRotation rot = ShapeRotation.getByName(this.rotationLabels[i].getCurrentChoice());
            modifiers[i] = new ShapeModifier(op, this.flipButtons[i].isPressed(), rot);
        }
        this.network.sendToServer((IMessage)new PacketSendComposerData(((ComposerTileEntity)this.tileEntity).getPos(), modifiers));
    }

    public void handleMouseInput() throws IOException {
        super.handleMouseInput();
        int x = Mouse.getEventX() * this.width / this.mc.displayWidth;
        int y = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
        this.getShapeRenderer().handleShapeDragging(x -= this.guiLeft, y -= this.guiTop);
    }

    protected void drawGuiContainerBackgroundLayer(float v, int x, int y) {
        ItemStack stack;
        this.getShapeRenderer().handleMouseWheel();
        this.drawWindow();
        Slot slot = this.inventorySlots.getSlot(0);
        if (slot.getHasStack() && !(stack = slot.getStack()).isEmpty()) {
            this.getShapeRenderer().setShapeID(this.getShapeID());
            this.getShapeRenderer().renderShape(this, stack, this.guiLeft, this.guiTop, this.showAxis.isPressed(), this.showOuter.isPressed(), this.showScan.isPressed(), true);
        }
    }
}

