/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shaper;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.shaper.ProjectorTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketProjectorClientNotification
implements IMessage {
    private BlockPos pos;
    private float verticalOffset;
    private float scale;
    private float angle;
    private boolean autoRotate;
    private boolean projecting;
    private boolean scanline;
    private boolean sound;
    private boolean grayscale;
    private int counter;

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
        this.verticalOffset = buf.readFloat();
        this.scale = buf.readFloat();
        this.angle = buf.readFloat();
        this.autoRotate = buf.readBoolean();
        this.projecting = buf.readBoolean();
        this.scanline = buf.readBoolean();
        this.sound = buf.readBoolean();
        this.grayscale = buf.readBoolean();
        this.counter = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        buf.writeFloat(this.verticalOffset);
        buf.writeFloat(this.scale);
        buf.writeFloat(this.angle);
        buf.writeBoolean(this.autoRotate);
        buf.writeBoolean(this.projecting);
        buf.writeBoolean(this.scanline);
        buf.writeBoolean(this.sound);
        buf.writeBoolean(this.grayscale);
        buf.writeInt(this.counter);
    }

    public float getVerticalOffset() {
        return this.verticalOffset;
    }

    public float getScale() {
        return this.scale;
    }

    public float getAngle() {
        return this.angle;
    }

    public boolean isAutoRotate() {
        return this.autoRotate;
    }

    public boolean isProjecting() {
        return this.projecting;
    }

    public boolean isScanline() {
        return this.scanline;
    }

    public int getCounter() {
        return this.counter;
    }

    public boolean isSound() {
        return this.sound;
    }

    public boolean isGrayscale() {
        return this.grayscale;
    }

    public PacketProjectorClientNotification() {
    }

    public PacketProjectorClientNotification(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketProjectorClientNotification(ProjectorTileEntity tileEntity) {
        this.pos = tileEntity.getPos();
        this.verticalOffset = tileEntity.getVerticalOffset();
        this.scale = tileEntity.getScale();
        this.angle = tileEntity.getAngle();
        this.autoRotate = tileEntity.isAutoRotate();
        this.projecting = tileEntity.isProjecting();
        this.scanline = tileEntity.isScanline();
        this.sound = tileEntity.isSound();
        this.grayscale = tileEntity.isGrayscale();
        this.counter = tileEntity.getCounter();
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te = RFTools.proxy.getClientWorld().getTileEntity(this.pos);
            if (te instanceof ProjectorTileEntity) {
                ((ProjectorTileEntity)te).updateFromServer(this);
            }
        });
        ctx.setPacketHandled(true);
    }
}

