/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shaper;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.container.SlotType;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftools.blocks.builder.BuilderSetup;
import mcjty.rftools.blocks.shaper.PacketProjectorClientNotification;
import mcjty.rftools.blocks.shaper.ProjectorOpcode;
import mcjty.rftools.blocks.shaper.ProjectorOperation;
import mcjty.rftools.blocks.shaper.ProjectorSounds;
import mcjty.rftools.blocks.shaper.ScannerConfiguration;
import mcjty.rftools.items.builder.ShapeCardItem;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.shapes.RenderData;
import mcjty.rftools.shapes.ShapeID;
import mcjty.rftools.shapes.ShapeRenderer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ProjectorTileEntity
extends GenericEnergyReceiverTileEntity
implements DefaultSidedInventory,
ITickable {
    public static final String CMD_RSSETTINGS = "projector.rsSettings";
    public static final Key<String> PARAM_OPON_N = new Key("opOn_n", Type.STRING);
    public static final Key<String> PARAM_OPON_S = new Key("opOn_s", Type.STRING);
    public static final Key<String> PARAM_OPON_W = new Key("opOn_w", Type.STRING);
    public static final Key<String> PARAM_OPON_E = new Key("opOn_e", Type.STRING);
    public static final List<Key<String>> PARAM_OPON = Arrays.asList(PARAM_OPON_N, PARAM_OPON_S, PARAM_OPON_W, PARAM_OPON_E);
    public static final Key<String> PARAM_OPOFF_N = new Key("opOff_n", Type.STRING);
    public static final Key<String> PARAM_OPOFF_S = new Key("opOff_s", Type.STRING);
    public static final Key<String> PARAM_OPOFF_W = new Key("opOff_w", Type.STRING);
    public static final Key<String> PARAM_OPOFF_E = new Key("opOff_e", Type.STRING);
    public static final List<Key<String>> PARAM_OPOFF = Arrays.asList(PARAM_OPOFF_N, PARAM_OPOFF_S, PARAM_OPOFF_W, PARAM_OPOFF_E);
    public static final Key<Double> PARAM_VALON_N = new Key("valOn_n", Type.DOUBLE);
    public static final Key<Double> PARAM_VALON_S = new Key("valOn_s", Type.DOUBLE);
    public static final Key<Double> PARAM_VALON_W = new Key("valOn_w", Type.DOUBLE);
    public static final Key<Double> PARAM_VALON_E = new Key("valOn_e", Type.DOUBLE);
    public static final List<Key<Double>> PARAM_VALON = Arrays.asList(PARAM_VALON_N, PARAM_VALON_S, PARAM_VALON_W, PARAM_VALON_E);
    public static final Key<Double> PARAM_VALOFF_N = new Key("valOff_n", Type.DOUBLE);
    public static final Key<Double> PARAM_VALOFF_S = new Key("valOff_s", Type.DOUBLE);
    public static final Key<Double> PARAM_VALOFF_W = new Key("valOff_w", Type.DOUBLE);
    public static final Key<Double> PARAM_VALOFF_E = new Key("valOff_e", Type.DOUBLE);
    public static final List<Key<Double>> PARAM_VALOFF = Arrays.asList(PARAM_VALOFF_N, PARAM_VALOFF_S, PARAM_VALOFF_W, PARAM_VALOFF_E);
    public static final String CMD_SETTINGS = "projector.settings";
    public static final Key<Integer> PARAM_SCALE = new Key("scale", Type.INTEGER);
    public static final Key<Integer> PARAM_OFFSET = new Key("offset", Type.INTEGER);
    public static final Key<Integer> PARAM_ANGLE = new Key("angle", Type.INTEGER);
    public static final Key<Boolean> PARAM_AUTO = new Key("auto", Type.BOOLEAN);
    public static final Key<Boolean> PARAM_SCAN = new Key("scan", Type.BOOLEAN);
    public static final Key<Boolean> PARAM_SOUND = new Key("sound", Type.BOOLEAN);
    public static final Key<Boolean> PARAM_GRAY = new Key("gray", Type.BOOLEAN);
    public static final int SLOT_CARD = 0;
    public static final ContainerFactory CONTAINER_FACTORY = new ContainerFactory(){

        protected void setup() {
            this.addSlot(new SlotDefinition(SlotType.SLOT_SPECIFICITEM, new ItemStack[]{new ItemStack((Item)BuilderSetup.shapeCardItem)}), "container", 0, 15, 7);
            this.layoutPlayerInventorySlots(85, 142);
        }
    };
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, CONTAINER_FACTORY, 1);
    private ShapeRenderer shapeRenderer = null;
    private ProjectorOperation[] operations = new ProjectorOperation[4];
    private boolean active = false;
    private float verticalOffset = 0.2f;
    private float scale = 0.01f;
    private float angle = 0.0f;
    private boolean autoRotate = false;
    private boolean projecting = false;
    private boolean scanline = true;
    private boolean sound = true;
    private boolean grayscale = false;
    private int counter = 0;
    private boolean scanNeeded = false;
    private boolean doNotifyClients = false;

    public ProjectorTileEntity() {
        super((long)ScannerConfiguration.PROJECTOR_MAXENERGY.get(), (long)ScannerConfiguration.PROJECTOR_RECEIVEPERTICK.get());
        for (int i = 0; i < this.operations.length; ++i) {
            this.operations[i] = new ProjectorOperation();
        }
        for (ProjectorOperation operation : this.operations) {
            operation.setOpcodeOn(ProjectorOpcode.NONE);
            operation.setValueOn(null);
            operation.setOpcodeOff(ProjectorOpcode.NONE);
            operation.setValueOff(null);
        }
        this.operations[0].setOpcodeOn(ProjectorOpcode.ON);
        this.operations[0].setOpcodeOff(ProjectorOpcode.ON);
    }

    public void update() {
        if (!this.getWorld().isRemote) {
            this.updateOperations(false);
            boolean a = this.active;
            if (a && this.getStoredPower() < (long)ScannerConfiguration.PROJECTOR_USEPERTICK.get()) {
                a = false;
            }
            if (a != this.projecting) {
                this.projecting = a;
                this.markForNotification();
            }
            if (this.projecting) {
                this.consumeEnergy(ScannerConfiguration.PROJECTOR_USEPERTICK.get());
            }
            if (this.doNotifyClients) {
                this.doNotifyClients = false;
                this.notifyClients();
            }
        } else {
            if (this.scanNeeded) {
                this.scanNeeded = false;
                RenderData data = ShapeRenderer.getRenderDataAndCreate(this.getShapeID());
                data.setWantData(true);
            }
            if (this.autoRotate) {
                this.angle += 1.0f;
                if (this.angle >= 360.0f) {
                    this.angle = 0.0f;
                }
            }
        }
    }

    public void invalidate() {
        super.invalidate();
        if (this.getWorld().isRemote) {
            this.stopSounds();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void stopSounds() {
        ProjectorSounds.stopSound(this.getPos());
    }

    public ShapeID getShapeID() {
        int scanId = ShapeCardItem.getScanId(this.getRenderStack());
        boolean isSolid = ShapeCardItem.isSolid(this.getRenderStack());
        if (scanId == 0) {
            return new ShapeID(this.getWorld().provider.getDimension(), this.getPos(), scanId, this.isGrayscale(), isSolid);
        }
        return new ShapeID(0, null, scanId, this.isGrayscale(), isSolid);
    }

    public void setPowerInput(int powered) {
        boolean changed = this.powerLevel != powered;
        super.setPowerInput(powered);
        if (changed) {
            this.updateOperations(true);
        }
    }

    private void updateOperations(boolean pulse) {
        for (EnumFacing facing : EnumFacing.HORIZONTALS) {
            int index = facing.ordinal() - 2;
            ProjectorOperation op = this.operations[index];
            int pl = index ^ 1;
            if ((this.powerLevel >> pl & 1) != 0) {
                this.handleOpcode(op.getOpcodeOn(), op.getValueOn(), pulse);
                continue;
            }
            this.handleOpcode(op.getOpcodeOff(), op.getValueOff(), pulse);
        }
    }

    private void handleOpcode(ProjectorOpcode op, @Nullable Double val, boolean pulse) {
        if (op == null) {
            op = ProjectorOpcode.NONE;
        }
        switch (op) {
            case NONE: {
                break;
            }
            case ON: {
                this.setActive(true);
                break;
            }
            case OFF: {
                this.setActive(false);
                break;
            }
            case SCAN: {
                if (!pulse) break;
                ++this.counter;
                this.markForNotification();
                break;
            }
            case OFFSET: {
                double o = this.getOffsetDouble();
                if (val == null || !(Math.abs(o - val) > 0.3)) break;
                o = o < val ? (o += 1.0) : (o -= 1.0);
                this.setOffsetInt(o);
                this.markForNotification();
                break;
            }
            case ROT: {
                int o = this.getAngleInt();
                if (val == null || (double)o == val) break;
                o = (double)o < val ? ++o : --o;
                this.setAngleInt(o);
                this.markForNotification();
                break;
            }
            case SCALE: {
                double o = this.getScaleDouble();
                if (val == null || !(Math.abs(o - val) > 0.3)) break;
                o = o < val ? (o += 1.0) : (o -= 1.0);
                this.setScaleInt(o);
                this.markForNotification();
                break;
            }
            case GRAYON: {
                this.grayscale = true;
                this.markForNotification();
                break;
            }
            case GRAYOFF: {
                this.grayscale = false;
                this.markForNotification();
            }
        }
    }

    private void setActive(boolean a) {
        if (a == this.active) {
            return;
        }
        this.active = a;
        this.markDirtyQuick();
    }

    public ProjectorOperation[] getOperations() {
        return this.operations;
    }

    public int getCounter() {
        return this.counter;
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return stack.getItem() == BuilderSetup.shapeCardItem;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.verticalOffset = tagCompound.hasKey("offs") ? tagCompound.getFloat("offs") : 0.2f;
        this.scale = tagCompound.hasKey("scale") ? tagCompound.getFloat("scale") : 0.01f;
        this.angle = tagCompound.hasKey("angle") ? tagCompound.getFloat("angle") : 0.0f;
        this.autoRotate = tagCompound.getBoolean("rot");
        this.scanline = tagCompound.getBoolean("scan");
        this.sound = tagCompound.getBoolean("sound");
        boolean gs = tagCompound.getBoolean("grayscale");
        if (gs != this.grayscale) {
            this.grayscale = gs;
            this.shapeRenderer = null;
            this.scanNeeded = true;
        }
        this.projecting = tagCompound.getBoolean("projecting");
        this.active = tagCompound.getBoolean("active");
        this.counter = tagCompound.getInteger("counter");
        for (EnumFacing facing : EnumFacing.HORIZONTALS) {
            if (!tagCompound.hasKey("op_" + facing.getName())) continue;
            int index = facing.ordinal() - 2;
            ProjectorOperation op = this.operations[index];
            NBTTagCompound tc = (NBTTagCompound)tagCompound.getTag("op_" + facing.getName());
            String on = tc.getString("on");
            Double von = null;
            if (tc.hasKey("von")) {
                von = tc.getDouble("von");
            }
            String off = tc.getString("off");
            Double voff = null;
            if (tc.hasKey("voff")) {
                voff = tc.getDouble("voff");
            }
            op.setOpcodeOn(ProjectorOpcode.getByCode(on));
            op.setOpcodeOff(ProjectorOpcode.getByCode(off));
            op.setValueOn(von);
            op.setValueOff(voff);
        }
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.setFloat("offs", this.verticalOffset);
        tagCompound.setFloat("scale", this.scale);
        tagCompound.setFloat("angle", this.angle);
        tagCompound.setBoolean("rot", this.autoRotate);
        tagCompound.setBoolean("scan", this.scanline);
        tagCompound.setBoolean("sound", this.sound);
        tagCompound.setBoolean("grayscale", this.grayscale);
        tagCompound.setBoolean("projecting", this.projecting);
        tagCompound.setBoolean("active", this.active);
        tagCompound.setInteger("counter", this.counter);
        for (EnumFacing facing : EnumFacing.HORIZONTALS) {
            int index = facing.ordinal() - 2;
            ProjectorOperation op = this.operations[index];
            NBTTagCompound tc = new NBTTagCompound();
            tc.setString("on", op.getOpcodeOn().getCode());
            if (op.getValueOn() != null) {
                tc.setDouble("von", op.getValueOn().doubleValue());
            }
            tc.setString("off", op.getOpcodeOff().getCode());
            if (op.getValueOff() != null) {
                tc.setDouble("voff", op.getValueOff().doubleValue());
            }
            tagCompound.setTag("op_" + facing.getName(), (NBTBase)tc);
        }
    }

    public float getVerticalOffset() {
        return this.verticalOffset;
    }

    public int getOffsetInt() {
        return (int)this.getOffsetDouble();
    }

    private float getOffsetDouble() {
        return this.verticalOffset * 20.0f;
    }

    private void setOffsetInt(double o) {
        this.verticalOffset = (float)(o / 20.0);
    }

    public float getScale() {
        return this.scale;
    }

    public int getScaleInt() {
        return (int)this.getScaleDouble();
    }

    private double getScaleDouble() {
        return 20.0 * Math.log((this.scale - 0.001f) / 0.1f * 147.4131f + 1.0f);
    }

    private void setScaleInt(double s) {
        this.scale = ((float)Math.exp(s / 20.0) - 1.0f) / 147.4131f * 0.1f + 0.001f;
    }

    public float getAngle() {
        return this.angle;
    }

    public int getAngleInt() {
        return (int)this.angle;
    }

    private void setAngleInt(int a) {
        this.angle = a;
    }

    public boolean isAutoRotate() {
        return this.autoRotate;
    }

    public boolean isScanline() {
        return this.scanline;
    }

    public boolean isSound() {
        return this.sound;
    }

    public boolean isGrayscale() {
        return this.grayscale;
    }

    public boolean isProjecting() {
        return this.projecting;
    }

    public ItemStack getRenderStack() {
        return this.inventoryHelper.getStackInSlot(0);
    }

    public ShapeRenderer getShapeRenderer() {
        if (this.shapeRenderer == null) {
            this.shapeRenderer = new ShapeRenderer(this.getShapeID());
        }
        return this.shapeRenderer;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.pos.add(-5, 0, -5), this.pos.add(6, 5, 6));
    }

    private void markForNotification() {
        this.markDirtyQuick();
        this.doNotifyClients = true;
    }

    private void notifyClients() {
        int dimension = this.getWorld().provider.getDimension();
        double x = this.getPos().getX();
        double y = this.getPos().getY();
        double z = this.getPos().getZ();
        double sqradius = 1600.0;
        for (EntityPlayerMP player : this.getWorld().getMinecraftServer().getPlayerList().getPlayers()) {
            double d2;
            double d1;
            double d0;
            if (player.dimension != dimension || !((d0 = x - player.posX) * d0 + (d1 = y - player.posY) * d1 + (d2 = z - player.posZ) * d2 < sqradius)) continue;
            RFToolsMessages.INSTANCE.sendTo((IMessage)new PacketProjectorClientNotification(this), player);
        }
    }

    public void updateFromServer(PacketProjectorClientNotification message) {
        this.verticalOffset = message.getVerticalOffset();
        this.scale = message.getScale();
        this.angle = message.getAngle();
        this.autoRotate = message.isAutoRotate();
        this.projecting = message.isProjecting();
        this.scanline = message.isScanline();
        this.sound = message.isSound();
        if (this.grayscale != message.isGrayscale()) {
            this.grayscale = message.isGrayscale();
            this.shapeRenderer = null;
            this.scanNeeded = true;
        }
        if (this.counter != message.getCounter()) {
            this.counter = message.getCounter();
            this.scanNeeded = true;
        }
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_RSSETTINGS.equals(command)) {
            for (EnumFacing facing : EnumFacing.HORIZONTALS) {
                int idx = facing.ordinal() - 2;
                String opOn = (String)params.get(PARAM_OPON.get(idx));
                String opOff = (String)params.get(PARAM_OPOFF.get(idx));
                Double valOn = (Double)params.get(PARAM_VALON.get(idx));
                Double valOff = (Double)params.get(PARAM_VALOFF.get(idx));
                this.operations[idx].setOpcodeOn(ProjectorOpcode.getByCode(opOn));
                this.operations[idx].setOpcodeOff(ProjectorOpcode.getByCode(opOff));
                this.operations[idx].setValueOn(valOn);
                this.operations[idx].setValueOff(valOff);
            }
            this.markDirtyClient();
            this.updateOperations(false);
            return true;
        }
        if (CMD_SETTINGS.equals(command)) {
            int scaleInt = (Integer)params.get(PARAM_SCALE);
            int offsetInt = (Integer)params.get(PARAM_OFFSET);
            int angleInt = (Integer)params.get(PARAM_ANGLE);
            this.setScaleInt(scaleInt);
            this.setOffsetInt(offsetInt);
            this.setAngleInt(angleInt);
            this.autoRotate = (Boolean)params.get(PARAM_AUTO);
            this.scanline = (Boolean)params.get(PARAM_SCAN);
            this.sound = (Boolean)params.get(PARAM_SOUND);
            this.grayscale = (Boolean)params.get(PARAM_GRAY);
            this.markDirtyClient();
            return true;
        }
        return false;
    }

    public void checkRedstone(World world, BlockPos pos) {
        IBlockState state = world.getBlockState(pos);
        if (state.getBlock() == BuilderSetup.projectorBlock) {
            EnumFacing horiz = OrientationTools.getOrientationHoriz((IBlockState)state);
            EnumFacing north = ProjectorTileEntity.reorient(EnumFacing.NORTH, horiz);
            EnumFacing south = ProjectorTileEntity.reorient(EnumFacing.SOUTH, horiz);
            EnumFacing west = ProjectorTileEntity.reorient(EnumFacing.WEST, horiz);
            EnumFacing east = ProjectorTileEntity.reorient(EnumFacing.EAST, horiz);
            int powered1 = this.getInputStrength(world, pos, north) > 0 ? 1 : 0;
            int powered2 = this.getInputStrength(world, pos, south) > 0 ? 2 : 0;
            int powered3 = this.getInputStrength(world, pos, west) > 0 ? 4 : 0;
            int powered4 = this.getInputStrength(world, pos, east) > 0 ? 8 : 0;
            this.setPowerInput(powered1 + powered2 + powered3 + powered4);
        }
    }

    private static EnumFacing reorient(EnumFacing side, EnumFacing blockDirection) {
        switch (blockDirection) {
            case NORTH: {
                if (side == EnumFacing.DOWN || side == EnumFacing.UP) {
                    return side;
                }
                return side.getOpposite();
            }
            case SOUTH: {
                return side;
            }
            case WEST: {
                if (side == EnumFacing.DOWN || side == EnumFacing.UP) {
                    return side;
                }
                if (side == EnumFacing.WEST) {
                    return EnumFacing.NORTH;
                }
                if (side == EnumFacing.NORTH) {
                    return EnumFacing.EAST;
                }
                if (side == EnumFacing.EAST) {
                    return EnumFacing.SOUTH;
                }
                return EnumFacing.WEST;
            }
            case EAST: {
                if (side == EnumFacing.DOWN || side == EnumFacing.UP) {
                    return side;
                }
                if (side == EnumFacing.WEST) {
                    return EnumFacing.SOUTH;
                }
                if (side == EnumFacing.NORTH) {
                    return EnumFacing.WEST;
                }
                if (side == EnumFacing.EAST) {
                    return EnumFacing.NORTH;
                }
                return EnumFacing.EAST;
            }
        }
        return side;
    }

    private int getInputStrength(World world, BlockPos pos, EnumFacing side) {
        IBlockState blockState;
        Block b;
        int power = world.getRedstonePower(pos.offset(side), side);
        if (power == 0 && (b = (blockState = world.getBlockState(pos.offset(side))).getBlock()) == Blocks.REDSTONE_WIRE) {
            power = world.isBlockPowered(pos.offset(side)) ? 15 : 0;
        }
        return power;
    }
}

