/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shield;

import javax.annotation.Nullable;
import mcjty.rftools.blocks.shield.AbstractShieldBlock;
import mcjty.rftools.blocks.shield.CamoBakedModel;
import mcjty.rftools.blocks.shield.CamoBlockId;
import mcjty.rftools.blocks.shield.CamoProperty;
import mcjty.rftools.blocks.shield.NoTickShieldBlockTileEntity;
import mcjty.rftools.blocks.shield.TickShieldSolidBlockTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CamoShieldBlock
extends AbstractShieldBlock {
    public static final String CAMO = "camo";
    public static final CamoProperty CAMOID = new CamoProperty("camoid");

    public CamoShieldBlock(String registryName, String unlocName, boolean opaque) {
        super(registryName, unlocName, opaque);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        StateMapperBase ignoreState = new StateMapperBase(){

            protected ModelResourceLocation getModelResourceLocation(IBlockState iBlockState) {
                return CamoBakedModel.modelFacade;
            }
        };
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)ignoreState);
    }

    @Override
    public TileEntity createNewTileEntity(World world, int metadata) {
        return new TickShieldSolidBlockTileEntity();
    }

    public boolean isFullBlock(IBlockState state) {
        return false;
    }

    public boolean isFullCube(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    @Override
    public boolean shouldSideBeRendered(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        Block block = world.getBlockState(pos.offset(side)).getBlock();
        return !(block instanceof CamoShieldBlock);
    }

    @Nullable
    protected IBlockState getMimicBlock(IBlockAccess blockAccess, BlockPos pos) {
        TileEntity te = blockAccess.getTileEntity(pos);
        if (te instanceof NoTickShieldBlockTileEntity) {
            return ((NoTickShieldBlockTileEntity)te).getMimicBlock();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void initColorHandler(BlockColors blockColors) {
        blockColors.registerBlockColorHandler((state, world, pos, tintIndex) -> {
            IBlockState mimicBlock = this.getMimicBlock(world, pos);
            return mimicBlock != null ? blockColors.colorMultiplier(mimicBlock, world, pos, tintIndex) : -1;
        }, new Block[]{this});
    }

    protected BlockStateContainer createBlockState() {
        IProperty[] listedProperties = new IProperty[]{};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{CAMOID};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)state;
        IBlockState mimicBlock = this.getMimicBlock(world, pos);
        if (mimicBlock != null) {
            return extendedBlockState.withProperty((IUnlistedProperty)CAMOID, (Object)new CamoBlockId(mimicBlock));
        }
        return extendedBlockState;
    }
}

