/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shield;

import java.util.Collection;
import mcjty.lib.McJtyRegister;
import mcjty.lib.base.ModBase;
import mcjty.lib.blocks.DamageMetadataItemBlock;
import mcjty.rftools.RFTools;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ShieldTemplateBlock
extends Block {
    public static final PropertyEnum<TemplateColor> COLOR = PropertyEnum.create((String)"color", TemplateColor.class);

    public static boolean activateBlock(Block block, World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return block.onBlockActivated(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public static Collection<IProperty<?>> getPropertyKeys(IBlockState state) {
        return state.getPropertyKeys();
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.getItemFromBlock((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_blue", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.getItemFromBlock((Block)this), (int)1, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_red", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.getItemFromBlock((Block)this), (int)2, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_green", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)Item.getItemFromBlock((Block)this), (int)3, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_yellow", "inventory"));
    }

    public ShieldTemplateBlock() {
        super(Material.GLASS);
        this.setTranslationKey("rftools.shield_template_block");
        this.setRegistryName("shield_template_block");
        this.setCreativeTab(RFTools.setup.getTab());
        McJtyRegister.registerLater((Block)this, (ModBase)RFTools.instance, DamageMetadataItemBlock::new);
        this.setDefaultState(this.blockState.getBaseState().withProperty(COLOR, (Comparable)((Object)TemplateColor.BLUE)));
    }

    public boolean isOpaqueCube(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getRenderLayer() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public int damageDropped(IBlockState state) {
        return ((TemplateColor)((Object)state.getValue(COLOR))).ordinal();
    }

    public void getSubBlocks(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (TemplateColor enumdyecolor : TemplateColor.values()) {
            items.add((Object)new ItemStack((Block)this, 1, enumdyecolor.ordinal()));
        }
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(COLOR, (Comparable)((Object)TemplateColor.values()[meta & 3]));
    }

    public int getMetaFromState(IBlockState state) {
        return ((TemplateColor)((Object)state.getValue(COLOR))).ordinal();
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{COLOR});
    }

    public static enum TemplateColor implements IStringSerializable
    {
        BLUE("blue"),
        RED("red"),
        GREEN("green"),
        YELLOW("yellow");

        private final String name;

        private TemplateColor(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

