/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spawner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.varia.EntityTools;
import mcjty.lib.varia.Logging;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class SpawnerConfiguration {
    public static final String CATEGORY_SPAWNER = "spawner";
    public static final String CATEGORY_MOBSPAWNAMOUNTS = "mobspawnamounts";
    public static final String CATEGORY_MOBSPAWNRF = "mobspawnrf";
    public static final String CATEGORY_LIVINGMATTER = "livingmatter";
    public static final Map<String, Integer> mobSpawnRf = new HashMap<String, Integer>();
    public static int defaultMobSpawnRf;
    public static final Map<String, List<MobSpawnAmount>> mobSpawnAmounts;
    public static final List<MobSpawnAmount> defaultSpawnAmounts;
    public static final Map<ResourceLocation, Float> livingMatter;
    public static final int MATERIALTYPE_KEY = 0;
    public static final int MATERIALTYPE_BULK = 1;
    public static final int MATERIALTYPE_LIVING = 2;
    public static int SPAWNER_MAXENERGY;
    public static int SPAWNER_RECEIVEPERTICK;
    public static int BEAMER_MAXENERGY;
    public static int BEAMER_RECEIVEPERTICK;
    public static int beamRfPerObject;
    public static int beamBlocksPerSend;
    public static int maxBeamDistance;
    public static int maxMatterStorage;

    public static void init(Configuration cfg) {
        cfg.addCustomCategoryComment(CATEGORY_SPAWNER, "Settings for the spawner system");
        cfg.addCustomCategoryComment(CATEGORY_MOBSPAWNAMOUNTS, "Amount of materials needed to spawn mobs");
        cfg.addCustomCategoryComment(CATEGORY_MOBSPAWNRF, "Amount of RF needed to spawn mobs");
        cfg.addCustomCategoryComment(CATEGORY_LIVINGMATTER, "Blocks and items that are seen as living for the spawner");
        SPAWNER_MAXENERGY = cfg.get(CATEGORY_SPAWNER, "spawnerMaxRF", SPAWNER_MAXENERGY, "Maximum RF storage that the spawner can hold").getInt();
        SPAWNER_RECEIVEPERTICK = cfg.get(CATEGORY_SPAWNER, "spawnerRFPerTick", SPAWNER_RECEIVEPERTICK, "RF per tick that the spawner can receive").getInt();
        BEAMER_MAXENERGY = cfg.get(CATEGORY_SPAWNER, "beamerMaxRF", BEAMER_MAXENERGY, "Maximum RF storage that the matter beamer can hold").getInt();
        BEAMER_RECEIVEPERTICK = cfg.get(CATEGORY_SPAWNER, "beamerRFPerTick", BEAMER_RECEIVEPERTICK, "RF per tick that the matter beamer can receive").getInt();
        beamRfPerObject = cfg.get(CATEGORY_SPAWNER, "beamerRfPerSend", beamRfPerObject, "RF per tick that the matter beamer will use for sending over a single object").getInt();
        beamBlocksPerSend = cfg.get(CATEGORY_SPAWNER, "beamerBlocksPerSend", beamBlocksPerSend, "The amount of blocks that the matter beamer will use send in one operation (every 20 ticks)").getInt();
        maxMatterStorage = cfg.get(CATEGORY_SPAWNER, "spawnerMaxMatterStorage", maxMatterStorage, "The maximum amount of energized matter that this spawner can store (per type)").getInt();
        maxBeamDistance = cfg.get(CATEGORY_SPAWNER, "maxBeamDistance", maxBeamDistance, "The maximum distance that a laser can travel between the beamer and the spawner").getInt();
        SpawnerConfiguration.readLivingConfig(cfg);
        defaultMobSpawnRf = 10000;
        defaultSpawnAmounts.add(new MobSpawnAmount(new ItemStack(Items.DIAMOND), 1.0f));
        defaultSpawnAmounts.add(new MobSpawnAmount(new ItemStack(Blocks.DIRT), 20.0f));
        defaultSpawnAmounts.add(new MobSpawnAmount(ItemStack.EMPTY, 120.0f));
        if (cfg.getCategory(CATEGORY_MOBSPAWNAMOUNTS).isEmpty()) {
            SpawnerConfiguration.setupInitialMobSpawnConfig(cfg);
        }
    }

    private static void readLivingConfig(Configuration cfg) {
        ConfigCategory category = cfg.getCategory(CATEGORY_LIVINGMATTER);
        if (category.isEmpty()) {
            SpawnerConfiguration.setupInitialLivingConfig(cfg);
        }
        for (Map.Entry entry : category.entrySet()) {
            String[] value = ((Property)entry.getValue()).getStringList();
            try {
                String name = value[1];
                Float factor = Float.valueOf(Float.parseFloat(value[2]));
                livingMatter.put(new ResourceLocation(name), factor);
            }
            catch (Exception e) {
                Logging.logError((String)"Badly formatted 'livingmatter' configuration option!");
                return;
            }
        }
    }

    private static void setupInitialLivingConfig(Configuration cfg) {
        int counter = 0;
        counter = SpawnerConfiguration.addLiving(cfg, (Block)Blocks.LEAVES, counter, 0.5f);
        counter = SpawnerConfiguration.addLiving(cfg, (Block)Blocks.LEAVES2, counter, 0.5f);
        counter = SpawnerConfiguration.addLiving(cfg, Blocks.SAPLING, counter, 0.5f);
        counter = SpawnerConfiguration.addLiving(cfg, Blocks.HAY_BLOCK, counter, 1.5f);
        counter = SpawnerConfiguration.addLiving(cfg, Blocks.MELON_BLOCK, counter, 1.0f);
        counter = SpawnerConfiguration.addLiving(cfg, (Block)Blocks.CACTUS, counter, 0.4f);
        counter = SpawnerConfiguration.addLiving(cfg, (Block)Blocks.RED_FLOWER, counter, 0.3f);
        counter = SpawnerConfiguration.addLiving(cfg, (Block)Blocks.YELLOW_FLOWER, counter, 0.3f);
        counter = SpawnerConfiguration.addLiving(cfg, Blocks.CHORUS_FLOWER, counter, 1.1f);
        counter = SpawnerConfiguration.addLiving(cfg, (Block)Blocks.BROWN_MUSHROOM, counter, 0.4f);
        counter = SpawnerConfiguration.addLiving(cfg, (Block)Blocks.RED_MUSHROOM, counter, 0.4f);
        counter = SpawnerConfiguration.addLiving(cfg, Blocks.PUMPKIN, counter, 0.9f);
        counter = SpawnerConfiguration.addLiving(cfg, Blocks.VINE, counter, 0.4f);
        counter = SpawnerConfiguration.addLiving(cfg, Blocks.WATERLILY, counter, 0.4f);
        counter = SpawnerConfiguration.addLiving(cfg, Blocks.COCOA, counter, 0.8f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.APPLE, counter, 1.0f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.WHEAT, counter, 1.1f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.WHEAT_SEEDS, counter, 0.4f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.POTATO, counter, 1.5f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.CARROT, counter, 1.5f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.PUMPKIN_SEEDS, counter, 0.4f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.MELON_SEEDS, counter, 0.4f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.BEEF, counter, 1.5f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.PORKCHOP, counter, 1.5f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.MUTTON, counter, 1.5f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.CHICKEN, counter, 1.5f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.RABBIT, counter, 1.2f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.RABBIT_FOOT, counter, 1.0f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.RABBIT_HIDE, counter, 0.5f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.BEETROOT, counter, 0.8f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.BEETROOT_SEEDS, counter, 0.4f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.CHORUS_FRUIT, counter, 1.5f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.FISH, counter, 1.5f);
        counter = SpawnerConfiguration.addLiving(cfg, Items.REEDS, counter, 1.0f);
    }

    private static int addLiving(Configuration cfg, Block block, int counter, float factor) {
        cfg.get(CATEGORY_LIVINGMATTER, "living." + counter, new String[]{"B", block.getRegistryName().toString(), Float.toString(factor)});
        return counter + 1;
    }

    private static int addLiving(Configuration cfg, Item item, int counter, float factor) {
        cfg.get(CATEGORY_LIVINGMATTER, "living." + counter, new String[]{"I", item.getRegistryName().toString(), Float.toString(factor)});
        return counter + 1;
    }

    public static void readMobSpawnAmountConfig(Configuration cfg) {
        String key;
        ConfigCategory category = cfg.getCategory(CATEGORY_MOBSPAWNAMOUNTS);
        for (Map.Entry entry : category.entrySet()) {
            key = (String)entry.getKey();
            String[] splitted = ((Property)entry.getValue()).getStringList();
            int materialType = key.endsWith(".spawnamount.0") ? 0 : (key.endsWith(".spawnamount.1") ? 1 : 2);
            String id = key.substring(0, key.indexOf(".spawnamount"));
            SpawnerConfiguration.setSpawnAmounts(id, materialType, splitted);
        }
        category = cfg.getCategory(CATEGORY_MOBSPAWNRF);
        for (Map.Entry entry : category.entrySet()) {
            key = (String)entry.getKey();
            int rf = ((Property)entry.getValue()).getInt();
            mobSpawnRf.put(key, rf);
        }
    }

    private static void setupInitialMobSpawnConfig(Configuration cfg) {
        SpawnerConfiguration.addMobSpawnRF(cfg, EntityBat.class, 100);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityBat.class, 0, (Object)Items.FEATHER, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityBat.class, 1, (Object)Blocks.DIRT, 0, 0.2f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityBat.class, 2, null, 0, 10.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntityBlaze.class, 1000);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityBlaze.class, 0, (Object)Items.BLAZE_ROD, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityBlaze.class, 1, (Object)Blocks.NETHERRACK, 0, 0.5f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityBlaze.class, 2, null, 0, 30.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntityCaveSpider.class, 500);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityCaveSpider.class, 0, (Object)Items.STRING, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityCaveSpider.class, 1, (Object)Blocks.DIRT, 0, 0.2f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityCaveSpider.class, 2, null, 0, 10.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntityChicken.class, 500);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityChicken.class, 0, (Object)Items.FEATHER, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityChicken.class, 1, (Object)Blocks.DIRT, 0, 0.2f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityChicken.class, 2, null, 0, 15.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntityCow.class, 800);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityCow.class, 0, (Object)Items.LEATHER, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityCow.class, 1, (Object)Blocks.DIRT, 0, 0.2f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityCow.class, 2, null, 0, 20.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntityCreeper.class, 800);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityCreeper.class, 0, (Object)Items.GUNPOWDER, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityCreeper.class, 1, (Object)Blocks.DIRT, 0, 0.5f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityCreeper.class, 2, null, 0, 20.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntityDragon.class, 100000);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityDragon.class, 0, (Object)Items.EXPERIENCE_BOTTLE, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityDragon.class, 1, (Object)Blocks.END_STONE, 0, 100.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityDragon.class, 2, null, 0, 200.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntityEnderman.class, 2000);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityEnderman.class, 0, (Object)Items.ENDER_PEARL, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityEnderman.class, 1, (Object)Blocks.END_STONE, 0, 0.5f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityEnderman.class, 2, null, 0, 40.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntityGhast.class, 2000);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityGhast.class, 0, (Object)Items.GHAST_TEAR, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityGhast.class, 1, (Object)Blocks.NETHERRACK, 0, 1.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityGhast.class, 2, null, 0, 50.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntityHorse.class, 1000);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityHorse.class, 0, (Object)Items.LEATHER, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityHorse.class, 1, (Object)Blocks.DIRT, 0, 0.5f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityHorse.class, 2, null, 0, 30.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntityIronGolem.class, 2000);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityIronGolem.class, 0, (Object)Items.IRON_INGOT, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityIronGolem.class, 1, (Object)Blocks.DIRT, 0, 6.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityIronGolem.class, 2, (Object)Blocks.RED_FLOWER, 0, 0.5f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntityMagmaCube.class, 600);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityMagmaCube.class, 0, (Object)Items.MAGMA_CREAM, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityMagmaCube.class, 1, (Object)Blocks.NETHERRACK, 0, 0.2f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityMagmaCube.class, 2, null, 0, 10.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntityMooshroom.class, 800);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityMooshroom.class, 0, (Object)Items.LEATHER, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityMooshroom.class, 1, (Object)Blocks.DIRT, 0, 1.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityMooshroom.class, 2, null, 0, 20.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntityOcelot.class, 800);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityOcelot.class, 0, (Object)Items.FISH, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityOcelot.class, 1, (Object)Blocks.DIRT, 0, 1.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityOcelot.class, 2, null, 0, 20.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntityPig.class, 800);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityPig.class, 0, (Object)Items.LEATHER, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityPig.class, 1, (Object)Blocks.DIRT, 0, 0.2f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityPig.class, 2, null, 0, 20.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntitySheep.class, 800);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntitySheep.class, 0, (Object)Blocks.WOOL, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntitySheep.class, 1, (Object)Blocks.DIRT, 0, 0.2f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntitySheep.class, 2, null, 0, 20.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntitySkeleton.class, 800);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntitySkeleton.class, 0, (Object)Items.BONE, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntitySkeleton.class, 1, (Object)Blocks.DIRT, 0, 0.5f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntitySkeleton.class, 2, null, 0, 20.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntitySlime.class, 600);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntitySlime.class, 0, (Object)Items.SLIME_BALL, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntitySlime.class, 1, (Object)Blocks.DIRT, 0, 0.5f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntitySlime.class, 2, null, 0, 15.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntitySnowman.class, 600);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntitySnowman.class, 0, (Object)Items.SNOWBALL, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntitySnowman.class, 1, (Object)Blocks.DIRT, 0, 1.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntitySnowman.class, 2, null, 0, 15.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntitySpider.class, 500);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntitySpider.class, 0, (Object)Items.STRING, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntitySpider.class, 1, (Object)Blocks.DIRT, 0, 0.2f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntitySpider.class, 2, null, 0, 15.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntitySquid.class, 500);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntitySquid.class, 0, (Object)Items.DYE, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntitySquid.class, 1, (Object)Blocks.DIRT, 0, 0.5f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntitySquid.class, 2, null, 0, 10.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntityVillager.class, 2000);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityVillager.class, 0, (Object)Items.BOOK, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityVillager.class, 1, (Object)Blocks.DIRT, 0, 5.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityVillager.class, 2, null, 0, 30.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntityWitch.class, 1200);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityWitch.class, 0, (Object)Items.GLASS_BOTTLE, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityWitch.class, 1, (Object)Blocks.DIRT, 0, 1.0f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityWitch.class, 2, null, 0, 30.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntityWither.class, 20000);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityWither.class, 0, (Object)Items.NETHER_STAR, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityWither.class, 1, (Object)Blocks.SOUL_SAND, 0, 0.5f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityWither.class, 2, null, 0, 100.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntityWolf.class, 800);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityWolf.class, 0, (Object)Items.BONE, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityWolf.class, 1, (Object)Blocks.DIRT, 0, 0.5f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityWolf.class, 2, null, 0, 20.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntityPigZombie.class, 1200);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityPigZombie.class, 0, (Object)Items.GOLD_NUGGET, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityPigZombie.class, 1, (Object)Blocks.NETHERRACK, 0, 0.5f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityPigZombie.class, 2, null, 0, 20.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntityZombie.class, 800);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityZombie.class, 0, (Object)Items.ROTTEN_FLESH, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityZombie.class, 1, (Object)Blocks.DIRT, 0, 0.2f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityZombie.class, 2, null, 0, 20.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntityGuardian.class, 1000);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityGuardian.class, 0, (Object)Items.PRISMARINE_SHARD, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityGuardian.class, 1, (Object)Blocks.DIRT, 0, 0.2f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityGuardian.class, 2, null, 0, 30.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntityShulker.class, 600);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityShulker.class, 0, (Object)Items.ENDER_PEARL, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityShulker.class, 1, (Object)Blocks.END_STONE, 0, 0.2f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityShulker.class, 2, null, 0, 20.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntityEndermite.class, 400);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityEndermite.class, 0, (Object)Items.ENDER_PEARL, 0, 0.05f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityEndermite.class, 1, (Object)Blocks.END_STONE, 0, 0.2f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityEndermite.class, 2, null, 0, 10.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntitySilverfish.class, 400);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntitySilverfish.class, 0, (Object)Items.IRON_INGOT, 0, 0.05f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntitySilverfish.class, 1, (Object)Blocks.DIRT, 0, 0.2f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntitySilverfish.class, 2, null, 0, 10.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntityRabbit.class, 300);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityRabbit.class, 0, (Object)Items.RABBIT_STEW, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityRabbit.class, 1, (Object)Blocks.DIRT, 0, 0.2f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityRabbit.class, 2, null, 0, 10.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, EntityPolarBear.class, 1500);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityPolarBear.class, 0, (Object)Items.FISH, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityPolarBear.class, 1, (Object)Blocks.DIRT, 0, 0.2f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, EntityPolarBear.class, 2, null, 0, 20.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "minecraft:wither_skeleton", 1500);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "minecraft:wither_skeleton", 0, (Object)Items.BONE, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "minecraft:wither_skeleton", 1, (Object)Blocks.NETHERRACK, 0, 0.5f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "minecraft:wither_skeleton", 2, null, 0, 30.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "minecraft:stray", 800);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "minecraft:stray", 0, (Object)Items.BONE, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "minecraft:stray", 1, (Object)Blocks.NETHERRACK, 0, 0.5f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "minecraft:stray", 2, null, 0, 20.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "WitherSkeleton", 1500);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "WitherSkeleton", 0, (Object)Items.BONE, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "WitherSkeleton", 1, (Object)Blocks.NETHERRACK, 0, 0.5f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "WitherSkeleton", 2, null, 0, 30.0f);
        SpawnerConfiguration.addMobSpawnRF(cfg, "StraySkeleton", 800);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "StraySkeleton", 0, (Object)Items.BONE, 0, 0.1f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "StraySkeleton", 1, (Object)Blocks.NETHERRACK, 0, 0.5f);
        SpawnerConfiguration.addMobSpawnAmount(cfg, "StraySkeleton", 2, null, 0, 20.0f);
    }

    public static void addMobSpawnRF(Configuration cfg, Class<? extends EntityLiving> clazz, int rf) {
        String id = EntityTools.findEntityIdByClass(clazz);
        SpawnerConfiguration.addMobSpawnRF(cfg, id, rf);
    }

    private static void addMobSpawnRF(Configuration cfg, String name, int rf) {
        cfg.get(CATEGORY_MOBSPAWNRF, name, rf);
    }

    public static void addMobSpawnAmount(Configuration cfg, Class<? extends EntityLiving> clazz, int materialType, Object object, int meta, float amount) {
        String id = EntityTools.findEntityIdByClass(clazz);
        SpawnerConfiguration.addMobSpawnAmount(cfg, id, materialType, object, meta, amount);
    }

    private static void addMobSpawnAmount(Configuration cfg, String id, int materialType, Object object, int meta, float amount) {
        ResourceLocation itemname;
        String type;
        if (object instanceof Item) {
            type = "I";
            itemname = (ResourceLocation)Item.REGISTRY.getNameForObject((Object)((Item)object));
        } else if (object instanceof Block) {
            type = "B";
            itemname = (ResourceLocation)Block.REGISTRY.getNameForObject((Object)((Block)object));
        } else {
            type = "L";
            itemname = null;
        }
        cfg.get(CATEGORY_MOBSPAWNAMOUNTS, id + ".spawnamount." + materialType, new String[]{type, itemname == null ? "" : itemname.toString(), Integer.toString(meta), Float.toString(amount)});
    }

    private static void setSpawnAmounts(String id, int materialType, String[] splitted) {
        float amount;
        int meta;
        ResourceLocation itemname;
        String type;
        try {
            type = splitted[0];
            String n = splitted[1];
            itemname = "".equals(n) ? null : new ResourceLocation(n);
            meta = Integer.parseInt(splitted[2]);
            amount = Float.parseFloat(splitted[3]);
        }
        catch (NumberFormatException e) {
            Logging.logError((String)("Something went wrong parsing the spawnamount setting for '" + id + "'!"));
            return;
        }
        ItemStack stack = ItemStack.EMPTY;
        if ("I".equals(type)) {
            Item item = (Item)Item.REGISTRY.getObject((Object)itemname);
            stack = new ItemStack(item, 1, meta);
        } else if ("B".equals(type)) {
            Block block = (Block)Block.REGISTRY.getObject((Object)itemname);
            stack = new ItemStack(block, 1, meta);
        } else if ("S".equals(type)) {
            // empty if block
        }
        List<MobSpawnAmount> list = mobSpawnAmounts.get(id);
        if (list == null) {
            list = new ArrayList<MobSpawnAmount>(3);
            list.add(null);
            list.add(null);
            list.add(null);
            mobSpawnAmounts.put(id, list);
        }
        list.set(materialType, new MobSpawnAmount(stack, amount));
    }

    static {
        mobSpawnAmounts = new HashMap<String, List<MobSpawnAmount>>();
        defaultSpawnAmounts = new ArrayList<MobSpawnAmount>();
        livingMatter = new HashMap<ResourceLocation, Float>();
        SPAWNER_MAXENERGY = 200000;
        SPAWNER_RECEIVEPERTICK = 2000;
        BEAMER_MAXENERGY = 200000;
        BEAMER_RECEIVEPERTICK = 1000;
        beamRfPerObject = 2000;
        beamBlocksPerSend = 1;
        maxBeamDistance = 8;
        maxMatterStorage = 6400;
    }

    public static class MobSpawnAmount {
        private final ItemStack object;
        private final float amount;

        public MobSpawnAmount(ItemStack object, float amount) {
            this.object = object;
            this.amount = amount;
        }

        public ItemStack getObject() {
            return this.object;
        }

        public float getAmount() {
            return this.amount;
        }

        public Float match(ItemStack stack) {
            if (this.object.isEmpty()) {
                Item item = stack.getItem();
                return livingMatter.get(item.getRegistryName());
            }
            if (stack.isItemEqual(this.object)) {
                return Float.valueOf(1.0f);
            }
            return null;
        }
    }
}

