/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import java.awt.Rectangle;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.container.GhostOutputSlot;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.AbstractWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.ImageLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.storage.ModularStorageConfiguration;
import mcjty.rftools.blocks.storage.ModularStorageContainer;
import mcjty.rftools.blocks.storage.ModularStorageItemContainer;
import mcjty.rftools.blocks.storage.ModularStorageItemInventory;
import mcjty.rftools.blocks.storage.ModularStorageTileEntity;
import mcjty.rftools.blocks.storage.PacketUpdateNBTItemStorage;
import mcjty.rftools.blocks.storage.RemoteStorageItemContainer;
import mcjty.rftools.blocks.storage.RemoteStorageItemInventory;
import mcjty.rftools.blocks.storage.modules.DefaultTypeModule;
import mcjty.rftools.blocks.storage.modules.TypeModule;
import mcjty.rftools.blocks.storage.sorters.ItemSorter;
import mcjty.rftools.craftinggrid.CraftingGridProvider;
import mcjty.rftools.craftinggrid.GuiCraftingGrid;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.setup.CommandHandler;
import mcjty.rftools.setup.GuiProxy;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiModularStorage
extends GenericGuiContainer<ModularStorageTileEntity> {
    public static final int STORAGE_WIDTH = 256;
    public static final String VIEW_LIST = "list";
    public static final String VIEW_COLUMNS = "columns";
    public static final String VIEW_ICONS = "icons";
    private TypeModule typeModule;
    private static final ResourceLocation iconLocationTop = new ResourceLocation("rftools", "textures/gui/modularstoragetop.png");
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/modularstorage.png");
    private static final ResourceLocation guiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");
    private WidgetList itemList;
    private TextField filter;
    private ImageChoiceLabel viewMode;
    private ImageChoiceLabel sortMode;
    private ImageChoiceLabel groupMode;
    private Label amountLabel;
    private Button cycleButton;
    private Button compactButton;
    private GuiCraftingGrid craftingGrid = new GuiCraftingGrid();

    public GuiModularStorage(ModularStorageTileEntity modularStorageTileEntity, ModularStorageContainer container) {
        this(modularStorageTileEntity, (Container)container);
    }

    public GuiModularStorage(RemoteStorageItemContainer container) {
        this(null, (Container)container);
    }

    public GuiModularStorage(ModularStorageItemContainer container) {
        this(null, (Container)container);
    }

    public GuiModularStorage(ModularStorageTileEntity modularStorageTileEntity, Container container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)modularStorageTileEntity, container, GuiProxy.GUI_MANUAL_MAIN, "storage");
        this.xSize = 256;
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.getMinecraft());
        int height = scaledresolution.getScaledHeight();
        this.ySize = height > 510 ? ModularStorageConfiguration.height3.get() : (height > 340 ? ModularStorageConfiguration.height2.get() : ModularStorageConfiguration.height1.get());
        IInventory gridInventory = ((GenericContainer)container).getInventory("grid");
        for (Object o : container.inventorySlots) {
            Slot slot = (Slot)o;
            if (slot.inventory == gridInventory) continue;
            slot.yPos = slot.yPos + this.ySize - ModularStorageConfiguration.height1.get();
        }
    }

    protected void registerWindows(WindowManager mgr) {
        super.registerWindows(mgr);
        mgr.addWindow(this.craftingGrid.getWindow());
    }

    public void initGui() {
        CraftingGridProvider provider;
        super.initGui();
        this.itemList = ((WidgetList)((WidgetList)((WidgetList)new WidgetList(this.mc, (Gui)this).setName("items")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(5, 3, 235, this.ySize - 89))).setNoSelectionMode(true).setUserObject((Object)new Integer(-1))).setLeftMargin(0).setRowheight(-1);
        Slider slider = ((Slider)((Slider)new Slider(this.mc, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(241, 3, 11, this.ySize - 89))).setDesiredWidth(11)).setVertical().setScrollableName("items");
        Panel modePanel = this.setupModePanel();
        this.cycleButton = (Button)((Button)((Button)((Button)((Button)new Button(this.mc, (Gui)this).setName("cycle")).setChannel("cycle")).setText("C")).setTooltips(new String[]{"Cycle to the next storage module"})).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(5, this.ySize - 23, 16, 16));
        Panel toplevel = (Panel)((Panel)((Panel)((Panel)new Panel(this.mc, (Gui)this).setLayout((Layout)new PositionalLayout()).addChild((Widget)this.itemList)).addChild((Widget)slider)).addChild((Widget)modePanel)).addChild((Widget)this.cycleButton);
        toplevel.setBackgrounds(iconLocationTop, iconLocation);
        toplevel.setBackgroundLayout(false, this.ySize - ModularStorageConfiguration.height1.get() + 2);
        if (this.tileEntity == null) {
            ImageLabel hideLabel = new ImageLabel(this.mc, (Gui)this);
            hideLabel.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(4, this.ySize - 26 - 54, 20, 55));
            hideLabel.setImage(guiElements, 32, 32);
            toplevel.addChild((Widget)hideLabel);
        }
        toplevel.setBounds(new Rectangle(this.guiLeft, this.guiTop, this.xSize, this.ySize));
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
        this.window.event("cycle", (source, params) -> this.cycleStorage());
        this.window.event("compact", (source, params) -> this.compact());
        if (ModularStorageConfiguration.autofocusSearch.get()) {
            this.window.setTextFocus((Widget)this.filter);
        }
        BlockPos pos = null;
        if (this.tileEntity != null) {
            provider = (CraftingGridProvider)this.tileEntity;
            pos = ((ModularStorageTileEntity)this.tileEntity).getPos();
        } else if (this.inventorySlots instanceof ModularStorageItemContainer) {
            ModularStorageItemContainer storageItemContainer = (ModularStorageItemContainer)this.inventorySlots;
            provider = storageItemContainer.getCraftingGridProvider();
        } else if (this.inventorySlots instanceof RemoteStorageItemContainer) {
            RemoteStorageItemContainer storageItemContainer = (RemoteStorageItemContainer)this.inventorySlots;
            provider = storageItemContainer.getCraftingGridProvider();
        } else {
            throw new RuntimeException("Should not happen!");
        }
        this.craftingGrid.initGui(this.modBase, this.network, this.mc, this, pos, provider, this.guiLeft, this.guiTop, this.xSize, this.ySize);
        this.sendServerCommand("rftools", "requestGridSync", TypedMap.builder().put(CommandHandler.PARAM_POS, (Object)pos).build());
    }

    private Panel setupModePanel() {
        this.filter = ((TextField)((TextField)new TextField(this.mc, (Gui)this).setLayoutHint(3, 3, 57, 13)).setTooltips(new String[]{"Name based filter for items"})).addTextEvent((parent, newText) -> this.updateSettings());
        this.viewMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.mc, (Gui)this).setLayoutHint(4, 19, 16, 16)).setTooltips(new String[]{"Control how items are shown", "in the view"})).addChoiceEvent((parent, newChoice) -> this.updateSettings());
        this.viewMode.addChoice(VIEW_LIST, "Items are shown in a list view", guiElements, 144, 16);
        this.viewMode.addChoice(VIEW_COLUMNS, "Items are shown in columns", guiElements, 160, 16);
        this.viewMode.addChoice(VIEW_ICONS, "Items are shown with icons", guiElements, 176, 16);
        this.updateTypeModule();
        this.sortMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.mc, (Gui)this).setLayoutHint(23, 19, 16, 16)).setTooltips(new String[]{"Control how items are sorted", "in the view"})).addChoiceEvent((parent, newChoice) -> this.updateSettings());
        for (ItemSorter sorter : this.typeModule.getSorters()) {
            this.sortMode.addChoice(sorter.getName(), sorter.getTooltip(), guiElements, sorter.getU(), sorter.getV());
        }
        this.groupMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel(this.mc, (Gui)this).setLayoutHint(42, 19, 16, 16)).setTooltips(new String[]{"If enabled it will show groups", "based on sorting criterium"})).addChoiceEvent((parent, newChoice) -> this.updateSettings());
        this.groupMode.addChoice("Off", "Don't show groups", guiElements, 208, 0);
        this.groupMode.addChoice("On", "Show groups", guiElements, 224, 0);
        this.amountLabel = new Label(this.mc, (Gui)this);
        this.amountLabel.setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        this.amountLabel.setLayoutHint(16, 40, 66, 12);
        this.amountLabel.setTooltips(new String[]{"Amount of stacks / maximum amount"});
        this.amountLabel.setText("?/?");
        this.compactButton = (Button)((Button)((Button)((Button)((Button)new Button(this.mc, (Gui)this).setName("compact")).setChannel("compact")).setLayoutHint(4, 39, 12, 12)).setText("z")).setTooltips(new String[]{"Compact equal stacks"});
        if (this.tileEntity != null) {
            this.filter.setText(ModularStorageConfiguration.clearSearchOnOpen.get() ? "" : ((ModularStorageTileEntity)this.tileEntity).getFilter());
            this.setViewMode(((ModularStorageTileEntity)this.tileEntity).getViewMode());
            this.setSortMode(((ModularStorageTileEntity)this.tileEntity).getSortMode());
            this.groupMode.setCurrentChoice(((ModularStorageTileEntity)this.tileEntity).isGroupMode() ? 1 : 0);
        } else {
            ItemStack heldItem = Minecraft.getMinecraft().player.getHeldItem(EnumHand.MAIN_HAND);
            if (!heldItem.isEmpty() && heldItem.hasTagCompound()) {
                NBTTagCompound tagCompound = heldItem.getTagCompound();
                this.filter.setText(ModularStorageConfiguration.clearSearchOnOpen.get() ? "" : tagCompound.getString("filter"));
                this.setViewMode(tagCompound.getString("viewMode"));
                this.setSortMode(tagCompound.getString("sortMode"));
                this.groupMode.setCurrentChoice(tagCompound.getBoolean("groupMode") ? 1 : 0);
            }
        }
        return (Panel)((Panel)((Panel)((Panel)new Panel(this.mc, (Gui)this).setLayout((Layout)new PositionalLayout()).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(24, this.ySize - 80, 64, 77))).setFilledRectThickness(-2)).setFilledBackground(StyleConfig.colorListBackground)).addChildren(new Widget[]{this.filter, this.viewMode, this.sortMode, this.groupMode, this.amountLabel, this.compactButton});
    }

    private void setSortMode(String sortMode) {
        int idx = this.sortMode.findChoice(sortMode);
        if (idx == -1) {
            this.sortMode.setCurrentChoice(0);
        } else {
            this.sortMode.setCurrentChoice(idx);
        }
    }

    private void setViewMode(String viewMode) {
        int idx = this.viewMode.findChoice(viewMode);
        if (idx == -1) {
            this.viewMode.setCurrentChoice(VIEW_LIST);
        } else {
            this.viewMode.setCurrentChoice(idx);
        }
    }

    private void cycleStorage() {
        if (this.tileEntity != null) {
            this.window.sendAction(RFToolsMessages.INSTANCE, (GenericTileEntity)((ModularStorageTileEntity)this.tileEntity), "cycle");
        } else {
            this.sendServerCommand("rftools", "cycleStorage");
        }
    }

    private void compact() {
        if (this.tileEntity != null) {
            this.window.sendAction(RFToolsMessages.INSTANCE, (GenericTileEntity)((ModularStorageTileEntity)this.tileEntity), "compact");
        } else {
            this.sendServerCommand("rftools", "compact");
        }
    }

    private void updateSettings() {
        if (this.tileEntity != null) {
            ((ModularStorageTileEntity)this.tileEntity).setSortMode(this.sortMode.getCurrentChoice());
            ((ModularStorageTileEntity)this.tileEntity).setViewMode(this.viewMode.getCurrentChoice());
            ((ModularStorageTileEntity)this.tileEntity).setFilter(this.filter.getText());
            ((ModularStorageTileEntity)this.tileEntity).setGroupMode(this.groupMode.getCurrentChoiceIndex() == 1);
            this.sendServerCommand(RFToolsMessages.INSTANCE, "storage.settings", TypedMap.builder().put(ModularStorageTileEntity.PARAM_SORTMODE, (Object)this.sortMode.getCurrentChoice()).put(ModularStorageTileEntity.PARAM_VIEWMODE, (Object)this.viewMode.getCurrentChoice()).put(ModularStorageTileEntity.PARAM_FILTER, (Object)this.filter.getText()).put(ModularStorageTileEntity.PARAM_GROUPMODE, (Object)(this.groupMode.getCurrentChoiceIndex() == 1 ? 1 : 0)).build());
        } else {
            RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketUpdateNBTItemStorage(TypedMap.builder().put(new Key("sortMode", mcjty.lib.typed.Type.STRING), (Object)this.sortMode.getCurrentChoice()).put(new Key("viewMode", mcjty.lib.typed.Type.STRING), (Object)this.viewMode.getCurrentChoice()).put(new Key("filter", mcjty.lib.typed.Type.STRING), (Object)this.filter.getText()).put(new Key("groupMode", mcjty.lib.typed.Type.BOOLEAN), (Object)(this.groupMode.getCurrentChoiceIndex() == 1 ? 1 : 0)).build()));
        }
    }

    private Slot findEmptySlot() {
        for (Object slotObject : this.inventorySlots.inventorySlots) {
            Slot slot = (Slot)slotObject;
            if (this.tileEntity != null && slot.getSlotIndex() < 3 || slot.getHasStack() && slot.getStack().getCount() != 0) continue;
            return slot;
        }
        return null;
    }

    public boolean isMouseOverSlot(Slot slotIn, int x, int y) {
        if (slotIn.inventory instanceof ModularStorageTileEntity || slotIn.inventory instanceof ModularStorageItemInventory || slotIn.inventory instanceof RemoteStorageItemInventory) {
            Widget widget = this.window.getToplevel().getWidgetAtPosition(x, y);
            if (widget instanceof BlockRender) {
                Object userObject = widget.getUserObject();
                if (userObject instanceof Integer) {
                    Integer slotIndex = (Integer)userObject;
                    return slotIndex.intValue() == slotIn.getSlotIndex();
                }
            } else {
                return super.isMouseOverSlot(slotIn, x, y);
            }
            return false;
        }
        return super.isMouseOverSlot(slotIn, x, y);
    }

    public Slot getSlotAtPosition(int x, int y) {
        Object userObject;
        Widget widget = this.window.getToplevel().getWidgetAtPosition(x, y);
        if (widget != null && (userObject = widget.getUserObject()) instanceof Integer) {
            Integer slotIndex = (Integer)userObject;
            if (slotIndex != -1) {
                return this.inventorySlots.getSlot(slotIndex.intValue());
            }
            return this.findEmptySlot();
        }
        return super.getSlotAtPosition(x, y);
    }

    private void dumpClasses(String name, Object o) {
        Logging.log((String)(name + ":" + o.getClass().getCanonicalName()));
        Class<?>[] classes = o.getClass().getClasses();
        for (Class<?> a : classes) {
            Logging.log((String)("        " + a.getCanonicalName()));
        }
        Logging.log((String)("        Super:" + o.getClass().getGenericSuperclass()));
        for (Type type : o.getClass().getGenericInterfaces()) {
            Logging.log((String)("        type:" + type.getClass().getCanonicalName()));
        }
    }

    protected void mouseClicked(int x, int y, int button) throws IOException {
        Slot slot;
        if ((Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) && (slot = this.getSlotAtPosition(x, y)) != null && slot.getHasStack()) {
            ItemStack stack = slot.getStack();
            Item item = stack.getItem();
            if (item instanceof ItemBlock) {
                Block block = ((ItemBlock)item).getBlock();
                this.dumpClasses("Block", block);
            } else {
                this.dumpClasses("Item", item);
            }
        }
        super.mouseClicked(x, y, button);
        this.craftingGrid.getWindow().mouseClicked(x, y, button);
        if (button == 1 && (slot = this.getSlotAtPosition(x, y)) instanceof GhostOutputSlot) {
            if (this.tileEntity != null) {
                this.window.sendAction(RFToolsMessages.INSTANCE, (GenericTileEntity)((ModularStorageTileEntity)this.tileEntity), "clearGrid");
            } else {
                this.sendServerCommand("rftools", "clearGrid");
            }
        }
    }

    public void handleMouseInput() throws IOException {
        super.handleMouseInput();
        this.craftingGrid.getWindow().handleMouseInput();
    }

    protected void mouseReleased(int x, int y, int state) {
        super.mouseReleased(x, y, state);
        this.craftingGrid.getWindow().mouseMovedOrUp(x, y, state);
    }

    private void updateList() {
        int max;
        int spacing;
        int labelWidth;
        int numcolumns;
        this.itemList.removeChildren();
        if (this.tileEntity != null && !this.inventorySlots.getSlot(0).getHasStack()) {
            this.amountLabel.setText("(empty)");
            this.compactButton.setEnabled(false);
            this.cycleButton.setEnabled(false);
            return;
        }
        this.cycleButton.setEnabled(this.isTabletWithRemote() || this.isRemote());
        String filterText = this.filter.getText().toLowerCase().trim();
        String view = this.viewMode.getCurrentChoice();
        if (VIEW_LIST.equals(view)) {
            numcolumns = 1;
            labelWidth = 210;
            spacing = 5;
        } else if (VIEW_COLUMNS.equals(view)) {
            numcolumns = 2;
            labelWidth = 86;
            spacing = 5;
        } else {
            numcolumns = 12;
            labelWidth = 0;
            spacing = 3;
        }
        ArrayList<Pair> items = new ArrayList<Pair>();
        if (this.tileEntity != null) {
            for (int i = 3; i < ((ModularStorageTileEntity)this.tileEntity).getSizeInventory(); ++i) {
                ItemStack stack = ((ModularStorageTileEntity)this.tileEntity).getStackInSlot(i);
                if (stack.isEmpty()) continue;
                String displayName = stack.getDisplayName();
                if (!filterText.isEmpty() && !displayName.toLowerCase().contains(filterText)) continue;
                items.add(Pair.of((Object)stack, (Object)i));
            }
            max = ((ModularStorageTileEntity)this.tileEntity).getSizeInventory() - 3;
        } else {
            for (int i = 0; i < 300; ++i) {
                Slot slot = this.inventorySlots.getSlot(i);
                ItemStack stack = slot.getStack();
                if (stack.isEmpty()) continue;
                String displayName = stack.getDisplayName();
                if (!filterText.isEmpty() && !displayName.toLowerCase().contains(filterText)) continue;
                items.add(Pair.of((Object)stack, (Object)i));
            }
            ItemStack heldItem = this.mc.player.getHeldItem(EnumHand.MAIN_HAND);
            max = !heldItem.isEmpty() && heldItem.hasTagCompound() ? heldItem.getTagCompound().getInteger("maxSize") : 0;
        }
        this.amountLabel.setText(items.size() + "/" + max);
        this.compactButton.setEnabled(max > 0);
        int sort = this.getCurrentSortMode();
        boolean dogroups = this.groupMode.getCurrentChoiceIndex() == 1;
        ItemSorter itemSorter = this.typeModule.getSorters().get(sort);
        Collections.sort(items, itemSorter.getComparator());
        Pair<Panel, Integer> currentPos = MutablePair.of(null, (Object)0);
        Pair prevItem = null;
        for (Pair item : items) {
            currentPos = this.addItemToList((ItemStack)item.getKey(), this.itemList, currentPos, numcolumns, labelWidth, spacing, (Integer)item.getValue(), dogroups && (prevItem == null || !itemSorter.isSameGroup(prevItem, (Pair<ItemStack, Integer>)item)), itemSorter.getGroupName((Pair<ItemStack, Integer>)item));
            prevItem = item;
        }
        int newfirst = -1;
        if (this.itemList.getCountSelected() == 0) {
            if (this.itemList.getBounds() != null) {
                this.itemList.setFirstSelected(0);
                newfirst = this.itemList.getChildCount() - this.itemList.getCountSelected();
                if (newfirst < 0) {
                    newfirst = 0;
                }
            }
        } else if (this.itemList.getFirstSelected() > this.itemList.getChildCount() - this.itemList.getCountSelected()) {
            newfirst = this.itemList.getChildCount() - this.itemList.getCountSelected();
        }
        if (newfirst >= 0) {
            this.itemList.setFirstSelected(newfirst);
        }
    }

    private boolean isRemote() {
        ItemStack stack = this.inventorySlots.getSlot(0).getStack();
        if (stack.isEmpty()) {
            return false;
        }
        return stack.getItemDamage() == 6;
    }

    private boolean isTabletWithRemote() {
        if (this.tileEntity != null) {
            return false;
        }
        ItemStack heldItem = this.mc.player.getHeldItem(EnumHand.MAIN_HAND);
        if (!heldItem.isEmpty() && heldItem.hasTagCompound()) {
            int storageType = heldItem.getTagCompound().getInteger("childDamage");
            return storageType == 6;
        }
        return false;
    }

    private int getCurrentSortMode() {
        this.updateTypeModule();
        String sortName = this.sortMode.getCurrentChoice();
        this.sortMode.clear();
        for (ItemSorter sorter : this.typeModule.getSorters()) {
            this.sortMode.addChoice(sorter.getName(), sorter.getTooltip(), guiElements, sorter.getU(), sorter.getV());
        }
        int sort = this.sortMode.findChoice(sortName);
        if (sort == -1) {
            sort = 0;
        }
        this.sortMode.setCurrentChoice(sort);
        return sort;
    }

    private void updateTypeModule() {
        ItemStack typeStack;
        this.typeModule = this.tileEntity != null ? ((typeStack = ((ModularStorageTileEntity)this.tileEntity).getStackInSlot(1)).isEmpty() || !(typeStack.getItem() instanceof TypeModule) ? new DefaultTypeModule() : (TypeModule)typeStack.getItem()) : new DefaultTypeModule();
    }

    private Pair<Panel, Integer> addItemToList(ItemStack stack, WidgetList itemList, Pair<Panel, Integer> currentPos, int numcolumns, int labelWidth, int spacing, int slot, boolean newgroup, String groupName) {
        Panel panel = (Panel)currentPos.getKey();
        if (panel == null || (Integer)currentPos.getValue() >= numcolumns || newgroup && groupName != null) {
            if (newgroup && groupName != null) {
                AbstractWidget groupLabel = ((Label)((Label)((Label)((Label)((Label)((Label)new Label(this.mc, (Gui)this).setText(groupName)).setColor(ModularStorageConfiguration.groupForeground.get())).setColor(StyleConfig.colorTextInListNormal)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setFilledBackground(ModularStorageConfiguration.groupBackground.get())).setDesiredHeight(10)).setDesiredWidth(231);
                itemList.addChild((Widget)((Panel)new Panel(this.mc, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setHorizontalMargin(2)).setVerticalMargin(0)).setDesiredHeight(10)).addChild((Widget)groupLabel));
            }
            panel = (Panel)((Panel)((Panel)new Panel(this.mc, (Gui)this).setLayout((Layout)new HorizontalLayout().setSpacing(spacing)).setDesiredHeight(12)).setUserObject((Object)new Integer(-1))).setDesiredHeight(16);
            currentPos = MutablePair.of((Object)panel, (Object)0);
            itemList.addChild((Widget)panel);
        }
        BlockRender blockRender = ((BlockRender)new BlockRender(this.mc, (Gui)this).setRenderItem((Object)stack).setUserObject((Object)new Integer(slot))).setOffsetX(-1).setOffsetY(-1);
        panel.addChild((Widget)blockRender);
        if (labelWidth > 0) {
            String displayName = labelWidth > 100 ? this.typeModule.getLongLabel(stack) : this.typeModule.getShortLabel(stack);
            AbstractWidget label = ((Label)((Label)((Label)((Label)new Label(this.mc, (Gui)this).setText(displayName)).setColor(StyleConfig.colorTextInListNormal)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setDesiredWidth(labelWidth)).setUserObject((Object)new Integer(-1));
            panel.addChild((Widget)label);
        }
        currentPos.setValue((Object)((Integer)currentPos.getValue() + 1));
        return currentPos;
    }

    protected void keyTyped(char typedChar, int keyCode) throws IOException {
        if (!this.window.keyTyped(typedChar, keyCode)) {
            if (typedChar >= '1' && typedChar <= '9') {
                return;
            }
            super.keyTyped(typedChar, keyCode);
        }
        this.craftingGrid.getWindow().keyTyped(typedChar, keyCode);
    }

    protected void drawGuiContainerBackgroundLayer(float v, int i, int i2) {
        this.updateList();
        if (this.tileEntity != null) {
            this.viewMode.setCurrentChoice(((ModularStorageTileEntity)this.tileEntity).getViewMode());
            this.sortMode.setCurrentChoice(((ModularStorageTileEntity)this.tileEntity).getSortMode());
            this.groupMode.setCurrentChoice(((ModularStorageTileEntity)this.tileEntity).isGroupMode() ? 1 : 0);
            String curFilter = ((ModularStorageTileEntity)this.tileEntity).getFilter();
            if (!this.filter.getText().equals(curFilter)) {
                this.filter.setText(curFilter);
            }
        }
        this.drawWindow();
    }

    protected void drawGuiContainerForegroundLayer(int i1, int i2) {
        int x = Mouse.getEventX() * this.width / this.mc.displayWidth;
        int y = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
        List tooltips = this.craftingGrid.getWindow().getTooltips();
        if (tooltips != null) {
            this.drawHoveringText(tooltips, this.window.getTooltipItems(), x - this.guiLeft, y - this.guiTop, this.mc.fontRenderer);
        }
        super.drawGuiContainerForegroundLayer(i1, i2);
    }

    protected void drawWindow() {
        super.drawWindow();
        this.craftingGrid.draw();
    }
}

