/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import java.util.List;
import java.util.function.BiFunction;
import mcjty.lib.api.IModuleSupport;
import mcjty.lib.base.ModBase;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.varia.ModuleSupport;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.screens.ScreenSetup;
import mcjty.rftools.blocks.storage.GuiLevelEmitter;
import mcjty.rftools.blocks.storage.LevelEmitterContainer;
import mcjty.rftools.blocks.storage.LevelEmitterTileEntity;
import mcjty.rftools.setup.GuiProxy;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class LevelEmitterBlock
extends LogicSlabBlock<LevelEmitterTileEntity, LevelEmitterContainer> {
    public static final PropertyBool MODULE = PropertyBool.create((String)"module");

    public LevelEmitterBlock() {
        super((ModBase)RFTools.instance, Material.IRON, LevelEmitterTileEntity.class, LevelEmitterContainer::new, "level_emitter", true);
    }

    @SideOnly(value=Side.CLIENT)
    public BiFunction<LevelEmitterTileEntity, LevelEmitterContainer, GenericGuiContainer<? super LevelEmitterTileEntity>> getGuiFactory() {
        return GuiLevelEmitter::new;
    }

    protected IModuleSupport getModuleSupport() {
        return new ModuleSupport(0){

            public boolean isModule(ItemStack itemStack) {
                return itemStack.getItem() == ScreenSetup.storageControlModuleItem;
            }
        };
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This block can be retrofitted with a");
            list.add(TextFormatting.WHITE + "Storage Control Screen Module so that");
            list.add(TextFormatting.WHITE + "you can count items in your storage");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        ItemStack module = LevelEmitterBlock.getModule(world.getTileEntity(data.getPos()));
        if (module.isEmpty()) {
            probeInfo.text(TextFormatting.GREEN + "Install storage control screen module first");
        } else {
            TileEntity te = world.getTileEntity(data.getPos());
            if (te instanceof LevelEmitterTileEntity) {
                LevelEmitterTileEntity emitterTileEntity = (LevelEmitterTileEntity)te;
                int count = emitterTileEntity.getCurrentCount();
                ItemStack toCount = emitterTileEntity.getInventoryHelper().getStackInSlot(1);
                if (!toCount.isEmpty()) {
                    probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(toCount).text(TextFormatting.BLUE + "Count: " + TextFormatting.WHITE + count);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        ItemStack module = LevelEmitterBlock.getModule(accessor.getTileEntity());
        if (module.isEmpty()) {
            currenttip.add(TextFormatting.GREEN + "Install storage control screen module first");
        }
        return currenttip;
    }

    public boolean needsRedstoneCheck() {
        return false;
    }

    public int getGuiID() {
        return GuiProxy.GUI_STORAGE_TERMINAL;
    }

    private static ItemStack getModule(TileEntity tileEntity) {
        if (tileEntity instanceof LevelEmitterTileEntity) {
            LevelEmitterTileEntity emitterTileEntity = (LevelEmitterTileEntity)tileEntity;
            return emitterTileEntity.getStackInSlot(0);
        }
        return ItemStack.EMPTY;
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
        ItemStack module = LevelEmitterBlock.getModule(world.getTileEntity(pos));
        return super.getActualState(state, world, pos).withProperty((IProperty)MODULE, (Comparable)Boolean.valueOf(!module.isEmpty()));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{LOGIC_FACING, META_INTERMEDIATE, MODULE});
    }
}

