/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftools.blocks.storage.ModularStorageConfiguration;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import mcjty.rftools.blocks.storage.RemoteStorageContainer;
import mcjty.rftools.blocks.storage.RemoteStorageIdRegistry;
import mcjty.rftools.items.storage.StorageModuleItem;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public class RemoteStorageTileEntity
extends GenericEnergyReceiverTileEntity
implements ITickable,
DefaultSidedInventory {
    public static final String CMD_SETGLOBAL = "relay.setGlobal";
    public static final Key<Integer> PARAM_INDEX = new Key("index", Type.INTEGER);
    public static final Key<Boolean> PARAM_GLOBAL = new Key("global", Type.BOOLEAN);
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, RemoteStorageContainer.factory, 8);
    private ItemStackList[] slots = new ItemStackList[]{ItemStackList.create((int)0), ItemStackList.create((int)0), ItemStackList.create((int)0), ItemStackList.create((int)0)};
    private int[] maxsize = new int[]{0, 0, 0, 0};
    private int[] numStacks = new int[]{0, 0, 0, 0};
    private boolean[] global = new boolean[]{false, false, false, false};
    private int version = 0;
    private int timer = 0;

    public RemoteStorageTileEntity() {
        super((long)ModularStorageConfiguration.REMOTE_MAXENERGY.get(), (long)ModularStorageConfiguration.REMOTE_RECEIVEPERTICK.get());
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public boolean isPowerLow() {
        return this.getStoredPower() < (long)ModularStorageConfiguration.remoteShareLocal.get();
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public void update() {
        if (!this.getWorld().isRemote) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        --this.timer;
        if (this.timer > 0) {
            return;
        }
        this.timer = 5;
        int hasPower = this.isPowerLow() ? 0 : 8;
        RemoteStorageIdRegistry registry = RemoteStorageIdRegistry.getRegistry(this.getWorld());
        for (int i = 0; i < 4; ++i) {
            ItemStack stack;
            NBTTagCompound tagCompound;
            if (!this.inventoryHelper.containsItem(i) || (tagCompound = (stack = this.inventoryHelper.getStackInSlot(i)).getTagCompound()) == null || !tagCompound.hasKey("id")) continue;
            int rf = this.isGlobal(i) ? ModularStorageConfiguration.remoteShareGlobal.get() : ModularStorageConfiguration.remoteShareLocal.get();
            rf = (int)((float)rf * (2.0f - this.getInfusedFactor()) / 2.0f);
            if (this.getStoredPower() < (long)rf) {
                return;
            }
            this.consumeEnergy(rf);
            this.markDirty();
            int id = tagCompound.getInteger("id");
            registry.publishStorage(id, new GlobalCoordinate(this.getPos(), this.getWorld().provider.getDimension()));
        }
    }

    public int[] getSlotsForFace(EnumFacing side) {
        return RemoteStorageContainer.factory.getAccessibleSlots();
    }

    public boolean canInsertItem(int index, ItemStack itemStackIn, EnumFacing direction) {
        return RemoteStorageContainer.factory.isInputSlot(index);
    }

    public boolean canExtractItem(int index, ItemStack stack, EnumFacing direction) {
        return RemoteStorageContainer.factory.isOutputSlot(index);
    }

    public int getVersion() {
        return this.version;
    }

    public void updateVersion() {
        ++this.version;
        this.markDirty();
    }

    public boolean hasStorage(int index) {
        return this.inventoryHelper.containsItem(index);
    }

    public int getSizeInventory() {
        return this.inventoryHelper.getCount();
    }

    public ItemStack getStackInSlot(int index) {
        return this.inventoryHelper.getStackInSlot(index);
    }

    public ItemStack decrStackSize(int index, int amount) {
        IBlockState state = this.getWorld().getBlockState(this.getPos());
        this.getWorld().notifyBlockUpdate(this.getPos(), state, state, 3);
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public void compact(int id) {
        int si = this.findRemoteIndex(id);
        if (si == -1) {
            return;
        }
        ItemStackList s = this.findStacksForId(id);
        InventoryHelper.compactStacks((List)s, (int)0, (int)this.maxsize[si]);
        this.updateStackCount(si);
        this.markDirty();
    }

    public int cycle(int id) {
        int si = this.findRemoteIndex(id);
        if (si == -1) {
            for (int i = 0; i < 4; ++i) {
                ItemStack stack = this.getStackInSlot(i);
                if (stack.isEmpty() || stack.getTagCompound() == null || !stack.getTagCompound().hasKey("id")) continue;
                return stack.getTagCompound().getInteger("id");
            }
            return -1;
        }
        for (int i = si + 1; i < si + 4; ++i) {
            int ii = i % 4;
            ItemStack stack = this.getStackInSlot(ii);
            if (stack.isEmpty() || stack.getTagCompound() == null || !stack.getTagCompound().hasKey("id")) continue;
            return stack.getTagCompound().getInteger("id");
        }
        return id;
    }

    private void link(int index) {
        int id;
        if (index >= 4) {
            index -= 4;
        }
        if (!this.inventoryHelper.containsItem(index)) {
            return;
        }
        if (!this.inventoryHelper.containsItem(index + 4)) {
            return;
        }
        ItemStack source = this.inventoryHelper.getStackInSlot(index);
        ItemStack dest = this.inventoryHelper.getStackInSlot(index + 4);
        if (dest.getItemDamage() != 6) {
            return;
        }
        NBTTagCompound tagCompound = source.getTagCompound();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            source.setTagCompound(tagCompound);
        }
        if (tagCompound.hasKey("id")) {
            id = tagCompound.getInteger("id");
        } else {
            RemoteStorageIdRegistry registry = RemoteStorageIdRegistry.getRegistry(this.getWorld());
            id = registry.getNewId();
            registry.save();
            tagCompound.setInteger("id", id);
        }
        tagCompound = dest.getTagCompound();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            dest.setTagCompound(tagCompound);
        }
        tagCompound.setInteger("id", id);
    }

    public void setInventorySlotContents(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.getInventoryStackLimit(), index, stack);
        if (index < 4) {
            this.copyFromModule(stack, index);
        }
        IBlockState state = this.getWorld().getBlockState(this.getPos());
        this.getWorld().notifyBlockUpdate(this.getPos(), state, state, 3);
        if (!this.getWorld().isRemote) {
            this.link(index);
        }
    }

    public int getInventoryStackLimit() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return stack.getItem() == ModularStorageSetup.storageModuleItem;
    }

    public int findRemoteIndex(int id) {
        for (int i = 0; i < 4; ++i) {
            NBTTagCompound tagCompound;
            ItemStack stack;
            if (!this.inventoryHelper.containsItem(i) || (stack = this.inventoryHelper.getStackInSlot(i)).getItemDamage() == 6 || (tagCompound = stack.getTagCompound()) == null || !tagCompound.hasKey("id") || id != tagCompound.getInteger("id")) continue;
            return i;
        }
        return -1;
    }

    public boolean isGlobal(int index) {
        return this.global[index];
    }

    public void setGlobal(int index, boolean global) {
        this.global[index] = global;
        this.markDirtyClient();
    }

    public ItemStackList getRemoteStacks(int si) {
        return this.slots[si];
    }

    public ItemStack getRemoteSlot(int si, int index) {
        if (index >= this.slots[si].size()) {
            return ItemStack.EMPTY;
        }
        return (ItemStack)this.slots[si].get(index);
    }

    public void updateCount(int si, int cnt) {
        this.numStacks[si] = cnt;
        StorageModuleItem.updateStackSize(this.getStackInSlot(si), this.numStacks[si]);
    }

    public int getCount(int si) {
        return this.numStacks[si];
    }

    public int getMaxStacks(int si) {
        return this.maxsize[si];
    }

    public ItemStack decrStackSizeRemote(int si, int index, int amount) {
        boolean hasNew;
        if (index >= this.slots[si].size()) {
            return ItemStack.EMPTY;
        }
        ItemStackList stacks = this.slots[si];
        boolean hasOld = !((ItemStack)stacks.get(index)).isEmpty();
        ItemStack its = ItemStack.EMPTY;
        if (!((ItemStack)stacks.get(index)).isEmpty()) {
            if (((ItemStack)stacks.get(index)).getCount() <= amount) {
                ItemStack old = (ItemStack)stacks.get(index);
                stacks.set(index, (Object)ItemStack.EMPTY);
                its = old;
            } else {
                its = ((ItemStack)stacks.get(index)).splitStack(amount);
                if (((ItemStack)stacks.get(index)).isEmpty()) {
                    stacks.set(index, (Object)ItemStack.EMPTY);
                }
            }
        }
        boolean bl = hasNew = !((ItemStack)stacks.get(index)).isEmpty();
        if (hasOld && !hasNew) {
            int n = si;
            this.numStacks[n] = this.numStacks[n] - 1;
        } else if (hasNew && !hasOld) {
            int n = si;
            this.numStacks[n] = this.numStacks[n] + 1;
        }
        StorageModuleItem.updateStackSize(this.getStackInSlot(si), this.numStacks[si]);
        this.markDirty();
        return its;
    }

    public ItemStack removeStackFromSlotRemote(int si, int index) {
        if (index >= this.slots[si].size()) {
            return ItemStack.EMPTY;
        }
        ItemStackList stacks = this.slots[si];
        if (((ItemStack)stacks.get(index)).isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack old = (ItemStack)stacks.get(index);
        stacks.set(index, (Object)ItemStack.EMPTY);
        int n = si;
        this.numStacks[n] = this.numStacks[n] - 1;
        StorageModuleItem.updateStackSize(this.getStackInSlot(si), this.numStacks[si]);
        this.markDirty();
        return old;
    }

    public boolean updateRemoteSlot(int si, int limit, int index, ItemStack stack) {
        boolean hasNew;
        if (index >= this.slots[si].size()) {
            return false;
        }
        boolean hasOld = !((ItemStack)this.slots[si].get(index)).isEmpty();
        this.slots[si].set(index, (Object)stack);
        if (!stack.isEmpty() && stack.getCount() > limit) {
            if (limit <= 0) {
                stack.setCount(0);
            } else {
                stack.setCount(limit);
            }
        }
        boolean bl = hasNew = !stack.isEmpty();
        if (hasOld && !hasNew) {
            int n = si;
            this.numStacks[n] = this.numStacks[n] - 1;
        } else if (hasNew && !hasOld) {
            int n = si;
            this.numStacks[n] = this.numStacks[n] + 1;
        }
        StorageModuleItem.updateStackSize(this.getStackInSlot(si), this.numStacks[si]);
        this.markDirty();
        return true;
    }

    public ItemStack findStorageWithId(int id) {
        for (int i = 0; i < 4; ++i) {
            NBTTagCompound tagCompound;
            ItemStack stack;
            if (!this.inventoryHelper.containsItem(i) || (stack = this.inventoryHelper.getStackInSlot(i)).getItemDamage() == 6 || (tagCompound = stack.getTagCompound()) == null || !tagCompound.hasKey("id") || id != tagCompound.getInteger("id")) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    @Nonnull
    public ItemStackList findStacksForId(int id) {
        for (int i = 0; i < 4; ++i) {
            NBTTagCompound tagCompound;
            ItemStack stack;
            if (!this.inventoryHelper.containsItem(i) || (stack = this.inventoryHelper.getStackInSlot(i)).getItemDamage() == 6 || (tagCompound = stack.getTagCompound()) == null || !tagCompound.hasKey("id") || id != tagCompound.getInteger("id")) continue;
            return this.slots[i];
        }
        return ItemStackList.EMPTY;
    }

    public void copyToModule(int si) {
        ItemStack stack = this.inventoryHelper.getStackInSlot(si);
        if (stack.isEmpty()) {
            return;
        }
        if (stack.getItemDamage() == 6) {
            return;
        }
        NBTTagCompound tagCompound = stack.getTagCompound();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.setTagCompound(tagCompound);
        }
        int cnt = this.writeSlotsToNBT(tagCompound, "Items", si);
        tagCompound.setInteger("count", cnt);
    }

    public void copyFromModule(ItemStack stack, int si) {
        if (stack.isEmpty()) {
            this.setMaxSize(si, 0);
            return;
        }
        if (stack.getItemDamage() == 6) {
            this.setMaxSize(si, 0);
            return;
        }
        this.setMaxSize(si, StorageModuleItem.MAXSIZE[stack.getItemDamage()]);
        NBTTagCompound tagCompound = stack.getTagCompound();
        if (tagCompound != null) {
            this.readSlotsFromNBT(tagCompound, "Items", si);
        }
        this.updateStackCount(si);
    }

    private void setMaxSize(int si, int ms) {
        this.maxsize[si] = ms;
        this.slots[si] = ItemStackList.create((int)ms);
        this.numStacks[si] = 0;
    }

    private void updateStackCount(int si) {
        this.numStacks[si] = 0;
        ItemStackList stacks = this.slots[si];
        for (ItemStack stack : stacks) {
            if (stack.isEmpty()) continue;
            int n = si;
            this.numStacks[n] = this.numStacks[n] + 1;
        }
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.version = tagCompound.getInteger("version");
        for (int i = 0; i < 4; ++i) {
            int max = tagCompound.getInteger("maxSize" + i);
            this.setMaxSize(i, max);
            this.readSlotsFromNBT(tagCompound, "Slots" + i, i);
            this.global[i] = tagCompound.getBoolean("global" + i);
            this.updateStackCount(i);
        }
    }

    private void readSlotsFromNBT(NBTTagCompound tagCompound, String tagname, int index) {
        NBTTagList bufferTagList = tagCompound.getTagList(tagname, 10);
        for (int i = 0; i < Math.min(bufferTagList.tagCount(), this.slots[index].size()); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.getCompoundTagAt(i);
            this.slots[index].set(i, (Object)new ItemStack(nbtTagCompound));
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.setInteger("version", this.version);
        for (int i = 0; i < 4; ++i) {
            this.writeSlotsToNBT(tagCompound, "Slots" + i, i);
            tagCompound.setInteger("maxSize" + i, this.maxsize[i]);
            tagCompound.setBoolean("global" + i, this.global[i]);
        }
    }

    private int writeSlotsToNBT(NBTTagCompound tagCompound, String tagname, int index) {
        NBTTagList bufferTagList = new NBTTagList();
        int cnt = 0;
        for (int i = 0; i < this.slots[index].size(); ++i) {
            ItemStack stack = (ItemStack)this.slots[index].get(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (!stack.isEmpty()) {
                stack.writeToNBT(nbtTagCompound);
                if (stack.getCount() > 0) {
                    ++cnt;
                }
            }
            bufferTagList.appendTag((NBTBase)nbtTagCompound);
        }
        tagCompound.setTag(tagname, (NBTBase)bufferTagList);
        return cnt;
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return rc;
        }
        if (CMD_SETGLOBAL.equals(command)) {
            int index = (Integer)params.get(PARAM_INDEX);
            boolean global = (Boolean)params.get(PARAM_GLOBAL);
            this.setGlobal(index, global);
            return true;
        }
        return false;
    }
}

