/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import java.util.List;
import java.util.function.BiFunction;
import mcjty.lib.api.IModuleSupport;
import mcjty.lib.base.ModBase;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.varia.ModuleSupport;
import mcjty.lib.varia.WorldTools;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.screens.ScreenSetup;
import mcjty.rftools.blocks.storage.GuiStorageTerminal;
import mcjty.rftools.blocks.storage.StorageTerminalContainer;
import mcjty.rftools.blocks.storage.StorageTerminalTileEntity;
import mcjty.rftools.blocks.storagemonitor.GuiStorageScanner;
import mcjty.rftools.blocks.storagemonitor.StorageScannerContainer;
import mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity;
import mcjty.rftools.craftinggrid.CraftingGridProvider;
import mcjty.rftools.setup.GuiProxy;
import mcjty.rftools.varia.RFToolsTools;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class StorageTerminalBlock
extends LogicSlabBlock<StorageTerminalTileEntity, StorageTerminalContainer> {
    public static final PropertyBool MODULE = PropertyBool.create((String)"module");

    public StorageTerminalBlock() {
        super((ModBase)RFTools.instance, Material.IRON, StorageTerminalTileEntity.class, StorageTerminalContainer::new, "storage_terminal", true);
    }

    @SideOnly(value=Side.CLIENT)
    public BiFunction<StorageTerminalTileEntity, StorageTerminalContainer, GenericGuiContainer<? super StorageTerminalTileEntity>> getGuiFactory() {
        return GuiStorageTerminal::new;
    }

    protected IModuleSupport getModuleSupport() {
        return new ModuleSupport(0){

            public boolean isModule(ItemStack itemStack) {
                return itemStack.getItem() == ScreenSetup.storageControlModuleItem;
            }
        };
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This terminal can be retrofitted with");
            list.add(TextFormatting.WHITE + "a Storage Control Screen Module so");
            list.add(TextFormatting.WHITE + "that you can access a Storage Scanner");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        ItemStack module = StorageTerminalBlock.getModule(world.getTileEntity(data.getPos()));
        if (module.isEmpty()) {
            probeInfo.text(TextFormatting.GREEN + "Install storage control screen module first");
        } else {
            probeInfo.text(TextFormatting.GREEN + "Use wrench to remove module");
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        ItemStack module = StorageTerminalBlock.getModule(accessor.getTileEntity());
        if (module.isEmpty()) {
            currenttip.add(TextFormatting.GREEN + "Install storage control screen module first");
        } else {
            currenttip.add(TextFormatting.GREEN + "Use wrench to remove module");
        }
        return currenttip;
    }

    public boolean hasRedstoneOutput() {
        return false;
    }

    public boolean needsRedstoneCheck() {
        return false;
    }

    public int getGuiID() {
        return GuiProxy.GUI_STORAGE_TERMINAL;
    }

    private static ItemStack getModule(TileEntity tileEntity) {
        if (tileEntity instanceof StorageTerminalTileEntity) {
            StorageTerminalTileEntity terminalTileEntity = (StorageTerminalTileEntity)tileEntity;
            return terminalTileEntity.getStackInSlot(0);
        }
        return ItemStack.EMPTY;
    }

    public Container createServerContainer(EntityPlayer entityPlayer, TileEntity tileEntity) {
        StorageTerminalTileEntity terminalTileEntity;
        ItemStack module;
        if (!entityPlayer.isSneaking() && tileEntity instanceof StorageTerminalTileEntity && !(module = (terminalTileEntity = (StorageTerminalTileEntity)tileEntity).getStackInSlot(0)).isEmpty()) {
            int dimension = RFToolsTools.getDimensionFromModule(module);
            BlockPos pos = RFToolsTools.getPositionFromModule(module);
            WorldServer world = DimensionManager.getWorld((int)dimension);
            if (!WorldTools.chunkLoaded((World)world, (BlockPos)pos)) {
                entityPlayer.sendStatusMessage((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Storage scanner out of range!"), false);
                return null;
            }
            TileEntity scannerTE = world.getTileEntity(pos);
            if (!(scannerTE instanceof StorageScannerTileEntity)) {
                entityPlayer.sendStatusMessage((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Storage scanner is missing!"), false);
                return null;
            }
            return new StorageScannerContainer(entityPlayer, (IInventory)scannerTE, terminalTileEntity);
        }
        return super.createServerContainer(entityPlayer, tileEntity);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createClientGui(EntityPlayer entityPlayer, final TileEntity tileEntity) {
        ItemStack module;
        if (!entityPlayer.isSneaking() && !(module = StorageTerminalBlock.getModule(tileEntity)).isEmpty()) {
            int monitordim = RFToolsTools.getDimensionFromModule(module);
            BlockPos pos = RFToolsTools.getPositionFromModule(module);
            StorageScannerTileEntity te = new StorageScannerTileEntity(entityPlayer, monitordim){

                @Override
                public BlockPos getCraftingGridContainerPos() {
                    return tileEntity.getPos();
                }

                @Override
                public CraftingGridProvider getCraftingGridProvider() {
                    return (CraftingGridProvider)tileEntity;
                }

                @Override
                public boolean isOpenWideView() {
                    TileEntity realTe = RFTools.proxy.getClientWorld().getTileEntity(this.pos);
                    if (realTe instanceof StorageScannerTileEntity) {
                        return ((StorageScannerTileEntity)realTe).isOpenWideView();
                    }
                    return true;
                }

                @Override
                public BlockPos getStorageScannerPos() {
                    return this.pos;
                }
            };
            te.setPos(pos);
            return new GuiStorageScanner(te, new StorageScannerContainer(entityPlayer, (IInventory)te, (CraftingGridProvider)tileEntity));
        }
        return super.createClientGui(entityPlayer, tileEntity);
    }

    protected boolean wrenchUse(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        StorageTerminalTileEntity storageTerminalTileEntity;
        ItemStack module;
        TileEntity te;
        if (!world.isRemote && (te = world.getTileEntity(pos)) instanceof StorageTerminalTileEntity && !(module = (storageTerminalTileEntity = (StorageTerminalTileEntity)te).getStackInSlot(0)).isEmpty()) {
            storageTerminalTileEntity.setInventorySlotContents(0, ItemStack.EMPTY);
            storageTerminalTileEntity.markDirtyClient();
            if (!player.inventory.addItemStackToInventory(module)) {
                player.entityDropItem(module, 1.05f);
            }
            player.sendStatusMessage((ITextComponent)new TextComponentString("Removed module"), false);
        }
        return true;
    }

    protected boolean openGui(World world, int x, int y, int z, EntityPlayer player) {
        if (world.isRemote) {
            return true;
        }
        TileEntity te = world.getTileEntity(new BlockPos(x, y, z));
        if (!this.tileEntityClass.isInstance(te)) {
            return false;
        }
        if (this.checkAccess(world, player, te)) {
            return true;
        }
        if (player.isSneaking()) {
            player.openGui((Object)this.modBase, this.getGuiID(), world, x, y, z);
        } else {
            player.openGui((Object)this.modBase, GuiProxy.GUI_STORAGE_TERMINAL_SCANNER, world, x, y, z);
        }
        return true;
    }

    public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
        ItemStack module = StorageTerminalBlock.getModule(world.getTileEntity(pos));
        return super.getActualState(state, world, pos).withProperty((IProperty)MODULE, (Comparable)Boolean.valueOf(!module.isEmpty()));
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{LOGIC_FACING, META_INTERMEDIATE, MODULE});
    }
}

