/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storagemonitor;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.varia.ItemStackList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ItemFilterCache {
    private boolean matchDamage = true;
    private boolean oredictMode = false;
    private boolean blacklistMode = true;
    private boolean nbtMode = false;
    private ItemStackList stacks;
    private Set<Integer> oredictMatches = new HashSet<Integer>();

    public ItemFilterCache(boolean matchDamage, boolean oredictMode, boolean blacklistMode, boolean nbtMode, @Nonnull ItemStackList stacks) {
        this.matchDamage = matchDamage;
        this.oredictMode = oredictMode;
        this.blacklistMode = blacklistMode;
        this.nbtMode = nbtMode;
        this.stacks = stacks;
        for (ItemStack s : stacks) {
            for (int id : OreDictionary.getOreIDs((ItemStack)s)) {
                this.oredictMatches.add(id);
            }
        }
    }

    public boolean match(ItemStack stack) {
        if (!stack.isEmpty()) {
            boolean match = false;
            if (this.oredictMode) {
                int[] oreIDs = OreDictionary.getOreIDs((ItemStack)stack);
                if (oreIDs.length == 0) {
                    match = this.itemMatches(stack);
                } else {
                    for (int id : oreIDs) {
                        if (!this.oredictMatches.contains(id)) continue;
                        match = true;
                        break;
                    }
                }
            } else {
                match = this.itemMatches(stack);
            }
            return match != this.blacklistMode;
        }
        return false;
    }

    private boolean itemMatches(ItemStack stack) {
        if (this.stacks != null) {
            for (ItemStack itemStack : this.stacks) {
                if (this.matchDamage && itemStack.getMetadata() != stack.getMetadata() || this.nbtMode && !ItemStack.areItemStackTagsEqual((ItemStack)itemStack, (ItemStack)stack) || !itemStack.getItem().equals(stack.getItem())) continue;
                return true;
            }
        }
        return false;
    }
}

