/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storagemonitor;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.rftools.blocks.storagemonitor.ReturnInfoHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketReturnInventoryInfo
implements IMessage {
    private List<InventoryInfo> inventories;

    public List<InventoryInfo> getInventories() {
        return this.inventories;
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.inventories = new ArrayList<InventoryInfo>(size);
        for (int i = 0; i < size; ++i) {
            BlockPos pos = NetworkTools.readPos((ByteBuf)buf);
            String name = NetworkTools.readString((ByteBuf)buf);
            boolean routable = buf.readBoolean();
            ItemStack stack = ItemStack.EMPTY;
            if (buf.readBoolean()) {
                stack = NetworkTools.readItemStack((ByteBuf)buf);
            }
            InventoryInfo info = new InventoryInfo(pos, name, routable, stack);
            this.inventories.add(info);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.inventories.size());
        for (InventoryInfo info : this.inventories) {
            NetworkTools.writePos((ByteBuf)buf, (BlockPos)info.getPos());
            NetworkTools.writeString((ByteBuf)buf, (String)info.getName());
            buf.writeBoolean(info.isRoutable());
            ItemStack stack = info.getStack();
            if (stack.isEmpty()) {
                buf.writeBoolean(false);
                continue;
            }
            buf.writeBoolean(true);
            NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)stack);
        }
    }

    public PacketReturnInventoryInfo() {
    }

    public PacketReturnInventoryInfo(ByteBuf buf) {
    }

    public PacketReturnInventoryInfo(List<InventoryInfo> inventories) {
        this.inventories = inventories;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> ReturnInfoHelper.onMessageFromServer(this));
        ctx.setPacketHandled(true);
    }

    public static class InventoryInfo {
        private final BlockPos pos;
        private final String name;
        private final boolean routable;
        private final ItemStack stack;

        public InventoryInfo(BlockPos pos, String name, boolean routable, ItemStack stack) {
            this.pos = pos;
            this.name = name;
            this.routable = routable;
            this.stack = stack;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public String getName() {
            return this.name;
        }

        public boolean isRoutable() {
            return this.routable;
        }

        public ItemStack getStack() {
            return this.stack;
        }
    }
}

