/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import mcjty.rftools.blocks.teleporter.MatterTransmitterTileEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BeamRenderer
extends TileEntitySpecialRenderer<MatterTransmitterTileEntity> {
    private static final ResourceLocation textureOk = new ResourceLocation("rftools", "textures/blocks/machineteleporter.png");
    private static final ResourceLocation textureWarn = new ResourceLocation("rftools", "textures/blocks/machineteleporterwarn.png");
    private static final ResourceLocation textureUnknown = new ResourceLocation("rftools", "textures/blocks/machineteleporterunknown.png");

    private void p(BufferBuilder renderer, double x, double y, double z, double u, double v) {
        renderer.pos(x, y, z).tex(u, v).color(1.0f, 1.0f, 1.0f, 1.0f).lightmap(0, 240).endVertex();
    }

    public void render(MatterTransmitterTileEntity tileEntity, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (tileEntity.isDialed() && !tileEntity.isBeamHidden()) {
            Tessellator tessellator = Tessellator.getInstance();
            GlStateManager.pushMatrix();
            GlStateManager.translate((double)x, (double)(y + 1.0), (double)z);
            GlStateManager.enableBlend();
            GlStateManager.depthMask((boolean)false);
            GlStateManager.blendFunc((int)770, (int)1);
            GlStateManager.alphaFunc((int)516, (float)0.003921569f);
            GlStateManager.disableCull();
            GlStateManager.enableDepth();
            int status = tileEntity.getStatus();
            ResourceLocation beamIcon = null;
            switch (status) {
                case 0: {
                    beamIcon = textureOk;
                    break;
                }
                case 1: {
                    beamIcon = textureWarn;
                    break;
                }
                default: {
                    beamIcon = textureUnknown;
                }
            }
            this.bindTexture(beamIcon);
            long ticks = System.currentTimeMillis() / 100L % 10L;
            float i1 = (float)ticks / 10.0f;
            float i2 = i1 + 0.1f;
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BufferBuilder renderer = tessellator.getBuffer();
            renderer.begin(7, DefaultVertexFormats.PARTICLE_POSITION_TEX_COLOR_LMAP);
            double o = 0.15;
            this.p(renderer, o, 4.0, o, 1.0, i1);
            this.p(renderer, 1.0 - o, 4.0, o, 1.0, i2);
            this.p(renderer, 1.0 - o, 0.0, o, 0.0, i2);
            this.p(renderer, o, 0.0, o, 0.0, i1);
            this.p(renderer, 1.0 - o, 4.0, 1.0 - o, 1.0, i1);
            this.p(renderer, o, 4.0, 1.0 - o, 1.0, i2);
            this.p(renderer, o, 0.0, 1.0 - o, 0.0, i2);
            this.p(renderer, 1.0 - o, 0.0, 1.0 - o, 0.0, i1);
            this.p(renderer, o, 4.0, 1.0 - o, 1.0, i1);
            this.p(renderer, o, 4.0, o, 1.0, i2);
            this.p(renderer, o, 0.0, o, 0.0, i2);
            this.p(renderer, o, 0.0, 1.0 - o, 0.0, i1);
            this.p(renderer, 1.0 - o, 4.0, o, 1.0, i1);
            this.p(renderer, 1.0 - o, 4.0, 1.0 - o, 1.0, i2);
            this.p(renderer, 1.0 - o, 0.0, 1.0 - o, 0.0, i2);
            this.p(renderer, 1.0 - o, 0.0, o, 0.0, i1);
            tessellator.draw();
            GlStateManager.depthMask((boolean)true);
            GlStateManager.enableLighting();
            GlStateManager.alphaFunc((int)516, (float)0.1f);
            GlStateManager.popMatrix();
        }
    }

    public static void register() {
        ClientRegistry.bindTileEntitySpecialRenderer(MatterTransmitterTileEntity.class, (TileEntitySpecialRenderer)new BeamRenderer());
    }
}

