/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import mcjty.lib.McJtyRegister;
import mcjty.lib.base.ModBase;
import mcjty.rftools.RFTools;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MatterBoosterBlock
extends Block {
    public static final PropertyDirection FACING = PropertyDirection.create((String)"facing");

    public MatterBoosterBlock() {
        super(Material.IRON);
        this.setTranslationKey("rftools.matter_booster");
        this.setRegistryName("matter_booster");
        this.setCreativeTab(RFTools.setup.getTab());
        this.setHardness(2.0f);
        this.setSoundType(SoundType.METAL);
        this.setHarvestLevel("pickaxe", 0);
        McJtyRegister.registerLater((Block)this, (ModBase)RFTools.instance, ItemBlock::new);
        this.setDefaultState(this.blockState.getBaseState().withProperty((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.getItemFromBlock((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return super.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).withProperty((IProperty)FACING, (Comparable)MatterBoosterBlock.getFacingFromEntity(pos, placer));
    }

    public static EnumFacing getFacingFromEntity(BlockPos clickedBlock, EntityLivingBase entityIn) {
        if (MathHelper.abs((float)((float)entityIn.posX - (float)clickedBlock.getX())) < 2.0f && MathHelper.abs((float)((float)entityIn.posZ - (float)clickedBlock.getZ())) < 2.0f) {
            double d0 = entityIn.posY + (double)entityIn.getEyeHeight();
            if (d0 - (double)clickedBlock.getY() > 2.0) {
                return EnumFacing.UP;
            }
            if ((double)clickedBlock.getY() - d0 > 0.0) {
                return EnumFacing.DOWN;
            }
        }
        return entityIn.getHorizontalFacing().getOpposite();
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty((IProperty)FACING, (Comparable)MatterBoosterBlock.getFacing(meta));
    }

    public static EnumFacing getFacing(int meta) {
        int i = meta & 7;
        return EnumFacing.byIndex((int)i);
    }

    public int getMetaFromState(IBlockState state) {
        return ((EnumFacing)state.getValue((IProperty)FACING)).getIndex();
    }

    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }
}

