/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import java.util.List;
import java.util.function.BiFunction;
import mcjty.lib.api.Infusable;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.teleporter.BeamRenderer;
import mcjty.rftools.blocks.teleporter.GuiMatterTransmitter;
import mcjty.rftools.blocks.teleporter.MatterTransmitterTileEntity;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.setup.CommandHandler;
import mcjty.rftools.setup.GuiProxy;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class MatterTransmitterBlock
extends GenericRFToolsBlock<MatterTransmitterTileEntity, EmptyContainer>
implements Infusable {
    public static Integer clientSideId = null;
    public static String clientSideName = "?";
    private static long lastTime = 0L;

    public MatterTransmitterBlock() {
        super(Material.IRON, MatterTransmitterTileEntity.class, EmptyContainer::new, "matter_transmitter", false);
        this.setDefaultState(this.blockState.getBaseState());
    }

    @SideOnly(value=Side.CLIENT)
    public static void setDestinationInfo(Integer id, String name) {
        clientSideId = id;
        clientSideName = name;
    }

    @SideOnly(value=Side.CLIENT)
    public BiFunction<MatterTransmitterTileEntity, EmptyContainer, GenericGuiContainer<? super MatterTransmitterTileEntity>> getGuiFactory() {
        return GuiMatterTransmitter::new;
    }

    public void initModel() {
        super.initModel();
        BeamRenderer.register();
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.getTagCompound();
        if (tagCompound != null) {
            boolean once;
            String name = tagCompound.getString("tpName");
            list.add(TextFormatting.GREEN + "Name: " + name);
            boolean dialed = false;
            BlockPos c = BlockPosTools.readFromNBT((NBTTagCompound)tagCompound, (String)"dest");
            if (c != null && c.getY() >= 0) {
                dialed = true;
            } else if (tagCompound.hasKey("destId") && tagCompound.getInteger("destId") != -1) {
                dialed = true;
            }
            if (dialed) {
                int destId = tagCompound.getInteger("destId");
                if (System.currentTimeMillis() - lastTime > 500L) {
                    lastTime = System.currentTimeMillis();
                    RFToolsMessages.sendToServer("getDestinationInfo", TypedMap.builder().put(CommandHandler.PARAM_ID, (Object)destId));
                }
                String destname = "?";
                if (clientSideId != null && clientSideId == destId) {
                    destname = clientSideName;
                }
                list.add(TextFormatting.YELLOW + "[DIALED to " + destname + "]");
            }
            if (once = tagCompound.getBoolean("once")) {
                list.add(TextFormatting.YELLOW + "[ONCE]");
            }
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "If you place this block near a Dialing Device then");
            list.add(TextFormatting.WHITE + "you can dial it to a Matter Receiver. Make sure to give");
            list.add(TextFormatting.WHITE + "it sufficient power!");
            list.add(TextFormatting.WHITE + "Use a Destination Analyzer adjacent to this block");
            list.add(TextFormatting.WHITE + "to check destination status (red is bad, green ok,");
            list.add(TextFormatting.WHITE + "yellow is unknown).");
            list.add(TextFormatting.WHITE + "Use a  Matter Booster adjacent to this block");
            list.add(TextFormatting.WHITE + "to be able to teleport to unpowered receivers.");
            list.add(TextFormatting.YELLOW + "Infusing bonus: reduced power consumption and");
            list.add(TextFormatting.YELLOW + "increased teleportation speed.");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.getTileEntity(data.getPos());
        if (te instanceof MatterTransmitterTileEntity) {
            MatterTransmitterTileEntity matterTransmitterTileEntity = (MatterTransmitterTileEntity)te;
            probeInfo.text(TextFormatting.GREEN + "Name: " + matterTransmitterTileEntity.getName());
            if (matterTransmitterTileEntity.isDialed()) {
                Integer teleportId = matterTransmitterTileEntity.getTeleportId();
                TeleportDestinations destinations = TeleportDestinations.getDestinations(world);
                String name = "?";
                if (teleportId != null) {
                    name = TeleportDestinations.getDestinationName(destinations, teleportId);
                }
                probeInfo.text(TextFormatting.YELLOW + "[DIALED to " + name + "]");
            }
            if (matterTransmitterTileEntity.isOnce()) {
                probeInfo.text(TextFormatting.YELLOW + "[ONCE]");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity te = accessor.getTileEntity();
        if (te instanceof MatterTransmitterTileEntity) {
            MatterTransmitterTileEntity matterTransmitterTileEntity = (MatterTransmitterTileEntity)te;
            currenttip.add(TextFormatting.GREEN + "Name: " + matterTransmitterTileEntity.getName());
            if (matterTransmitterTileEntity.isDialed()) {
                if (System.currentTimeMillis() - lastTime > 500L) {
                    lastTime = System.currentTimeMillis();
                    RFToolsMessages.sendToServer("getDestinationInfo", TypedMap.builder().put(CommandHandler.PARAM_ID, (Object)matterTransmitterTileEntity.getTeleportId()));
                }
                String name = "?";
                if (clientSideId != null && clientSideId == matterTransmitterTileEntity.getTeleportId()) {
                    name = clientSideName;
                }
                currenttip.add(TextFormatting.YELLOW + "[DIALED to " + name + "]");
            }
            if (matterTransmitterTileEntity.isOnce()) {
                currenttip.add(TextFormatting.YELLOW + "[ONCE]");
            }
        }
        return currenttip;
    }

    public int getGuiID() {
        return GuiProxy.GUI_MATTER_TRANSMITTER;
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.restoreBlockFromNBT(world, pos, stack);
        this.setOwner(world, pos, placer);
    }

    public BaseBlock.RotationType getRotationType() {
        return BaseBlock.RotationType.NONE;
    }
}

