/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.network.ICommandHandler;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.thirteen.Context;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.rftools.blocks.teleporter.DialingDeviceTileEntity;
import mcjty.rftools.blocks.teleporter.PacketReceiversReady;
import mcjty.rftools.blocks.teleporter.TeleportDestinationClientInfo;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketGetReceivers
implements IMessage {
    protected BlockPos pos;
    protected TypedMap params;

    public PacketGetReceivers() {
    }

    public PacketGetReceivers(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketGetReceivers(BlockPos pos, String playerName) {
        this.pos = pos;
        this.params = TypedMap.builder().put(DialingDeviceTileEntity.PARAM_PLAYER, (Object)playerName).build();
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
        this.params = TypedMapTools.readArguments((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        TypedMapTools.writeArguments((ByteBuf)buf, (TypedMap)this.params);
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te = ctx.getSender().getEntityWorld().getTileEntity(this.pos);
            if (!(te instanceof ICommandHandler)) {
                Logging.log((String)"createStartScanPacket: TileEntity is not a CommandHandler!");
                return;
            }
            ICommandHandler commandHandler = (ICommandHandler)te;
            List list = commandHandler.executeWithResultList("getReceivers", this.params, Type.create(TeleportDestinationClientInfo.class));
            PacketReceiversReady msg = new PacketReceiversReady(this.pos, "getReceivers", list);
            RFToolsMessages.INSTANCE.sendTo((IMessage)msg, ctx.getSender());
        });
        ctx.setPacketHandled(true);
    }
}

