/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.teleporter;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.network.IClientCommandHandler;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.Logging;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.teleporter.TransmitterInfo;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketTransmittersReady
implements IMessage {
    public BlockPos pos;
    public List<TransmitterInfo> list;
    public String command;

    public PacketTransmittersReady() {
    }

    public PacketTransmittersReady(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketTransmittersReady(BlockPos pos, String command, List<TransmitterInfo> list) {
        this.pos = pos;
        this.command = command;
        this.list = new ArrayList<TransmitterInfo>();
        this.list.addAll(list);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
        this.command = NetworkTools.readString((ByteBuf)buf);
        int size = buf.readInt();
        if (size != -1) {
            this.list = new ArrayList<TransmitterInfo>(size);
            for (int i = 0; i < size; ++i) {
                TransmitterInfo item = new TransmitterInfo(buf);
                this.list.add(item);
            }
        } else {
            this.list = null;
        }
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        NetworkTools.writeString((ByteBuf)buf, (String)this.command);
        if (this.list == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(this.list.size());
            for (TransmitterInfo item : this.list) {
                item.toBytes(buf);
            }
        }
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te = RFTools.proxy.getClientWorld().getTileEntity(this.pos);
            if (!(te instanceof IClientCommandHandler)) {
                Logging.log((String)"createInventoryReadyPacket: TileEntity is not a ClientCommandHandler!");
                return;
            }
            IClientCommandHandler clientCommandHandler = (IClientCommandHandler)te;
            if (!clientCommandHandler.receiveListFromServer(this.command, this.list, Type.create(TransmitterInfo.class))) {
                Logging.log((String)("Command " + this.command + " was not handled!"));
            }
        });
        ctx.setPacketHandled(true);
    }
}

