/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.crafting;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class NBTMatchingRecipe
extends ShapedRecipes {
    private final String[][] matchingNBTs;

    public NBTMatchingRecipe(int width, int height, ItemStack[] input, String[][] matchingNBTs, ItemStack output) {
        super("rftools:nbtmatching", width, height, NBTMatchingRecipe.getIngredients(input), output);
        this.matchingNBTs = matchingNBTs;
    }

    private static NonNullList<Ingredient> getIngredients(ItemStack[] input) {
        NonNullList inputList = NonNullList.withSize((int)input.length, (Object)Ingredient.EMPTY);
        for (int i = 0; i < input.length; ++i) {
            inputList.set(i, (Object)Ingredient.fromStacks((ItemStack[])new ItemStack[]{input[i]}));
        }
        return inputList;
    }

    public ItemStack getCraftingResult(InventoryCrafting inventoryCrafting) {
        return super.getCraftingResult(inventoryCrafting);
    }

    public boolean matches(InventoryCrafting inventoryCrafting, World world) {
        for (int i = 0; i <= 3 - this.recipeWidth; ++i) {
            for (int j = 0; j <= 3 - this.recipeHeight; ++j) {
                if (this.checkMatchNBT(inventoryCrafting, i, j, true)) {
                    return true;
                }
                if (!this.checkMatchNBT(inventoryCrafting, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatchNBT(InventoryCrafting inventoryCrafting, int x, int y, boolean reversed) {
        for (int col = 0; col < 3; ++col) {
            for (int row = 0; row < 3; ++row) {
                ItemStack itemstack1;
                int i1 = col - x;
                int j1 = row - y;
                ItemStack itemstack = ItemStack.EMPTY;
                String[] nbt = null;
                if (i1 >= 0 && j1 >= 0 && i1 < this.recipeWidth && j1 < this.recipeHeight) {
                    int idx = reversed ? this.recipeWidth - i1 - 1 + j1 * this.recipeWidth : i1 + j1 * this.recipeWidth;
                    Ingredient ingredient = (Ingredient)this.recipeItems.get(idx);
                    itemstack = ingredient.getMatchingStacks().length > 0 ? ingredient.getMatchingStacks()[0] : ItemStack.EMPTY;
                    nbt = this.matchingNBTs[idx];
                }
                if ((itemstack1 = inventoryCrafting.getStackInRowAndColumn(col, row)).isEmpty() && itemstack.isEmpty()) continue;
                if (itemstack1.isEmpty() || itemstack.isEmpty()) {
                    return false;
                }
                if (itemstack.getItem() != itemstack1.getItem()) {
                    return false;
                }
                if (itemstack.getMetadata() != Short.MAX_VALUE && itemstack.getMetadata() != itemstack1.getMetadata()) {
                    return false;
                }
                NBTTagCompound compound = itemstack.getTagCompound();
                NBTTagCompound compound1 = itemstack1.getTagCompound();
                if (nbt == null) continue;
                if (compound == null && compound1 != null) {
                    return false;
                }
                if (compound != null && compound1 == null) {
                    return false;
                }
                if (compound == null) continue;
                for (String tagName : nbt) {
                    NBTBase tag = compound.getTag(tagName);
                    NBTBase tag1 = compound1.getTag(tagName);
                    if (tag == null && tag1 != null) {
                        return false;
                    }
                    if (tag != null && tag1 == null) {
                        return false;
                    }
                    if (tag == null || tag.equals((Object)tag1)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

