/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.craftinggrid;

import mcjty.rftools.craftinggrid.CraftingGridInventory;
import mcjty.rftools.craftinggrid.CraftingRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class CraftingGrid {
    private CraftingGridInventory craftingGridInventory = new CraftingGridInventory();
    private CraftingRecipe[] recipes = new CraftingRecipe[6];

    public CraftingGrid() {
        for (int i = 0; i < 6; ++i) {
            this.recipes[i] = new CraftingRecipe();
        }
    }

    public CraftingGridInventory getCraftingGridInventory() {
        return this.craftingGridInventory;
    }

    public CraftingRecipe getRecipe(int index) {
        return this.recipes[index];
    }

    public CraftingRecipe getActiveRecipe() {
        CraftingRecipe recipe = new CraftingRecipe();
        recipe.setRecipe(this.craftingGridInventory.getIngredients(), this.craftingGridInventory.getResult());
        return recipe;
    }

    public void setRecipe(int index, ItemStack[] stacks) {
        CraftingRecipe recipe = this.recipes[index];
        recipe.setResult(stacks[0]);
        for (int i = 0; i < 9; ++i) {
            recipe.getInventory().setInventorySlotContents(i, stacks[i + 1]);
        }
    }

    public void storeRecipe(int index) {
        CraftingRecipe recipe = this.getRecipe(index);
        recipe.setRecipe(this.craftingGridInventory.getIngredients(), this.craftingGridInventory.getResult());
    }

    public void selectRecipe(int index) {
        CraftingRecipe recipe = this.getRecipe(index);
        this.craftingGridInventory.setInventorySlotContents(CraftingGridInventory.SLOT_GHOSTOUTPUT, recipe.getResult());
        for (int i = 0; i < 9; ++i) {
            this.craftingGridInventory.setInventorySlotContents(i + CraftingGridInventory.SLOT_GHOSTINPUT, recipe.getInventory().getStackInSlot(i));
        }
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 0; i < this.craftingGridInventory.getSizeInventory(); ++i) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            ItemStack stack = this.craftingGridInventory.getStackInSlot(i);
            if (!stack.isEmpty()) {
                stack.writeToNBT(nbtTagCompound);
            }
            bufferTagList.appendTag((NBTBase)nbtTagCompound);
        }
        tagCompound.setTag("grid", (NBTBase)bufferTagList);
        NBTTagList recipeTagList = new NBTTagList();
        for (CraftingRecipe recipe : this.recipes) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            recipe.writeToNBT(nbtTagCompound);
            recipeTagList.appendTag((NBTBase)nbtTagCompound);
        }
        tagCompound.setTag("recipes", (NBTBase)recipeTagList);
        return tagCompound;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound == null) {
            return;
        }
        NBTTagList bufferTagList = tagCompound.getTagList("grid", 10);
        for (int i = 0; i < this.craftingGridInventory.getSizeInventory(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.getCompoundTagAt(i);
            this.craftingGridInventory.setInventorySlotContents(i, new ItemStack(nbtTagCompound));
        }
        NBTTagList recipeTagList = tagCompound.getTagList("recipes", 10);
        for (int i = 0; i < recipeTagList.tagCount(); ++i) {
            this.recipes[i] = new CraftingRecipe();
            NBTTagCompound nbtTagCompound = recipeTagList.getCompoundTagAt(i);
            this.recipes[i].readFromNBT(nbtTagCompound);
        }
    }
}

