/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.craftinggrid;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class CraftingRecipe {
    private InventoryCrafting inv = new InventoryCrafting(new Container(){

        public boolean canInteractWith(EntityPlayer var1) {
            return false;
        }
    }, 3, 3);
    private ItemStack result = ItemStack.EMPTY;
    private boolean recipePresent = false;
    private IRecipe recipe = null;
    private boolean keepOne = false;
    private CraftMode craftMode = CraftMode.EXT;

    public static IRecipe findRecipe(World world, InventoryCrafting inv) {
        for (IRecipe r : CraftingManager.REGISTRY) {
            if (r == null || !r.matches(inv, world)) continue;
            return r;
        }
        return null;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        NBTTagList nbtTagList = tagCompound.getTagList("Items", 10);
        for (int i = 0; i < nbtTagList.tagCount(); ++i) {
            NBTTagCompound nbtTagCompound = nbtTagList.getCompoundTagAt(i);
            this.inv.setInventorySlotContents(i, new ItemStack(nbtTagCompound));
        }
        NBTTagCompound resultCompound = tagCompound.getCompoundTag("Result");
        this.result = resultCompound != null ? new ItemStack(resultCompound) : ItemStack.EMPTY;
        this.keepOne = tagCompound.getBoolean("Keep");
        this.craftMode = CraftMode.values()[tagCompound.getByte("Int")];
        this.recipePresent = false;
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        NBTTagList nbtTagList = new NBTTagList();
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.inv.getStackInSlot(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (!stack.isEmpty()) {
                stack.writeToNBT(nbtTagCompound);
            }
            nbtTagList.appendTag((NBTBase)nbtTagCompound);
        }
        NBTTagCompound resultCompound = new NBTTagCompound();
        if (!this.result.isEmpty()) {
            this.result.writeToNBT(resultCompound);
        }
        tagCompound.setTag("Result", (NBTBase)resultCompound);
        tagCompound.setTag("Items", (NBTBase)nbtTagList);
        tagCompound.setBoolean("Keep", this.keepOne);
        tagCompound.setByte("Int", (byte)this.craftMode.ordinal());
    }

    public void setRecipe(ItemStack[] items, ItemStack result) {
        for (int i = 0; i < 9; ++i) {
            this.inv.setInventorySlotContents(i, items[i]);
        }
        this.result = result;
        this.recipePresent = false;
    }

    public InventoryCrafting getInventory() {
        return this.inv;
    }

    public void setResult(ItemStack result) {
        this.result = result;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public IRecipe getCachedRecipe(World world) {
        if (!this.recipePresent) {
            this.recipePresent = true;
            this.recipe = CraftingRecipe.findRecipe(world, this.inv);
        }
        return this.recipe;
    }

    public boolean isKeepOne() {
        return this.keepOne;
    }

    public void setKeepOne(boolean keepOne) {
        this.keepOne = keepOne;
    }

    public CraftMode getCraftMode() {
        return this.craftMode;
    }

    public void setCraftMode(CraftMode craftMode) {
        this.craftMode = craftMode;
    }

    public static enum CraftMode {
        EXT("Ext"),
        INT("Int"),
        EXTC("ExtC");

        private final String description;

        private CraftMode(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

