/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.craftinggrid;

import java.awt.Rectangle;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.DefaultSelectionEvent;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockTools;
import mcjty.rftools.craftinggrid.CraftingGridInventory;
import mcjty.rftools.craftinggrid.CraftingGridProvider;
import mcjty.rftools.craftinggrid.CraftingRecipe;
import mcjty.rftools.craftinggrid.PacketGridToServer;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.setup.CommandHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import org.lwjgl.input.Mouse;

public class GuiCraftingGrid {
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/craftinggrid.png");
    protected Window craftWindow;
    private Button craft1Button;
    private Button craft4Button;
    private Button craft8Button;
    private Button craftSButton;
    private Button storeButton;
    private WidgetList recipeList;
    private Minecraft mc;
    private GenericGuiContainer<?> gui;
    private CraftingGridProvider provider;
    private BlockPos pos;
    public static int[] testResultFromServer = null;
    private int lastTestAmount = -2;
    private int lastTestTimer = 0;

    public void initGui(ModBase modBase, SimpleNetworkWrapper network, Minecraft mc, GenericGuiContainer<?> gui, BlockPos pos, CraftingGridProvider provider, int guiLeft, int guiTop, int xSize, int ySize) {
        this.mc = mc;
        this.gui = gui;
        this.provider = provider;
        this.pos = pos;
        this.recipeList = (WidgetList)new WidgetList(mc, gui).setLayoutHint(5, 5, 56, 102);
        this.recipeList.addSelectionEvent((SelectionEvent)new DefaultSelectionEvent(){

            public void select(Widget<?> parent, int index) {
            }

            public void doubleClick(Widget<?> parent, int index) {
                GuiCraftingGrid.this.selectRecipe();
            }
        });
        this.craft1Button = (Button)((Button)((Button)((Button)new Button(mc, gui).setChannel("craft1")).setText("1")).setLayoutHint(29, 183, 14, 10)).setTooltips(new String[]{"Craft one"});
        this.craft4Button = (Button)((Button)((Button)((Button)new Button(mc, gui).setChannel("craft4")).setText("4")).setLayoutHint(45, 183, 14, 10)).setTooltips(new String[]{"Craft four"});
        this.craft8Button = (Button)((Button)((Button)((Button)new Button(mc, gui).setChannel("craft8")).setText("8")).setLayoutHint(29, 195, 14, 10)).setTooltips(new String[]{"Craft eight"});
        this.craftSButton = (Button)((Button)((Button)((Button)new Button(mc, gui).setChannel("craftstack")).setText("*")).setLayoutHint(45, 195, 14, 10)).setTooltips(new String[]{"Craft a stack"});
        this.storeButton = (Button)((Button)((Button)((Button)new Button(mc, gui).setChannel("store")).setText("Store")).setLayoutHint(5, 109, 56, 14)).setTooltips(new String[]{"Store the current recipe"});
        Panel sidePanel = (Panel)new Panel(mc, gui).setLayout((Layout)new PositionalLayout()).addChildren(new Widget[]{this.craft1Button, this.craft4Button, this.craft8Button, this.craftSButton, this.storeButton, this.recipeList});
        int sideLeft = guiLeft - CraftingGridInventory.GRID_WIDTH - 2;
        int sideTop = guiTop;
        sidePanel.setBounds(new Rectangle(sideLeft, sideTop, CraftingGridInventory.GRID_WIDTH, CraftingGridInventory.GRID_HEIGHT));
        sidePanel.setBackground(iconLocation);
        this.craftWindow = new Window(gui, (AbstractContainerWidget)sidePanel);
        this.craftWindow.event("craft1", (source, params) -> this.craft(1));
        this.craftWindow.event("craft4", (source, params) -> this.craft(4));
        this.craftWindow.event("craft8", (source, params) -> this.craft(8));
        this.craftWindow.event("craftstack", (source, params) -> this.craft(-1));
        this.craftWindow.event("store", (source, params) -> this.store());
    }

    public Window getWindow() {
        return this.craftWindow;
    }

    private void craft(int n) {
        RFToolsMessages.sendToServer("craftFromGrid", TypedMap.builder().put(CommandHandler.PARAM_COUNT, (Object)n).put(CommandHandler.PARAM_TEST, (Object)false).put(CommandHandler.PARAM_POS, (Object)this.pos));
    }

    private void testCraft(int n) {
        if (this.lastTestAmount != n || this.lastTestTimer <= 0) {
            RFToolsMessages.sendToServer("craftFromGrid", TypedMap.builder().put(CommandHandler.PARAM_COUNT, (Object)n).put(CommandHandler.PARAM_TEST, (Object)true).put(CommandHandler.PARAM_POS, (Object)this.pos));
            this.lastTestAmount = n;
            this.lastTestTimer = 20;
        }
        --this.lastTestTimer;
    }

    private void store() {
        int selected = this.recipeList.getSelected();
        if (selected == -1) {
            return;
        }
        this.provider.storeRecipe(selected);
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGridToServer(this.pos, this.provider.getCraftingGrid()));
    }

    private void selectRecipe() {
        int selected = this.recipeList.getSelected();
        if (selected == -1) {
            return;
        }
        this.provider.getCraftingGrid().selectRecipe(selected);
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketGridToServer(this.pos, this.provider.getCraftingGrid()));
    }

    private void populateList() {
        this.recipeList.removeChildren();
        for (int i = 0; i < 6; ++i) {
            CraftingRecipe recipe = this.provider.getCraftingGrid().getRecipe(i);
            this.addRecipeLine(recipe.getResult());
        }
    }

    public void draw() {
        int selected = this.recipeList.getSelected();
        this.storeButton.setEnabled(selected != -1);
        this.populateList();
        this.testRecipe();
        int x = Mouse.getEventX() * this.gui.width / this.gui.mc.displayWidth;
        int y = this.gui.height - Mouse.getEventY() * this.gui.height / this.gui.mc.displayHeight - 1;
        Widget widget = this.craftWindow.getToplevel().getWidgetAtPosition(x, y);
        if (widget == this.craft1Button) {
            this.testCraft(1);
        } else if (widget == this.craft4Button) {
            this.testCraft(4);
        } else if (widget == this.craft8Button) {
            this.testCraft(8);
        } else if (widget == this.craftSButton) {
            this.testCraft(-1);
        } else {
            testResultFromServer = null;
            this.lastTestAmount = -2;
            this.lastTestTimer = 0;
        }
        this.craftWindow.draw();
        if (testResultFromServer != null) {
            Slot slot;
            GlStateManager.pushMatrix();
            GlStateManager.translate((float)this.gui.getGuiLeft(), (float)this.gui.getGuiTop(), (float)0.0f);
            if (testResultFromServer[9] > 0 && (slot = this.gui.inventorySlots.getSlotFromInventory((IInventory)this.provider.getCraftingGrid().getCraftingGridInventory(), CraftingGridInventory.SLOT_GHOSTOUTPUT)) != null) {
                GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                int xPos = slot.xPos;
                int yPos = slot.yPos;
                Gui.drawRect((int)xPos, (int)yPos, (int)(xPos + 16), (int)(yPos + 16), (int)-65536);
            }
            for (int i = 0; i < 9; ++i) {
                Slot slot2;
                if (testResultFromServer[i] <= 0 || (slot2 = this.gui.inventorySlots.getSlotFromInventory((IInventory)this.provider.getCraftingGrid().getCraftingGridInventory(), CraftingGridInventory.SLOT_GHOSTINPUT + i)) == null) continue;
                GlStateManager.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                int xPos = slot2.xPos;
                int yPos = slot2.yPos;
                Gui.drawRect((int)xPos, (int)yPos, (int)(xPos + 16), (int)(yPos + 16), (int)-65536);
            }
            GlStateManager.popMatrix();
        }
    }

    private void testRecipe() {
        InventoryCrafting inv = new InventoryCrafting(new Container(){

            public boolean canInteractWith(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            inv.setInventorySlotContents(i, this.provider.getCraftingGrid().getCraftingGridInventory().getStackInSlot(i + 1));
        }
        IRecipe recipe = CraftingRecipe.findRecipe((World)this.mc.world, inv);
        ItemStack newResult = recipe == null ? ItemStack.EMPTY : recipe.getCraftingResult(inv);
        this.provider.getCraftingGrid().getCraftingGridInventory().setInventorySlotContents(0, newResult);
    }

    private void addRecipeLine(ItemStack craftingResult) {
        String readableName = BlockTools.getReadableName((ItemStack)craftingResult);
        int color = StyleConfig.colorTextInListNormal;
        if (craftingResult.isEmpty()) {
            readableName = "<recipe>";
            color = -11513776;
        }
        Panel panel = (Panel)((Panel)new Panel(this.mc, this.gui).setLayout((Layout)new PositionalLayout()).addChild(new BlockRender(this.mc, this.gui).setRenderItem((Object)craftingResult).setLayoutHint(0, 0, 18, 18))).addChild(((Label)((Label)((Label)new Label(this.mc, this.gui).setColor(color)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setText(readableName)).setLayoutHint(20, 0, 30, 18));
        this.recipeList.addChild((Widget)panel);
    }
}

