/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.craftinggrid;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import mcjty.rftools.craftinggrid.CraftingGrid;
import mcjty.rftools.craftinggrid.CraftingGridInventory;
import mcjty.rftools.craftinggrid.CraftingGridProvider;
import mcjty.rftools.craftinggrid.PacketGridSync;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketGridToServer
extends PacketGridSync
implements IMessage {
    private ItemStack[] stacks = new ItemStack[0];

    public void fromBytes(ByteBuf buf) {
        this.convertFromBytes(buf);
        int len = buf.readInt();
        this.stacks = new ItemStack[len];
        for (int i = 0; i < len; ++i) {
            this.stacks[i] = buf.readBoolean() ? NetworkTools.readItemStack((ByteBuf)buf) : ItemStack.EMPTY;
        }
    }

    public void toBytes(ByteBuf buf) {
        this.convertToBytes(buf);
        buf.writeInt(this.stacks.length);
        for (ItemStack stack : this.stacks) {
            if (!stack.isEmpty()) {
                buf.writeBoolean(true);
                NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)stack);
                continue;
            }
            buf.writeBoolean(false);
        }
    }

    public PacketGridToServer() {
    }

    public PacketGridToServer(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketGridToServer(BlockPos pos, CraftingGrid grid) {
        this.init(pos, grid);
        this.stacks = new ItemStack[10];
        for (int i = 0; i < 10; ++i) {
            this.stacks[i] = grid.getCraftingGridInventory().getStackInSlot(i);
        }
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            EntityPlayerMP player = ctx.getSender();
            World world = player.getEntityWorld();
            CraftingGridProvider provider = this.handleMessage(world, (EntityPlayer)player);
            if (provider != null) {
                CraftingGridInventory inventory = provider.getCraftingGrid().getCraftingGridInventory();
                for (int i = 0; i < 10; ++i) {
                    inventory.setInventorySlotContents(i, this.stacks[i]);
                }
                provider.markInventoryDirty();
            }
        });
        ctx.setPacketHandled(true);
    }
}

