/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.craftinggrid;

import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.rftools.blocks.storage.ModularStorageItemContainer;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import mcjty.rftools.blocks.storage.RemoteStorageItemContainer;
import mcjty.rftools.blocks.storagemonitor.StorageScannerContainer;
import mcjty.rftools.craftinggrid.CraftingGridProvider;
import mcjty.rftools.craftinggrid.CraftingRecipe;
import mcjty.rftools.craftinggrid.IItemKey;
import mcjty.rftools.craftinggrid.IItemSource;
import mcjty.rftools.craftinggrid.PacketCraftTestResultToClient;
import mcjty.rftools.craftinggrid.PacketGridToClient;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;

public class StorageCraftingTools {
    @Nonnull
    private static int[] tryRecipe(EntityPlayer player, CraftingRecipe craftingRecipe, int n, IItemSource itemSource, boolean strictDamage) {
        InventoryCrafting workInventory = new InventoryCrafting(new Container(){

            public boolean canInteractWith(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        InventoryCrafting inventory = craftingRecipe.getInventory();
        int[] missingCount = new int[10];
        TIntHashSet[] hashSets = new TIntHashSet[9];
        for (int i = 0; i < 10; ++i) {
            if (i < 9) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (!stack.isEmpty()) {
                    missingCount[i] = stack.getCount() * n;
                    hashSets[i] = new TIntHashSet(OreDictionary.getOreIDs((ItemStack)stack));
                } else {
                    missingCount[i] = 0;
                }
                workInventory.setInventorySlotContents(i, ItemStack.EMPTY);
                continue;
            }
            missingCount[i] = 0;
        }
        for (Pair<IItemKey, ItemStack> pair : itemSource.getItems()) {
            ItemStack input = (ItemStack)pair.getValue();
            int size = input.getCount();
            if (input.isEmpty()) continue;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack;
                if (missingCount[i] <= 0 || !StorageCraftingTools.match(stack = inventory.getStackInSlot(i), hashSets[i], input, strictDamage)) continue;
                if (size > missingCount[i]) {
                    size -= missingCount[i];
                    missingCount[i] = 0;
                } else {
                    int n2 = i;
                    missingCount[n2] = missingCount[n2] - size;
                    size = 0;
                }
                workInventory.setInventorySlotContents(i, input.copy());
            }
        }
        IRecipe recipe = craftingRecipe.getCachedRecipe(player.getEntityWorld());
        missingCount[9] = !recipe.matches(workInventory, player.getEntityWorld()) ? 1 : 0;
        if (missingCount[9] == 0) {
            for (int i = 0; i < 9; ++i) {
                if (missingCount[i] <= 0) continue;
                missingCount[9] = 1;
                break;
            }
        }
        return missingCount;
    }

    private static List<ItemStack> testAndConsumeCraftingItems(EntityPlayer player, CraftingRecipe craftingRecipe, IItemSource itemSource, boolean strictDamage) {
        ItemStack stack;
        InventoryCrafting workInventory = new InventoryCrafting(new Container(){

            public boolean canInteractWith(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        ArrayList<Pair<IItemKey, ItemStack>> undo = new ArrayList<Pair<IItemKey, ItemStack>>();
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        InventoryCrafting inventory = craftingRecipe.getInventory();
        for (int i = 0; i < inventory.getSizeInventory(); ++i) {
            stack = inventory.getStackInSlot(i);
            if (!stack.isEmpty()) {
                int count = stack.getCount();
                if ((count = StorageCraftingTools.findMatchingItems(workInventory, undo, i, stack, count, itemSource, strictDamage)) <= 0) continue;
                StorageCraftingTools.undo(player, itemSource, undo);
                return Collections.emptyList();
            }
            workInventory.setInventorySlotContents(i, ItemStack.EMPTY);
        }
        IRecipe recipe = craftingRecipe.getCachedRecipe(player.getEntityWorld());
        if (!recipe.matches(workInventory, player.getEntityWorld())) {
            result.clear();
            StorageCraftingTools.undo(player, itemSource, undo);
            return result;
        }
        stack = recipe.getCraftingResult(workInventory);
        if (!stack.isEmpty()) {
            result.add(stack);
            NonNullList remaining = recipe.getRemainingItems(workInventory);
            for (ItemStack s : remaining) {
                if (s.isEmpty()) continue;
                result.add(s);
            }
        } else {
            result.clear();
            StorageCraftingTools.undo(player, itemSource, undo);
        }
        return result;
    }

    private static boolean match(@Nonnull ItemStack target, @Nonnull TIntHashSet targetIDs, @Nonnull ItemStack input, boolean strictDamage) {
        int[] inputIDs;
        if (strictDamage) {
            return target.isItemEqual(input);
        }
        if (target.isItemEqual(input)) {
            return true;
        }
        if (targetIDs.isEmpty()) {
            return false;
        }
        for (int id : inputIDs = OreDictionary.getOreIDs((ItemStack)input)) {
            if (!targetIDs.contains(id)) continue;
            return true;
        }
        return false;
    }

    private static int findMatchingItems(InventoryCrafting workInventory, List<Pair<IItemKey, ItemStack>> undo, int i, @Nonnull ItemStack stack, int count, IItemSource itemSource, boolean strictDamage) {
        TIntHashSet stackIDs = new TIntHashSet(OreDictionary.getOreIDs((ItemStack)stack));
        for (Pair<IItemKey, ItemStack> pair : itemSource.getItems()) {
            ItemStack input = (ItemStack)pair.getValue();
            if (!input.isEmpty() && StorageCraftingTools.match(stack, stackIDs, input, strictDamage)) {
                workInventory.setInventorySlotContents(i, input.copy());
                int ss = count;
                if (input.getCount() - ss < 0) {
                    ss = input.getCount();
                }
                count -= ss;
                IItemKey key = (IItemKey)pair.getKey();
                ItemStack actuallyExtracted = itemSource.decrStackSize(key, ss);
                undo.add((Pair<IItemKey, ItemStack>)Pair.of((Object)key, (Object)actuallyExtracted));
            }
            if (count != 0) continue;
            break;
        }
        return count;
    }

    private static void undo(EntityPlayer player, IItemSource itemSource, List<Pair<IItemKey, ItemStack>> undo) {
        for (Pair<IItemKey, ItemStack> pair : undo) {
            int amountLeft;
            ItemStack stack = (ItemStack)pair.getValue();
            if (itemSource.insertStack((IItemKey)pair.getKey(), stack) || (amountLeft = itemSource.insertStackAnySlot((IItemKey)pair.getKey(), stack)) <= 0) continue;
            ItemStack copy = stack.copy();
            copy.setCount(amountLeft);
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)copy);
        }
        player.openContainer.detectAndSendChanges();
    }

    public static void craftItems(EntityPlayer player, int n, CraftingRecipe craftingRecipe, IItemSource itemSource) {
        IRecipe recipe = craftingRecipe.getCachedRecipe(player.getEntityWorld());
        if (recipe == null) {
            return;
        }
        ItemStack recipeResult = recipe.getRecipeOutput();
        if (!recipeResult.isEmpty() && recipeResult.getCount() > 0) {
            if (n == -1) {
                n = recipeResult.getMaxStackSize();
            }
            int remainder = n % recipeResult.getCount();
            n /= recipeResult.getCount();
            if (remainder != 0) {
                ++n;
            }
            if (n * recipeResult.getCount() > recipeResult.getMaxStackSize()) {
                --n;
            }
            for (int i = 0; i < n; ++i) {
                List<ItemStack> result = StorageCraftingTools.testAndConsumeCraftingItems(player, craftingRecipe, itemSource, true);
                if (result.isEmpty() && (result = StorageCraftingTools.testAndConsumeCraftingItems(player, craftingRecipe, itemSource, false)).isEmpty()) {
                    return;
                }
                for (ItemStack stack : result) {
                    if (player.inventory.addItemStackToInventory(stack)) continue;
                    player.entityDropItem(stack, 1.05f);
                }
            }
        }
    }

    @Nonnull
    public static int[] testCraftItems(EntityPlayer player, int n, CraftingRecipe craftingRecipe, IItemSource itemSource) {
        IRecipe recipe = craftingRecipe.getCachedRecipe(player.getEntityWorld());
        if (recipe == null) {
            return new int[0];
        }
        ItemStack recipeResult = recipe.getRecipeOutput();
        if (!recipeResult.isEmpty() && recipeResult.getCount() > 0) {
            if (n == -1) {
                n = recipeResult.getMaxStackSize();
            }
            int remainder = n % recipeResult.getCount();
            n /= recipeResult.getCount();
            if (remainder != 0) {
                ++n;
            }
            if (n * recipeResult.getCount() > recipeResult.getMaxStackSize()) {
                --n;
            }
            int[] result = StorageCraftingTools.tryRecipe(player, craftingRecipe, n, itemSource, true);
            for (int i = 0; i < 10; ++i) {
                if (result[i] <= 0) continue;
                int[] result2 = StorageCraftingTools.tryRecipe(player, craftingRecipe, n, itemSource, false);
                if (result2[9] == 0) {
                    return result2;
                }
                return result;
            }
            return result;
        }
        return new int[0];
    }

    public static void craftFromGrid(EntityPlayer player, int count, boolean test, BlockPos pos) {
        player.addStat(StatList.CRAFTING_TABLE_INTERACTION);
        int[] testResult = new int[]{};
        if (pos == null) {
            ItemStack mainhand = player.getHeldItemMainhand();
            if (!mainhand.isEmpty() && mainhand.getItem() == ModularStorageSetup.storageModuleTabletItem) {
                if (player.openContainer instanceof ModularStorageItemContainer) {
                    ModularStorageItemContainer storageItemContainer = (ModularStorageItemContainer)player.openContainer;
                    testResult = storageItemContainer.getCraftingGridProvider().craft(player, count, test);
                } else if (player.openContainer instanceof RemoteStorageItemContainer) {
                    RemoteStorageItemContainer storageItemContainer = (RemoteStorageItemContainer)player.openContainer;
                    testResult = storageItemContainer.getCraftingGridProvider().craft(player, count, test);
                } else if (player.openContainer instanceof StorageScannerContainer) {
                    StorageScannerContainer storageItemContainer = (StorageScannerContainer)player.openContainer;
                    testResult = storageItemContainer.getStorageScannerTileEntity().craft(player, count, test);
                }
            }
        } else {
            TileEntity te = player.getEntityWorld().getTileEntity(pos);
            if (te instanceof CraftingGridProvider) {
                testResult = ((CraftingGridProvider)te).craft(player, count, test);
            }
        }
        if (testResult.length > 0) {
            RFToolsMessages.INSTANCE.sendTo((IMessage)new PacketCraftTestResultToClient(testResult), (EntityPlayerMP)player);
        }
    }

    public static void requestGridSync(EntityPlayer player, BlockPos pos) {
        World world = player.getEntityWorld();
        CraftingGridProvider provider = null;
        if (pos == null) {
            ItemStack mainhand = player.getHeldItemMainhand();
            if (!mainhand.isEmpty() && mainhand.getItem() == ModularStorageSetup.storageModuleTabletItem) {
                if (player.openContainer instanceof ModularStorageItemContainer) {
                    ModularStorageItemContainer storageItemContainer = (ModularStorageItemContainer)player.openContainer;
                    provider = storageItemContainer.getCraftingGridProvider();
                } else if (player.openContainer instanceof RemoteStorageItemContainer) {
                    RemoteStorageItemContainer storageItemContainer = (RemoteStorageItemContainer)player.openContainer;
                    provider = storageItemContainer.getCraftingGridProvider();
                } else if (player.openContainer instanceof StorageScannerContainer) {
                    StorageScannerContainer storageItemContainer = (StorageScannerContainer)player.openContainer;
                    provider = storageItemContainer.getStorageScannerTileEntity();
                }
            }
        } else {
            TileEntity te = world.getTileEntity(pos);
            if (te instanceof CraftingGridProvider) {
                provider = (CraftingGridProvider)te;
            }
        }
        if (provider != null) {
            RFToolsMessages.INSTANCE.sendTo((IMessage)new PacketGridToClient(pos, provider.getCraftingGrid()), (EntityPlayerMP)player);
        }
    }
}

