/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.manual;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import mcjty.lib.base.ModBase;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextPage;
import mcjty.lib.gui.widgets.Widget;
import mcjty.rftools.RFTools;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;

public class GuiRFToolsManual
extends GuiScreen {
    private int xSize = 400;
    private int ySize = 224;
    private Window window;
    private TextPage textPage;
    private Label pageLabel;
    private Button prevButton;
    private Button nextButton;
    public static int MANUAL_MAIN = 0;
    public static int MANUAL_SHAPE = 1;
    private ResourceLocation manualText;
    public static String locatePage = null;
    private static final ResourceLocation manualMainText = new ResourceLocation("rftools", "text/manual.txt");
    private static final ResourceLocation manualShapeText = new ResourceLocation("rftools", "text/manual_shape.txt");
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");

    public GuiRFToolsManual(int manual) {
        String gameLocale = Minecraft.getMinecraft().getLanguageManager().getCurrentLanguage().getLanguageCode().toLowerCase(Locale.ENGLISH);
        if (manual == MANUAL_MAIN) {
            this.manualText = gameLocale.equals("en_us") ? manualMainText : new ResourceLocation("rftools", "text/manual-" + gameLocale + ".txt");
        } else if (manual == MANUAL_SHAPE) {
            this.manualText = gameLocale.equals("en_us") ? manualShapeText : new ResourceLocation("rftools", "text/manual_shape-" + gameLocale + ".txt");
        }
    }

    public void initGui() {
        super.initGui();
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        this.textPage = new TextPage((ModBase)RFTools.instance, this.mc, (Gui)this).setText(this.manualText).setArrowImage(iconGuiElements, 144, 0).setCraftingGridImage(iconGuiElements, 0, 192);
        this.prevButton = ((Button)new Button(this.mc, (Gui)this).setText("<")).addButtonEvent(parent -> {
            this.textPage.prevPage();
            this.window.setTextFocus((Widget)this.textPage);
        });
        this.pageLabel = (Label)new Label(this.mc, (Gui)this).setText("0 / 0");
        this.nextButton = ((Button)new Button(this.mc, (Gui)this).setText(">")).addButtonEvent(parent -> {
            this.textPage.nextPage();
            this.window.setTextFocus((Widget)this.textPage);
        });
        Panel buttonPanel = (Panel)((Panel)new Panel(this.mc, (Gui)this).setLayout((Layout)new HorizontalLayout()).setDesiredHeight(16)).addChildren(new Widget[]{this.prevButton, this.pageLabel, this.nextButton});
        Panel toplevel = (Panel)((Panel)new Panel(this.mc, (Gui)this).setFilledRectThickness(2)).setLayout((Layout)new VerticalLayout()).addChildren(new Widget[]{this.textPage, buttonPanel});
        toplevel.setBounds(new Rectangle(k, l, this.xSize, this.ySize));
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
        this.window.setTextFocus((Widget)this.textPage);
        if (locatePage != null) {
            this.textPage.gotoNode(locatePage);
            locatePage = null;
        }
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    protected void mouseClicked(int x, int y, int button) throws IOException {
        super.mouseClicked(x, y, button);
        this.window.mouseClicked(x, y, button);
    }

    public void handleMouseInput() throws IOException {
        super.handleMouseInput();
        this.window.handleMouseInput();
    }

    protected void mouseReleased(int mouseX, int mouseY, int state) {
        super.mouseReleased(mouseX, mouseY, state);
        this.window.mouseMovedOrUp(mouseX, mouseY, state);
    }

    protected void keyTyped(char typedChar, int keyCode) throws IOException {
        super.keyTyped(typedChar, keyCode);
        this.window.keyTyped(typedChar, keyCode);
    }

    public void drawScreen(int xSize_lo, int ySize_lo, float par3) {
        super.drawScreen(xSize_lo, ySize_lo, par3);
        int index = this.textPage.getPageIndex();
        int count = this.textPage.getPageCount();
        this.pageLabel.setText(index + 1 + "/" + count);
        this.prevButton.setEnabled(index > 0);
        this.nextButton.setEnabled(index < count - 1);
        this.window.draw();
        List tooltips = this.window.getTooltips();
        if (tooltips != null) {
            int guiLeft = (this.width - this.xSize) / 2;
            int guiTop = (this.height - this.ySize) / 2;
            int x = Mouse.getEventX() * this.width / this.mc.displayWidth;
            int y = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
            this.drawHoveringText(tooltips, x - guiLeft, y - guiTop, this.mc.fontRenderer);
        }
    }
}

