/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.modifier;

import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import mcjty.lib.base.ModBase;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftools.RFTools;
import mcjty.rftools.items.ModItems;
import mcjty.rftools.items.modifier.ModifierCommand;
import mcjty.rftools.items.modifier.ModifierContainer;
import mcjty.rftools.items.modifier.ModifierEntry;
import mcjty.rftools.items.modifier.ModifierFilterOperation;
import mcjty.rftools.items.modifier.ModifierFilterType;
import mcjty.rftools.items.modifier.ModifierItem;
import mcjty.rftools.items.modifier.PacketUpdateModifier;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.setup.GuiProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiModifier
extends GenericGuiContainer<GenericTileEntity> {
    public static final int MODIFIER_WIDTH = 180;
    public static final int MODIFIER_HEIGHT = 228;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/modifier.png");
    private static final ResourceLocation guiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");
    private ChoiceLabel mode;
    private ChoiceLabel op;
    private Button add;
    private Button del;
    private Button up;
    private Button down;
    private WidgetList list;

    public GuiModifier(ModifierContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, null, (Container)container, GuiProxy.GUI_MANUAL_SHAPE, "modifier");
        this.xSize = 180;
        this.ySize = 228;
    }

    private ItemStack getItem() {
        EntityPlayerSP player = Minecraft.getMinecraft().player;
        return player.getHeldItem(EnumHand.MAIN_HAND);
    }

    private boolean isValidItem() {
        ItemStack item = this.getItem();
        return !item.isEmpty() && item.getItem() == ModItems.modifierItem;
    }

    public void initGui() {
        super.initGui();
        Panel toplevel = (Panel)new Panel(this.mc, (Gui)this).setLayout((Layout)new PositionalLayout()).setBackground(iconLocation);
        this.mode = new ChoiceLabel(this.mc, (Gui)this).addChoices(new String[]{ModifierFilterType.FILTER_SLOT.getCode(), ModifierFilterType.FILTER_ORE.getCode(), ModifierFilterType.FILTER_LIQUID.getCode(), ModifierFilterType.FILTER_TILEENTITY.getCode()});
        this.mode.setLayoutHint(30, 9, 45, 14);
        toplevel.addChild((Widget)this.mode);
        this.op = new ChoiceLabel(this.mc, (Gui)this).addChoices(new String[]{ModifierFilterOperation.OPERATION_SLOT.getCode(), ModifierFilterOperation.OPERATION_VOID.getCode()});
        this.op.setLayoutHint(110, 9, 40, 14);
        toplevel.addChild((Widget)this.op);
        this.add = (Button)((Button)new Button(this.mc, (Gui)this).setChannel("add")).setText("Add");
        this.add.setLayoutHint(10, 30, 40, 13);
        toplevel.addChild((Widget)this.add);
        this.del = (Button)((Button)new Button(this.mc, (Gui)this).setChannel("del")).setText("Del");
        this.del.setLayoutHint(52, 30, 40, 13);
        toplevel.addChild((Widget)this.del);
        this.up = (Button)((Button)new Button(this.mc, (Gui)this).setChannel("up")).setText("Up");
        this.up.setLayoutHint(110, 30, 30, 13);
        toplevel.addChild((Widget)this.up);
        this.down = (Button)((Button)new Button(this.mc, (Gui)this).setChannel("down")).setText("Down");
        this.down.setLayoutHint(142, 30, 30, 13);
        toplevel.addChild((Widget)this.down);
        this.list = (WidgetList)new WidgetList(this.mc, (Gui)this).setName("list");
        this.list.setLayoutHint(9, 45, 153, 95);
        toplevel.addChild((Widget)this.list);
        Slider slider = new Slider(this.mc, (Gui)this).setVertical().setScrollableName("list");
        slider.setLayoutHint(162, 45, 10, 95);
        toplevel.addChild((Widget)slider);
        toplevel.setBounds(new Rectangle(this.guiLeft, this.guiTop, this.xSize, this.ySize));
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
        this.window.event("add", (source, params) -> this.addOp());
        this.window.event("del", (source, params) -> this.delOp());
        this.window.event("up", (source, params) -> this.upOp());
        this.window.event("down", (source, params) -> this.downOp());
    }

    private void refreshList() {
        this.list.removeChildren();
        List<ModifierEntry> modifiers = this.getModifiers();
        for (ModifierEntry modifier : modifiers) {
            ItemStack stackIn = modifier.getIn();
            ItemStack stackOut = modifier.getOut();
            ModifierFilterType type = modifier.getType();
            ModifierFilterOperation op = modifier.getOp();
            Panel panel = (Panel)((Panel)new Panel(this.mc, (Gui)this).setLayout((Layout)new PositionalLayout()).setDesiredHeight(18)).setDesiredWidth(150);
            panel.addChild((Widget)((BlockRender)new BlockRender(this.mc, (Gui)this).setLayoutHint(1, 0, 18, 18)).setRenderItem((Object)stackIn));
            panel.addChild(((Label)((Label)new Label(this.mc, (Gui)this).setText(type.getCode() + " -> " + op.getCode())).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setLayoutHint(22, 0, 100, 18));
            panel.addChild((Widget)((BlockRender)new BlockRender(this.mc, (Gui)this).setLayoutHint(130, 0, 18, 18)).setRenderItem((Object)stackOut));
            this.list.addChild((Widget)panel);
        }
    }

    private List<ModifierEntry> getModifiers() {
        if (!this.isValidItem()) {
            return Collections.emptyList();
        }
        ItemStack item = this.getItem();
        return ModifierItem.getModifiers(item);
    }

    private void addOp() {
        if (!this.isValidItem()) {
            return;
        }
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketUpdateModifier(ModifierCommand.ADD, 0, ModifierFilterType.getByCode(this.mode.getCurrentChoice()), ModifierFilterOperation.getByCode(this.op.getCurrentChoice())));
    }

    private void delOp() {
        if (this.list.getSelected() < 0) {
            return;
        }
        if (!this.isValidItem()) {
            return;
        }
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketUpdateModifier(ModifierCommand.DEL, this.list.getSelected(), ModifierFilterType.getByCode(this.mode.getCurrentChoice()), ModifierFilterOperation.getByCode(this.op.getCurrentChoice())));
    }

    private void upOp() {
        if (this.list.getSelected() <= 0) {
            return;
        }
        if (!this.isValidItem()) {
            return;
        }
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketUpdateModifier(ModifierCommand.UP, this.list.getSelected(), ModifierFilterType.getByCode(this.mode.getCurrentChoice()), ModifierFilterOperation.getByCode(this.op.getCurrentChoice())));
        this.list.setSelected(this.list.getSelected() - 1);
    }

    private void downOp() {
        if (this.list.getSelected() > this.list.getChildCount() - 1) {
            return;
        }
        if (!this.isValidItem()) {
            return;
        }
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketUpdateModifier(ModifierCommand.DOWN, this.list.getSelected(), ModifierFilterType.getByCode(this.mode.getCurrentChoice()), ModifierFilterOperation.getByCode(this.op.getCurrentChoice())));
        this.list.setSelected(this.list.getSelected() + 1);
    }

    protected void drawGuiContainerBackgroundLayer(float v, int i, int i2) {
        this.refreshList();
        this.del.setEnabled(this.list.getSelected() >= 0 && this.list.getChildCount() > 0 && this.list.getSelected() < this.list.getChildCount());
        this.up.setEnabled(this.list.getSelected() > 0 && this.list.getSelected() < this.list.getChildCount());
        this.down.setEnabled(this.list.getSelected() < this.list.getChildCount() - 1 && this.list.getSelected() >= 0);
        this.drawWindow();
    }
}

