/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.modifier;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftools.RFTools;
import mcjty.rftools.items.GenericRFToolsItem;
import mcjty.rftools.items.ModItems;
import mcjty.rftools.items.modifier.ModifierCommand;
import mcjty.rftools.items.modifier.ModifierEntry;
import mcjty.rftools.items.modifier.ModifierFilterOperation;
import mcjty.rftools.items.modifier.ModifierFilterType;
import mcjty.rftools.items.modifier.ModifierInventory;
import mcjty.rftools.setup.GuiProxy;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ModifierItem
extends GenericRFToolsItem {
    public ModifierItem() {
        super("modifier_module");
        this.setMaxStackSize(1);
    }

    private static NBTTagList getOpList(ItemStack item) {
        if (!item.isEmpty() && item.getItem() == ModItems.modifierItem) {
            NBTTagCompound tag;
            if (!item.hasTagCompound()) {
                item.setTagCompound(new NBTTagCompound());
            }
            if ((tag = item.getTagCompound()).hasKey("ops")) {
                return tag.getTagList("ops", 10);
            }
            NBTTagList taglist = new NBTTagList();
            tag.setTag("ops", (NBTBase)taglist);
            return taglist;
        }
        return null;
    }

    public static void performCommand(EntityPlayer player, ItemStack stack, ModifierCommand cmd, int index, ModifierFilterType type, ModifierFilterOperation op) {
        stack = stack.copy();
        switch (cmd) {
            case ADD: {
                ModifierItem.addOp(stack, type, op);
                break;
            }
            case DEL: {
                ModifierItem.delOp(stack, index);
                break;
            }
            case UP: {
                ModifierItem.upOp(stack, index);
                break;
            }
            case DOWN: {
                ModifierItem.downOp(stack, index);
            }
        }
        player.setHeldItem(EnumHand.MAIN_HAND, stack);
        player.openContainer.detectAndSendChanges();
    }

    private static NBTTagList getTagList(List<ModifierEntry> modifiers) {
        NBTTagList taglist = new NBTTagList();
        for (ModifierEntry modifier : modifiers) {
            NBTTagCompound tc;
            NBTTagCompound tag = new NBTTagCompound();
            if (!modifier.getIn().isEmpty()) {
                tc = new NBTTagCompound();
                modifier.getIn().writeToNBT(tc);
                tag.setTag("in", (NBTBase)tc);
            }
            if (!modifier.getOut().isEmpty()) {
                tc = new NBTTagCompound();
                modifier.getOut().writeToNBT(tc);
                tag.setTag("out", (NBTBase)tc);
            }
            tag.setString("type", modifier.getType().getCode());
            tag.setString("op", modifier.getOp().getCode());
            taglist.appendTag((NBTBase)tag);
        }
        return taglist;
    }

    private static void updateModifiers(ItemStack stack, List<ModifierEntry> modifiers) {
        NBTTagList tagList = ModifierItem.getTagList(modifiers);
        stack.getTagCompound().setTag("ops", (NBTBase)tagList);
    }

    public static ItemStackList getItemStacks(@Nullable NBTTagCompound tagCompound) {
        ItemStackList stacks = ItemStackList.create((int)2);
        if (tagCompound != null) {
            NBTTagList bufferTagList = tagCompound.getTagList("Items", 10);
            for (int i = 0; i < bufferTagList.tagCount(); ++i) {
                NBTTagCompound nbtTagCompound = bufferTagList.getCompoundTagAt(i);
                stacks.set(i, (Object)new ItemStack(nbtTagCompound));
            }
        }
        return stacks;
    }

    private static void upOp(ItemStack stack, int index) {
        List<ModifierEntry> modifiers = ModifierItem.getModifiers(stack);
        ModifierEntry entry = modifiers.get(index);
        modifiers.remove(index);
        modifiers.add(index - 1, entry);
        ModifierItem.updateModifiers(stack, modifiers);
    }

    private static void downOp(ItemStack stack, int index) {
        List<ModifierEntry> modifiers = ModifierItem.getModifiers(stack);
        ModifierEntry entry = modifiers.get(index);
        modifiers.remove(index);
        modifiers.add(index + 1, entry);
        ModifierItem.updateModifiers(stack, modifiers);
    }

    private static void addOp(ItemStack stack, ModifierFilterType type, ModifierFilterOperation op) {
        List<ModifierEntry> modifiers = ModifierItem.getModifiers(stack);
        NBTTagCompound tagCompound = stack.getTagCompound();
        ItemStackList stacks = ModifierItem.getItemStacks(tagCompound);
        ItemStack stackIn = (ItemStack)stacks.get(0);
        ItemStack stackOut = (ItemStack)stacks.get(1);
        modifiers.add(new ModifierEntry(stackIn, stackOut, type, op));
        stacks.set(0, (Object)ItemStack.EMPTY);
        stacks.set(1, (Object)ItemStack.EMPTY);
        ModifierInventory.convertItemsToNBT(tagCompound, stacks);
        ModifierItem.updateModifiers(stack, modifiers);
    }

    private static void delOp(ItemStack stack, int index) {
        List<ModifierEntry> modifiers = ModifierItem.getModifiers(stack);
        ModifierEntry entry = modifiers.get(index);
        ItemStack in = entry.getIn();
        ItemStack out = entry.getOut();
        NBTTagCompound tagCompound = stack.getTagCompound();
        ItemStackList stacks = ModifierItem.getItemStacks(tagCompound);
        if (!in.isEmpty() && !((ItemStack)stacks.get(0)).isEmpty()) {
            return;
        }
        if (!out.isEmpty() && !((ItemStack)stacks.get(1)).isEmpty()) {
            return;
        }
        if (!in.isEmpty()) {
            stacks.set(0, (Object)in.copy());
        }
        if (!out.isEmpty()) {
            stacks.set(1, (Object)out.copy());
        }
        ModifierInventory.convertItemsToNBT(tagCompound, stacks);
        modifiers.remove(index);
        ModifierItem.updateModifiers(stack, modifiers);
    }

    public static List<ModifierEntry> getModifiers(ItemStack item) {
        ArrayList<ModifierEntry> modifiers = new ArrayList<ModifierEntry>();
        NBTTagList taglist = ModifierItem.getOpList(item);
        if (taglist == null) {
            return Collections.emptyList();
        }
        for (int i = 0; i < taglist.tagCount(); ++i) {
            NBTTagCompound compound = taglist.getCompoundTagAt(i);
            ItemStack stackIn = new ItemStack(compound.getCompoundTag("in"));
            ItemStack stackOut = new ItemStack(compound.getCompoundTag("out"));
            ModifierFilterType type = ModifierFilterType.getByCode(compound.getString("type"));
            ModifierFilterOperation op = ModifierFilterOperation.getByCode(compound.getString("op"));
            modifiers.add(new ModifierEntry(stackIn, stackOut, type, op));
        }
        return modifiers;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This module can be used by the area scanner to");
            list.add(TextFormatting.WHITE + "modify the scanned output");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.getHeldItem(hand);
        if (!world.isRemote) {
            player.openGui((Object)RFTools.instance, GuiProxy.GUI_MODIFIER_MODULE, player.getEntityWorld(), (int)player.posX, (int)player.posY, (int)player.posZ);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }
}

