/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.screenmodules;

import java.util.List;
import mcjty.lib.varia.Logging;
import mcjty.rftools.api.screens.IModuleGuiBuilder;
import mcjty.rftools.api.screens.IModuleProvider;
import mcjty.rftools.blocks.logic.wireless.RedstoneChannelTileEntity;
import mcjty.rftools.blocks.screens.ScreenConfiguration;
import mcjty.rftools.blocks.screens.modules.RedstoneScreenModule;
import mcjty.rftools.blocks.screens.modulesclient.RedstoneClientScreenModule;
import mcjty.rftools.items.GenericRFToolsItem;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RedstoneModuleItem
extends GenericRFToolsItem
implements IModuleProvider {
    public RedstoneModuleItem() {
        super("redstone_module");
        this.setMaxStackSize(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation("rftools:" + this.getTranslationKey().substring(5), "inventory"));
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 1;
    }

    public Class<RedstoneScreenModule> getServerScreenModule() {
        return RedstoneScreenModule.class;
    }

    public Class<RedstoneClientScreenModule> getClientScreenModule() {
        return RedstoneClientScreenModule.class;
    }

    @Override
    public String getName() {
        return "Red";
    }

    @Override
    public void createGui(IModuleGuiBuilder guiBuilder) {
        guiBuilder.label("Label:").text("text", "Label text").color("color", "Color for the label").nl().label("Yes:").text("yestext", "Positive text").color("yescolor", "Color for the positive text").nl().label("No:").text("notext", "Negative text").color("nocolor", "Color for the negative text").nl().choices("align", "Label alignment", "Left", "Center", "Right").toggle("analog", "Analog mode", "Whether to show the exact level").nl().label("Block:").block("monitor").nl();
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        list.add(TextFormatting.GREEN + "Uses " + ScreenConfiguration.REDSTONE_RFPERTICK.get() + " RF/tick");
        NBTTagCompound tagCompound = itemStack.getTagCompound();
        if (tagCompound != null) {
            list.add(TextFormatting.YELLOW + "Label: " + tagCompound.getString("text"));
            int channel = tagCompound.getInteger("channel");
            if (channel != -1) {
                list.add(TextFormatting.YELLOW + "Channel: " + channel);
            } else if (tagCompound.hasKey("monitorx")) {
                int mx = tagCompound.getInteger("monitorx");
                int my = tagCompound.getInteger("monitory");
                int mz = tagCompound.getInteger("monitorz");
                list.add(TextFormatting.YELLOW + "Block at: " + mx + "," + my + "," + mz);
            }
        }
        list.add(TextFormatting.WHITE + "Sneak right-click on a redstone transmitter or");
        list.add(TextFormatting.WHITE + "receiver to set the channel for this module.");
        list.add(TextFormatting.WHITE + "Or else sneak right-click on the side of any");
        list.add(TextFormatting.WHITE + "block to monitor the redstone output on that side");
    }

    public EnumActionResult onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.isRemote) {
            return EnumActionResult.SUCCESS;
        }
        ItemStack stack = player.getHeldItem(hand);
        TileEntity te = world.getTileEntity(pos);
        NBTTagCompound tagCompound = stack.getTagCompound();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.setTagCompound(tagCompound);
        }
        int channel = -1;
        if (!(te instanceof RedstoneChannelTileEntity)) {
            tagCompound.setInteger("channel", -1);
            tagCompound.setInteger("monitordim", world.provider.getDimension());
            tagCompound.setInteger("monitorx", pos.getX());
            tagCompound.setInteger("monitory", pos.getY());
            tagCompound.setInteger("monitorz", pos.getZ());
            tagCompound.setInteger("monitorside", facing.ordinal());
            Logging.message((EntityPlayer)player, (String)("Redstone module is set to " + pos));
            return EnumActionResult.SUCCESS;
        }
        channel = ((RedstoneChannelTileEntity)te).getChannel(true);
        tagCompound.removeTag("monitordim");
        tagCompound.removeTag("monitorx");
        tagCompound.removeTag("monitory");
        tagCompound.removeTag("monitorz");
        tagCompound.removeTag("monitorside");
        if (channel != -1) {
            tagCompound.setInteger("channel", channel);
            Logging.message((EntityPlayer)player, (String)("Redstone module is set to channel '" + channel + "'"));
        } else {
            tagCompound.removeTag("channel");
            Logging.message((EntityPlayer)player, (String)"Redstone module is cleared");
        }
        return EnumActionResult.SUCCESS;
    }
}

