/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.storage;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.thirteen.Context;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.rftools.items.storage.StorageFilterItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketUpdateNBTItemFilter
implements IMessage {
    public TypedMap args;

    public PacketUpdateNBTItemFilter() {
    }

    public PacketUpdateNBTItemFilter(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketUpdateNBTItemFilter(TypedMap arguments) {
        this.args = arguments;
    }

    protected boolean isValidItem(ItemStack itemStack) {
        return itemStack.getItem() instanceof StorageFilterItem;
    }

    public void fromBytes(ByteBuf buf) {
        this.args = TypedMapTools.readArguments((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        TypedMapTools.writeArguments((ByteBuf)buf, (TypedMap)this.args);
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            EntityPlayerMP playerEntity = ctx.getSender();
            ItemStack heldItem = playerEntity.getHeldItem(EnumHand.MAIN_HAND);
            if (heldItem.isEmpty()) {
                return;
            }
            if (!this.isValidItem(heldItem)) {
                return;
            }
            NBTTagCompound tagCompound = heldItem.getTagCompound();
            if (tagCompound == null) {
                tagCompound = new NBTTagCompound();
                heldItem.setTagCompound(tagCompound);
            }
            for (Key akey : this.args.getKeys()) {
                String key = akey.getName();
                if (Type.STRING.equals(akey.getType())) {
                    tagCompound.setString(key, (String)this.args.get(akey));
                    continue;
                }
                if (Type.INTEGER.equals(akey.getType())) {
                    tagCompound.setInteger(key, ((Integer)this.args.get(akey)).intValue());
                    continue;
                }
                if (Type.LONG.equals(akey.getType())) {
                    tagCompound.setLong(key, ((Long)this.args.get(akey)).longValue());
                    continue;
                }
                if (Type.DOUBLE.equals(akey.getType())) {
                    tagCompound.setDouble(key, ((Double)this.args.get(akey)).doubleValue());
                    continue;
                }
                if (Type.BOOLEAN.equals(akey.getType())) {
                    tagCompound.setBoolean(key, ((Boolean)this.args.get(akey)).booleanValue());
                    continue;
                }
                if (Type.BLOCKPOS.equals(akey.getType())) {
                    throw new RuntimeException("BlockPos not supported for PacketUpdateNBTItem!");
                }
                if (Type.ITEMSTACK.equals(akey.getType())) {
                    throw new RuntimeException("ItemStack not supported for PacketUpdateNBTItem!");
                }
                throw new RuntimeException(akey.getType().getType().getSimpleName() + " not supported for PacketUpdateNBTItem!");
            }
        });
        ctx.setPacketHandled(true);
    }
}

