/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.storage;

import mcjty.lib.container.BaseSlot;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.container.SlotFactory;
import mcjty.lib.container.SlotType;
import mcjty.rftools.items.storage.StorageFilterInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class StorageFilterContainer
extends GenericContainer {
    public static final String CONTAINER_INVENTORY = "container";
    public static final int SLOT_FILTER = 0;
    public static final int FILTER_SLOTS = 30;
    private int cardIndex;
    public static final ContainerFactory factory = new ContainerFactory(){

        protected void setup() {
            this.addSlotBox(new SlotDefinition(SlotType.SLOT_GHOST, new ItemStack[0]), StorageFilterContainer.CONTAINER_INVENTORY, 0, 10, 9, 6, 18, 5, 18);
            this.layoutPlayerInventorySlots(10, 106);
        }
    };

    public StorageFilterContainer(EntityPlayer player) {
        super(factory);
        this.addInventory(CONTAINER_INVENTORY, new StorageFilterInventory(player));
        this.addInventory("player", (IInventory)player.inventory);
        this.cardIndex = player.inventory.currentItem;
        this.generateSlots();
    }

    protected Slot createSlot(SlotFactory slotFactory, IInventory inventory, int index, int x, int y, SlotType slotType) {
        if (slotType == SlotType.SLOT_PLAYERHOTBAR && index == this.cardIndex) {
            return new BaseSlot((IInventory)this.inventories.get(slotFactory.getInventoryName()), slotFactory.getIndex(), slotFactory.getX(), slotFactory.getY()){

                public boolean canTakeStack(EntityPlayer player) {
                    return false;
                }
            };
        }
        return super.createSlot(slotFactory, inventory, index, x, y, slotType);
    }

    public ItemStack transferStackInSlot(EntityPlayer player, int index) {
        Slot slot = (Slot)this.inventorySlots.get(index);
        if (slot != null && slot.getHasStack() && index >= 30 && index < 66) {
            ItemStack stack = slot.getStack().copy();
            stack.setCount(1);
            IInventory inv = (IInventory)this.inventories.get(CONTAINER_INVENTORY);
            for (int i = 0; i < inv.getSizeInventory(); ++i) {
                if (!inv.getStackInSlot(i).isEmpty()) continue;
                inv.setInventorySlotContents(i, stack);
                break;
            }
            slot.onSlotChanged();
        }
        return ItemStack.EMPTY;
    }
}

