/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.storage;

import java.util.List;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.IEnergyItem;
import mcjty.lib.varia.ItemCapabilityProvider;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.WorldTools;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.storage.ModularStorageConfiguration;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import mcjty.rftools.items.GenericRFToolsItem;
import mcjty.rftools.items.screenmodules.StorageControlModuleItem;
import mcjty.rftools.items.storage.StorageModuleItem;
import mcjty.rftools.setup.GuiProxy;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class StorageModuleTabletItem
extends GenericRFToolsItem
implements IEnergyItem {
    private int capacity;
    private int maxReceive;
    private int maxExtract;
    public static final int DAMAGE_EMPTY = 0;
    public static final int DAMAGE_FULL = 1;
    public static final int DAMAGE_SCANNER = 2;
    public static final int META_FOR_SCANNER = 666;

    public StorageModuleTabletItem() {
        super("storage_module_tablet");
        this.setMaxStackSize(1);
        this.capacity = ModularStorageConfiguration.TABLET_MAXENERGY.get();
        this.maxReceive = ModularStorageConfiguration.TABLET_RECEIVEPERTICK.get();
        this.maxExtract = ModularStorageConfiguration.TABLET_CONSUMEPERUSE.get();
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.isEmpty() != newStack.isEmpty()) {
            return true;
        }
        return oldStack.getItem() != newStack.getItem();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new ItemCapabilityProvider(stack, (IEnergyItem)this);
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(this.getRegistryName() + "_empty", "inventory"), new ModelResourceLocation(this.getRegistryName(), "inventory")});
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_empty", "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)1, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)2, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName() + "_scanner", "inventory"));
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.getHeldItem(hand);
        if (hand != EnumHand.MAIN_HAND) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (!world.isRemote) {
            int rfNeeded;
            NBTTagCompound tagCompound = stack.getTagCompound();
            if (tagCompound == null || !tagCompound.hasKey("childDamage")) {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "This tablet contains no storage module!"));
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            int moduleDamage = tagCompound.getInteger("childDamage");
            if (moduleDamage == 666) {
                rfNeeded = ModularStorageConfiguration.TABLET_CONSUMEPERUSE_SCANNER.get();
            } else {
                rfNeeded = ModularStorageConfiguration.TABLET_CONSUMEPERUSE.get();
                if (moduleDamage != 6) {
                    rfNeeded += ModularStorageConfiguration.TABLET_EXTRACONSUME.get() * (moduleDamage + 1);
                }
            }
            int energy = tagCompound.getInteger("Energy");
            if (energy < rfNeeded) {
                Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "Not enough energy to open the contents!"));
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            tagCompound.setInteger("Energy", energy -= rfNeeded);
            if (moduleDamage == 666) {
                if (tagCompound.hasKey("monitorx")) {
                    int monitordim = tagCompound.getInteger("monitordim");
                    int monitorx = tagCompound.getInteger("monitorx");
                    int monitory = tagCompound.getInteger("monitory");
                    int monitorz = tagCompound.getInteger("monitorz");
                    BlockPos pos = new BlockPos(monitorx, monitory, monitorz);
                    WorldServer w = DimensionManager.getWorld((int)monitordim);
                    if (w == null || !WorldTools.chunkLoaded((World)w, (BlockPos)pos)) {
                        player.sendStatusMessage((ITextComponent)new TextComponentString(TextFormatting.RED + "Storage scanner is out of range!"), false);
                    } else {
                        player.openGui((Object)RFTools.instance, GuiProxy.GUI_REMOTE_STORAGESCANNER_ITEM, player.getEntityWorld(), (int)player.posX, (int)player.posY, (int)player.posZ);
                    }
                } else {
                    player.sendStatusMessage((ITextComponent)new TextComponentString(TextFormatting.RED + "Storage module is not linked to a storage scanner!"), false);
                }
            } else if (moduleDamage == 6) {
                if (!tagCompound.hasKey("id")) {
                    Logging.message((EntityPlayer)player, (String)(TextFormatting.YELLOW + "This remote storage module is not linked!"));
                    return new ActionResult(EnumActionResult.FAIL, (Object)stack);
                }
                player.openGui((Object)RFTools.instance, GuiProxy.GUI_REMOTE_STORAGE_ITEM, player.getEntityWorld(), (int)player.posX, (int)player.posY, (int)player.posZ);
            } else {
                player.openGui((Object)RFTools.instance, GuiProxy.GUI_MODULAR_STORAGE_ITEM, player.getEntityWorld(), (int)player.posX, (int)player.posY, (int)player.posZ);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return stack.getItemDamage() != 0;
    }

    public Item getContainerItem() {
        return ModularStorageSetup.storageModuleTabletItem;
    }

    public boolean isDamageable() {
        return super.isDamageable();
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (this.hasContainerItem(stack) && stack.hasTagCompound()) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.setInteger("Energy", stack.getTagCompound().getInteger("Energy"));
            if (stack.getTagCompound().hasKey("grid")) {
                tagCompound.setTag("grid", stack.getTagCompound().getTag("grid"));
            }
            ItemStack container = new ItemStack(this.getContainerItem());
            container.setTagCompound(tagCompound);
            return container;
        }
        return ItemStack.EMPTY;
    }

    public void addInformation(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.getTagCompound();
        if (tagCompound != null) {
            list.add(TextFormatting.BLUE + "Energy: " + tagCompound.getInteger("Energy") + " RF");
            if (itemStack.getItemDamage() == 1) {
                int max = StorageModuleItem.MAXSIZE[tagCompound.getInteger("childDamage")];
                StorageModuleItem.addModuleInformation(list, max, tagCompound);
            } else if (itemStack.getItemDamage() == 2) {
                list.add(TextFormatting.YELLOW + "Storage scanner module installed!");
                StorageControlModuleItem.addModuleInformation(list, itemStack);
            } else {
                list.add(TextFormatting.YELLOW + "No storage module installed!");
            }
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add("This RF/charged tablet can hold a storage module");
            list.add("and allows the wielder to manipulate the contents of");
            list.add("this module (remote or normal).");
            list.add("You can also craft this with a storage control");
            list.add("screen module for remote access to a storage scanner");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public long receiveEnergyL(ItemStack container, long maxReceive, boolean simulate) {
        if (container.getTagCompound() == null) {
            container.setTagCompound(new NBTTagCompound());
        }
        int energy = container.getTagCompound().getInteger("Energy");
        int energyReceived = Math.min(this.capacity - energy, Math.min(this.maxReceive, EnergyTools.unsignedClampToInt((long)maxReceive)));
        if (!simulate) {
            container.getTagCompound().setInteger("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public long extractEnergyL(ItemStack container, long maxExtract, boolean simulate) {
        if (container.getTagCompound() == null || !container.getTagCompound().hasKey("Energy")) {
            return 0L;
        }
        int energy = container.getTagCompound().getInteger("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.maxExtract, EnergyTools.unsignedClampToInt((long)maxExtract)));
        if (!simulate) {
            container.getTagCompound().setInteger("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public long getEnergyStoredL(ItemStack container) {
        if (container.getTagCompound() == null || !container.getTagCompound().hasKey("Energy")) {
            return 0L;
        }
        return container.getTagCompound().getInteger("Energy");
    }

    public long getMaxEnergyStoredL(ItemStack container) {
        return this.capacity;
    }
}

