/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.teleportprobe;

import java.awt.Rectangle;
import mcjty.lib.base.ModBase;
import mcjty.lib.gui.GuiItemScreen;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.typed.TypedMap;
import mcjty.rftools.RFTools;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.setup.CommandHandler;
import mcjty.rftools.setup.GuiProxy;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;

public class GuiAdvancedPorter
extends GuiItemScreen {
    private static final int xSize = 340;
    private static final int ySize = 136;
    private Panel[] panels = new Panel[8];
    private TextField[] destinations = new TextField[8];
    private static int target = -1;
    private static int[] targets = new int[8];
    private static String[] names = new String[8];

    public GuiAdvancedPorter() {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, 340, 136, GuiProxy.GUI_MANUAL_MAIN, "porter");
    }

    public static void setInfo(int target, int[] targets, String[] names) {
        GuiAdvancedPorter.target = target;
        GuiAdvancedPorter.targets = targets;
        GuiAdvancedPorter.names = names;
    }

    public void initGui() {
        super.initGui();
        int k = (this.width - 340) / 2;
        int l = (this.height - 136) / 2;
        Panel toplevel = ((Panel)new Panel(this.mc, (Gui)this).setFilledRectThickness(2)).setLayout((Layout)new VerticalLayout().setSpacing(0));
        for (int i = 0; i < 8; ++i) {
            this.destinations[i] = new TextField(this.mc, (Gui)this);
            this.panels[i] = this.createPanel(this.destinations[i], i);
            toplevel.addChild((Widget)this.panels[i]);
        }
        toplevel.setBounds(new Rectangle(k, l, 340, 136));
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
        this.updateInfoFromServer();
    }

    private Panel createPanel(TextField destination, int i) {
        return (Panel)((Panel)((Panel)((Panel)new Panel(this.mc, (Gui)this).setLayout((Layout)new HorizontalLayout()).addChild((Widget)destination)).addChild((Widget)((Button)((Button)((Button)new Button(this.mc, (Gui)this).setText("Set")).setDesiredWidth(30)).setDesiredHeight(16)).addButtonEvent(parent -> {
            if (targets[i] != -1) {
                RFToolsMessages.sendToServer("setTarget", TypedMap.builder().put(CommandHandler.PARAM_TARGET, (Object)targets[i]));
                target = targets[i];
            }
        }))).addChild((Widget)((Button)((Button)((Button)new Button(this.mc, (Gui)this).setText("Clear")).setDesiredWidth(40)).setDesiredHeight(16)).addButtonEvent(parent -> {
            if (targets[i] != -1 && targets[i] == target) {
                target = -1;
            }
            RFToolsMessages.sendToServer("clearTarget", TypedMap.builder().put(CommandHandler.PARAM_TARGET, (Object)i));
            GuiAdvancedPorter.targets[i] = -1;
        }))).setDesiredHeight(16);
    }

    private void updateInfoFromServer() {
        RFToolsMessages.sendToServer("getTargets");
    }

    private void setTarget(int i) {
        this.panels[i].setFilledBackground(-1);
        if (targets[i] == -1) {
            this.destinations[i].setText("No target set");
        } else {
            this.destinations[i].setText(targets[i] + ": " + names[i]);
            if (targets[i] == target) {
                this.panels[i].setFilledBackground(-1123021);
            }
        }
    }

    public void drawScreen(int xSize_lo, int ySize_lo, float par3) {
        super.drawScreen(xSize_lo, ySize_lo, par3);
        for (int i = 0; i < 8; ++i) {
            this.setTarget(i);
        }
        this.drawWindow();
    }
}

