/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.playerprops;

import java.util.HashMap;
import java.util.Map;
import mcjty.rftools.PlayerBuff;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.playerprops.PacketSendBuffsToClient;
import mcjty.rftools.playerprops.PlayerExtendedProperties;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BuffProperties {
    public static final int BUFF_MAXTICKS = 180;
    private int buffTimeout = 0;
    private final Map<PlayerBuff, Integer> buffs = new HashMap<PlayerBuff, Integer>();
    private boolean oldAllowFlying = false;
    private boolean allowFlying = false;
    private boolean globalSyncNeeded = true;
    private boolean onElevator = false;

    private void syncBuffs(EntityPlayerMP player) {
        RFToolsMessages.INSTANCE.sendTo((IMessage)new PacketSendBuffsToClient(this.buffs), player);
    }

    public void tickBuffs(EntityPlayerMP player) {
        --this.buffTimeout;
        if (this.buffTimeout <= 0) {
            this.buffTimeout = 180;
            HashMap<PlayerBuff, Integer> copyBuffs = new HashMap<PlayerBuff, Integer>(this.buffs);
            this.buffs.clear();
            boolean syncNeeded = false;
            for (Map.Entry entry : copyBuffs.entrySet()) {
                int timeout = (Integer)entry.getValue();
                if ((timeout -= 180) > 0) {
                    this.buffs.put((PlayerBuff)((Object)entry.getKey()), timeout);
                    continue;
                }
                syncNeeded = true;
            }
            if (syncNeeded) {
                this.syncBuffs(player);
                this.performBuffs(player);
                this.globalSyncNeeded = false;
            }
        }
        if (this.globalSyncNeeded) {
            this.globalSyncNeeded = false;
            this.syncBuffs(player);
            this.performBuffs(player);
        }
    }

    private void performBuffs(EntityPlayerMP player) {
        boolean enableFlight = false;
        if (this.onElevator) {
            enableFlight = true;
            player.capabilities.isFlying = true;
        } else {
            for (PlayerBuff buff : this.buffs.keySet()) {
                if (buff != PlayerBuff.BUFF_FLIGHT) continue;
                enableFlight = true;
                break;
            }
        }
        boolean oldAllow = player.capabilities.allowFlying;
        if (enableFlight) {
            if (!this.allowFlying) {
                this.oldAllowFlying = player.capabilities.allowFlying;
                this.allowFlying = true;
            }
            player.capabilities.allowFlying = true;
        } else if (this.allowFlying) {
            player.capabilities.allowFlying = this.oldAllowFlying;
            if (player.capabilities.isCreativeMode) {
                player.capabilities.allowFlying = true;
            }
            this.allowFlying = false;
        }
        if (player.capabilities.allowFlying != oldAllow && !player.capabilities.allowFlying) {
            player.capabilities.isFlying = false;
        }
        player.sendPlayerAbilities();
    }

    public static void enableElevatorMode(EntityPlayer player) {
        BuffProperties buffProperties = PlayerExtendedProperties.getBuffProperties(player);
        buffProperties.onElevator = true;
        buffProperties.performBuffs((EntityPlayerMP)player);
    }

    public static void disableElevatorMode(EntityPlayer player) {
        BuffProperties buffProperties = PlayerExtendedProperties.getBuffProperties(player);
        buffProperties.onElevator = false;
        player.capabilities.isFlying = false;
        buffProperties.performBuffs((EntityPlayerMP)player);
    }

    public static void addBuffToPlayer(EntityPlayer player, PlayerBuff buff, int ticks) {
        BuffProperties buffProperties = PlayerExtendedProperties.getBuffProperties(player);
        buffProperties.addBuff((EntityPlayerMP)player, buff, ticks);
    }

    public void addBuff(EntityPlayerMP player, PlayerBuff buff, int ticks) {
        this.buffs.put(buff, ticks + 5);
        this.syncBuffs(player);
        this.performBuffs(player);
    }

    public Map<PlayerBuff, Integer> getBuffs() {
        return this.buffs;
    }

    public boolean hasBuff(PlayerBuff buff) {
        return this.buffs.containsKey((Object)buff);
    }

    public void saveNBTData(NBTTagCompound compound) {
        compound.setBoolean("onElevator", this.onElevator);
        compound.setInteger("buffTicks", this.buffTimeout);
        compound.setBoolean("allowFlying", this.allowFlying);
        compound.setBoolean("oldAllowFlying", this.oldAllowFlying);
        int[] buffArray = new int[this.buffs.size()];
        int[] timeoutArray = new int[this.buffs.size()];
        int idx = 0;
        for (Map.Entry<PlayerBuff, Integer> entry : this.buffs.entrySet()) {
            PlayerBuff buff = entry.getKey();
            buffArray[idx] = buff.ordinal();
            timeoutArray[idx] = entry.getValue();
            ++idx;
        }
        compound.setIntArray("buffs", buffArray);
        compound.setIntArray("buffTimeouts", timeoutArray);
    }

    public void loadNBTData(NBTTagCompound compound) {
        this.onElevator = compound.getBoolean("onElevator");
        this.buffTimeout = compound.getInteger("buffTicks");
        int[] buffArray = compound.getIntArray("buffs");
        int[] timeoutArray = compound.getIntArray("buffTimeouts");
        this.buffs.clear();
        for (int i = 0; i < buffArray.length; ++i) {
            int buffIdx = buffArray[i];
            this.buffs.put(PlayerBuff.values()[buffIdx], timeoutArray[i]);
        }
        this.allowFlying = compound.getBoolean("allowFlying");
        this.oldAllowFlying = compound.getBoolean("oldAllowFlying");
        this.globalSyncNeeded = true;
    }
}

