/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.shapes;

import java.util.ArrayList;
import java.util.List;
import mcjty.lib.varia.Check32;
import mcjty.rftools.blocks.shaper.ScannerConfiguration;
import mcjty.rftools.items.builder.ShapeCardItem;
import mcjty.rftools.shapes.IFormula;
import mcjty.rftools.shapes.Scan;
import mcjty.rftools.shapes.ScanDataManager;
import mcjty.rftools.shapes.ScanDataManagerClient;
import mcjty.rftools.shapes.ShapeBlockInfo;
import mcjty.rftools.shapes.ShapeModifier;
import mcjty.rftools.shapes.ShapeOperation;
import mcjty.rftools.shapes.ShapeRotation;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class Formulas {
    private static float squaredDistance3D(float cx, float cy, float cz, float x1, float y1, float z1, float dx2, float dy2, float dz2) {
        return (x1 - cx) * (x1 - cx) / dx2 + (y1 - cy) * (y1 - cy) / dy2 + (z1 - cz) * (z1 - cz) / dz2;
    }

    private static float squaredDistance2D(float cx, float cz, float x1, float z1, float dx2, float dz2) {
        return (x1 - cx) * (x1 - cx) / dx2 + (z1 - cz) * (z1 - cz) / dz2;
    }

    static class FormulaPrism
    implements IFormula {
        private int x1;
        private int y1;
        private int z1;
        private int x2;
        private int y2;
        private int z2;

        FormulaPrism() {
        }

        @Override
        public void setup(BlockPos thisCoord, BlockPos dimension, BlockPos offset, NBTTagCompound card) {
            int dx = dimension.getX();
            int dy = dimension.getY();
            int dz = dimension.getZ();
            int xCoord = thisCoord.getX();
            int yCoord = thisCoord.getY();
            int zCoord = thisCoord.getZ();
            BlockPos tl = new BlockPos(xCoord - dx / 2 + offset.getX(), yCoord - dy / 2 + offset.getY(), zCoord - dz / 2 + offset.getZ());
            this.x1 = tl.getX();
            this.y1 = tl.getY();
            this.z1 = tl.getZ();
            this.x2 = this.x1 + dx;
            this.y2 = this.y1 + dy;
            this.z2 = this.z1 + dz;
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            if (y < this.y1 || y >= this.y2) {
                return false;
            }
            int dy = y - this.y1;
            return x >= this.x1 + dy && x < this.x2 - dy && z >= this.z1 + dy && z < this.z2 - dy;
        }
    }

    static class FormulaCone
    implements IFormula {
        private float centerx;
        private float centerz;
        private float dx2;
        private float dz2;
        private float dy;
        private float topy;
        private int davg;

        FormulaCone() {
        }

        @Override
        public void setup(BlockPos thisCoord, BlockPos dimension, BlockPos offset, NBTTagCompound card) {
            int dx = dimension.getX();
            int dy = dimension.getY();
            int dz = dimension.getZ();
            int xCoord = thisCoord.getX();
            int yCoord = thisCoord.getY();
            int zCoord = thisCoord.getZ();
            this.centerx = (float)(xCoord + offset.getX()) + (dx % 2 != 0 ? 0.0f : -0.5f);
            this.centerz = (float)(zCoord + offset.getZ()) + (dz % 2 != 0 ? 0.0f : -0.5f);
            float factor = 1.7f;
            this.dx2 = dx == 0 ? 0.5f : ((float)dx + factor) * ((float)dx + factor) / 4.0f;
            this.dz2 = dz == 0 ? 0.5f : ((float)dz + factor) * ((float)dz + factor) / 4.0f;
            this.davg = (int)(((float)(dx + dz) + factor * 2.0f) / 2.0f);
            this.dy = (float)dy + 0.5f;
            this.topy = yCoord + offset.getY() + dy / 2;
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            double distance = Math.sqrt(Formulas.squaredDistance2D(this.centerx, this.centerz, x, z, this.dx2, this.dz2));
            return (float)((int)(distance * (double)(this.davg / 2 + 1))) <= (float)(this.davg / 2 - 1) * (this.topy - (float)y) / this.dy;
        }
    }

    static class FormulaCylinder
    implements IFormula {
        private float centerx;
        private float centerz;
        private float dx2;
        private float dz2;
        private int davg;

        FormulaCylinder() {
        }

        @Override
        public void setup(BlockPos thisCoord, BlockPos dimension, BlockPos offset, NBTTagCompound card) {
            int dx = dimension.getX();
            int dy = dimension.getY();
            int dz = dimension.getZ();
            int xCoord = thisCoord.getX();
            int yCoord = thisCoord.getY();
            int zCoord = thisCoord.getZ();
            this.centerx = (float)(xCoord + offset.getX()) + (dx % 2 != 0 ? 0.0f : -0.5f);
            this.centerz = (float)(zCoord + offset.getZ()) + (dz % 2 != 0 ? 0.0f : -0.5f);
            float factor = 1.7f;
            this.dx2 = dx == 0 ? 0.5f : ((float)dx + factor) * ((float)dx + factor) / 4.0f;
            this.dz2 = dz == 0 ? 0.5f : ((float)dz + factor) * ((float)dz + factor) / 4.0f;
            this.davg = (int)(((float)(dx + dz) + factor * 2.0f) / 2.0f);
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            double distance = Math.sqrt(Formulas.squaredDistance2D(this.centerx, this.centerz, x, z, this.dx2, this.dz2));
            return (int)(distance * (double)(this.davg / 2 + 1)) <= this.davg / 2 - 1;
        }
    }

    static class FormulaCappedCylinder
    implements IFormula {
        private float centerx;
        private float centerz;
        private float dx2;
        private float dz2;
        private int davg;
        private int y1;
        private int y2;

        FormulaCappedCylinder() {
        }

        @Override
        public void setup(BlockPos thisCoord, BlockPos dimension, BlockPos offset, NBTTagCompound card) {
            int dx = dimension.getX();
            int dy = dimension.getY();
            int dz = dimension.getZ();
            int xCoord = thisCoord.getX();
            int yCoord = thisCoord.getY();
            int zCoord = thisCoord.getZ();
            this.centerx = (float)(xCoord + offset.getX()) + (dx % 2 != 0 ? 0.0f : -0.5f);
            this.centerz = (float)(zCoord + offset.getZ()) + (dz % 2 != 0 ? 0.0f : -0.5f);
            float factor = 1.7f;
            this.dx2 = dx == 0 ? 0.5f : ((float)dx + factor) * ((float)dx + factor) / 4.0f;
            this.dz2 = dz == 0 ? 0.5f : ((float)dz + factor) * ((float)dz + factor) / 4.0f;
            this.davg = (int)(((float)(dx + dz) + factor * 2.0f) / 2.0f);
            this.y1 = yCoord - dy / 2 + offset.getY();
            this.y2 = this.y1 + dy;
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            if (y < this.y1 || y >= this.y2) {
                return false;
            }
            double distance = Math.sqrt(Formulas.squaredDistance2D(this.centerx, this.centerz, x, z, this.dx2, this.dz2));
            return (int)(distance * (double)(this.davg / 2 + 1)) <= this.davg / 2 - 1;
        }
    }

    static class FormulaBox
    implements IFormula {
        private int x1;
        private int y1;
        private int z1;
        private int x2;
        private int y2;
        private int z2;

        FormulaBox() {
        }

        @Override
        public void setup(BlockPos thisCoord, BlockPos dimension, BlockPos offset, NBTTagCompound card) {
            int dx = dimension.getX();
            int dy = dimension.getY();
            int dz = dimension.getZ();
            int xCoord = thisCoord.getX();
            int yCoord = thisCoord.getY();
            int zCoord = thisCoord.getZ();
            BlockPos tl = new BlockPos(xCoord - dx / 2 + offset.getX(), yCoord - dy / 2 + offset.getY(), zCoord - dz / 2 + offset.getZ());
            this.x1 = tl.getX();
            this.y1 = tl.getY();
            this.z1 = tl.getZ();
            this.x2 = this.x1 + dx;
            this.y2 = this.y1 + dy;
            this.z2 = this.z1 + dz;
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            return x >= this.x1 && x < this.x2 && y >= this.y1 && y < this.y2 && z >= this.z1 && z < this.z2;
        }

        @Override
        public boolean isBorder(int x, int y, int z) {
            return x == this.x1 || x == this.x2 - 1 || y == this.y1 || y == this.y2 - 1 || z == this.z1 || z == this.z2 - 1;
        }
    }

    static class FormulaBottomDome
    implements IFormula {
        private float centerx;
        private float centery;
        private float centerz;
        private float dx2;
        private float dy2;
        private float dz2;
        private int davg;

        FormulaBottomDome() {
        }

        @Override
        public void setup(BlockPos thisCoord, BlockPos dimension, BlockPos offset, NBTTagCompound card) {
            int dx = dimension.getX();
            int dy = dimension.getY();
            int dz = dimension.getZ();
            int xCoord = thisCoord.getX();
            int yCoord = thisCoord.getY();
            int zCoord = thisCoord.getZ();
            this.centerx = (float)(xCoord + offset.getX()) + (dx % 2 != 0 ? 0.0f : -0.5f);
            this.centery = (float)(yCoord + offset.getY()) + (dy % 2 != 0 ? 0.0f : -0.5f);
            this.centerz = (float)(zCoord + offset.getZ()) + (dz % 2 != 0 ? 0.0f : -0.5f);
            float factor = 1.8f;
            this.dx2 = dx == 0 ? 0.5f : ((float)dx + factor) * ((float)dx + factor) / 4.0f;
            this.dy2 = dy == 0 ? 0.5f : ((float)dy + factor) * ((float)dy + factor) / 4.0f;
            this.dz2 = dz == 0 ? 0.5f : ((float)dz + factor) * ((float)dz + factor) / 4.0f;
            this.davg = (int)(((float)(dx + dy + dz) + factor * 3.0f) / 3.0f);
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            if ((float)y > this.centery) {
                return false;
            }
            double distance = Math.sqrt(Formulas.squaredDistance3D(this.centerx, this.centery, this.centerz, x, y, z, this.dx2, this.dy2, this.dz2));
            return (int)(distance * (double)(this.davg / 2 + 1)) <= this.davg / 2 - 1;
        }
    }

    static class FormulaTopDome
    implements IFormula {
        private float centerx;
        private float centery;
        private float centerz;
        private float dx2;
        private float dy2;
        private float dz2;
        private int davg;

        FormulaTopDome() {
        }

        @Override
        public void setup(BlockPos thisCoord, BlockPos dimension, BlockPos offset, NBTTagCompound card) {
            int dx = dimension.getX();
            int dy = dimension.getY();
            int dz = dimension.getZ();
            int xCoord = thisCoord.getX();
            int yCoord = thisCoord.getY();
            int zCoord = thisCoord.getZ();
            this.centerx = (float)(xCoord + offset.getX()) + (dx % 2 != 0 ? 0.0f : -0.5f);
            this.centery = (float)(yCoord + offset.getY()) + (dy % 2 != 0 ? 0.0f : -0.5f);
            this.centerz = (float)(zCoord + offset.getZ()) + (dz % 2 != 0 ? 0.0f : -0.5f);
            float factor = 1.8f;
            this.dx2 = dx == 0 ? 0.5f : ((float)dx + factor) * ((float)dx + factor) / 4.0f;
            this.dy2 = dy == 0 ? 0.5f : ((float)dy + factor) * ((float)dy + factor) / 4.0f;
            this.dz2 = dz == 0 ? 0.5f : ((float)dz + factor) * ((float)dz + factor) / 4.0f;
            this.davg = (int)(((float)(dx + dy + dz) + factor * 3.0f) / 3.0f);
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            if ((float)y < this.centery) {
                return false;
            }
            double distance = Math.sqrt(Formulas.squaredDistance3D(this.centerx, this.centery, this.centerz, x, y, z, this.dx2, this.dy2, this.dz2));
            return (int)(distance * (double)(this.davg / 2 + 1)) <= this.davg / 2 - 1;
        }
    }

    static class FormulaSphere
    implements IFormula {
        private float centerx;
        private float centery;
        private float centerz;
        private float dx2;
        private float dy2;
        private float dz2;
        private int davg;

        FormulaSphere() {
        }

        @Override
        public void setup(BlockPos thisCoord, BlockPos dimension, BlockPos offset, NBTTagCompound card) {
            int dx = dimension.getX();
            int dy = dimension.getY();
            int dz = dimension.getZ();
            int xCoord = thisCoord.getX();
            int yCoord = thisCoord.getY();
            int zCoord = thisCoord.getZ();
            this.centerx = (float)(xCoord + offset.getX()) + (dx % 2 != 0 ? 0.0f : -0.5f);
            this.centery = (float)(yCoord + offset.getY()) + (dy % 2 != 0 ? 0.0f : -0.5f);
            this.centerz = (float)(zCoord + offset.getZ()) + (dz % 2 != 0 ? 0.0f : -0.5f);
            float factor = 1.8f;
            this.dx2 = dx == 0 ? 0.5f : ((float)dx + factor) * ((float)dx + factor) / 4.0f;
            this.dy2 = dy == 0 ? 0.5f : ((float)dy + factor) * ((float)dy + factor) / 4.0f;
            this.dz2 = dz == 0 ? 0.5f : ((float)dz + factor) * ((float)dz + factor) / 4.0f;
            this.davg = (int)(((float)(dx + dy + dz) + factor * 3.0f) / 3.0f);
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            double distance = Math.sqrt(Formulas.squaredDistance3D(this.centerx, this.centery, this.centerz, x, y, z, this.dx2, this.dy2, this.dz2));
            return (int)(distance * (double)(this.davg / 2 + 1)) <= this.davg / 2 - 1;
        }
    }

    static class FormulaHeart
    implements IFormula {
        private float centerx;
        private float centery;
        private float centerz;
        private int dx;
        private int dy;
        private int dz;

        FormulaHeart() {
        }

        @Override
        public void setup(BlockPos thisCoord, BlockPos dimension, BlockPos offset, NBTTagCompound card) {
            this.dx = dimension.getX();
            this.dy = dimension.getY();
            this.dz = dimension.getZ();
            int xCoord = thisCoord.getX();
            int yCoord = thisCoord.getY();
            int zCoord = thisCoord.getZ();
            this.centerx = (float)(xCoord + offset.getX()) + (this.dx % 2 != 0 ? 0.0f : -0.5f);
            this.centery = (float)(yCoord + offset.getY()) + (this.dy % 2 != 0 ? 0.0f : -0.5f);
            this.centerz = (float)(zCoord + offset.getZ()) + (this.dz % 2 != 0 ? 0.0f : -0.5f);
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            double f3;
            double f2;
            double xx = (double)((float)x - this.centerx) * 2.6 / (double)this.dx + 0.1;
            double yy = (double)((float)z - this.centerz) * 1.6 / (double)this.dz + 0.1;
            double zz = (double)((float)y - this.centery) * 2.4 / (double)this.dy + 0.2;
            double f1 = Math.pow(xx * xx + 2.25 * yy * yy + zz * zz - 1.0, 3.0);
            double f = f1 - (f2 = xx * xx * zz * zz * zz) - (f3 = 0.1125 * yy * yy * zz * zz * zz);
            return f < 0.0;
        }
    }

    static class FormulaTorus
    implements IFormula {
        private float smallRadius;
        private float bigRadius;
        private float centerx;
        private float centery;
        private float centerz;

        FormulaTorus() {
        }

        @Override
        public void setup(BlockPos thisCoord, BlockPos dimension, BlockPos offset, NBTTagCompound card) {
            int dx = dimension.getX();
            int dy = dimension.getY();
            int dz = dimension.getZ();
            this.smallRadius = (float)(dy - 2) / 2.0f;
            this.bigRadius = (float)(dx - 2) / 2.0f - this.smallRadius;
            int xCoord = thisCoord.getX();
            int yCoord = thisCoord.getY();
            int zCoord = thisCoord.getZ();
            this.centerx = (float)(xCoord + offset.getX()) + (dx % 2 != 0 ? 0.0f : -0.5f);
            this.centery = (float)(yCoord + offset.getY()) + (dy % 2 != 0 ? 0.0f : -0.5f);
            this.centerz = (float)(zCoord + offset.getZ()) + (dz % 2 != 0 ? 0.0f : -0.5f);
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            double rr = (double)this.bigRadius - Math.sqrt(((float)x - this.centerx) * ((float)x - this.centerx) + ((float)z - this.centerz) * ((float)z - this.centerz));
            double f = rr * rr + (double)(((float)y - this.centery) * ((float)y - this.centery)) - (double)(this.smallRadius * this.smallRadius);
            return f < 0.0;
        }
    }

    static class FormulaComposition
    implements IFormula {
        private BlockPos thisCoord;
        private IBlockState blockState;
        private List<IFormula> formulas = new ArrayList<IFormula>();
        private List<Bounds> bounds = new ArrayList<Bounds>();
        private List<ShapeModifier> modifiers = new ArrayList<ShapeModifier>();
        private List<IBlockState> blockStates = new ArrayList<IBlockState>();

        FormulaComposition() {
        }

        @Override
        public void setup(BlockPos thisCoord, BlockPos dimension, BlockPos offset, NBTTagCompound card) {
            this.thisCoord = thisCoord;
            if (card == null) {
                return;
            }
            int dx = dimension.getX();
            int dy = dimension.getY();
            int dz = dimension.getZ();
            if (dx <= 0 || dy <= 0 || dz <= 0) {
                return;
            }
            NBTTagList children = card.getTagList("children", 10);
            for (int i = 0; i < children.tagCount(); ++i) {
                Block block;
                NBTTagCompound childTag = children.getCompoundTagAt(i);
                IFormula formula = ShapeCardItem.createCorrectFormula(childTag);
                String op = childTag.getString("mod_op");
                ShapeOperation operation = ShapeOperation.getByName(op);
                boolean flip = childTag.getBoolean("mod_flipy");
                String rot = childTag.getString("mod_rot");
                ShapeRotation rotation = ShapeRotation.getByName(rot);
                this.modifiers.add(new ShapeModifier(operation, flip, rotation));
                BlockPos dim = ShapeCardItem.getClampedDimension(childTag, ScannerConfiguration.maxScannerDimension.get());
                BlockPos off = ShapeCardItem.getClampedOffset(childTag, ScannerConfiguration.maxScannerOffset.get());
                BlockPos o = off.add((Vec3i)offset);
                formula.setup(thisCoord, dim, o, childTag);
                this.formulas.add(formula);
                dim = rotation.transformDimension(dim);
                BlockPos tl = new BlockPos(o.getX() - dim.getX() / 2, o.getY() - dim.getY() / 2, o.getZ() - dim.getZ() / 2);
                this.bounds.add(new Bounds(tl, tl.add((Vec3i)dim), o));
                IBlockState state = null;
                if (childTag.hasKey("ghost_block") && (block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(childTag.getString("ghost_block")))) != null) {
                    int meta = childTag.getInteger("ghost_meta");
                    state = block.getStateFromMeta(meta);
                }
                this.blockStates.add(state);
            }
        }

        @Override
        public void getCheckSumClient(NBTTagCompound tc, Check32 crc) {
            ShapeCardItem.getLocalChecksum(tc, crc);
            NBTTagList children = tc.getTagList("children", 10);
            for (int i = 0; i < children.tagCount(); ++i) {
                NBTTagCompound childTag = children.getCompoundTagAt(i);
                IFormula formula = ShapeCardItem.createCorrectFormula(childTag);
                formula.getCheckSumClient(childTag, crc);
                crc.add(childTag.getBoolean("mod_flipy") ? 1 : 0);
                String rot = childTag.getString("mod_rot");
                ShapeRotation rotation = ShapeRotation.getByName(rot);
                crc.add(rotation.ordinal());
                String op = childTag.getString("mod_op");
                ShapeOperation operation = ShapeOperation.getByName(op);
                crc.add(operation.ordinal());
                if (!childTag.hasKey("ghost_block")) continue;
                Object state = null;
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(childTag.getString("ghost_block")));
                if (block == null) continue;
                crc.add(Block.getIdFromBlock((Block)block));
                int meta = childTag.getInteger("ghost_meta");
                crc.add(meta);
            }
        }

        @Override
        public IBlockState getLastState() {
            return this.blockState;
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            this.blockState = null;
            x -= this.thisCoord.getX();
            y -= this.thisCoord.getY();
            z -= this.thisCoord.getZ();
            boolean ok = false;
            block10: for (int i = 0; i < this.formulas.size(); ++i) {
                IFormula formula = this.formulas.get(i);
                Bounds bounds = this.bounds.get(i);
                ShapeModifier modifier = this.modifiers.get(i);
                boolean inside = false;
                if (bounds.in(x, y, z)) {
                    int tx = x;
                    int ty = y;
                    int tz = z;
                    BlockPos o = bounds.getOffset();
                    switch (modifier.getRotation()) {
                        default: {
                            break;
                        }
                        case X: {
                            tx = x;
                            ty = z - o.getZ() + o.getY();
                            tz = y - o.getY() + o.getZ();
                            break;
                        }
                        case Y: {
                            tx = z - o.getZ() + o.getX();
                            ty = y;
                            tz = x - o.getX() + o.getZ();
                            break;
                        }
                        case Z: {
                            tx = y - o.getY() + o.getX();
                            ty = x - o.getX() + o.getY();
                            tz = z;
                        }
                    }
                    if (modifier.isFlipY()) {
                        ty = bounds.getP1().getY() + bounds.getP2().getY() - 1 - ty;
                    }
                    inside = formula.isInside(tx + this.thisCoord.getX(), ty + this.thisCoord.getY(), tz + this.thisCoord.getZ());
                }
                switch (modifier.getOperation()) {
                    case UNION: {
                        if (!inside) continue block10;
                        ok = true;
                        this.blockState = this.blockStates.get(i);
                        if (this.blockState != null) continue block10;
                        this.blockState = formula.getLastState();
                        continue block10;
                    }
                    case SUBTRACT: {
                        if (!inside) continue block10;
                        ok = false;
                        continue block10;
                    }
                    case INTERSECT: {
                        if (inside && ok) {
                            if (this.blockState != null) continue block10;
                            this.blockState = this.blockStates.get(i);
                            if (this.blockState != null) continue block10;
                            this.blockState = formula.getLastState();
                            continue block10;
                        }
                        ok = false;
                    }
                }
            }
            return ok;
        }

        @Override
        public boolean isCustom() {
            return true;
        }
    }

    static class FormulaScan
    implements IFormula {
        private byte[] data;
        private List<IBlockState> palette = new ArrayList<IBlockState>();
        private int x1;
        private int y1;
        private int z1;
        private int dx;
        private int dy;
        private int dz;
        private IBlockState lastState = null;

        FormulaScan() {
        }

        @Override
        public void getCheckSumClient(NBTTagCompound tc, Check32 crc) {
            ShapeCardItem.getLocalChecksum(tc, crc);
            int scanId = tc.getInteger("scanid");
            crc.add(scanId);
            crc.add(ScanDataManagerClient.getScansClient().getScanDirtyCounterClient(scanId));
        }

        @Override
        public void setup(BlockPos thisCoord, BlockPos dimension, BlockPos offset, NBTTagCompound card) {
            this.data = null;
            if (card == null) {
                return;
            }
            this.dx = dimension.getX();
            this.dy = dimension.getY();
            this.dz = dimension.getZ();
            if (this.dx <= 0 || this.dy <= 0 || this.dz <= 0) {
                return;
            }
            int xCoord = thisCoord.getX();
            int yCoord = thisCoord.getY();
            int zCoord = thisCoord.getZ();
            BlockPos tl = new BlockPos(xCoord - this.dx / 2 + offset.getX(), yCoord - this.dy / 2 + offset.getY(), zCoord - this.dz / 2 + offset.getZ());
            this.x1 = tl.getX();
            this.y1 = tl.getY();
            this.z1 = tl.getZ();
            this.palette.clear();
            int scanId = card.getInteger("scanid");
            if (scanId != 0) {
                Scan scan = ScanDataManager.getScans().loadScan(scanId);
                this.palette = new ArrayList<IBlockState>(scan.getMaterialPalette());
                byte[] datas = scan.getRledata();
                this.data = new byte[this.dx * this.dy * this.dz];
                int j = 0;
                for (int i = 0; i < datas.length / 2; ++i) {
                    int cnt = datas[i * 2] & 0xFF;
                    int c = datas[i * 2 + 1] & 0xFF;
                    if (c == 255) {
                        c = 0;
                    }
                    while (cnt > 0 && j < this.data.length) {
                        this.data[j++] = (byte)c;
                        --cnt;
                    }
                    if (j >= this.data.length) break;
                }
            }
        }

        @Override
        public boolean isBorder(int x, int y, int z) {
            if (x <= this.x1 || x >= this.x1 + this.dx - 1 || y <= this.y1 || y >= this.y1 + this.dy - 1 || z <= this.z1 || z >= this.z1 + this.dz - 1) {
                return this.isInsideSafe(x, y, z);
            }
            if (this.data == null) {
                return false;
            }
            int index = (x - this.x1) * this.dy * this.dz + (z - this.z1) * this.dy + (y - this.y1);
            if (!(this.isInsideInternal(index - 1) && this.isInsideInternal(index + 1) && this.isInsideInternal(index - this.dy) && this.isInsideInternal(index + this.dy) && this.isInsideInternal(index - this.dy * this.dz) && this.isInsideInternal(index + this.dy * this.dz))) {
                return this.isInsideInternal(index);
            }
            return false;
        }

        @Override
        public boolean isVisible(int x, int y, int z) {
            int index = (x - this.x1) * this.dy * this.dz + (z - this.z1) * this.dy + (y - this.y1);
            return this.isClear(index - 1) || this.isClear(index + 1) || this.isClear(index - this.dy) || this.isClear(index + this.dy) || this.isClear(index - this.dy * this.dz) || this.isClear(index + this.dy * this.dz);
        }

        public boolean isClear(int index) {
            if (!this.isInsideInternal(index)) {
                return true;
            }
            IBlockState state = this.getLastState();
            if (state != null) {
                return ShapeBlockInfo.isNonSolidBlock(state.getBlock());
            }
            return false;
        }

        private boolean isInsideInternal(int index) {
            if (this.data[index] == 0) {
                return false;
            }
            int idx = (this.data[index] & 0xFF) - 1;
            this.lastState = this.palette.get(idx);
            return true;
        }

        @Override
        public boolean isInsideSafe(int x, int y, int z) {
            if (x < this.x1 || x >= this.x1 + this.dx || y < this.y1 || y >= this.y1 + this.dy || z < this.z1 || z >= this.z1 + this.dz) {
                return false;
            }
            return this.isInside(x, y, z);
        }

        @Override
        public boolean isInside(int x, int y, int z) {
            if (this.data == null) {
                return false;
            }
            int index = (x - this.x1) * this.dy * this.dz + (z - this.z1) * this.dy + (y - this.y1);
            return this.isInsideInternal(index);
        }

        @Override
        public IBlockState getLastState() {
            return this.lastState;
        }
    }

    public static class Bounds {
        private BlockPos p1;
        private BlockPos p2;
        private BlockPos offset;

        public Bounds(BlockPos p1, BlockPos p2, BlockPos offset) {
            this.p1 = p1;
            this.p2 = p2;
            this.offset = offset;
        }

        public BlockPos getP1() {
            return this.p1;
        }

        public BlockPos getP2() {
            return this.p2;
        }

        public BlockPos getOffset() {
            return this.offset;
        }

        public boolean in(BlockPos p) {
            int x = p.getX();
            int y = p.getY();
            int z = p.getZ();
            return this.in(x, y, z);
        }

        public boolean in(int x, int y, int z) {
            return x >= this.p1.getX() && x < this.p2.getX() && y >= this.p1.getY() && y < this.p2.getY() && z >= this.p1.getZ() && z < this.p2.getZ();
        }
    }
}

