/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.shapes;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class Scan {
    private byte[] rledata;
    private List<IBlockState> materialPalette = new ArrayList<IBlockState>();
    private BlockPos dataDim;
    private BlockPos dataOffset = new BlockPos(0, 0, 0);
    private int dirtyCounter = 0;
    public int dirtyRequestTimeout = 0;
    public static final byte[] EMPTY = new byte[0];

    public byte[] getRledata() {
        if (this.rledata == null) {
            return EMPTY;
        }
        return this.rledata;
    }

    public byte[] getDataInt() {
        return this.rledata;
    }

    public void setData(byte[] data, List<IBlockState> materialPalette, BlockPos dim, BlockPos offset) {
        this.rledata = data;
        this.materialPalette = materialPalette;
        this.dataDim = dim;
        this.dataOffset = offset;
        ++this.dirtyCounter;
    }

    public void setDirtyCounter(int dirtyCounter) {
        this.dirtyCounter = dirtyCounter;
    }

    public int getDirtyCounter() {
        return this.dirtyCounter;
    }

    public List<IBlockState> getMaterialPalette() {
        return this.materialPalette;
    }

    public BlockPos getDataDim() {
        return this.dataDim;
    }

    public BlockPos getDataOffset() {
        return this.dataOffset;
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        tagCompound.setInteger("dirty", this.dirtyCounter);
    }

    public void writeToNBTExternal(NBTTagCompound tagCompound) {
        tagCompound.setByteArray("data", this.rledata == null ? new byte[]{} : this.rledata);
        NBTTagList pal = new NBTTagList();
        for (IBlockState state : this.materialPalette) {
            NBTTagCompound tc = new NBTTagCompound();
            Block block = state.getBlock();
            if (block == null || block.getRegistryName() == null) {
                tc.setString("r", Blocks.STONE.getRegistryName().toString());
                tc.setInteger("m", 0);
            } else {
                tc.setString("r", block.getRegistryName().toString());
                tc.setInteger("m", block.getMetaFromState(state));
            }
            pal.appendTag((NBTBase)tc);
        }
        tagCompound.setTag("scanpal", (NBTBase)pal);
        if (this.dataDim != null) {
            tagCompound.setInteger("scandimx", this.dataDim.getX());
            tagCompound.setInteger("scandimy", this.dataDim.getY());
            tagCompound.setInteger("scandimz", this.dataDim.getZ());
        }
        if (this.dataOffset != null) {
            tagCompound.setInteger("scanoffx", this.dataOffset.getX());
            tagCompound.setInteger("scanoffy", this.dataOffset.getY());
            tagCompound.setInteger("scanoffz", this.dataOffset.getZ());
        }
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        this.dirtyCounter = tagCompound.getInteger("dirty");
    }

    public void readFromNBTExternal(NBTTagCompound tagCompound) {
        NBTTagList list = tagCompound.getTagList("scanpal", 10);
        for (int i = 0; i < list.tagCount(); ++i) {
            NBTTagCompound tc = list.getCompoundTagAt(i);
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(tc.getString("r")));
            if (block == null) {
                block = Blocks.STONE;
            }
            this.materialPalette.add(block.getStateFromMeta(tc.getInteger("m")));
        }
        this.rledata = tagCompound.getByteArray("data");
        this.dataDim = new BlockPos(tagCompound.getInteger("scandimx"), tagCompound.getInteger("scandimy"), tagCompound.getInteger("scandimz"));
        this.dataOffset = new BlockPos(tagCompound.getInteger("scanoffx"), tagCompound.getInteger("scanoffy"), tagCompound.getInteger("scanoffz"));
    }
}

