/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.shapes;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.lib.varia.Check32;
import mcjty.rftools.blocks.shaper.ScannerConfiguration;
import mcjty.rftools.items.builder.ShapeCardItem;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.shapes.BeaconType;
import mcjty.rftools.shapes.IShapeParentGui;
import mcjty.rftools.shapes.PacketRequestShapeData;
import mcjty.rftools.shapes.RenderData;
import mcjty.rftools.shapes.ScanDataManagerClient;
import mcjty.rftools.shapes.ScanExtraData;
import mcjty.rftools.shapes.ShapeBlockInfo;
import mcjty.rftools.shapes.ShapeDataManagerClient;
import mcjty.rftools.shapes.ShapeID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class ShapeRenderer {
    private int prevX = -1;
    private int prevY = -1;
    private float scale = 3.0f;
    private float dx = 230.0f;
    private float dy = 100.0f;
    private float xangle = 25.0f;
    private float yangle = 25.0f;
    private float zangle = 0.0f;
    private ShapeID shapeID;
    private int waitForNewRequest = 0;
    private int extraDataCounter = 0;
    private static RenderData.RenderElement[] beaconElement = null;
    private static RenderData.RenderElement[] beaconElementBeacon = null;

    public ShapeRenderer(ShapeID shapeID) {
        this.shapeID = shapeID;
    }

    public void setShapeID(ShapeID shapeID) {
        this.shapeID = shapeID;
    }

    public ShapeID getShapeID() {
        return this.shapeID;
    }

    public int getCount() {
        RenderData data = ShapeDataManagerClient.getRenderData(this.shapeID);
        if (data != null) {
            return data.getBlockCount();
        }
        return 0;
    }

    public static RenderData getRenderDataAndCreate(ShapeID shapeID) {
        RenderData data = ShapeDataManagerClient.getRenderDataAndCreate(shapeID);
        data.touch();
        return data;
    }

    public static void setRenderData(ShapeID id, @Nullable RenderData.RenderPlane plane, int offsetY, int dy, String msg) {
        RenderData data = ShapeRenderer.getRenderDataAndCreate(id);
        data.setPlaneData(plane, offsetY, dy);
        data.previewMessage = msg;
    }

    public void initView(int dx, int dy) {
        Minecraft mc = Minecraft.getMinecraft();
        ScaledResolution scaledresolution = new ScaledResolution(mc);
        int xScale = scaledresolution.getScaledWidth();
        int yScale = scaledresolution.getScaledHeight();
        int sx = (dx + 84) * mc.displayWidth / xScale;
        int sy = mc.displayHeight - (dy + 136) * mc.displayHeight / yScale;
        int sw = 161 * mc.displayWidth / xScale;
        int sh = 130 * mc.displayHeight / yScale;
        int vx = sx + sw / 2;
        int vy = sy + sh / 2;
        this.dx = vx / scaledresolution.getScaleFactor();
        this.dy = vy / scaledresolution.getScaleFactor();
    }

    public void handleShapeDragging(int x, int y) {
        if (x >= 100 && y <= 120) {
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                if (this.prevX != -1 && Mouse.isButtonDown((int)0)) {
                    this.dx += (float)(x - this.prevX);
                    this.dy += (float)(y - this.prevY);
                }
            } else if (this.prevX != -1 && Mouse.isButtonDown((int)0)) {
                this.yangle -= (float)(x - this.prevX);
                this.xangle += (float)(y - this.prevY);
            }
            this.prevX = x;
            this.prevY = y;
        }
        if (Mouse.isButtonDown((int)2)) {
            this.xangle = 0.0f;
            this.yangle = 0.0f;
        }
    }

    public void handleMouseWheel() {
        int dwheel = Mouse.getDWheel();
        if (dwheel < 0) {
            this.scale = (float)((double)this.scale * 0.6);
            if ((double)this.scale <= 0.1) {
                this.scale = 0.1f;
            }
        } else if (dwheel > 0) {
            this.scale = (float)((double)this.scale * 1.4);
        }
    }

    public boolean renderShapeInWorld(ItemStack stack, double x, double y, double z, float offset, float scale, float angle, boolean scan, ShapeID shape) {
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)((float)x + 0.5f), (float)((float)y + 1.0f + offset), (float)((float)z + 0.5f));
        GlStateManager.scale((float)scale, (float)scale, (float)scale);
        GlStateManager.rotate((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        Minecraft.getMinecraft().entityRenderer.disableLightmap();
        GlStateManager.disableBlend();
        GlStateManager.enableCull();
        GlStateManager.disableLighting();
        GlStateManager.disableTexture2D();
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder buffer = tessellator.getBuffer();
        boolean doSound = this.renderFaces(tessellator, buffer, stack, scan, shape.isGrayscale(), shape.getScanId());
        GlStateManager.enableTexture2D();
        GlStateManager.disableBlend();
        GlStateManager.enableLighting();
        Minecraft.getMinecraft().entityRenderer.enableLightmap();
        GlStateManager.popMatrix();
        return doSound;
    }

    public void renderShape(IShapeParentGui gui, ItemStack stack, int x, int y, boolean showAxis, boolean showOuter, boolean showScan, boolean showGuidelines) {
        ShapeRenderer.setupScissor(gui);
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)this.dx, (float)this.dy, (float)200.0f);
        GlStateManager.rotate((float)(180.0f - this.xangle), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotate((float)this.yangle, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotate((float)this.zangle, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.scale((float)(-this.scale), (float)this.scale, (float)this.scale);
        GlStateManager.disableBlend();
        GlStateManager.disableCull();
        GlStateManager.disableTexture2D();
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder buffer = tessellator.getBuffer();
        GL11.glEnable((int)3089);
        this.renderFaces(tessellator, buffer, stack, showScan, false, -1);
        BlockPos dimension = ShapeCardItem.getDimension(stack);
        this.renderHelpers(tessellator, buffer, dimension.getX(), dimension.getY(), dimension.getZ(), showAxis, showOuter);
        GL11.glDisable((int)3089);
        GlStateManager.popMatrix();
        if (showGuidelines) {
            GlStateManager.glLineWidth((float)3.0f);
            buffer.begin(1, DefaultVertexFormats.POSITION_COLOR);
            buffer.pos((double)(x - 62), (double)(y + 180), 0.0).color(1.0f, 0.0f, 0.0f, 1.0f).endVertex();
            buffer.pos((double)(x - 39), (double)(y + 180), 0.0).color(1.0f, 0.0f, 0.0f, 1.0f).endVertex();
            buffer.pos((double)(x - 62), (double)(y + 195), 0.0).color(0.0f, 0.8f, 0.0f, 1.0f).endVertex();
            buffer.pos((double)(x - 39), (double)(y + 195), 0.0).color(0.0f, 0.8f, 0.0f, 1.0f).endVertex();
            buffer.pos((double)(x - 62), (double)(y + 210), 0.0).color(0.0f, 0.0f, 1.0f, 1.0f).endVertex();
            buffer.pos((double)(x - 39), (double)(y + 210), 0.0).color(0.0f, 0.0f, 1.0f, 1.0f).endVertex();
            tessellator.draw();
        }
        GlStateManager.enableTexture2D();
        GlStateManager.disableBlend();
        RenderHelper.enableGUIStandardItemLighting();
        RenderData data = ShapeDataManagerClient.getRenderData(this.shapeID);
        if (data != null && !data.previewMessage.isEmpty()) {
            Minecraft.getMinecraft().fontRenderer.drawString(data.previewMessage, gui.getPreviewLeft() + 84, gui.getPreviewTop() + 50, -65536);
        }
    }

    private void renderHelpers(Tessellator tessellator, BufferBuilder buffer, int xlen, int ylen, int zlen, boolean showAxis, boolean showOuter) {
        if (showAxis) {
            ShapeRenderer.renderAxis(tessellator, buffer, xlen / 2, ylen / 2, zlen / 2);
        }
        if (showOuter) {
            ShapeRenderer.renderOuterBox(tessellator, buffer, xlen, ylen, zlen);
        }
    }

    static void renderOuterBox(Tessellator tessellator, BufferBuilder buffer, int xlen, int ylen, int zlen) {
        GlStateManager.glLineWidth((float)1.0f);
        buffer.begin(1, DefaultVertexFormats.POSITION_COLOR);
        int xleft = -xlen / 2;
        int xright = xlen / 2 + (xlen & 1);
        int ybot = -ylen / 2;
        int ytop = ylen / 2 + (ylen & 1);
        int zsouth = -zlen / 2;
        int znorth = zlen / 2 + (zlen & 1);
        buffer.pos((double)xleft, (double)ybot, (double)zsouth).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        buffer.pos((double)xright, (double)ybot, (double)zsouth).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        buffer.pos((double)xleft, (double)ybot, (double)zsouth).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        buffer.pos((double)xleft, (double)ytop, (double)zsouth).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        buffer.pos((double)xleft, (double)ybot, (double)zsouth).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        buffer.pos((double)xleft, (double)ybot, (double)znorth).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        buffer.pos((double)xright, (double)ytop, (double)znorth).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        buffer.pos((double)xleft, (double)ytop, (double)znorth).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        buffer.pos((double)xright, (double)ytop, (double)znorth).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        buffer.pos((double)xright, (double)ybot, (double)znorth).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        buffer.pos((double)xright, (double)ytop, (double)znorth).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        buffer.pos((double)xright, (double)ytop, (double)zsouth).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        buffer.pos((double)xright, (double)ybot, (double)zsouth).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        buffer.pos((double)xright, (double)ybot, (double)znorth).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        buffer.pos((double)xright, (double)ybot, (double)zsouth).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        buffer.pos((double)xright, (double)ytop, (double)zsouth).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        buffer.pos((double)xleft, (double)ytop, (double)zsouth).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        buffer.pos((double)xright, (double)ytop, (double)zsouth).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        buffer.pos((double)xleft, (double)ytop, (double)zsouth).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        buffer.pos((double)xleft, (double)ytop, (double)znorth).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        buffer.pos((double)xleft, (double)ytop, (double)znorth).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        buffer.pos((double)xleft, (double)ybot, (double)znorth).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        buffer.pos((double)xleft, (double)ybot, (double)znorth).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        buffer.pos((double)xright, (double)ybot, (double)znorth).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        buffer.setTranslation(0.0, 0.0, 0.0);
        tessellator.draw();
    }

    static void renderAxis(Tessellator tessellator, BufferBuilder buffer, int xlen, int ylen, int zlen) {
        GlStateManager.glLineWidth((float)2.5f);
        buffer.begin(1, DefaultVertexFormats.POSITION_COLOR);
        buffer.pos(0.0, 0.0, 0.0).color(1.0f, 0.0f, 0.0f, 1.0f).endVertex();
        buffer.pos((double)xlen, 0.0, 0.0).color(1.0f, 0.0f, 0.0f, 1.0f).endVertex();
        buffer.pos(0.0, 0.0, 0.0).color(0.0f, 1.0f, 0.0f, 1.0f).endVertex();
        buffer.pos(0.0, (double)ylen, 0.0).color(0.0f, 1.0f, 0.0f, 1.0f).endVertex();
        buffer.pos(0.0, 0.0, 0.0).color(0.0f, 0.0f, 1.0f, 1.0f).endVertex();
        buffer.pos(0.0, 0.0, (double)zlen).color(0.0f, 0.0f, 1.0f, 1.0f).endVertex();
        buffer.setTranslation(0.0, 0.0, 0.0);
        tessellator.draw();
    }

    private int calculateChecksum(ItemStack stack) {
        Check32 crc = new Check32();
        if (!stack.isEmpty()) {
            ShapeCardItem.getFormulaCheckClient(stack, crc);
        }
        return crc.get();
    }

    private boolean renderFaces(Tessellator tessellator, BufferBuilder buffer, ItemStack stack, boolean showScan, boolean grayscale, int scanId) {
        int recursiveScanId;
        RenderData data = ShapeRenderer.getRenderDataAndCreate(this.shapeID);
        if (data.isWantData() || this.waitForNewRequest > 0) {
            if (this.waitForNewRequest <= 0) {
                RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketRequestShapeData(stack, this.shapeID));
                this.waitForNewRequest = 20;
                data.setWantData(false);
            } else {
                --this.waitForNewRequest;
            }
        } else {
            long check = this.calculateChecksum(stack);
            if (!data.hasData() || check != data.getChecksum()) {
                data.setChecksum(check);
                data.setWantData(true);
            }
        }
        boolean needScanSound = false;
        if (data.getPlanes() != null) {
            long time = System.currentTimeMillis();
            for (RenderData.RenderPlane plane : data.getPlanes()) {
                boolean flash;
                if (plane == null) continue;
                if (plane.isDirty()) {
                    this.createRenderData(tessellator, buffer, plane, data, grayscale);
                    plane.markClean();
                }
                boolean bl = flash = showScan && plane.getBirthtime() > time - (long)ScannerConfiguration.projectorFlashTimeout.get();
                if (flash) {
                    needScanSound = true;
                    GlStateManager.enableBlend();
                    GlStateManager.blendFunc((int)1, (int)1);
                }
                plane.render();
                if (!flash) continue;
                GlStateManager.disableBlend();
                GlStateManager.blendFunc((int)770, (int)771);
            }
        }
        if ((recursiveScanId = ShapeCardItem.getScanIdRecursive(stack)) > 0) {
            --this.extraDataCounter;
            if (this.extraDataCounter <= 0) {
                this.extraDataCounter = 10;
                ScanDataManagerClient.getScansClient().requestExtraDataClient(recursiveScanId);
            }
            ScanExtraData extraData = ScanDataManagerClient.getScansClient().getExtraDataClient(recursiveScanId);
            for (ScanExtraData.Beacon beacon : extraData.getBeacons()) {
                int x = beacon.getPos().getX();
                int y = beacon.getPos().getY() + 1;
                int z = beacon.getPos().getZ();
                BeaconType type = beacon.getType();
                GlStateManager.translate((float)x, (float)y, (float)z);
                RenderData.RenderElement element = ShapeRenderer.getBeaconElement(tessellator, buffer, type, beacon.isDoBeacon());
                element.render();
                GlStateManager.translate((float)(-x), (float)(-y), (float)(-z));
            }
        }
        return needScanSound;
    }

    private void createRenderData(Tessellator tessellator, BufferBuilder buffer, RenderData.RenderPlane plane, RenderData data, boolean grayscale) {
        HashMap<IBlockState, ShapeBlockInfo> palette = new HashMap<IBlockState, ShapeBlockInfo>();
        double origOffsetX = buffer.xOffset;
        double origOffsetY = buffer.yOffset;
        double origOffsetZ = buffer.zOffset;
        int avgcnt = 0;
        int total = 0;
        int y = plane.getY();
        int offsety = plane.getOffsety();
        buffer = data.createRenderList(buffer, offsety);
        buffer.begin(7, DefaultVertexFormats.POSITION_COLOR);
        for (RenderData.RenderStrip strip : plane.getStrips()) {
            int z = plane.getStartz();
            int x = strip.getX();
            List<Pair<Integer, IBlockState>> columnData = strip.getData();
            for (int i = 0; i < columnData.size(); ++i) {
                Pair<Integer, IBlockState> pair = columnData.get(i);
                int cnt = (Integer)pair.getKey();
                IBlockState state = (IBlockState)pair.getValue();
                if (state != null) {
                    ShapeBlockInfo.IBlockRender bd;
                    buffer.setTranslation(origOffsetX + (double)x, origOffsetY + (double)y, origOffsetZ + (double)z);
                    avgcnt += cnt;
                    ++total;
                    ShapeBlockInfo info = ShapeBlockInfo.getBlockInfo(palette, state);
                    ShapeBlockInfo.Col col = info.getCol();
                    float r = col.getR();
                    float g = col.getG();
                    float b = col.getB();
                    if (grayscale) {
                        float a;
                        g = b = (a = 0.21f * r + 0.72f * g + 0.07f * b);
                        r = b;
                    }
                    if ((bd = info.getRender()) == null) {
                        ShapeRenderer.addSideFullTextureU(buffer, cnt, r * 0.8f, g * 0.8f, b * 0.8f);
                        ShapeRenderer.addSideFullTextureD(buffer, cnt, r * 0.8f, g * 0.8f, b * 0.8f);
                        if (strip.isEmptyAt(i - 1, palette)) {
                            ShapeRenderer.addSideFullTextureN(buffer, cnt, r * 1.2f, g * 1.2f, b * 1.2f);
                        }
                        if (strip.isEmptyAt(i + 1, palette)) {
                            ShapeRenderer.addSideFullTextureS(buffer, cnt, r * 1.2f, g * 1.2f, b * 1.2f);
                        }
                        ShapeRenderer.addSideFullTextureW(buffer, cnt, r, g, b);
                        ShapeRenderer.addSideFullTextureE(buffer, cnt, r, g, b);
                    } else {
                        for (int c = 0; c < cnt; ++c) {
                            bd.render(buffer, c, r, g, b);
                        }
                    }
                }
                z += cnt;
            }
        }
        buffer.setTranslation(origOffsetX, origOffsetY, origOffsetZ);
        data.performRenderToList(tessellator, buffer, offsety);
    }

    private static RenderData.RenderElement getBeaconElement(Tessellator tessellator, BufferBuilder buffer, BeaconType type, boolean doBeacon) {
        RenderData.RenderElement[] elements;
        if (beaconElement == null) {
            beaconElement = new RenderData.RenderElement[BeaconType.VALUES.length];
            beaconElementBeacon = new RenderData.RenderElement[BeaconType.VALUES.length];
            for (int i = 0; i < BeaconType.VALUES.length; ++i) {
                ShapeRenderer.beaconElement[i] = null;
                ShapeRenderer.beaconElementBeacon[i] = null;
            }
        }
        if ((elements = doBeacon ? beaconElementBeacon : beaconElement)[type.ordinal()] == null) {
            elements[type.ordinal()] = new RenderData.RenderElement();
            elements[type.ordinal()].createRenderList(buffer);
            GlStateManager.glLineWidth((float)3.0f);
            buffer.begin(7, DefaultVertexFormats.POSITION_COLOR);
            float r = type.getR();
            float g = type.getG();
            float b = type.getB();
            double origOffsetX = buffer.xOffset;
            double origOffsetY = buffer.yOffset;
            double origOffsetZ = buffer.zOffset;
            buffer.setTranslation(origOffsetX, origOffsetY - (double)0.7f, origOffsetZ);
            ShapeRenderer.addSideN(buffer, r, g, b, 0.3f);
            ShapeRenderer.addSideS(buffer, r, g, b, 0.3f);
            ShapeRenderer.addSideW(buffer, r, g, b, 0.3f);
            ShapeRenderer.addSideE(buffer, r, g, b, 0.3f);
            ShapeRenderer.addSideU(buffer, r, g, b, 0.3f);
            ShapeRenderer.addSideD(buffer, r, g, b, 0.3f);
            buffer.setTranslation(origOffsetX, origOffsetY - (double)0.2f, origOffsetZ);
            ShapeRenderer.addSideN(buffer, r, g, b, 0.2f);
            ShapeRenderer.addSideS(buffer, r, g, b, 0.2f);
            ShapeRenderer.addSideW(buffer, r, g, b, 0.2f);
            ShapeRenderer.addSideE(buffer, r, g, b, 0.2f);
            ShapeRenderer.addSideU(buffer, r, g, b, 0.2f);
            ShapeRenderer.addSideD(buffer, r, g, b, 0.2f);
            if (doBeacon) {
                buffer.setTranslation(origOffsetX, origOffsetY + (double)0.2f, origOffsetZ);
                ShapeRenderer.addSideN(buffer, r, g, b, 0.1f, ScannerConfiguration.locatorBeaconHeight.get());
                ShapeRenderer.addSideS(buffer, r, g, b, 0.1f, ScannerConfiguration.locatorBeaconHeight.get());
                ShapeRenderer.addSideW(buffer, r, g, b, 0.1f, ScannerConfiguration.locatorBeaconHeight.get());
                ShapeRenderer.addSideE(buffer, r, g, b, 0.1f, ScannerConfiguration.locatorBeaconHeight.get());
            }
            buffer.setTranslation(origOffsetX, origOffsetY, origOffsetZ);
            elements[type.ordinal()].performRenderToList(tessellator, buffer);
        }
        return elements[type.ordinal()];
    }

    private static void setupScissor(IShapeParentGui gui) {
        Minecraft mc = Minecraft.getMinecraft();
        ScaledResolution scaledresolution = new ScaledResolution(mc);
        int xScale = scaledresolution.getScaledWidth();
        int yScale = scaledresolution.getScaledHeight();
        int sx = (gui.getPreviewLeft() + 84) * mc.displayWidth / xScale;
        int sy = mc.displayHeight - (gui.getPreviewTop() + 136) * mc.displayHeight / yScale;
        int sw = 161 * mc.displayWidth / xScale;
        int sh = 130 * mc.displayHeight / yScale;
        GL11.glScissor((int)sx, (int)sy, (int)sw, (int)sh);
    }

    public static void addSideFullTextureD(BufferBuilder buffer, int cnt, float r, float g, float b) {
        float a = 0.5f;
        buffer.pos(0.0, 0.0, 0.0).color(r, g, b, a).endVertex();
        buffer.pos(1.0, 0.0, 0.0).color(r, g, b, a).endVertex();
        buffer.pos(1.0, 0.0, (double)cnt).color(r, g, b, a).endVertex();
        buffer.pos(0.0, 0.0, (double)cnt).color(r, g, b, a).endVertex();
    }

    public static void addSideFullTextureU(BufferBuilder buffer, int cnt, float r, float g, float b) {
        float a = 0.5f;
        buffer.pos(0.0, 1.0, (double)cnt).color(r, g, b, a).endVertex();
        buffer.pos(1.0, 1.0, (double)cnt).color(r, g, b, a).endVertex();
        buffer.pos(1.0, 1.0, 0.0).color(r, g, b, a).endVertex();
        buffer.pos(0.0, 1.0, 0.0).color(r, g, b, a).endVertex();
    }

    public static void addSideFullTextureE(BufferBuilder buffer, int cnt, float r, float g, float b) {
        float a = 0.5f;
        buffer.pos(1.0, 0.0, 0.0).color(r, g, b, a).endVertex();
        buffer.pos(1.0, 1.0, 0.0).color(r, g, b, a).endVertex();
        buffer.pos(1.0, 1.0, (double)cnt).color(r, g, b, a).endVertex();
        buffer.pos(1.0, 0.0, (double)cnt).color(r, g, b, a).endVertex();
    }

    public static void addSideFullTextureW(BufferBuilder buffer, int cnt, float r, float g, float b) {
        float a = 0.5f;
        buffer.pos(0.0, 0.0, (double)cnt).color(r, g, b, a).endVertex();
        buffer.pos(0.0, 1.0, (double)cnt).color(r, g, b, a).endVertex();
        buffer.pos(0.0, 1.0, 0.0).color(r, g, b, a).endVertex();
        buffer.pos(0.0, 0.0, 0.0).color(r, g, b, a).endVertex();
    }

    public static void addSideFullTextureN(BufferBuilder buffer, int cnt, float r, float g, float b) {
        float a = 0.5f;
        buffer.pos(1.0, 1.0, 0.0).color(r, g, b, a).endVertex();
        buffer.pos(1.0, 0.0, 0.0).color(r, g, b, a).endVertex();
        buffer.pos(0.0, 0.0, 0.0).color(r, g, b, a).endVertex();
        buffer.pos(0.0, 1.0, 0.0).color(r, g, b, a).endVertex();
    }

    public static void addSideFullTextureS(BufferBuilder buffer, int cnt, float r, float g, float b) {
        float a = 0.5f;
        buffer.pos(1.0, 0.0, (double)cnt).color(r, g, b, a).endVertex();
        buffer.pos(1.0, 1.0, (double)cnt).color(r, g, b, a).endVertex();
        buffer.pos(0.0, 1.0, (double)cnt).color(r, g, b, a).endVertex();
        buffer.pos(0.0, 0.0, (double)cnt).color(r, g, b, a).endVertex();
    }

    public static void addSideD(BufferBuilder buffer, float r, float g, float b, float size) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.pos((double)l, (double)l, (double)l).color(r, g, b, a).endVertex();
        buffer.pos((double)h, (double)l, (double)l).color(r, g, b, a).endVertex();
        buffer.pos((double)h, (double)l, (double)h).color(r, g, b, a).endVertex();
        buffer.pos((double)l, (double)l, (double)h).color(r, g, b, a).endVertex();
    }

    public static void addSideU(BufferBuilder buffer, float r, float g, float b, float size) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.pos((double)l, (double)h, (double)h).color(r, g, b, a).endVertex();
        buffer.pos((double)h, (double)h, (double)h).color(r, g, b, a).endVertex();
        buffer.pos((double)h, (double)h, (double)l).color(r, g, b, a).endVertex();
        buffer.pos((double)l, (double)h, (double)l).color(r, g, b, a).endVertex();
    }

    public static void addSideE(BufferBuilder buffer, float r, float g, float b, float size) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.pos((double)h, (double)l, (double)l).color(r, g, b, a).endVertex();
        buffer.pos((double)h, (double)h, (double)l).color(r, g, b, a).endVertex();
        buffer.pos((double)h, (double)h, (double)h).color(r, g, b, a).endVertex();
        buffer.pos((double)h, (double)l, (double)h).color(r, g, b, a).endVertex();
    }

    public static void addSideW(BufferBuilder buffer, float r, float g, float b, float size) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.pos((double)l, (double)l, (double)h).color(r, g, b, a).endVertex();
        buffer.pos((double)l, (double)h, (double)h).color(r, g, b, a).endVertex();
        buffer.pos((double)l, (double)h, (double)l).color(r, g, b, a).endVertex();
        buffer.pos((double)l, (double)l, (double)l).color(r, g, b, a).endVertex();
    }

    public static void addSideN(BufferBuilder buffer, float r, float g, float b, float size) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.pos((double)h, (double)h, (double)l).color(r, g, b, a).endVertex();
        buffer.pos((double)h, (double)l, (double)l).color(r, g, b, a).endVertex();
        buffer.pos((double)l, (double)l, (double)l).color(r, g, b, a).endVertex();
        buffer.pos((double)l, (double)h, (double)l).color(r, g, b, a).endVertex();
    }

    public static void addSideS(BufferBuilder buffer, float r, float g, float b, float size) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.pos((double)h, (double)l, (double)h).color(r, g, b, a).endVertex();
        buffer.pos((double)h, (double)h, (double)h).color(r, g, b, a).endVertex();
        buffer.pos((double)l, (double)h, (double)h).color(r, g, b, a).endVertex();
        buffer.pos((double)l, (double)l, (double)h).color(r, g, b, a).endVertex();
    }

    public static void addSideE(BufferBuilder buffer, float r, float g, float b, float size, float height) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.pos((double)h, 0.0, (double)l).color(r, g, b, a).endVertex();
        buffer.pos((double)h, (double)height, (double)l).color(r, g, b, a).endVertex();
        buffer.pos((double)h, (double)height, (double)h).color(r, g, b, a).endVertex();
        buffer.pos((double)h, 0.0, (double)h).color(r, g, b, a).endVertex();
    }

    public static void addSideW(BufferBuilder buffer, float r, float g, float b, float size, float height) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.pos((double)l, 0.0, (double)h).color(r, g, b, a).endVertex();
        buffer.pos((double)l, (double)height, (double)h).color(r, g, b, a).endVertex();
        buffer.pos((double)l, (double)height, (double)l).color(r, g, b, a).endVertex();
        buffer.pos((double)l, 0.0, (double)l).color(r, g, b, a).endVertex();
    }

    public static void addSideN(BufferBuilder buffer, float r, float g, float b, float size, float height) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.pos((double)h, (double)height, (double)l).color(r, g, b, a).endVertex();
        buffer.pos((double)h, 0.0, (double)l).color(r, g, b, a).endVertex();
        buffer.pos((double)l, 0.0, (double)l).color(r, g, b, a).endVertex();
        buffer.pos((double)l, (double)height, (double)l).color(r, g, b, a).endVertex();
    }

    public static void addSideS(BufferBuilder buffer, float r, float g, float b, float size, float height) {
        float a = 0.5f;
        float l = -size;
        float h = size;
        buffer.pos((double)h, 0.0, (double)h).color(r, g, b, a).endVertex();
        buffer.pos((double)h, (double)height, (double)h).color(r, g, b, a).endVertex();
        buffer.pos((double)l, (double)height, (double)h).color(r, g, b, a).endVertex();
        buffer.pos((double)l, 0.0, (double)h).color(r, g, b, a).endVertex();
    }
}

