/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.builder;

import com.mojang.authlib.GameProfile;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import mcjty.lib.bindings.DefaultAction;
import mcjty.lib.bindings.DefaultValue;
import mcjty.lib.bindings.IAction;
import mcjty.lib.bindings.IValue;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.Broadcaster;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.ModuleSupport;
import mcjty.lib.varia.OrientationTools;
import mcjty.lib.varia.RedstoneMode;
import mcjty.lib.varia.SoundTools;
import mcjty.lib.varia.WorldTools;
import mcjty.rftools.ClientCommandHandler;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.builder.BuilderConfiguration;
import mcjty.rftools.blocks.builder.BuilderSetup;
import mcjty.rftools.blocks.builder.BuilderTileEntityMode;
import mcjty.rftools.blocks.builder.SpaceChamberRepository;
import mcjty.rftools.blocks.builder.SupportBlock;
import mcjty.rftools.blocks.teleporter.TeleportationTools;
import mcjty.rftools.hud.IHudSupport;
import mcjty.rftools.items.builder.ShapeCardItem;
import mcjty.rftools.items.builder.ShapeCardType;
import mcjty.rftools.items.storage.StorageFilterCache;
import mcjty.rftools.items.storage.StorageFilterItem;
import mcjty.rftools.network.PacketGetHudLog;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.setup.ModSetup;
import mcjty.rftools.shapes.Shape;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBlockSpecial;
import net.minecraft.item.ItemRedstone;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityShulkerBox;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;

public class BuilderTileEntity
extends GenericEnergyReceiverTileEntity
implements DefaultSidedInventory,
ITickable,
IHudSupport {
    public static final String CMD_SETMODE = "builder.setMode";
    public static final String CMD_SETROTATE = "builder.setRotate";
    public static final String CMD_SETANCHOR = "builder.setAnchor";
    public static final Key<Integer> PARAM_ANCHOR_INDEX = new Key("anchorIndex", Type.INTEGER);
    public static final String CMD_GETLEVEL = "getLevel";
    public static final Key<Integer> PARAM_LEVEL = new Key("level", Type.INTEGER);
    public static final int SLOT_TAB = 0;
    public static final int SLOT_FILTER = 1;
    public static final ContainerFactory CONTAINER_FACTORY = new ContainerFactory(new ResourceLocation("rftools", "gui/builder.gui"));
    public static final ModuleSupport MODULE_SUPPORT = new ModuleSupport(0){

        public boolean isModule(ItemStack itemStack) {
            return itemStack.func_77973_b() == BuilderSetup.shapeCardItem || itemStack.func_77973_b() == BuilderSetup.spaceChamberCardItem;
        }
    };
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, CONTAINER_FACTORY, 2);
    public static final int MODE_COPY = 0;
    public static final int MODE_MOVE = 1;
    public static final int MODE_SWAP = 2;
    public static final int MODE_BACK = 3;
    public static final int MODE_COLLECT = 4;
    public static final String[] MODES = new String[]{"Copy", "Move", "Swap", "Back", "Collect"};
    public static final String ROTATE_0 = "0";
    public static final String ROTATE_90 = "90";
    public static final String ROTATE_180 = "180";
    public static final String ROTATE_270 = "270";
    public static final int ANCHOR_SW = 0;
    public static final int ANCHOR_SE = 1;
    public static final int ANCHOR_NW = 2;
    public static final int ANCHOR_NE = 3;
    private String lastError = null;
    private int mode = 0;
    private int rotate = 0;
    private int anchor = 0;
    private boolean silent = false;
    private boolean supportMode = false;
    private boolean entityMode = false;
    private boolean loopMode = false;
    private boolean waitMode = true;
    private boolean hilightMode = false;
    private static int currentLevel = 0;
    private int scanLocCnt = 0;
    private static Map<BlockPos, Pair<Long, BlockPos>> scanLocClient = new HashMap<BlockPos, Pair<Long, BlockPos>>();
    private int collectCounter = BuilderConfiguration.collectTimer.get();
    private int collectXP = 0;
    private boolean boxValid = false;
    private BlockPos minBox = null;
    private BlockPos maxBox = null;
    private BlockPos scan = null;
    private int projDx;
    private int projDy;
    private int projDz;
    private long lastHudTime = 0L;
    private List<String> clientHudLog = new ArrayList<String>();
    private ShapeCardType cardType = ShapeCardType.CARD_UNKNOWN;
    private StorageFilterCache filterCache = null;
    private ForgeChunkManager.Ticket ticket = null;
    private ChunkPos forcedChunk = null;
    private Map<BlockPos, IBlockState> cachedBlocks = null;
    private ChunkPos cachedChunk = null;
    private Set<Block> cachedVoidableBlocks = null;
    private List<ItemStack> overflowItems = null;
    private FakePlayer harvester = null;
    public static final Key<Boolean> VALUE_WAIT = new Key("wait", Type.BOOLEAN);
    public static final Key<Boolean> VALUE_LOOP = new Key("loop", Type.BOOLEAN);
    public static final Key<Boolean> VALUE_HILIGHT = new Key("highlight", Type.BOOLEAN);
    public static final Key<Boolean> VALUE_SUPPORT = new Key("support", Type.BOOLEAN);
    public static final Key<Boolean> VALUE_SILENT = new Key("silent", Type.BOOLEAN);
    public static final Key<Boolean> VALUE_ENTITIES = new Key("entities", Type.BOOLEAN);
    private static Random random = new Random();
    private static long lastTime = 0L;

    public BuilderTileEntity() {
        super((long)BuilderConfiguration.BUILDER_MAXENERGY.get(), (long)BuilderConfiguration.BUILDER_RECEIVEPERTICK.get());
        this.setRSMode(RedstoneMode.REDSTONE_ONREQUIRED);
    }

    public IValue<?>[] getValues() {
        return new IValue[]{new DefaultValue(VALUE_RSMODE, () -> ((BuilderTileEntity)this).getRSModeInt(), arg_0 -> ((BuilderTileEntity)this).setRSModeInt(arg_0)), new DefaultValue(VALUE_WAIT, this::isWaitMode, this::setWaitMode), new DefaultValue(VALUE_LOOP, this::hasLoopMode, this::setLoopMode), new DefaultValue(VALUE_HILIGHT, this::isHilightMode, this::setHilightMode), new DefaultValue(VALUE_SUPPORT, this::hasSupportMode, this::setSupportMode), new DefaultValue(VALUE_SILENT, this::isSilent, this::setSilent), new DefaultValue(VALUE_ENTITIES, this::hasEntityMode, this::setEntityMode)};
    }

    public IAction[] getActions() {
        return new IAction[]{new DefaultAction("restart", this::restartScan)};
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    private FakePlayer getHarvester() {
        if (this.harvester == null) {
            this.harvester = FakePlayerFactory.get((WorldServer)((WorldServer)this.field_145850_b), (GameProfile)new GameProfile(UUID.nameUUIDFromBytes("rftools_builder".getBytes()), "rftools_builder"));
        }
        this.harvester.func_70029_a(this.field_145850_b);
        this.harvester.func_70107_b((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p());
        return this.harvester;
    }

    @Override
    public EnumFacing getBlockOrientation() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() == BuilderSetup.builderBlock) {
            return OrientationTools.getOrientationHoriz((IBlockState)state);
        }
        return null;
    }

    @Override
    public boolean isBlockAboveAir() {
        return this.func_145831_w().func_175623_d(this.field_174879_c.func_177984_a());
    }

    @Override
    public List<String> getClientLog() {
        return this.clientHudLog;
    }

    public List<String> getHudLog() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(TextFormatting.BLUE + "Mode:");
        if (this.isShapeCard()) {
            this.getCardType().addHudLog(list, this.inventoryHelper);
        } else {
            list.add("    Space card: " + (new String[]{"copy", "move", "swap", "back", "collect"})[this.mode]);
        }
        if (this.scan != null) {
            list.add(TextFormatting.BLUE + "Progress:");
            list.add("    Y level: " + this.scan.func_177956_o());
            int minChunkX = this.minBox.func_177958_n() >> 4;
            int minChunkZ = this.minBox.func_177952_p() >> 4;
            int maxChunkX = this.maxBox.func_177958_n() >> 4;
            int maxChunkZ = this.maxBox.func_177952_p() >> 4;
            int curX = this.scan.func_177958_n() >> 4;
            int curZ = this.scan.func_177952_p() >> 4;
            int totChunks = (maxChunkX - minChunkX + 1) * (maxChunkZ - minChunkZ + 1);
            int curChunk = (curZ - minChunkZ) * (maxChunkX - minChunkX) + curX - minChunkX;
            list.add("    Chunk:  " + curChunk + " of " + totChunks);
        }
        if (this.lastError != null && !this.lastError.isEmpty()) {
            String[] errors;
            for (String error : errors = StringUtils.split((String)this.lastError, (String)"\n")) {
                list.add(TextFormatting.RED + error);
            }
        }
        return list;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.func_174877_v();
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastHudTime;
    }

    @Override
    public void setLastUpdateTime(long t) {
        this.lastHudTime = t;
    }

    private boolean isShapeCard() {
        ItemStack itemStack = this.inventoryHelper.getStackInSlot(0);
        if (itemStack.func_190926_b()) {
            return false;
        }
        return itemStack.func_77973_b() == BuilderSetup.shapeCardItem;
    }

    private NBTTagCompound hasCard() {
        ItemStack itemStack = this.inventoryHelper.getStackInSlot(0);
        if (itemStack.func_190926_b()) {
            return null;
        }
        return itemStack.func_77978_p();
    }

    private void makeSupportBlocksShaped() {
        ItemStack shapeCard = this.inventoryHelper.getStackInSlot(0);
        BlockPos dimension = ShapeCardItem.getClampedDimension(shapeCard, BuilderConfiguration.maxBuilderDimension.get());
        BlockPos offset = ShapeCardItem.getClampedOffset(shapeCard, BuilderConfiguration.maxBuilderOffset.get());
        Shape shape = ShapeCardItem.getShape(shapeCard);
        HashMap<BlockPos, IBlockState> blocks = new HashMap<BlockPos, IBlockState>();
        ShapeCardItem.composeFormula(shapeCard, shape.getFormulaFactory().get(), this.field_145850_b, this.func_174877_v(), dimension, offset, blocks, BuilderConfiguration.maxBuilderDimension.get() * 256 * BuilderConfiguration.maxBuilderDimension.get(), false, false, null);
        IBlockState state = BuilderSetup.supportBlock.func_176223_P().func_177226_a((IProperty)SupportBlock.STATUS, (Comparable)Integer.valueOf(0));
        for (Map.Entry entry : blocks.entrySet()) {
            BlockPos p = (BlockPos)entry.getKey();
            if (!this.field_145850_b.func_175623_d(p)) continue;
            this.field_145850_b.func_180501_a(p, state, 2);
        }
    }

    private void makeSupportBlocks() {
        if (this.isShapeCard()) {
            this.makeSupportBlocksShaped();
            return;
        }
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = this.calculateBox();
        if (chamberChannel != null) {
            int dimension = chamberChannel.getDimension();
            WorldServer world = DimensionManager.getWorld((int)dimension);
            if (world == null) {
                return;
            }
            BlockPos.MutableBlockPos src = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos dest = new BlockPos.MutableBlockPos();
            for (int x = this.minBox.func_177958_n(); x <= this.maxBox.func_177958_n(); ++x) {
                for (int y = this.minBox.func_177956_o(); y <= this.maxBox.func_177956_o(); ++y) {
                    for (int z = this.minBox.func_177952_p(); z <= this.maxBox.func_177952_p(); ++z) {
                        src.func_181079_c(x, y, z);
                        this.sourceToDest((BlockPos)src, dest);
                        IBlockState srcState = world.func_180495_p((BlockPos)src);
                        Block srcBlock = srcState.func_177230_c();
                        IBlockState dstState = world.func_180495_p((BlockPos)dest);
                        Block dstBlock = dstState.func_177230_c();
                        int error = 0;
                        if (this.mode != 0) {
                            TileEntity srcTileEntity = world.func_175625_s((BlockPos)src);
                            TileEntity dstTileEntity = this.func_145831_w().func_175625_s((BlockPos)dest);
                            int error1 = this.isMovable((World)world, (BlockPos)src, srcBlock, srcTileEntity);
                            int error2 = this.isMovable(this.func_145831_w(), (BlockPos)dest, dstBlock, dstTileEntity);
                            error = Math.max(error1, error2);
                        }
                        if (BuilderTileEntity.isEmpty(srcState, srcBlock) && !BuilderTileEntity.isEmpty(dstState, dstBlock)) {
                            this.func_145831_w().func_180501_a((BlockPos)src, BuilderSetup.supportBlock.func_176223_P().func_177226_a((IProperty)SupportBlock.STATUS, (Comparable)Integer.valueOf(error)), 3);
                        }
                        if (!BuilderTileEntity.isEmpty(dstState, dstBlock) || BuilderTileEntity.isEmpty(srcState, srcBlock)) continue;
                        this.func_145831_w().func_180501_a((BlockPos)dest, BuilderSetup.supportBlock.func_176223_P().func_177226_a((IProperty)SupportBlock.STATUS, (Comparable)Integer.valueOf(error)), 3);
                    }
                }
            }
        }
    }

    private void clearSupportBlocksShaped() {
        ItemStack shapeCard = this.inventoryHelper.getStackInSlot(0);
        BlockPos dimension = ShapeCardItem.getClampedDimension(shapeCard, BuilderConfiguration.maxBuilderDimension.get());
        BlockPos offset = ShapeCardItem.getClampedOffset(shapeCard, BuilderConfiguration.maxBuilderOffset.get());
        Shape shape = ShapeCardItem.getShape(shapeCard);
        HashMap<BlockPos, IBlockState> blocks = new HashMap<BlockPos, IBlockState>();
        ShapeCardItem.composeFormula(shapeCard, shape.getFormulaFactory().get(), this.field_145850_b, this.func_174877_v(), dimension, offset, blocks, BuilderConfiguration.maxSpaceChamberDimension.get() * BuilderConfiguration.maxSpaceChamberDimension.get() * BuilderConfiguration.maxSpaceChamberDimension.get(), false, false, null);
        for (Map.Entry entry : blocks.entrySet()) {
            BlockPos p = (BlockPos)entry.getKey();
            if (this.field_145850_b.func_180495_p(p).func_177230_c() != BuilderSetup.supportBlock) continue;
            this.field_145850_b.func_175698_g(p);
        }
    }

    public void clearSupportBlocks() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.isShapeCard()) {
            this.clearSupportBlocksShaped();
            return;
        }
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = this.calculateBox();
        if (chamberChannel != null) {
            int dimension = chamberChannel.getDimension();
            WorldServer world = DimensionManager.getWorld((int)dimension);
            BlockPos.MutableBlockPos src = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos dest = new BlockPos.MutableBlockPos();
            for (int x = this.minBox.func_177958_n(); x <= this.maxBox.func_177958_n(); ++x) {
                for (int y = this.minBox.func_177956_o(); y <= this.maxBox.func_177956_o(); ++y) {
                    for (int z = this.minBox.func_177952_p(); z <= this.maxBox.func_177952_p(); ++z) {
                        Block srcBlock;
                        src.func_181079_c(x, y, z);
                        if (world != null && (srcBlock = world.func_180495_p((BlockPos)src).func_177230_c()) == BuilderSetup.supportBlock) {
                            world.func_175698_g((BlockPos)src);
                        }
                        this.sourceToDest((BlockPos)src, dest);
                        Block dstBlock = this.func_145831_w().func_180495_p((BlockPos)dest).func_177230_c();
                        if (dstBlock != BuilderSetup.supportBlock) continue;
                        this.func_145831_w().func_175698_g((BlockPos)dest);
                    }
                }
            }
        }
    }

    public boolean isHilightMode() {
        return this.hilightMode;
    }

    public void setHilightMode(boolean hilightMode) {
        this.hilightMode = hilightMode;
    }

    public boolean isWaitMode() {
        return this.waitMode;
    }

    public void setWaitMode(boolean waitMode) {
        this.waitMode = waitMode;
        this.markDirtyClient();
    }

    private boolean waitOrSkip(String error) {
        if (this.waitMode) {
            this.lastError = error;
        }
        return this.waitMode;
    }

    private boolean skip() {
        this.lastError = null;
        return false;
    }

    public boolean suspend(int rfNeeded, BlockPos srcPos, IBlockState srcState, IBlockState pickState) {
        this.lastError = null;
        return true;
    }

    private boolean suspend(String error) {
        this.lastError = error;
        return true;
    }

    public boolean hasLoopMode() {
        return this.loopMode;
    }

    public void setLoopMode(boolean loopMode) {
        this.loopMode = loopMode;
        this.markDirtyClient();
    }

    public boolean hasEntityMode() {
        return this.entityMode;
    }

    public void setEntityMode(boolean entityMode) {
        this.entityMode = entityMode;
        this.markDirtyClient();
    }

    public boolean hasSupportMode() {
        return this.supportMode;
    }

    public void setSupportMode(boolean supportMode) {
        this.supportMode = supportMode;
        if (supportMode) {
            this.makeSupportBlocks();
        } else {
            this.clearSupportBlocks();
        }
        this.markDirtyClient();
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
        this.markDirtyClient();
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        if (mode != this.mode) {
            this.mode = mode;
            this.restartScan();
            this.markDirtyClient();
        }
    }

    public void resetBox() {
        this.boxValid = false;
    }

    public int getAnchor() {
        return this.anchor;
    }

    public void setAnchor(int anchor) {
        if (this.supportMode) {
            this.clearSupportBlocks();
        }
        this.boxValid = false;
        this.anchor = anchor;
        if (this.isShapeCard()) {
            ItemStack shapeCard = this.inventoryHelper.getStackInSlot(0);
            BlockPos dimension = ShapeCardItem.getDimension(shapeCard);
            BlockPos minBox = this.positionBox(dimension);
            int dx = dimension.func_177958_n();
            int dy = dimension.func_177956_o();
            int dz = dimension.func_177952_p();
            BlockPos offset = new BlockPos(minBox.func_177958_n() + (int)Math.ceil(dx / 2), minBox.func_177956_o() + (int)Math.ceil(dy / 2), minBox.func_177952_p() + (int)Math.ceil(dz / 2));
            ShapeCardItem.setOffset(shapeCard, offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p());
        }
        if (this.supportMode) {
            this.makeSupportBlocks();
        }
        this.markDirtyClient();
    }

    private BlockPos positionBox(BlockPos dimension) {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)BaseBlock.FACING_HORIZ);
        int spanX = dimension.func_177958_n();
        int spanY = dimension.func_177956_o();
        int spanZ = dimension.func_177952_p();
        int x = 0;
        int z = 0;
        int y = -(this.anchor == 3 || this.anchor == 2 ? spanY - 1 : 0);
        switch (direction) {
            case SOUTH: {
                x = -(this.anchor == 3 || this.anchor == 1 ? spanX - 1 : 0);
                z = -spanZ;
                break;
            }
            case NORTH: {
                x = 1 - spanX + (this.anchor == 3 || this.anchor == 1 ? spanX - 1 : 0);
                z = 1;
                break;
            }
            case WEST: {
                x = 1;
                z = -(this.anchor == 3 || this.anchor == 1 ? spanZ - 1 : 0);
                break;
            }
            case EAST: {
                x = -spanX;
                z = -(this.anchor == 3 || this.anchor == 1 ? 0 : spanZ - 1);
                break;
            }
        }
        return new BlockPos(x, y, z);
    }

    public int getRotate() {
        return this.rotate;
    }

    public void setRotate(int rotate) {
        if (this.supportMode) {
            this.clearSupportBlocks();
        }
        this.boxValid = false;
        this.rotate = rotate;
        if (this.supportMode) {
            this.makeSupportBlocks();
        }
        this.markDirtyClient();
    }

    public void setPowerInput(int powered) {
        boolean o = this.isMachineEnabled();
        super.setPowerInput(powered);
        boolean n = this.isMachineEnabled();
        if (o != n && (this.loopMode || n && this.scan == null)) {
            this.restartScan();
        }
    }

    private void createProjection(SpaceChamberRepository.SpaceChamberChannel chamberChannel) {
        BlockPos minC = this.rotate(chamberChannel.getMinCorner());
        BlockPos maxC = this.rotate(chamberChannel.getMaxCorner());
        BlockPos minCorner = new BlockPos(Math.min(minC.func_177958_n(), maxC.func_177958_n()), Math.min(minC.func_177956_o(), maxC.func_177956_o()), Math.min(minC.func_177952_p(), maxC.func_177952_p()));
        BlockPos maxCorner = new BlockPos(Math.max(minC.func_177958_n(), maxC.func_177958_n()), Math.max(minC.func_177956_o(), maxC.func_177956_o()), Math.max(minC.func_177952_p(), maxC.func_177952_p()));
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)BaseBlock.FACING_HORIZ);
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        int spanX = maxCorner.func_177958_n() - minCorner.func_177958_n();
        int spanY = maxCorner.func_177956_o() - minCorner.func_177956_o();
        int spanZ = maxCorner.func_177952_p() - minCorner.func_177952_p();
        switch (direction) {
            case SOUTH: {
                this.projDx = xCoord + EnumFacing.NORTH.func_176730_m().func_177958_n() - minCorner.func_177958_n() - (this.anchor == 3 || this.anchor == 1 ? spanX : 0);
                this.projDz = zCoord + EnumFacing.NORTH.func_176730_m().func_177952_p() - minCorner.func_177952_p() - spanZ;
                break;
            }
            case NORTH: {
                this.projDx = xCoord + EnumFacing.SOUTH.func_176730_m().func_177958_n() - minCorner.func_177958_n() - spanX + (this.anchor == 3 || this.anchor == 1 ? spanX : 0);
                this.projDz = zCoord + EnumFacing.SOUTH.func_176730_m().func_177952_p() - minCorner.func_177952_p();
                break;
            }
            case WEST: {
                this.projDx = xCoord + EnumFacing.EAST.func_176730_m().func_177958_n() - minCorner.func_177958_n();
                this.projDz = zCoord + EnumFacing.EAST.func_176730_m().func_177952_p() - minCorner.func_177952_p() - (this.anchor == 3 || this.anchor == 1 ? spanZ : 0);
                break;
            }
            case EAST: {
                this.projDx = xCoord + EnumFacing.WEST.func_176730_m().func_177958_n() - minCorner.func_177958_n() - spanX;
                this.projDz = zCoord + EnumFacing.WEST.func_176730_m().func_177952_p() - minCorner.func_177952_p() - spanZ + (this.anchor == 3 || this.anchor == 1 ? spanZ : 0);
                break;
            }
        }
        this.projDy = yCoord - minCorner.func_177956_o() - (this.anchor == 3 || this.anchor == 2 ? spanY : 0);
    }

    private void calculateBox(NBTTagCompound cardCompound) {
        int channel = cardCompound.func_74762_e("channel");
        SpaceChamberRepository repository = SpaceChamberRepository.getChannels(this.func_145831_w());
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = repository.getChannel(channel);
        BlockPos minCorner = chamberChannel.getMinCorner();
        BlockPos maxCorner = chamberChannel.getMaxCorner();
        if (minCorner == null || maxCorner == null) {
            return;
        }
        if (this.boxValid && minCorner.equals((Object)this.minBox) && maxCorner.equals((Object)this.maxBox)) {
            return;
        }
        this.boxValid = true;
        this.cardType = ShapeCardType.CARD_SPACE;
        this.createProjection(chamberChannel);
        this.minBox = minCorner;
        this.maxBox = maxCorner;
        this.restartScan();
    }

    private void checkStateServerShaped() {
        float factor = this.getInfusedFactor();
        int i = 0;
        while ((float)i < (float)BuilderConfiguration.quarryBaseSpeed.get() + factor * (float)BuilderConfiguration.quarryInfusionSpeedFactor.get()) {
            if (this.scan != null) {
                this.handleBlockShaped();
            }
            ++i;
        }
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        if (this.overflowItems != null && this.insertItems(this.overflowItems)) {
            this.overflowItems = null;
        }
        if (!this.isMachineEnabled() && this.loopMode) {
            return;
        }
        if (this.scan == null) {
            return;
        }
        if (this.isHilightMode()) {
            this.updateHilight();
        }
        if (this.isShapeCard()) {
            if (!this.isMachineEnabled()) {
                this.chunkUnload();
                return;
            }
            this.checkStateServerShaped();
            return;
        }
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = this.calculateBox();
        if (chamberChannel == null) {
            this.scan = null;
            this.func_70296_d();
            return;
        }
        int dimension = chamberChannel.getDimension();
        WorldServer world = DimensionManager.getWorld((int)dimension);
        if (world == null) {
            return;
        }
        if (this.mode == 4) {
            this.collectItems((World)world);
        } else {
            float factor = this.getInfusedFactor();
            int i = 0;
            while ((float)i < 2.0f + factor * 40.0f) {
                if (this.scan != null) {
                    this.handleBlock((World)world);
                }
                ++i;
            }
        }
    }

    public List<ItemStack> getOverflowItems() {
        return this.overflowItems;
    }

    private void updateHilight() {
        --this.scanLocCnt;
        if (this.scanLocCnt <= 0) {
            this.scanLocCnt = 5;
            int x = this.scan.func_177958_n();
            int y = this.scan.func_177956_o();
            int z = this.scan.func_177952_p();
            double sqradius = 900.0;
            for (EntityPlayerMP player : this.func_145831_w().func_73046_m().func_184103_al().func_181057_v()) {
                double d2;
                double d1;
                double d0;
                if (player.field_71093_bK != this.func_145831_w().field_73011_w.getDimension() || !((d0 = (double)x - player.field_70165_t) * d0 + (d1 = (double)y - player.field_70163_u) * d1 + (d2 = (double)z - player.field_70161_v) * d2 < sqradius)) continue;
                RFToolsMessages.sendToClient((EntityPlayer)player, "positionToClient", TypedMap.builder().put(ClientCommandHandler.PARAM_POS, (Object)this.func_174877_v()).put(ClientCommandHandler.PARAM_SCAN, (Object)this.scan));
            }
        }
    }

    private void collectItems(World world) {
        --this.collectCounter;
        if (this.collectCounter > 0) {
            return;
        }
        this.collectCounter = BuilderConfiguration.collectTimer.get();
        if (!this.loopMode) {
            this.scan = null;
        }
        long rf = this.getStoredPower();
        float area = (this.maxBox.func_177958_n() - this.minBox.func_177958_n() + 1) * (this.maxBox.func_177956_o() - this.minBox.func_177956_o() + 1) * (this.maxBox.func_177952_p() - this.minBox.func_177952_p() + 1);
        float infusedFactor = (4.0f - this.getInfusedFactor()) / 4.0f;
        int rfNeeded = (int)(BuilderConfiguration.collectRFPerTickPerArea.get() * (double)area * (double)infusedFactor) * BuilderConfiguration.collectTimer.get();
        if ((long)rfNeeded > rf) {
            return;
        }
        this.consumeEnergy(rfNeeded);
        AxisAlignedBB bb = new AxisAlignedBB((double)this.minBox.func_177958_n() - 0.8, (double)this.minBox.func_177956_o() - 0.8, (double)this.minBox.func_177952_p() - 0.8, (double)this.maxBox.func_177958_n() + 0.8, (double)this.maxBox.func_177956_o() + 0.8, (double)this.maxBox.func_177952_p() + 0.8);
        List items = world.func_72872_a(Entity.class, bb);
        for (Entity entity : items) {
            if (!(entity instanceof EntityItem ? this.collectItem(world, infusedFactor, (EntityItem)entity) : entity instanceof EntityXPOrb && this.collectXP(world, infusedFactor, (EntityXPOrb)entity))) continue;
            return;
        }
    }

    private boolean collectXP(World world, float infusedFactor, EntityXPOrb orb) {
        int xp = orb.func_70526_d();
        long rf = this.getStoredPower();
        int rfNeeded = (int)(BuilderConfiguration.collectRFPerXP.get() * (double)infusedFactor * (double)xp);
        if ((long)rfNeeded > rf) {
            return true;
        }
        this.collectXP += xp;
        int bottles = this.collectXP / 7;
        if (bottles > 0) {
            if (this.insertItem(new ItemStack(Items.field_151062_by, bottles)).func_190926_b()) {
                this.collectXP %= 7;
                world.func_72900_e((Entity)orb);
                this.consumeEnergy(rfNeeded);
            } else {
                this.collectXP = 0;
            }
        }
        return false;
    }

    private boolean collectItem(World world, float infusedFactor, EntityItem item) {
        ItemStack stack = item.func_92059_d();
        long rf = this.getStoredPower();
        int rfNeeded = (int)((float)BuilderConfiguration.collectRFPerItem.get() * infusedFactor) * stack.func_190916_E();
        if ((long)rfNeeded > rf) {
            return true;
        }
        this.consumeEnergy(rfNeeded);
        world.func_72900_e((Entity)item);
        stack = this.insertItem(stack);
        if (!stack.func_190926_b()) {
            BlockPos position = item.func_180425_c();
            EntityItem entityItem = new EntityItem(this.func_145831_w(), (double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), stack);
            this.func_145831_w().func_72838_d((Entity)entityItem);
        }
        return false;
    }

    private void calculateBoxShaped() {
        ItemStack shapeCard = this.inventoryHelper.getStackInSlot(0);
        if (shapeCard.func_190926_b()) {
            return;
        }
        BlockPos dimension = ShapeCardItem.getClampedDimension(shapeCard, BuilderConfiguration.maxBuilderDimension.get());
        BlockPos offset = ShapeCardItem.getClampedOffset(shapeCard, BuilderConfiguration.maxBuilderOffset.get());
        BlockPos minCorner = ShapeCardItem.getMinCorner(this.func_174877_v(), dimension, offset);
        BlockPos maxCorner = ShapeCardItem.getMaxCorner(this.func_174877_v(), dimension, offset);
        if (minCorner.func_177956_o() < 0) {
            minCorner = new BlockPos(minCorner.func_177958_n(), 0, minCorner.func_177952_p());
        } else if (minCorner.func_177956_o() > 255) {
            minCorner = new BlockPos(minCorner.func_177958_n(), 255, minCorner.func_177952_p());
        }
        if (maxCorner.func_177956_o() < 0) {
            maxCorner = new BlockPos(maxCorner.func_177958_n(), 0, maxCorner.func_177952_p());
        } else if (maxCorner.func_177956_o() > 255) {
            maxCorner = new BlockPos(maxCorner.func_177958_n(), 255, maxCorner.func_177952_p());
        }
        if (this.boxValid && minCorner.equals((Object)this.minBox) && maxCorner.equals((Object)this.maxBox)) {
            return;
        }
        this.boxValid = true;
        this.cardType = ShapeCardType.fromDamage(shapeCard.func_77952_i());
        this.cachedBlocks = null;
        this.cachedChunk = null;
        this.cachedVoidableBlocks = null;
        this.minBox = minCorner;
        this.maxBox = maxCorner;
        this.restartScan();
    }

    private SpaceChamberRepository.SpaceChamberChannel calculateBox() {
        NBTTagCompound tc = this.hasCard();
        if (tc == null) {
            return null;
        }
        int channel = tc.func_74762_e("channel");
        if (channel == -1) {
            return null;
        }
        SpaceChamberRepository repository = SpaceChamberRepository.getChannels(this.func_145831_w());
        SpaceChamberRepository.SpaceChamberChannel chamberChannel = repository.getChannel(channel);
        if (chamberChannel == null) {
            return null;
        }
        this.calculateBox(tc);
        if (!this.boxValid) {
            return null;
        }
        return chamberChannel;
    }

    private Map<BlockPos, IBlockState> getCachedBlocks(ChunkPos chunk) {
        if (chunk != null && !chunk.equals((Object)this.cachedChunk) || chunk == null && this.cachedChunk != null) {
            this.cachedBlocks = null;
        }
        if (this.cachedBlocks == null) {
            this.cachedBlocks = new HashMap<BlockPos, IBlockState>();
            ItemStack shapeCard = this.inventoryHelper.getStackInSlot(0);
            Shape shape = ShapeCardItem.getShape(shapeCard);
            boolean solid = ShapeCardItem.isSolid(shapeCard);
            BlockPos dimension = ShapeCardItem.getClampedDimension(shapeCard, BuilderConfiguration.maxBuilderDimension.get());
            BlockPos offset = ShapeCardItem.getClampedOffset(shapeCard, BuilderConfiguration.maxBuilderOffset.get());
            boolean forquarry = !ShapeCardItem.isNormalShapeCard(shapeCard);
            ShapeCardItem.composeFormula(shapeCard, shape.getFormulaFactory().get(), this.func_145831_w(), this.func_174877_v(), dimension, offset, this.cachedBlocks, BuilderConfiguration.maxSpaceChamberDimension.get() * BuilderConfiguration.maxSpaceChamberDimension.get() * BuilderConfiguration.maxSpaceChamberDimension.get(), solid, forquarry, chunk);
            this.cachedChunk = chunk;
        }
        return this.cachedBlocks;
    }

    private void handleBlockShaped() {
        for (int i = 0; i < 100; ++i) {
            if (this.scan == null) {
                return;
            }
            Map<BlockPos, IBlockState> blocks = this.getCachedBlocks(new ChunkPos(this.scan.func_177958_n() >> 4, this.scan.func_177952_p() >> 4));
            if (blocks.containsKey(this.scan)) {
                IBlockState state = blocks.get(this.scan);
                if (!this.handleSingleBlock(state)) {
                    this.nextLocation();
                }
                return;
            }
            this.nextLocation();
        }
    }

    private ShapeCardType getCardType() {
        ItemStack card;
        if (this.cardType == ShapeCardType.CARD_UNKNOWN && !(card = this.inventoryHelper.getStackInSlot(0)).func_190926_b()) {
            this.cardType = ShapeCardType.fromDamage(card.func_77952_i());
        }
        return this.cardType;
    }

    private boolean handleSingleBlock(IBlockState pickState) {
        Block block;
        BlockPos srcPos = this.scan;
        int sx = this.scan.func_177958_n();
        int sy = this.scan.func_177956_o();
        int sz = this.scan.func_177952_p();
        if (!this.chunkLoad(sx, sz)) {
            return this.suspend("Chunk not available!");
        }
        int rfNeeded = this.getCardType().getRfNeeded();
        IBlockState state = null;
        if (this.getCardType() != ShapeCardType.CARD_SHAPE && this.getCardType() != ShapeCardType.CARD_PUMP_LIQUID && !BuilderTileEntity.isEmpty(state = this.func_145831_w().func_180495_p(srcPos), block = state.func_177230_c())) {
            float hardness;
            if (BuilderTileEntity.isFluidBlock(block)) {
                hardness = 1.0f;
            } else {
                if (this.getCachedVoidableBlocks().contains(block)) {
                    rfNeeded = (int)((double)BuilderConfiguration.builderRfPerQuarry.get() * BuilderConfiguration.voidShapeCardFactor.get());
                }
                hardness = block.func_176195_g(state, this.func_145831_w(), srcPos);
            }
            rfNeeded *= (int)((hardness + 1.0f) * 2.0f);
        }
        if ((long)(rfNeeded = (int)((float)rfNeeded * (3.0f - this.getInfusedFactor()) / 3.0f)) > this.getStoredPower()) {
            return this.suspend("Not enough power!");
        }
        return this.getCardType().handleSingleBlock(this, rfNeeded, srcPos, state, pickState);
    }

    public boolean buildBlock(int rfNeeded, BlockPos srcPos, IBlockState srcState, IBlockState pickState) {
        if (BuilderTileEntity.isEmptyOrReplacable(this.func_145831_w(), srcPos)) {
            TakeableItem item = this.createTakeableItem(this.func_145831_w(), srcPos, pickState);
            ItemStack stack = item.peek();
            if (stack.func_190926_b()) {
                return this.waitOrSkip("Cannot find block!\nor missing inventory\non top or below");
            }
            FakePlayer fakePlayer = this.getHarvester();
            IBlockState newState = BlockTools.placeStackAt((EntityPlayer)fakePlayer, (ItemStack)stack, (World)this.func_145831_w(), (BlockPos)srcPos, (IBlockState)pickState);
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)item.peek())) {
                if (!stack.func_190926_b()) {
                    if (!(stack = item.takeAndReplace(stack)).func_190926_b() && !(stack = this.insertItem(stack)).func_190926_b()) {
                        this.func_145831_w().func_72838_d((Entity)new EntityItem(this.func_145831_w(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), stack));
                    }
                } else {
                    item.take();
                }
            }
            if (!this.silent) {
                SoundTools.playSound((World)this.func_145831_w(), (SoundEvent)newState.func_177230_c().getSoundType(newState, this.func_145831_w(), srcPos, (Entity)fakePlayer).func_185841_e(), (double)srcPos.func_177958_n(), (double)srcPos.func_177956_o(), (double)srcPos.func_177952_p(), (double)1.0, (double)1.0);
            }
            this.consumeEnergy(rfNeeded);
        }
        return this.skip();
    }

    private Set<Block> getCachedVoidableBlocks() {
        if (this.cachedVoidableBlocks == null) {
            ItemStack card = this.inventoryHelper.getStackInSlot(0);
            this.cachedVoidableBlocks = !card.func_190926_b() && card.func_77973_b() == BuilderSetup.shapeCardItem ? ShapeCardItem.getVoidedBlocks(card) : Collections.emptySet();
        }
        return this.cachedVoidableBlocks;
    }

    private void clearOrDirtBlock(int rfNeeded, BlockPos spos, IBlockState srcState, boolean clear) {
        TileEntity te;
        if (srcState.func_177230_c() instanceof BlockShulkerBox && (te = this.field_145850_b.func_175625_s(spos)) instanceof TileEntityShulkerBox) {
            ((TileEntityShulkerBox)te).func_174888_l();
        }
        if (clear) {
            this.func_145831_w().func_175698_g(spos);
        } else {
            this.func_145831_w().func_180501_a(spos, this.getReplacementBlock(), 2);
        }
        this.consumeEnergy(rfNeeded);
        if (!this.silent) {
            SoundTools.playSound((World)this.func_145831_w(), (SoundEvent)srcState.func_177230_c().getSoundType(srcState, this.func_145831_w(), spos, null).func_185845_c(), (double)spos.func_177958_n(), (double)spos.func_177956_o(), (double)spos.func_177952_p(), (double)1.0, (double)1.0);
        }
    }

    private IBlockState getReplacementBlock() {
        return BuilderConfiguration.getQuarryReplace();
    }

    public boolean silkQuarryBlock(int rfNeeded, BlockPos srcPos, IBlockState srcState, IBlockState pickState) {
        return this.commonQuarryBlock(true, rfNeeded, srcPos, srcState);
    }

    private void getFilterCache() {
        if (this.filterCache == null) {
            this.filterCache = StorageFilterItem.getCache(this.inventoryHelper.getStackInSlot(1));
        }
    }

    public static boolean allowedToBreak(IBlockState state, World world, BlockPos pos, EntityPlayer entityPlayer) {
        if (!state.func_177230_c().canEntityDestroy(state, (IBlockAccess)world, pos, (Entity)entityPlayer)) {
            return false;
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, entityPlayer);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    public boolean quarryBlock(int rfNeeded, BlockPos srcPos, IBlockState srcState, IBlockState pickState) {
        return this.commonQuarryBlock(false, rfNeeded, srcPos, srcState);
    }

    private boolean commonQuarryBlock(boolean silk, int rfNeeded, BlockPos srcPos, IBlockState srcState) {
        Block block = srcState.func_177230_c();
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        int sx = srcPos.func_177958_n();
        int sy = srcPos.func_177956_o();
        int sz = srcPos.func_177952_p();
        if (sx >= xCoord - 1 && sx <= xCoord + 1 && sy >= yCoord - 1 && sy <= yCoord + 1 && sz >= zCoord - 1 && sz <= zCoord + 1) {
            return this.skip();
        }
        if (BuilderTileEntity.isEmpty(srcState, block)) {
            return this.skip();
        }
        if (block.func_176195_g(srcState, this.func_145831_w(), srcPos) >= 0.0f) {
            boolean clear = this.getCardType().isClearing();
            if (!clear && srcState == this.getReplacementBlock()) {
                return this.skip();
            }
            if (!BuilderConfiguration.quarryTileEntities.get() && this.func_145831_w().func_175625_s(srcPos) != null) {
                return this.skip();
            }
            FakePlayer fakePlayer = this.getHarvester();
            if (BuilderTileEntity.allowedToBreak(srcState, this.func_145831_w(), srcPos, (EntityPlayer)fakePlayer)) {
                ItemStack filter = this.func_70301_a(1);
                if (!filter.func_190926_b()) {
                    boolean match;
                    this.getFilterCache();
                    if (this.filterCache != null && !(match = this.filterCache.match(block.func_185473_a(this.func_145831_w(), srcPos, srcState)))) {
                        this.consumeEnergy(Math.min(rfNeeded, BuilderConfiguration.builderRfPerSkipped.get()));
                        return this.skip();
                    }
                }
                if (!this.getCachedVoidableBlocks().contains(block)) {
                    List<ItemStack> drops;
                    if (this.overflowItems != null) {
                        return this.waitOrSkip("Not enough room!\nor no usable storage\non top or below!");
                    }
                    if (silk && block.canSilkHarvest(this.func_145831_w(), srcPos, srcState, (EntityPlayer)fakePlayer)) {
                        ItemStack drop;
                        try {
                            drop = (ItemStack)ModSetup.Block_getSilkTouch.invoke((Object)block, srcState);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                        drops = new ArrayList();
                        if (!drop.func_190926_b()) {
                            drops.add(drop);
                        }
                        ForgeEventFactory.fireBlockHarvesting(drops, (World)this.func_145831_w(), (BlockPos)srcPos, (IBlockState)srcState, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)fakePlayer);
                    } else {
                        int fortune;
                        int n = fortune = this.getCardType().isFortune() ? 3 : 0;
                        if (block instanceof BlockShulkerBox) {
                            drops = new ArrayList();
                            TileEntity te = this.func_145831_w().func_175625_s(srcPos);
                            if (te instanceof TileEntityShulkerBox) {
                                TileEntityShulkerBox teShulkerBox = (TileEntityShulkerBox)te;
                                ItemStack stack = new ItemStack(Item.func_150898_a((Block)block));
                                teShulkerBox.func_190580_f(stack.func_190925_c("BlockEntityTag"));
                                if (teShulkerBox.func_145818_k_()) {
                                    stack.func_151001_c(teShulkerBox.func_70005_c_());
                                }
                                drops.add(stack);
                            }
                        } else {
                            drops = block.getDrops((IBlockAccess)this.func_145831_w(), srcPos, srcState, fortune);
                        }
                        ForgeEventFactory.fireBlockHarvesting(drops, (World)this.func_145831_w(), (BlockPos)srcPos, (IBlockState)srcState, (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)fakePlayer);
                    }
                    if (this.checkValidItems(block, drops) && !this.insertItems(drops)) {
                        this.overflowItems = drops;
                        this.clearOrDirtBlock(rfNeeded, srcPos, srcState, clear);
                        return this.waitOrSkip("Not enough room!\nor no usable storage\non top or below!");
                    }
                }
                this.clearOrDirtBlock(rfNeeded, srcPos, srcState, clear);
            }
        }
        return silk ? this.skip() : false;
    }

    private static boolean isFluidBlock(Block block) {
        return block instanceof BlockLiquid || block instanceof BlockFluidBase;
    }

    private static int getFluidLevel(IBlockState srcState) {
        if (srcState.func_177230_c() instanceof BlockLiquid) {
            return (Integer)srcState.func_177229_b((IProperty)BlockLiquid.field_176367_b);
        }
        if (srcState.func_177230_c() instanceof BlockFluidBase) {
            return (Integer)srcState.func_177229_b((IProperty)BlockFluidBase.LEVEL);
        }
        return -1;
    }

    public boolean placeLiquidBlock(int rfNeeded, BlockPos srcPos, IBlockState srcState, IBlockState pickState) {
        if (BuilderTileEntity.isEmptyOrReplacable(this.func_145831_w(), srcPos)) {
            FluidStack stack = this.consumeLiquid(this.func_145831_w(), srcPos);
            if (stack == null) {
                return this.waitOrSkip("Cannot find liquid!\nor no usable tank\nabove or below");
            }
            Fluid fluid = stack.getFluid();
            if (fluid.doesVaporize(stack) && this.func_145831_w().field_73011_w.func_177500_n()) {
                fluid.vaporize(null, this.func_145831_w(), srcPos, stack);
            } else {
                Block block = fluid.getBlock();
                FakePlayer fakePlayer = this.getHarvester();
                this.func_145831_w().func_180501_a(srcPos, block.func_176223_P(), 11);
                if (!this.silent) {
                    SoundTools.playSound((World)this.func_145831_w(), (SoundEvent)block.getSoundType(block.func_176223_P(), this.func_145831_w(), srcPos, (Entity)fakePlayer).func_185841_e(), (double)srcPos.func_177958_n(), (double)srcPos.func_177956_o(), (double)srcPos.func_177952_p(), (double)1.0, (double)1.0);
                }
            }
            this.consumeEnergy(rfNeeded);
        }
        return this.skip();
    }

    public boolean pumpBlock(int rfNeeded, BlockPos srcPos, IBlockState srcState, IBlockState pickState) {
        Block block = srcState.func_177230_c();
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
        if (fluid == null) {
            return this.skip();
        }
        if (!BuilderTileEntity.isFluidBlock(block)) {
            return this.skip();
        }
        if (BuilderTileEntity.getFluidLevel(srcState) != 0) {
            return this.skip();
        }
        if (block.func_176195_g(srcState, this.func_145831_w(), srcPos) >= 0.0f) {
            FakePlayer fakePlayer = this.getHarvester();
            if (BuilderTileEntity.allowedToBreak(srcState, this.func_145831_w(), srcPos, (EntityPlayer)fakePlayer)) {
                if (this.checkAndInsertFluids(fluid)) {
                    this.consumeEnergy(rfNeeded);
                    boolean clear = this.getCardType().isClearing();
                    if (clear) {
                        this.func_145831_w().func_175698_g(srcPos);
                    } else {
                        this.func_145831_w().func_180501_a(srcPos, this.getReplacementBlock(), 2);
                    }
                    if (!this.silent) {
                        SoundTools.playSound((World)this.func_145831_w(), (SoundEvent)block.getSoundType(srcState, this.func_145831_w(), srcPos, (Entity)fakePlayer).func_185845_c(), (double)srcPos.func_177958_n(), (double)srcPos.func_177956_o(), (double)srcPos.func_177952_p(), (double)1.0, (double)1.0);
                    }
                    return this.skip();
                }
                return this.waitOrSkip("No room for liquid\nor no usable tank\nabove or below!");
            }
        }
        return this.skip();
    }

    public boolean voidBlock(int rfNeeded, BlockPos srcPos, IBlockState srcState, IBlockState pickState) {
        Block block = srcState.func_177230_c();
        int xCoord = this.func_174877_v().func_177958_n();
        int yCoord = this.func_174877_v().func_177956_o();
        int zCoord = this.func_174877_v().func_177952_p();
        int sx = srcPos.func_177958_n();
        int sy = srcPos.func_177956_o();
        int sz = srcPos.func_177952_p();
        if (sx >= xCoord - 1 && sx <= xCoord + 1 && sy >= yCoord - 1 && sy <= yCoord + 1 && sz >= zCoord - 1 && sz <= zCoord + 1) {
            return this.skip();
        }
        FakePlayer fakePlayer = this.getHarvester();
        if (BuilderTileEntity.allowedToBreak(srcState, this.func_145831_w(), srcPos, (EntityPlayer)fakePlayer) && block.func_176195_g(srcState, this.func_145831_w(), srcPos) >= 0.0f) {
            ItemStack filter = this.func_70301_a(1);
            if (!filter.func_190926_b()) {
                boolean match;
                this.getFilterCache();
                if (this.filterCache != null && !(match = this.filterCache.match(block.func_185473_a(this.func_145831_w(), srcPos, srcState)))) {
                    this.consumeEnergy(Math.min(rfNeeded, BuilderConfiguration.builderRfPerSkipped.get()));
                    return this.skip();
                }
            }
            if (!this.silent) {
                SoundTools.playSound((World)this.func_145831_w(), (SoundEvent)block.getSoundType(srcState, this.func_145831_w(), srcPos, (Entity)fakePlayer).func_185845_c(), (double)sx, (double)sy, (double)sz, (double)1.0, (double)1.0);
            }
            this.func_145831_w().func_175698_g(srcPos);
            this.consumeEnergy(rfNeeded);
        }
        return this.skip();
    }

    private void handleBlock(World world) {
        BlockPos srcPos = this.scan;
        BlockPos destPos = this.sourceToDest(this.scan);
        int x = this.scan.func_177958_n();
        int y = this.scan.func_177956_o();
        int z = this.scan.func_177952_p();
        int destX = destPos.func_177958_n();
        int destY = destPos.func_177956_o();
        int destZ = destPos.func_177952_p();
        switch (this.mode) {
            case 0: {
                this.copyBlock(world, srcPos, this.func_145831_w(), destPos);
                break;
            }
            case 1: {
                if (this.entityMode) {
                    this.moveEntities(world, x, y, z, this.func_145831_w(), destX, destY, destZ);
                }
                this.moveBlock(world, srcPos, this.func_145831_w(), destPos, this.rotate);
                break;
            }
            case 3: {
                if (this.entityMode) {
                    this.moveEntities(this.func_145831_w(), destX, destY, destZ, world, x, y, z);
                }
                this.moveBlock(this.func_145831_w(), destPos, world, srcPos, this.oppositeRotate());
                break;
            }
            case 2: {
                if (this.entityMode) {
                    this.swapEntities(world, x, y, z, this.func_145831_w(), destX, destY, destZ);
                }
                this.swapBlock(world, srcPos, this.func_145831_w(), destPos);
            }
        }
        this.nextLocation();
    }

    private TakeableItem findBlockTakeableItem(IItemHandler inventory, World srcWorld, BlockPos srcPos, IBlockState state) {
        if (state == null) {
            ArrayList<Integer> slots = new ArrayList<Integer>();
            for (int i = 0; i < inventory.getSlots(); ++i) {
                if (!this.isPlacable(inventory.getStackInSlot(i))) continue;
                slots.add(i);
            }
            if (!slots.isEmpty()) {
                return new TakeableItem(inventory, (int)((Integer)slots.get(random.nextInt(slots.size()))));
            }
        } else {
            Block block = state.func_177230_c();
            ItemStack srcItem = block.func_185473_a(srcWorld, srcPos, state);
            if (this.isPlacable(srcItem)) {
                for (int i = 0; i < inventory.getSlots(); ++i) {
                    ItemStack stack = inventory.getStackInSlot(i);
                    if (stack.func_190926_b() || !stack.func_77969_a(srcItem)) continue;
                    return new TakeableItem(inventory, i);
                }
            }
        }
        return TakeableItem.EMPTY;
    }

    private boolean isPlacable(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        return item instanceof ItemBlock || item instanceof ItemSkull || item instanceof ItemBlockSpecial || item instanceof IPlantable || item instanceof ItemRedstone;
    }

    private TakeableItem findBlockTakeableItem(IInventory inventory, World srcWorld, BlockPos srcPos, IBlockState state) {
        if (state == null) {
            ArrayList<Integer> slots = new ArrayList<Integer>();
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                if (!this.isPlacable(inventory.func_70301_a(i))) continue;
                slots.add(i);
            }
            if (!slots.isEmpty()) {
                return new TakeableItem(inventory, (int)((Integer)slots.get(random.nextInt(slots.size()))));
            }
        } else {
            Block block = state.func_177230_c();
            ItemStack srcItem = block.func_185473_a(srcWorld, srcPos, state);
            if (this.isPlacable(srcItem)) {
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    ItemStack stack = inventory.func_70301_a(i);
                    if (stack.func_190926_b() || !stack.func_77969_a(srcItem)) continue;
                    return new TakeableItem(inventory, i);
                }
            }
        }
        return TakeableItem.EMPTY;
    }

    private boolean checkValidItems(Block block, List<ItemStack> items) {
        for (ItemStack stack : items) {
            if (stack.func_190926_b() || stack.func_77973_b() != null) continue;
            Logging.logError((String)("Builder tried to quarry " + block.getRegistryName().toString() + " and it returned null item!"));
            Broadcaster.broadcast((World)this.func_145831_w(), (int)this.field_174879_c.func_177958_n(), (int)this.field_174879_c.func_177956_o(), (int)this.field_174879_c.func_177952_p(), (String)("Builder tried to quarry " + block.getRegistryName().toString() + " and it returned null item!\nPlease report to mod author!"), (float)10.0f);
            return false;
        }
        return true;
    }

    private boolean checkAndInsertFluids(Fluid fluid) {
        if (this.checkFluidTank(fluid, this.func_174877_v().func_177984_a(), EnumFacing.DOWN)) {
            return true;
        }
        return this.checkFluidTank(fluid, this.func_174877_v().func_177977_b(), EnumFacing.UP);
    }

    private boolean checkFluidTank(Fluid fluid, BlockPos up, EnumFacing side) {
        FluidStack fluidStack;
        IFluidHandler handler;
        int amount;
        TileEntity te = this.func_145831_w().func_175625_s(up);
        if (te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side) && (amount = (handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)).fill(fluidStack = new FluidStack(fluid, 1000), false)) == 1000) {
            handler.fill(fluidStack, true);
            return true;
        }
        return false;
    }

    private boolean insertItems(List<ItemStack> items) {
        TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177984_a());
        boolean ok = InventoryHelper.insertItemsAtomic(items, (TileEntity)te, (EnumFacing)EnumFacing.DOWN);
        if (!ok) {
            te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177977_b());
            ok = InventoryHelper.insertItemsAtomic(items, (TileEntity)te, (EnumFacing)EnumFacing.UP);
        }
        return ok;
    }

    private ItemStack insertItem(ItemStack s) {
        s = InventoryHelper.insertItem((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (EnumFacing)EnumFacing.UP, (ItemStack)s);
        if (!s.func_190926_b()) {
            s = InventoryHelper.insertItem((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (EnumFacing)EnumFacing.DOWN, (ItemStack)s);
        }
        return s;
    }

    private TakeableItem createTakeableItem(EnumFacing direction, World srcWorld, BlockPos srcPos, IBlockState state) {
        TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(direction));
        if (te != null) {
            if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d())) {
                IItemHandler capability = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d());
                return this.findBlockTakeableItem(capability, srcWorld, srcPos, state);
            }
            if (te instanceof IInventory) {
                return this.findBlockTakeableItem((IInventory)te, srcWorld, srcPos, state);
            }
        }
        return TakeableItem.EMPTY;
    }

    private FluidStack consumeLiquid(World srcWorld, BlockPos srcPos) {
        FluidStack b = this.consumeLiquid(EnumFacing.UP, srcWorld, srcPos);
        if (b == null) {
            b = this.consumeLiquid(EnumFacing.DOWN, srcWorld, srcPos);
        }
        return b;
    }

    private FluidStack consumeLiquid(EnumFacing direction, World srcWorld, BlockPos srcPos) {
        TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(direction));
        if (te != null) {
            if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.func_176734_d())) {
                IFluidHandler capability = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction.func_176734_d());
                return this.findAndConsumeLiquid(capability, srcWorld, srcPos);
            }
            if (te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
                IFluidHandler capability = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                return this.findAndConsumeLiquid(capability, srcWorld, srcPos);
            }
        }
        return null;
    }

    private FluidStack findAndConsumeLiquid(IFluidHandler tank, World srcWorld, BlockPos srcPos) {
        for (IFluidTankProperties properties : tank.getTankProperties()) {
            FluidStack contents = properties.getContents();
            if (contents == null || contents.getFluid() == null || contents.amount < 1000) continue;
            FluidStack drained = tank.drain(new FluidStack(contents.getFluid(), 1000, contents.tag), true);
            return drained;
        }
        return null;
    }

    private TakeableItem createTakeableItem(World srcWorld, BlockPos srcPos, IBlockState state) {
        TakeableItem b = this.createTakeableItem(EnumFacing.UP, srcWorld, srcPos, state);
        if (b.peek().func_190926_b()) {
            b = this.createTakeableItem(EnumFacing.DOWN, srcWorld, srcPos, state);
        }
        return b;
    }

    public static BuilderSetup.BlockInformation getBlockInformation(EntityPlayer fakePlayer, World world, BlockPos pos, Block block, TileEntity tileEntity) {
        IBlockState state = world.func_180495_p(pos);
        if (BuilderTileEntity.isEmpty(state, block)) {
            return BuilderSetup.BlockInformation.FREE;
        }
        if (!BuilderTileEntity.allowedToBreak(state, world, pos, fakePlayer)) {
            return BuilderSetup.BlockInformation.INVALID;
        }
        BuilderSetup.BlockInformation blockInformation = BuilderSetup.getBlockInformation(block);
        if (tileEntity != null) {
            switch ((BuilderTileEntityMode)((Object)BuilderConfiguration.teMode.get())) {
                case MOVE_FORBIDDEN: {
                    return BuilderSetup.BlockInformation.INVALID;
                }
                case MOVE_WHITELIST: {
                    if (blockInformation != null && blockInformation.getBlockLevel() != 2) break;
                    return BuilderSetup.BlockInformation.INVALID;
                }
                case MOVE_BLACKLIST: {
                    if (blockInformation == null || blockInformation.getBlockLevel() != 2) break;
                    return BuilderSetup.BlockInformation.INVALID;
                }
            }
        }
        if (blockInformation != null) {
            return blockInformation;
        }
        return BuilderSetup.BlockInformation.OK;
    }

    private int isMovable(World world, BlockPos pos, Block block, TileEntity tileEntity) {
        return BuilderTileEntity.getBlockInformation((EntityPlayer)this.getHarvester(), world, pos, block, tileEntity).getBlockLevel();
    }

    public static boolean isEmptyOrReplacable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.func_176200_f((IBlockAccess)world, pos)) {
            return true;
        }
        return BuilderTileEntity.isEmpty(state, block);
    }

    public static boolean isEmpty(IBlockState state, Block block) {
        if (block == null) {
            return true;
        }
        if (block.func_149688_o(state) == Material.field_151579_a) {
            return true;
        }
        return block == BuilderSetup.supportBlock;
    }

    private void clearBlock(World world, BlockPos pos) {
        if (this.supportMode) {
            world.func_180501_a(pos, BuilderSetup.supportBlock.func_176223_P(), 3);
        } else {
            world.func_175698_g(pos);
        }
    }

    private int oppositeRotate() {
        switch (this.rotate) {
            case 1: {
                return 3;
            }
            case 3: {
                return 1;
            }
        }
        return this.rotate;
    }

    private void copyBlock(World srcWorld, BlockPos srcPos, World destWorld, BlockPos destPos) {
        long rf = this.getStoredPower();
        int rfNeeded = (int)((double)BuilderConfiguration.builderRfPerOperation.get() * this.getDimensionCostFactor(srcWorld, destWorld) * (double)(4.0f - this.getInfusedFactor()) / 4.0);
        if ((long)rfNeeded > rf) {
            return;
        }
        if (BuilderTileEntity.isEmptyOrReplacable(destWorld, destPos)) {
            if (srcWorld.func_175623_d(srcPos)) {
                return;
            }
            IBlockState srcState = srcWorld.func_180495_p(srcPos);
            TakeableItem takeableItem = this.createTakeableItem(srcWorld, srcPos, srcState);
            ItemStack consumedStack = takeableItem.peek();
            if (consumedStack.func_190926_b()) {
                return;
            }
            FakePlayer fakePlayer = this.getHarvester();
            IBlockState newState = BlockTools.placeStackAt((EntityPlayer)fakePlayer, (ItemStack)consumedStack, (World)destWorld, (BlockPos)destPos, (IBlockState)srcState);
            destWorld.func_180501_a(destPos, newState, 3);
            if (!ItemStack.func_77989_b((ItemStack)consumedStack, (ItemStack)takeableItem.peek())) {
                if (!consumedStack.func_190926_b()) {
                    if (!(consumedStack = takeableItem.takeAndReplace(consumedStack)).func_190926_b() && !(consumedStack = this.insertItem(consumedStack)).func_190926_b()) {
                        this.func_145831_w().func_72838_d((Entity)new EntityItem(this.func_145831_w(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), consumedStack));
                    }
                } else {
                    takeableItem.take();
                }
            }
            if (!this.silent) {
                SoundTools.playSound((World)destWorld, (SoundEvent)newState.func_177230_c().getSoundType(newState, destWorld, destPos, (Entity)fakePlayer).func_185841_e(), (double)destPos.func_177958_n(), (double)destPos.func_177956_o(), (double)destPos.func_177952_p(), (double)1.0, (double)1.0);
            }
            this.consumeEnergy(rfNeeded);
        }
    }

    private double getDimensionCostFactor(World world, World destWorld) {
        return destWorld.field_73011_w.getDimension() == world.field_73011_w.getDimension() ? 1.0 : BuilderConfiguration.dimensionCostFactor.get();
    }

    private boolean consumeEntityEnergy(int rfNeeded, int rfNeededPlayer, Entity entity) {
        long rf;
        int rfn = entity instanceof EntityPlayer ? rfNeededPlayer : rfNeeded;
        if ((long)rfn > (rf = this.getStoredPower())) {
            return true;
        }
        this.consumeEnergy(rfn);
        return false;
    }

    private void moveEntities(World world, int x, int y, int z, World destWorld, int destX, int destY, int destZ) {
        int rfNeeded = (int)((double)BuilderConfiguration.builderRfPerEntity.get() * this.getDimensionCostFactor(world, destWorld) * (double)(4.0f - this.getInfusedFactor()) / 4.0);
        int rfNeededPlayer = (int)((double)BuilderConfiguration.builderRfPerPlayer.get() * this.getDimensionCostFactor(world, destWorld) * (double)(4.0f - this.getInfusedFactor()) / 4.0);
        List entities = world.func_72839_b(null, new AxisAlignedBB((double)x - 0.1, (double)y - 0.1, (double)z - 0.1, (double)x + 1.1, (double)y + 1.1, (double)z + 1.1));
        for (Entity entity : entities) {
            if (this.consumeEntityEnergy(rfNeeded, rfNeededPlayer, entity)) {
                return;
            }
            double newX = (double)destX + (entity.field_70165_t - (double)x);
            double newY = (double)destY + (entity.field_70163_u - (double)y);
            double newZ = (double)destZ + (entity.field_70161_v - (double)z);
            this.teleportEntity(world, destWorld, entity, newX, newY, newZ);
        }
    }

    private void swapEntities(World world, int x, int y, int z, World destWorld, int destX, int destY, int destZ) {
        double newZ;
        double newY;
        double newX;
        int rfNeeded = (int)((double)BuilderConfiguration.builderRfPerEntity.get() * this.getDimensionCostFactor(world, destWorld) * (double)(4.0f - this.getInfusedFactor()) / 4.0);
        int rfNeededPlayer = (int)((double)BuilderConfiguration.builderRfPerPlayer.get() * this.getDimensionCostFactor(world, destWorld) * (double)(4.0f - this.getInfusedFactor()) / 4.0);
        List entitiesSrc = world.func_72839_b(null, new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)));
        List entitiesDst = destWorld.func_72839_b(null, new AxisAlignedBB((double)destX, (double)destY, (double)destZ, (double)(destX + 1), (double)(destY + 1), (double)(destZ + 1)));
        for (Entity entity : entitiesSrc) {
            if (!this.isEntityInBlock(x, y, z, entity)) continue;
            if (this.consumeEntityEnergy(rfNeeded, rfNeededPlayer, entity)) {
                return;
            }
            newX = (double)destX + (entity.field_70165_t - (double)x);
            newY = (double)destY + (entity.field_70163_u - (double)y);
            newZ = (double)destZ + (entity.field_70161_v - (double)z);
            this.teleportEntity(world, destWorld, entity, newX, newY, newZ);
        }
        for (Entity entity : entitiesDst) {
            if (!this.isEntityInBlock(destX, destY, destZ, entity)) continue;
            if (this.consumeEntityEnergy(rfNeeded, rfNeededPlayer, entity)) {
                return;
            }
            newX = (double)x + (entity.field_70165_t - (double)destX);
            newY = (double)y + (entity.field_70163_u - (double)destY);
            newZ = (double)z + (entity.field_70161_v - (double)destZ);
            this.teleportEntity(destWorld, world, entity, newX, newY, newZ);
        }
    }

    private void teleportEntity(World world, World destWorld, Entity entity, double newX, double newY, double newZ) {
        if (!TeleportationTools.allowTeleport(entity, world.field_73011_w.getDimension(), entity.func_180425_c(), destWorld.field_73011_w.getDimension(), new BlockPos(newX, newY, newZ))) {
            return;
        }
        mcjty.lib.varia.TeleportationTools.teleportEntity((Entity)entity, (World)destWorld, (double)newX, (double)newY, (double)newZ, null);
    }

    private boolean isEntityInBlock(int x, int y, int z, Entity entity) {
        return entity.field_70165_t >= (double)x && entity.field_70165_t < (double)(x + 1) && entity.field_70163_u >= (double)y && entity.field_70163_u < (double)(y + 1) && entity.field_70161_v >= (double)z && entity.field_70161_v < (double)(z + 1);
    }

    private void moveBlock(World srcWorld, BlockPos srcPos, World destWorld, BlockPos destPos, int rotMode) {
        Block oldDestBlock;
        IBlockState oldDestState = destWorld.func_180495_p(destPos);
        if (BuilderTileEntity.isEmpty(oldDestState, oldDestBlock = oldDestState.func_177230_c())) {
            Block srcBlock;
            IBlockState srcState = srcWorld.func_180495_p(srcPos);
            if (BuilderTileEntity.isEmpty(srcState, srcBlock = srcState.func_177230_c())) {
                return;
            }
            TileEntity srcTileEntity = srcWorld.func_175625_s(srcPos);
            BuilderSetup.BlockInformation srcInformation = BuilderTileEntity.getBlockInformation((EntityPlayer)this.getHarvester(), srcWorld, srcPos, srcBlock, srcTileEntity);
            if (srcInformation.getBlockLevel() == 2) {
                return;
            }
            long rf = this.getStoredPower();
            int rfNeeded = (int)((double)BuilderConfiguration.builderRfPerOperation.get() * this.getDimensionCostFactor(srcWorld, destWorld) * srcInformation.getCostFactor() * (double)(4.0f - this.getInfusedFactor()) / 4.0);
            if ((long)rfNeeded > rf) {
                return;
            }
            this.consumeEnergy(rfNeeded);
            NBTTagCompound tc = null;
            if (srcTileEntity != null) {
                tc = new NBTTagCompound();
                srcTileEntity.func_189515_b(tc);
                srcWorld.func_175713_t(srcPos);
            }
            this.clearBlock(srcWorld, srcPos);
            destWorld.func_180501_a(destPos, srcState, 3);
            if (srcTileEntity != null && tc != null) {
                this.setTileEntityNBT(destWorld, tc, destPos, srcState);
            }
            if (!this.silent) {
                SoundTools.playSound((World)srcWorld, (SoundEvent)srcBlock.getSoundType(srcState, srcWorld, srcPos, null).func_185845_c(), (double)srcPos.func_177958_n(), (double)srcPos.func_177956_o(), (double)srcPos.func_177952_p(), (double)1.0, (double)1.0);
                SoundTools.playSound((World)destWorld, (SoundEvent)srcBlock.getSoundType(srcState, destWorld, destPos, null).func_185841_e(), (double)destPos.func_177958_n(), (double)destPos.func_177956_o(), (double)destPos.func_177952_p(), (double)1.0, (double)1.0);
            }
        }
    }

    private void setTileEntityNBT(World destWorld, NBTTagCompound tc, BlockPos destpos, IBlockState newDestState) {
        tc.func_74768_a("x", destpos.func_177958_n());
        tc.func_74768_a("y", destpos.func_177956_o());
        tc.func_74768_a("z", destpos.func_177952_p());
        TileEntity tileEntity = TileEntity.func_190200_a((World)destWorld, (NBTTagCompound)tc);
        if (tileEntity != null) {
            destWorld.func_175726_f(destpos).func_150813_a(tileEntity);
            tileEntity.func_70296_d();
            destWorld.func_184138_a(destpos, newDestState, newDestState, 3);
        }
    }

    private void swapBlock(World srcWorld, BlockPos srcPos, World destWorld, BlockPos dstPos) {
        IBlockState oldSrcState = srcWorld.func_180495_p(srcPos);
        Block srcBlock = oldSrcState.func_177230_c();
        TileEntity srcTileEntity = srcWorld.func_175625_s(srcPos);
        IBlockState oldDstState = destWorld.func_180495_p(dstPos);
        Block dstBlock = oldDstState.func_177230_c();
        TileEntity dstTileEntity = destWorld.func_175625_s(dstPos);
        if (BuilderTileEntity.isEmpty(oldSrcState, srcBlock) && BuilderTileEntity.isEmpty(oldDstState, dstBlock)) {
            return;
        }
        BuilderSetup.BlockInformation srcInformation = BuilderTileEntity.getBlockInformation((EntityPlayer)this.getHarvester(), srcWorld, srcPos, srcBlock, srcTileEntity);
        if (srcInformation.getBlockLevel() == 2) {
            return;
        }
        BuilderSetup.BlockInformation dstInformation = BuilderTileEntity.getBlockInformation((EntityPlayer)this.getHarvester(), destWorld, dstPos, dstBlock, dstTileEntity);
        if (dstInformation.getBlockLevel() == 2) {
            return;
        }
        long rf = this.getStoredPower();
        int rfNeeded = (int)((double)BuilderConfiguration.builderRfPerOperation.get() * this.getDimensionCostFactor(srcWorld, destWorld) * srcInformation.getCostFactor() * (double)(4.0f - this.getInfusedFactor()) / 4.0);
        if ((long)(rfNeeded += (int)((double)BuilderConfiguration.builderRfPerOperation.get() * this.getDimensionCostFactor(srcWorld, destWorld) * dstInformation.getCostFactor() * (double)(4.0f - this.getInfusedFactor()) / 4.0)) > rf) {
            return;
        }
        this.consumeEnergy(rfNeeded);
        srcWorld.func_175713_t(srcPos);
        srcWorld.func_175698_g(srcPos);
        destWorld.func_175713_t(dstPos);
        destWorld.func_175698_g(dstPos);
        IBlockState newDstState = oldSrcState;
        destWorld.func_180501_a(dstPos, newDstState, 3);
        if (srcTileEntity != null) {
            srcTileEntity.func_145829_t();
            destWorld.func_175690_a(dstPos, srcTileEntity);
            srcTileEntity.func_70296_d();
            destWorld.func_184138_a(dstPos, newDstState, newDstState, 3);
        }
        IBlockState newSrcState = oldDstState;
        srcWorld.func_180501_a(srcPos, newSrcState, 3);
        if (dstTileEntity != null) {
            dstTileEntity.func_145829_t();
            srcWorld.func_175690_a(srcPos, dstTileEntity);
            dstTileEntity.func_70296_d();
            srcWorld.func_184138_a(srcPos, newSrcState, newSrcState, 3);
        }
        if (!this.silent) {
            if (!BuilderTileEntity.isEmpty(oldSrcState, srcBlock)) {
                SoundTools.playSound((World)srcWorld, (SoundEvent)srcBlock.getSoundType(oldSrcState, srcWorld, srcPos, null).func_185845_c(), (double)srcPos.func_177958_n(), (double)srcPos.func_177956_o(), (double)srcPos.func_177952_p(), (double)1.0, (double)1.0);
                SoundTools.playSound((World)destWorld, (SoundEvent)srcBlock.getSoundType(oldSrcState, destWorld, dstPos, null).func_185841_e(), (double)dstPos.func_177958_n(), (double)dstPos.func_177956_o(), (double)dstPos.func_177952_p(), (double)1.0, (double)1.0);
            }
            if (!BuilderTileEntity.isEmpty(oldDstState, dstBlock)) {
                SoundTools.playSound((World)destWorld, (SoundEvent)dstBlock.getSoundType(oldDstState, destWorld, dstPos, null).func_185845_c(), (double)dstPos.func_177958_n(), (double)dstPos.func_177956_o(), (double)dstPos.func_177952_p(), (double)1.0, (double)1.0);
                SoundTools.playSound((World)srcWorld, (SoundEvent)dstBlock.getSoundType(oldDstState, srcWorld, srcPos, null).func_185841_e(), (double)srcPos.func_177958_n(), (double)srcPos.func_177956_o(), (double)srcPos.func_177952_p(), (double)1.0, (double)1.0);
            }
        }
    }

    private BlockPos sourceToDest(BlockPos source) {
        return this.rotate(source).func_177982_a(this.projDx, this.projDy, this.projDz);
    }

    private BlockPos rotate(BlockPos c) {
        switch (this.rotate) {
            case 0: {
                return c;
            }
            case 1: {
                return new BlockPos(-c.func_177952_p(), c.func_177956_o(), c.func_177958_n());
            }
            case 2: {
                return new BlockPos(-c.func_177958_n(), c.func_177956_o(), -c.func_177952_p());
            }
            case 3: {
                return new BlockPos(c.func_177952_p(), c.func_177956_o(), -c.func_177958_n());
            }
        }
        return c;
    }

    private void sourceToDest(BlockPos source, BlockPos.MutableBlockPos dest) {
        this.rotate(source, dest);
        dest.func_181079_c(dest.func_177958_n() + this.projDx, dest.func_177956_o() + this.projDy, dest.func_177952_p() + this.projDz);
    }

    private void rotate(BlockPos c, BlockPos.MutableBlockPos dest) {
        switch (this.rotate) {
            case 0: {
                dest.func_189533_g((Vec3i)c);
                break;
            }
            case 1: {
                dest.func_181079_c(-c.func_177952_p(), c.func_177956_o(), c.func_177958_n());
                break;
            }
            case 2: {
                dest.func_181079_c(-c.func_177958_n(), c.func_177956_o(), -c.func_177952_p());
                break;
            }
            case 3: {
                dest.func_181079_c(c.func_177952_p(), c.func_177956_o(), -c.func_177958_n());
            }
        }
    }

    private void restartScan() {
        this.lastError = null;
        this.chunkUnload();
        if (this.loopMode || this.isMachineEnabled() && this.scan == null) {
            if (this.getCardType() == ShapeCardType.CARD_SPACE) {
                this.calculateBox();
                this.scan = this.minBox;
            } else if (this.getCardType() != ShapeCardType.CARD_UNKNOWN) {
                this.calculateBoxShaped();
                this.scan = new BlockPos(this.minBox.func_177958_n(), this.maxBox.func_177956_o(), this.minBox.func_177952_p());
            }
            this.cachedBlocks = null;
            this.cachedChunk = null;
            this.cachedVoidableBlocks = null;
        } else {
            this.scan = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.chunkUnload();
    }

    private void chunkUnload() {
        if (this.forcedChunk != null && this.ticket != null) {
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)this.forcedChunk);
            this.forcedChunk = null;
        }
    }

    private boolean chunkLoad(int x, int z) {
        int cx = x >> 4;
        int cz = z >> 4;
        if (WorldTools.chunkLoaded((World)this.func_145831_w(), (BlockPos)new BlockPos(x, 0, z))) {
            return true;
        }
        if (BuilderConfiguration.quarryChunkloads.get()) {
            ChunkPos pair;
            if (this.ticket == null) {
                this.ticket = ForgeChunkManager.requestTicket((Object)RFTools.instance, (World)this.func_145831_w(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
                if (this.ticket == null) {
                    return false;
                }
            }
            if ((pair = new ChunkPos(cx, cz)).equals((Object)this.forcedChunk)) {
                return true;
            }
            if (this.forcedChunk != null) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)this.forcedChunk);
            }
            this.forcedChunk = pair;
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkPos)this.forcedChunk);
            return true;
        }
        return false;
    }

    public static void setScanLocationClient(BlockPos tePos, BlockPos scanPos) {
        scanLocClient.put(tePos, (Pair<Long, BlockPos>)Pair.of((Object)System.currentTimeMillis(), (Object)scanPos));
    }

    public static Map<BlockPos, Pair<Long, BlockPos>> getScanLocClient() {
        if (scanLocClient.isEmpty()) {
            return scanLocClient;
        }
        HashMap<BlockPos, Pair<Long, BlockPos>> scans = new HashMap<BlockPos, Pair<Long, BlockPos>>();
        long time = System.currentTimeMillis();
        for (Map.Entry<BlockPos, Pair<Long, BlockPos>> entry : scanLocClient.entrySet()) {
            if ((Long)entry.getValue().getKey() + 10000L <= time) continue;
            scans.put(entry.getKey(), entry.getValue());
        }
        scanLocClient = scans;
        return scanLocClient;
    }

    private void nextLocation() {
        if (this.scan != null) {
            int x = this.scan.func_177958_n();
            int y = this.scan.func_177956_o();
            int z = this.scan.func_177952_p();
            if (this.getCardType() == ShapeCardType.CARD_SPACE) {
                this.nextLocationNormal(x, y, z);
            } else {
                this.nextLocationQuarry(x, y, z);
            }
        }
    }

    private void nextLocationQuarry(int x, int y, int z) {
        if (x >= this.maxBox.func_177958_n() || (x + 1) % 16 == 0) {
            if (z >= this.maxBox.func_177952_p() || (z + 1) % 16 == 0) {
                if (y <= this.minBox.func_177956_o()) {
                    if (x < this.maxBox.func_177958_n()) {
                        z = z >> 4 << 4;
                        y = this.maxBox.func_177956_o();
                        this.scan = new BlockPos(++x, y, z);
                    } else if (z < this.maxBox.func_177952_p()) {
                        x = this.minBox.func_177958_n();
                        y = this.maxBox.func_177956_o();
                        this.scan = new BlockPos(x, y, ++z);
                    } else {
                        this.restartScan();
                    }
                } else {
                    this.scan = new BlockPos(x >> 4 << 4, y - 1, z >> 4 << 4);
                }
            } else {
                this.scan = new BlockPos(x >> 4 << 4, y, z + 1);
            }
        } else {
            this.scan = new BlockPos(x + 1, y, z);
        }
    }

    private void nextLocationNormal(int x, int y, int z) {
        if (x >= this.maxBox.func_177958_n()) {
            if (z >= this.maxBox.func_177952_p()) {
                if (y >= this.maxBox.func_177956_o()) {
                    if (this.mode != 2 || this.isShapeCard()) {
                        this.restartScan();
                    } else {
                        this.scan = null;
                    }
                } else {
                    this.scan = new BlockPos(this.minBox.func_177958_n(), y + 1, this.minBox.func_177952_p());
                }
            } else {
                this.scan = new BlockPos(this.minBox.func_177958_n(), y, z + 1);
            }
        } else {
            this.scan = new BlockPos(x + 1, y, z);
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        return CONTAINER_FACTORY.getAccessibleSlots();
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return CONTAINER_FACTORY.isInputSlot(index);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return CONTAINER_FACTORY.isOutputSlot(index);
    }

    public ItemStack func_70298_a(int index, int amount) {
        if (index == 0 && !this.inventoryHelper.getStackInSlot(index).func_190926_b() && amount > 0) {
            this.refreshSettings();
        }
        if (index == 1) {
            this.filterCache = null;
        }
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index == 0 && (stack.func_190926_b() && !this.inventoryHelper.getStackInSlot(index).func_190926_b() || !stack.func_190926_b() && this.inventoryHelper.getStackInSlot(index).func_190926_b())) {
            this.refreshSettings();
        }
        if (index == 1) {
            this.filterCache = null;
        }
        this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
    }

    private void refreshSettings() {
        this.clearSupportBlocks();
        this.cachedBlocks = null;
        this.cachedChunk = null;
        this.cachedVoidableBlocks = null;
        this.boxValid = false;
        this.scan = null;
        this.cardType = ShapeCardType.CARD_UNKNOWN;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() == BuilderSetup.spaceChamberCardItem || stack.func_77973_b() == BuilderSetup.shapeCardItem;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (tagCompound.func_74764_b("overflowItems")) {
            NBTTagList overflowItemsNbt = tagCompound.func_150295_c("overflowItems", 10);
            this.overflowItems = new ArrayList<ItemStack>(overflowItemsNbt.func_74745_c());
            for (NBTBase overflowNbt : overflowItemsNbt) {
                this.overflowItems.add(new ItemStack((NBTTagCompound)overflowNbt));
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        if (this.overflowItems != null) {
            NBTTagList overflowItemsNbt = new NBTTagList();
            for (ItemStack overflow : this.overflowItems) {
                overflowItemsNbt.func_74742_a((NBTBase)overflow.func_77955_b(new NBTTagCompound()));
            }
            tagCompound.func_74782_a("overflowItems", (NBTBase)overflowItemsNbt);
        }
        return tagCompound;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        if (!tagCompound.func_74764_b("rsMode")) {
            this.rsMode = RedstoneMode.REDSTONE_ONREQUIRED;
        }
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.lastError = tagCompound.func_74764_b("lastError") ? tagCompound.func_74779_i("lastError") : null;
        this.mode = tagCompound.func_74762_e("mode");
        this.anchor = tagCompound.func_74762_e("anchor");
        this.rotate = tagCompound.func_74762_e("rotate");
        this.silent = tagCompound.func_74767_n("silent");
        this.supportMode = tagCompound.func_74767_n("support");
        this.entityMode = tagCompound.func_74767_n("entityMode");
        this.loopMode = tagCompound.func_74767_n("loopMode");
        this.waitMode = tagCompound.func_74764_b("waitMode") ? tagCompound.func_74767_n("waitMode") : true;
        this.hilightMode = tagCompound.func_74767_n("hilightMode");
        this.scan = BlockPosTools.readFromNBT((NBTTagCompound)tagCompound, (String)"scan");
        this.minBox = BlockPosTools.readFromNBT((NBTTagCompound)tagCompound, (String)"minBox");
        this.maxBox = BlockPosTools.readFromNBT((NBTTagCompound)tagCompound, (String)"maxBox");
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        if (this.lastError != null) {
            tagCompound.func_74778_a("lastError", this.lastError);
        }
        tagCompound.func_74768_a("mode", this.mode);
        tagCompound.func_74768_a("anchor", this.anchor);
        tagCompound.func_74768_a("rotate", this.rotate);
        tagCompound.func_74757_a("silent", this.silent);
        tagCompound.func_74757_a("support", this.supportMode);
        tagCompound.func_74757_a("entityMode", this.entityMode);
        tagCompound.func_74757_a("loopMode", this.loopMode);
        tagCompound.func_74757_a("waitMode", this.waitMode);
        tagCompound.func_74757_a("hilightMode", this.hilightMode);
        BlockPosTools.writeToNBT((NBTTagCompound)tagCompound, (String)"scan", (BlockPos)this.scan);
        BlockPosTools.writeToNBT((NBTTagCompound)tagCompound, (String)"minBox", (BlockPos)this.minBox);
        BlockPosTools.writeToNBT((NBTTagCompound)tagCompound, (String)"maxBox", (BlockPos)this.maxBox);
    }

    public void requestCurrentLevel() {
        this.requestDataFromServer("rftools", CMD_GETLEVEL, TypedMap.EMPTY);
    }

    public static int getCurrentLevelClientSide() {
        return currentLevel;
    }

    public int getCurrentLevel() {
        return this.scan == null ? -1 : this.scan.func_177956_o();
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_SETROTATE.equals(command)) {
            this.setRotate(Integer.parseInt((String)params.get(ChoiceLabel.PARAM_CHOICE)) / 90);
            return true;
        }
        if (CMD_SETANCHOR.equals(command)) {
            this.setAnchor((Integer)params.get(PARAM_ANCHOR_INDEX));
            return true;
        }
        if (CMD_SETMODE.equals(command)) {
            this.setMode((Integer)params.get(ChoiceLabel.PARAM_CHOICE_IDX));
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, TypedMap args, Type<T> type) {
        List rc = super.executeWithResultList(command, args, type);
        if (!rc.isEmpty()) {
            return rc;
        }
        if (PacketGetHudLog.CMD_GETHUDLOG.equals(command)) {
            return type.convert(this.getHudLog());
        }
        return rc;
    }

    public <T> boolean receiveListFromServer(String command, List<T> list, Type<T> type) {
        boolean rc = super.receiveListFromServer(command, list, type);
        if (rc) {
            return true;
        }
        if (PacketGetHudLog.CLIENTCMD_GETHUDLOG.equals(command)) {
            this.clientHudLog = Type.STRING.convert(list);
            return true;
        }
        return false;
    }

    public TypedMap executeWithResult(String command, TypedMap args) {
        TypedMap rc = super.executeWithResult(command, args);
        if (rc != null) {
            return rc;
        }
        if (CMD_GETLEVEL.equals(command)) {
            return TypedMap.builder().put(PARAM_LEVEL, (Object)(this.scan == null ? -1 : this.scan.func_177956_o())).build();
        }
        return null;
    }

    public boolean receiveDataFromServer(String command, @Nonnull TypedMap result) {
        boolean rc = super.receiveDataFromServer(command, result);
        if (rc) {
            return true;
        }
        if (CMD_GETLEVEL.equals(command)) {
            currentLevel = (Integer)result.get(PARAM_LEVEL);
            return true;
        }
        return false;
    }

    public void onBlockBreak(World world, BlockPos pos, IBlockState state) {
        if (this.hasSupportMode()) {
            this.clearSupportBlocks();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 2, 1));
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        int scan = this.getCurrentLevel();
        probeInfo.text(TextFormatting.GREEN + "Current level: " + (scan == -1 ? "not scanning" : Integer.valueOf(scan)));
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public void addWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.addWailaBody(itemStack, currenttip, accessor, config);
        if (System.currentTimeMillis() - lastTime > 250L) {
            lastTime = System.currentTimeMillis();
            this.requestCurrentLevel();
        }
        int scan = BuilderTileEntity.getCurrentLevelClientSide();
        currenttip.add(TextFormatting.GREEN + "Current level: " + (scan == -1 ? "not scanning" : Integer.valueOf(scan)));
    }

    public void rotateBlock(EnumFacing axis) {
        super.rotateBlock(axis);
        if (!this.field_145850_b.field_72995_K && this.hasSupportMode()) {
            this.clearSupportBlocks();
            this.resetBox();
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState metadata, int fortune) {
        super.getDrops(drops, world, pos, metadata, fortune);
        List<ItemStack> overflowItems = this.getOverflowItems();
        if (overflowItems != null) {
            drops.addAll(overflowItems);
        }
    }

    private static class TakeableItem {
        private final IItemHandler itemHandler;
        private final IInventory inventory;
        private final int slot;
        private final ItemStack peekStack;
        public static final TakeableItem EMPTY = new TakeableItem();

        private TakeableItem() {
            this.itemHandler = null;
            this.inventory = null;
            this.slot = -1;
            this.peekStack = ItemStack.field_190927_a;
        }

        public TakeableItem(IItemHandler itemHandler, int slot) {
            Validate.inclusiveBetween((long)0L, (long)(itemHandler.getSlots() - 1), (long)slot);
            this.itemHandler = itemHandler;
            this.inventory = null;
            this.slot = slot;
            this.peekStack = itemHandler.extractItem(slot, 1, true);
        }

        public TakeableItem(IInventory inventory, int slot) {
            Validate.inclusiveBetween((long)0L, (long)(inventory.func_70302_i_() - 1), (long)slot);
            this.itemHandler = null;
            this.inventory = inventory;
            this.slot = slot;
            this.peekStack = inventory.func_70301_a(slot).func_77946_l();
            this.peekStack.func_190920_e(1);
        }

        public ItemStack peek() {
            return this.peekStack.func_77946_l();
        }

        public void take() {
            if (this.itemHandler != null) {
                this.itemHandler.extractItem(this.slot, 1, false);
            } else if (this.slot != -1) {
                this.inventory.func_70298_a(this.slot, 1);
            }
        }

        public ItemStack takeAndReplace(ItemStack replacement) {
            if (this.itemHandler != null) {
                this.itemHandler.extractItem(this.slot, 1, false);
                return this.itemHandler.insertItem(this.slot, replacement, false);
            }
            if (this.slot != -1) {
                this.inventory.func_70298_a(this.slot, 1);
                if (this.inventory.func_94041_b(this.slot, replacement) && this.inventory.func_70301_a(this.slot).func_190926_b()) {
                    this.inventory.func_70299_a(this.slot, replacement);
                    return ItemStack.field_190927_a;
                }
            }
            return replacement;
        }
    }
}

