/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mcjty.lib.api.smartwrench.SmartWrench;
import mcjty.lib.api.smartwrench.SmartWrenchMode;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.WrenchChecker;
import mcjty.rftools.PlayerBuff;
import mcjty.rftools.TickOrderHandler;
import mcjty.rftools.blocks.blockprotector.BlockProtectorConfiguration;
import mcjty.rftools.blocks.blockprotector.BlockProtectors;
import mcjty.rftools.blocks.environmental.NoTeleportAreaManager;
import mcjty.rftools.blocks.environmental.PeacefulAreaManager;
import mcjty.rftools.blocks.screens.ScreenBlock;
import mcjty.rftools.blocks.screens.ScreenHitBlock;
import mcjty.rftools.blocks.screens.ScreenSetup;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportationTools;
import mcjty.rftools.items.smartwrench.SmartWrenchItem;
import mcjty.rftools.playerprops.BuffProperties;
import mcjty.rftools.playerprops.FavoriteDestinationsProperties;
import mcjty.rftools.playerprops.PlayerExtendedProperties;
import mcjty.rftools.playerprops.PropertiesDispatcher;
import mcjty.rftools.shapes.ShapeDataManagerServer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.tuple.Pair;

public class ForgeEventHandlers {
    private static List<Pair<TeleportDestination, EntityPlayer>> playersToTeleportHere = new ArrayList<Pair<TeleportDestination, EntityPlayer>>();

    public static void addPlayerToTeleportHere(TeleportDestination destination, EntityPlayer player) {
        playersToTeleportHere.add((Pair<TeleportDestination, EntityPlayer>)Pair.of((Object)destination, (Object)player));
    }

    private static void performDelayedTeleports() {
        if (!playersToTeleportHere.isEmpty()) {
            for (Pair<TeleportDestination, EntityPlayer> pair : playersToTeleportHere) {
                TeleportationTools.performTeleport((EntityPlayer)pair.getRight(), (TeleportDestination)pair.getLeft(), 0, 10, false);
            }
            playersToTeleportHere.clear();
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.world.provider.getDimension() == 0) {
            ForgeEventHandlers.performDelayedTeleports();
            ShapeDataManagerServer.handleWork();
        }
    }

    @SubscribeEvent
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        BuffProperties buffProperties;
        if (event.phase == TickEvent.Phase.START && !event.player.getEntityWorld().isRemote && (buffProperties = PlayerExtendedProperties.getBuffProperties(event.player)) != null) {
            buffProperties.tickBuffs((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer && !((Entity)event.getObject()).hasCapability(PlayerExtendedProperties.BUFF_CAPABILITY, null)) {
            event.addCapability(new ResourceLocation("rftools", "Properties"), (ICapabilityProvider)new PropertiesDispatcher());
        }
    }

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        double blockReachDistance;
        RayTraceResult rayTrace;
        if (event.getWorld().isRemote) {
            return;
        }
        EntityPlayer player = event.getEntityPlayer();
        ItemStack heldItem = player.getHeldItemMainhand();
        if ((heldItem.isEmpty() || !(heldItem.getItem() instanceof SmartWrench)) && (rayTrace = ForgeHooks.rayTraceEyes((EntityLivingBase)player, (double)((blockReachDistance = ((EntityPlayerMP)player).interactionManager.getBlockReachDistance()) + 1.0))) != null && rayTrace.typeOfHit == RayTraceResult.Type.BLOCK) {
            Block block = event.getWorld().getBlockState(rayTrace.getBlockPos()).getBlock();
            if (block instanceof ScreenBlock) {
                event.setCanceled(true);
                return;
            }
            if (block instanceof ScreenHitBlock) {
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteractEvent(PlayerInteractEvent event) {
        World world;
        ItemStack heldItem;
        EntityPlayer player = event.getEntityPlayer();
        if (event instanceof PlayerInteractEvent.LeftClickBlock) {
            this.checkCreativeClick(event);
        } else if (event instanceof PlayerInteractEvent.RightClickBlock && player.isSneaking() && ((heldItem = player.getHeldItemMainhand()).isEmpty() || !(heldItem.getItem() instanceof SmartWrench))) {
            world = event.getWorld();
            IBlockState state = world.getBlockState(event.getPos());
            Block block = state.getBlock();
            if (block instanceof ScreenBlock) {
                Vec3d vec = ((PlayerInteractEvent.RightClickBlock)event).getHitVec();
                ((ScreenBlock)block).activate(world, event.getPos(), state, player, event.getHand(), event.getFace(), (float)vec.x, (float)vec.y, (float)vec.z);
                ((PlayerInteractEvent.RightClickBlock)event).setUseItem(Event.Result.DENY);
                return;
            }
            if (block instanceof ScreenHitBlock) {
                Vec3d vec = ((PlayerInteractEvent.RightClickBlock)event).getHitVec();
                ((ScreenHitBlock)block).activate(world, event.getPos(), state, player, event.getHand(), event.getFace(), (float)vec.x, (float)vec.y, (float)vec.z);
                ((PlayerInteractEvent.RightClickBlock)event).setUseItem(Event.Result.DENY);
                return;
            }
        }
        heldItem = player.getHeldItem(event.getHand());
        if (heldItem.isEmpty() || heldItem.getItem() == null) {
            return;
        }
        if (BlockProtectorConfiguration.enabled.get() && player.isSneaking() && WrenchChecker.isAWrench((Item)heldItem.getItem())) {
            Collection<GlobalCoordinate> protectors;
            int z;
            int y;
            if (heldItem.getItem() instanceof SmartWrenchItem && SmartWrenchItem.getCurrentMode(heldItem) == SmartWrenchMode.MODE_SELECT) {
                return;
            }
            world = event.getWorld();
            int x = event.getPos().getX();
            if (BlockProtectors.checkHarvestProtection(x, y = event.getPos().getY(), z = event.getPos().getZ(), (IBlockAccess)world, protectors = BlockProtectors.getProtectors(world, x, y, z))) {
                event.setCanceled(true);
            }
        }
    }

    private void checkCreativeClick(PlayerInteractEvent event) {
        Block block;
        if (event.getEntityPlayer().isCreative() && ((block = event.getWorld().getBlockState(event.getPos()).getBlock()) == ScreenSetup.screenBlock || block == ScreenSetup.creativeScreenBlock || block == ScreenSetup.screenHitBlock) && !event.getEntityPlayer().isSneaking()) {
            if (event.getWorld().isRemote) {
                block.onBlockClicked(event.getWorld(), event.getPos(), event.getEntityPlayer());
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        EntityPlayer player;
        BuffProperties buffProperties;
        if (event.getEntityLiving() instanceof EntityPlayer && (buffProperties = PlayerExtendedProperties.getBuffProperties(player = (EntityPlayer)event.getEntityLiving())) != null) {
            if (buffProperties.hasBuff(PlayerBuff.BUFF_FEATHERFALLING)) {
                event.setDamageMultiplier(event.getDamageMultiplier() / 2.0f);
            }
            if (buffProperties.hasBuff(PlayerBuff.BUFF_FEATHERFALLINGPLUS)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onEntityTeleport(EnderTeleportEvent event) {
        BlockPos coordinate;
        World world = event.getEntity().getEntityWorld();
        int id = world.provider.getDimension();
        Entity entity = event.getEntity();
        if (NoTeleportAreaManager.isTeleportPrevented(entity, new GlobalCoordinate(coordinate = new BlockPos((int)entity.posX, (int)entity.posY, (int)entity.posZ), id))) {
            event.setCanceled(true);
        } else {
            coordinate = new BlockPos((int)event.getTargetX(), (int)event.getTargetY(), (int)event.getTargetZ());
            if (NoTeleportAreaManager.isTeleportPrevented(entity, new GlobalCoordinate(coordinate, id))) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onEntitySpawnEvent(LivingSpawnEvent.CheckSpawn event) {
        BlockPos coordinate;
        World world = event.getWorld();
        int id = world.provider.getDimension();
        Entity entity = event.getEntity();
        if (entity instanceof IMob && PeacefulAreaManager.isPeaceful(new GlobalCoordinate(coordinate = new BlockPos((int)entity.posX, (int)entity.posY, (int)entity.posZ), id))) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath() && event.getOriginal().hasCapability(PlayerExtendedProperties.FAVORITE_DESTINATIONS_CAPABILITY, null)) {
            FavoriteDestinationsProperties oldFavorites = (FavoriteDestinationsProperties)event.getOriginal().getCapability(PlayerExtendedProperties.FAVORITE_DESTINATIONS_CAPABILITY, null);
            FavoriteDestinationsProperties newFavorites = PlayerExtendedProperties.getFavoriteDestinations(event.getEntityPlayer());
            newFavorites.copyFrom(oldFavorites);
        }
    }

    @SubscribeEvent
    public void onPostWorldTick(TickEvent.WorldTickEvent event) {
        if (!event.world.isRemote) {
            TickOrderHandler.postWorldTick(event.world.provider.getDimension());
        }
    }
}

