/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools;

import java.util.List;
import mcjty.lib.McJtyLib;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.preferences.PreferencesProperties;
import mcjty.rftools.PlayerBuff;
import mcjty.rftools.blocks.environmental.EnvironmentalSetup;
import mcjty.rftools.items.GenericRFToolsItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class RenderGameOverlayEventHandler {
    private static final int BUFF_ICON_SIZE = 16;
    public static List<PlayerBuff> buffs = null;

    public static void onRender(RenderGameOverlayEvent event) {
        if (event.isCanceled() || event.getType() != RenderGameOverlayEvent.ElementType.POTION_ICONS) {
            return;
        }
        RenderGameOverlayEventHandler.renderBuffs();
    }

    private static void renderBuffs() {
        if (buffs == null || buffs.isEmpty()) {
            return;
        }
        EntityPlayerSP player = Minecraft.getMinecraft().player;
        PreferencesProperties preferences = McJtyLib.getPreferencesProperties((EntityPlayer)player);
        int x = preferences.getBuffX();
        int y = preferences.getBuffY();
        if (x == -1 || y == -1) {
            return;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        for (PlayerBuff buff : buffs) {
            Item item = RenderGameOverlayEventHandler.getBuffItem(buff);
            if (item == null) continue;
            RenderItem itemRender = Minecraft.getMinecraft().getRenderItem();
            RenderHelper.renderItemStack((Minecraft)Minecraft.getMinecraft(), (RenderItem)itemRender, (ItemStack)new ItemStack(item), (int)x, (int)y, (String)"", (boolean)false);
            x += 16;
        }
    }

    private static Item getBuffItem(PlayerBuff buff) {
        GenericRFToolsItem item;
        switch (buff) {
            case BUFF_FEATHERFALLING: {
                item = EnvironmentalSetup.featherFallingEModuleItem;
                break;
            }
            case BUFF_FEATHERFALLINGPLUS: {
                item = EnvironmentalSetup.featherFallingPlusEModuleItem;
                break;
            }
            case BUFF_HASTE: {
                item = EnvironmentalSetup.hasteEModuleItem;
                break;
            }
            case BUFF_HASTEPLUS: {
                item = EnvironmentalSetup.hastePlusEModuleItem;
                break;
            }
            case BUFF_REGENERATION: {
                item = EnvironmentalSetup.regenerationEModuleItem;
                break;
            }
            case BUFF_REGENERATIONPLUS: {
                item = EnvironmentalSetup.regenerationPlusEModuleItem;
                break;
            }
            case BUFF_SATURATION: {
                item = EnvironmentalSetup.saturationEModuleItem;
                break;
            }
            case BUFF_SATURATIONPLUS: {
                item = EnvironmentalSetup.saturationPlusEModuleItem;
                break;
            }
            case BUFF_SPEED: {
                item = EnvironmentalSetup.speedEModuleItem;
                break;
            }
            case BUFF_SPEEDPLUS: {
                item = EnvironmentalSetup.speedPlusEModuleItem;
                break;
            }
            case BUFF_FLIGHT: {
                item = EnvironmentalSetup.flightEModuleItem;
                break;
            }
            case BUFF_PEACEFUL: {
                item = EnvironmentalSetup.peacefulEModuleItem;
                break;
            }
            case BUFF_GLOWING: {
                item = EnvironmentalSetup.glowingEModuleItem;
                break;
            }
            case BUFF_WATERBREATHING: {
                item = EnvironmentalSetup.waterBreathingEModuleItem;
                break;
            }
            case BUFF_NIGHTVISION: {
                item = EnvironmentalSetup.nightVisionEModuleItem;
                break;
            }
            case BUFF_BLINDNESS: {
                item = EnvironmentalSetup.blindnessEModuleItem;
                break;
            }
            case BUFF_WEAKNESS: {
                item = EnvironmentalSetup.weaknessEModuleItem;
                break;
            }
            case BUFF_POISON: {
                item = EnvironmentalSetup.poisonEModuleItem;
                break;
            }
            case BUFF_SLOWNESS: {
                item = EnvironmentalSetup.slownessEModuleItem;
                break;
            }
            case BUFF_LUCK: {
                item = EnvironmentalSetup.luckEModuleItem;
                break;
            }
            case BUFF_NOTELEPORT: {
                item = EnvironmentalSetup.noTeleportEModuleItem;
                break;
            }
            default: {
                item = null;
            }
        }
        return item;
    }
}

