/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.crafter;

import mcjty.lib.container.BaseSlot;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.container.SlotFactory;
import mcjty.lib.container.SlotType;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftools.blocks.crafter.CrafterBaseTE;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class CrafterContainer
extends GenericContainer {
    public static final String CONTAINER_INVENTORY = "container";
    public static final int SLOT_CRAFTINPUT = 0;
    public static final int SLOT_CRAFTOUTPUT = 9;
    public static final int SLOT_BUFFER = 10;
    public static final int BUFFER_SIZE = 26;
    public static final int SLOT_BUFFEROUT = 36;
    public static final int BUFFEROUT_SIZE = 4;
    public static final int SLOT_FILTER_MODULE = 40;
    private final CrafterBaseTE crafterBaseTE;
    public static final ContainerFactory CONTAINER_FACTORY = new ContainerFactory(new ResourceLocation("rftools", "gui/crafter.gui"));

    public CrafterBaseTE getCrafterTE() {
        return this.crafterBaseTE;
    }

    public CrafterContainer(EntityPlayer player, IInventory containerInventory) {
        super(CONTAINER_FACTORY);
        this.crafterBaseTE = (CrafterBaseTE)containerInventory;
        this.addInventory(CONTAINER_INVENTORY, containerInventory);
        this.addInventory("player", (IInventory)player.inventory);
        this.generateSlots();
    }

    protected Slot createSlot(SlotFactory slotFactory, IInventory inventory, int index, int x, int y, SlotType slotType) {
        if (index >= 10 && index < 36 && slotType == SlotType.SLOT_INPUT) {
            return new BaseSlot(inventory, index, x, y){

                public boolean isItemValid(ItemStack stack) {
                    if (!CrafterContainer.this.crafterBaseTE.isItemValidForSlot(this.getSlotIndex(), stack)) {
                        return false;
                    }
                    return super.isItemValid(stack);
                }

                public void onSlotChanged() {
                    ((CrafterContainer)CrafterContainer.this).crafterBaseTE.noRecipesWork = false;
                    super.onSlotChanged();
                }
            };
        }
        if (index >= 36 && index < 40) {
            return new BaseSlot(inventory, index, x, y){

                public boolean isItemValid(ItemStack stack) {
                    if (!CrafterContainer.this.crafterBaseTE.isItemValidForSlot(this.getSlotIndex(), stack)) {
                        return false;
                    }
                    return super.isItemValid(stack);
                }

                public void onSlotChanged() {
                    ((CrafterContainer)CrafterContainer.this).crafterBaseTE.noRecipesWork = false;
                    super.onSlotChanged();
                }
            };
        }
        return super.createSlot(slotFactory, inventory, index, x, y, slotType);
    }

    public ItemStack slotClick(int index, int button, ClickType mode, EntityPlayer player) {
        if (mode == ClickType.QUICK_MOVE && index >= 10 && index < 36) {
            int offset = index - 10;
            ItemStackList ghostSlots = this.crafterBaseTE.getGhostSlots();
            ItemStack ghostSlot = (ItemStack)ghostSlots.get(offset);
            ItemStack clickedWith = player.inventory.getItemStack();
            if (!ghostSlot.isEmpty() && !ghostSlot.isItemEqual(clickedWith)) {
                ItemStack copy = clickedWith.copy();
                copy.setCount(1);
                ghostSlots.set(offset, (Object)copy);
                this.detectAndSendChanges();
                return ItemStack.EMPTY;
            }
        }
        return super.slotClick(index, button, mode, player);
    }
}

