/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.endergen;

import java.util.List;
import java.util.function.BiFunction;
import mcjty.lib.base.ModBase;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.endergen.EnderMonitorMode;
import mcjty.rftools.blocks.endergen.EnderMonitorTileEntity;
import mcjty.rftools.blocks.endergen.GuiEnderMonitor;
import mcjty.rftools.setup.GuiProxy;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnderMonitorBlock
extends LogicSlabBlock<EnderMonitorTileEntity, EmptyContainer> {
    public EnderMonitorBlock() {
        super((ModBase)RFTools.instance, Material.IRON, EnderMonitorTileEntity.class, EmptyContainer::new, "ender_monitor", false);
        this.setCreativeTab(RFTools.setup.getTab());
    }

    public boolean needsRedstoneCheck() {
        return false;
    }

    public int getGuiID() {
        return GuiProxy.GUI_ENDERMONITOR;
    }

    @SideOnly(value=Side.CLIENT)
    public BiFunction<EnderMonitorTileEntity, EmptyContainer, GenericGuiContainer<? super EnderMonitorTileEntity>> getGuiFactory() {
        return GuiEnderMonitor::new;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, World player, List<String> list, ITooltipFlag whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.getTagCompound();
        if (tagCompound != null) {
            int mode = tagCompound.getInteger("mode");
            String smode = EnderMonitorMode.values()[mode].getDescription();
            list.add(TextFormatting.GREEN + "Mode: " + smode);
        }
    }
}

