/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.endergen;

import mcjty.lib.client.RenderGlowEffect;
import mcjty.lib.client.RenderHelper;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.endergen.EndergenicTileEntity;
import mcjty.rftools.hud.HudRenderer;
import mcjty.rftools.items.smartwrench.SmartWrenchItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class EndergenicRenderer
extends TileEntitySpecialRenderer<EndergenicTileEntity> {
    private ResourceLocation halo = new ResourceLocation("rftools", "textures/entities/floatingpearl.png");
    private ResourceLocation whiteflash = new ResourceLocation("rftools", "textures/entities/whiteflash.png");
    private ResourceLocation blackflash = new ResourceLocation("rftools", "textures/entities/redflash.png");
    private static final ResourceLocation redglow = new ResourceLocation("rftools", "textures/blocks/redglow.png");
    private static final ResourceLocation blueglow = new ResourceLocation("rftools", "textures/blocks/blueglow.png");

    public void render(EndergenicTileEntity tileEntity, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        boolean showOverlay;
        Tessellator tessellator = Tessellator.getInstance();
        BlockPos coord = tileEntity.getPos();
        if (coord.equals((Object)RFTools.instance.clientInfo.getSelectedTE())) {
            this.bindTexture(redglow);
            RenderGlowEffect.renderGlow((Tessellator)tessellator, (double)x, (double)y, (double)z);
        } else if (coord.equals((Object)RFTools.instance.clientInfo.getDestinationTE())) {
            this.bindTexture(blueglow);
            RenderGlowEffect.renderGlow((Tessellator)tessellator, (double)x, (double)y, (double)z);
        }
        GlStateManager.depthMask((boolean)false);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)1, (int)1);
        GlStateManager.disableAlpha();
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        this.bindTexture(this.halo);
        float s = (float)(System.currentTimeMillis() % 1000L) / 1000.0f;
        if (s > 0.5f) {
            s = 1.0f - s;
        }
        RenderHelper.renderBillboardQuadBright((double)(0.2f + s * 0.3f));
        GlStateManager.blendFunc((int)770, (int)1);
        if (tileEntity.getGoodCounter() > 0) {
            this.bindTexture(this.whiteflash);
            RenderHelper.renderBillboardQuadBright((double)(0.8f * ((float)tileEntity.getGoodCounter() / 10.0f)));
        }
        if (tileEntity.getBadCounter() > 0) {
            this.bindTexture(this.blackflash);
            RenderHelper.renderBillboardQuadBright((double)(0.8f * ((float)tileEntity.getBadCounter() / 20.0f)));
        }
        GlStateManager.popMatrix();
        ItemStack mainHand = Minecraft.getMinecraft().player.getHeldItemMainhand();
        ItemStack offHand = Minecraft.getMinecraft().player.getHeldItemOffhand();
        boolean bl = showOverlay = !mainHand.isEmpty() && mainHand.getItem() instanceof SmartWrenchItem || !offHand.isEmpty() && offHand.getItem() instanceof SmartWrenchItem;
        if (showOverlay) {
            HudRenderer.renderHud(tileEntity, x, y, z);
        }
    }

    public static void register() {
        ClientRegistry.bindTileEntitySpecialRenderer(EndergenicTileEntity.class, (TileEntitySpecialRenderer)new EndergenicRenderer());
    }
}

