/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.environmental;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import mcjty.lib.api.information.IMachineInformation;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.ScrollableLabel;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.ModuleSupport;
import mcjty.lib.varia.RedstoneMode;
import mcjty.rftools.blocks.environmental.EnvModuleProvider;
import mcjty.rftools.blocks.environmental.EnvironmentalConfiguration;
import mcjty.rftools.blocks.environmental.modules.EnvironmentModule;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")})
public class EnvironmentalControllerTileEntity
extends GenericEnergyReceiverTileEntity
implements DefaultSidedInventory,
ITickable,
IMachineInformation,
SimpleComponent {
    public static final String CMD_SETRADIUS = "env.setRadius";
    public static final String CMD_RSMODE = "env.setRsMode";
    public static final String CMD_SETBOUNDS = "env.setBounds";
    public static final Key<Integer> PARAM_MIN = new Key("min", Type.INTEGER);
    public static final Key<Integer> PARAM_MAX = new Key("max", Type.INTEGER);
    public static final String CMD_SETMODE = "env.setBlacklist";
    public static final Key<Integer> PARAM_MODE = new Key("mode", Type.INTEGER);
    public static final String CMD_ADDPLAYER = "env.addPlayer";
    public static final String CMD_DELPLAYER = "env.delPlayer";
    public static final Key<String> PARAM_NAME = new Key("name", Type.STRING);
    public static final String CMD_GETPLAYERS = "getPlayers";
    public static final String CLIENTCMD_GETPLAYERS = "getPlayers";
    public static final String COMPONENT_NAME = "environmental_controller";
    public static final int ENV_MODULES = 7;
    public static final ContainerFactory CONTAINER_FACTORY = new ContainerFactory(new ResourceLocation("rftools", "gui/environmental.gui"));
    public static final int SLOT_MODULES = 0;
    public static final ModuleSupport MODULE_SUPPORT = new ModuleSupport(0, 6){

        public boolean isModule(ItemStack itemStack) {
            return itemStack.getItem() instanceof EnvModuleProvider;
        }
    };
    public static final String CONTAINER_INVENTORY = "container";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, CONTAINER_FACTORY, 7);
    private List<EnvironmentModule> environmentModules = null;
    Set<String> players = new HashSet<String>();
    private EnvironmentalMode mode = EnvironmentalMode.MODE_BLACKLIST;
    private int totalRfPerTick = 0;
    private int radius = 50;
    private int miny = 30;
    private int maxy = 70;
    private int volume = -1;
    private boolean active = false;
    private int powerTimeout = 0;

    public EnvironmentalControllerTileEntity() {
        super((long)EnvironmentalConfiguration.ENVIRONMENTAL_MAXENERGY.get(), (long)EnvironmentalConfiguration.ENVIRONMENTAL_RECEIVEPERTICK.get());
    }

    public long getEnergyDiffPerTick() {
        return this.isActive() ? (long)(-this.getTotalRfPerTick()) : 0L;
    }

    @Nullable
    public String getEnergyUnitName() {
        return "RF";
    }

    public boolean isMachineActive() {
        return this.isActive();
    }

    public boolean isMachineRunning() {
        return this.isActive();
    }

    @Nullable
    public String getMachineStatus() {
        return this.isActive() ? "active" : "idle";
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    @Optional.Method(modid="opencomputers")
    public String getComponentName() {
        return COMPONENT_NAME;
    }

    @Callback(doc="Get or set the current redstone mode. Values are 'Ignored', 'Off', or 'On'", getter=true, setter=true)
    @Optional.Method(modid="opencomputers")
    public Object[] redstoneMode(Context context, Arguments args) {
        if (args.count() == 0) {
            return new Object[]{this.getRSMode().getDescription()};
        }
        String mode = args.checkString(0);
        return this.setRedstoneMode(mode);
    }

    public EnvironmentalMode getMode() {
        return this.mode;
    }

    public void setMode(EnvironmentalMode mode) {
        this.mode = mode;
        this.markDirtyClient();
    }

    private float getPowerMultiplier() {
        switch (this.mode) {
            case MODE_BLACKLIST: 
            case MODE_WHITELIST: {
                return 1.0f;
            }
            case MODE_HOSTILE: 
            case MODE_PASSIVE: 
            case MODE_MOBS: 
            case MODE_ALL: {
                return (float)EnvironmentalConfiguration.mobsPowerMultiplier.get();
            }
        }
        return 1.0f;
    }

    public boolean isEntityAffected(Entity entity) {
        switch (this.mode) {
            case MODE_BLACKLIST: {
                if (entity instanceof EntityPlayer) {
                    return this.isPlayerAffected((EntityPlayer)entity);
                }
                return false;
            }
            case MODE_WHITELIST: {
                if (entity instanceof EntityPlayer) {
                    return this.isPlayerAffected((EntityPlayer)entity);
                }
                return false;
            }
            case MODE_HOSTILE: {
                return entity instanceof IMob;
            }
            case MODE_PASSIVE: {
                return entity instanceof IAnimals && !(entity instanceof IMob);
            }
            case MODE_MOBS: {
                return entity instanceof IAnimals;
            }
            case MODE_ALL: {
                if (entity instanceof EntityPlayer) {
                    return this.isPlayerAffected((EntityPlayer)entity);
                }
                return true;
            }
        }
        return false;
    }

    public boolean isPlayerAffected(EntityPlayer player) {
        if (this.mode == EnvironmentalMode.MODE_WHITELIST) {
            return this.players.contains(player.getName());
        }
        if (this.mode == EnvironmentalMode.MODE_BLACKLIST) {
            return !this.players.contains(player.getName());
        }
        return this.mode == EnvironmentalMode.MODE_ALL;
    }

    private List<String> getPlayersAsList() {
        return new ArrayList<String>(this.players);
    }

    private void addPlayer(String player) {
        if (!this.players.contains(player)) {
            this.players.add(player);
            this.markDirtyClient();
        }
    }

    private void delPlayer(String player) {
        if (this.players.contains(player)) {
            this.players.remove(player);
            this.markDirtyClient();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public int getTotalRfPerTick() {
        if (this.environmentModules == null) {
            this.getEnvironmentModules();
        }
        int rfNeeded = (int)((float)this.totalRfPerTick * this.getPowerMultiplier() * (4.0f - this.getInfusedFactor()) / 4.0f);
        if (this.environmentModules.isEmpty()) {
            return rfNeeded;
        }
        if (rfNeeded < EnvironmentalConfiguration.MIN_USAGE.get()) {
            rfNeeded = EnvironmentalConfiguration.MIN_USAGE.get();
        }
        return rfNeeded;
    }

    public int getVolume() {
        if (this.volume == -1) {
            this.volume = (int)((double)(this.radius * this.radius) * Math.PI * (double)(this.maxy - this.miny + 1));
        }
        return this.volume;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.volume = -1;
        this.environmentModules = null;
        this.markDirtyClient();
    }

    public int getMiny() {
        return this.miny;
    }

    public void setMiny(int miny) {
        this.miny = miny;
        this.volume = -1;
        this.environmentModules = null;
        this.markDirtyClient();
    }

    public int getMaxy() {
        return this.maxy;
    }

    public void setMaxy(int maxy) {
        this.maxy = maxy;
        this.volume = -1;
        this.environmentModules = null;
        this.markDirtyClient();
    }

    public void update() {
        if (!this.getWorld().isRemote) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        if (this.powerTimeout > 0) {
            --this.powerTimeout;
            return;
        }
        long rf = this.getStoredPower();
        if (!this.isMachineEnabled()) {
            rf = 0L;
        }
        this.getEnvironmentModules();
        int rfNeeded = this.getTotalRfPerTick();
        if ((long)rfNeeded > rf || this.environmentModules.isEmpty()) {
            this.deactivate();
            this.powerTimeout = 20;
        } else {
            this.consumeEnergy(rfNeeded);
            for (EnvironmentModule module : this.environmentModules) {
                module.activate(true);
                module.tick(this.getWorld(), this.getPos(), this.radius, this.miny, this.maxy, this);
            }
            if (!this.active) {
                this.active = true;
                this.markDirtyClient();
            }
        }
    }

    public void deactivate() {
        for (EnvironmentModule module : this.environmentModules) {
            module.activate(false);
        }
        if (this.active) {
            this.active = false;
            this.markDirtyClient();
        }
    }

    private Object[] setRedstoneMode(String mode) {
        RedstoneMode redstoneMode = RedstoneMode.getMode((String)mode);
        if (redstoneMode == null) {
            throw new IllegalArgumentException("Not a valid mode");
        }
        this.setRSMode(redstoneMode);
        return null;
    }

    public void setPowerInput(int powered) {
        if (this.powerLevel != powered) {
            this.powerTimeout = 0;
        }
        super.setPowerInput(powered);
    }

    public List<EnvironmentModule> getEnvironmentModules() {
        if (this.environmentModules == null) {
            int volume = this.getVolume();
            this.totalRfPerTick = 0;
            this.environmentModules = new ArrayList<EnvironmentModule>();
            for (int i = 0; i < this.inventoryHelper.getCount(); ++i) {
                EnvironmentModule environmentModule;
                ItemStack itemStack = this.inventoryHelper.getStackInSlot(i);
                if (itemStack.isEmpty() || !(itemStack.getItem() instanceof EnvModuleProvider)) continue;
                EnvModuleProvider moduleProvider = (EnvModuleProvider)itemStack.getItem();
                Class<? extends EnvironmentModule> moduleClass = moduleProvider.getServerEnvironmentModule();
                try {
                    environmentModule = moduleClass.newInstance();
                }
                catch (InstantiationException e) {
                    Logging.log((String)"Failed to instantiate controller module!");
                    continue;
                }
                catch (IllegalAccessException e) {
                    Logging.log((String)"Failed to instantiate controller module!");
                    continue;
                }
                this.environmentModules.add(environmentModule);
                this.totalRfPerTick += (int)(environmentModule.getRfPerTick() * (float)volume);
            }
        }
        return this.environmentModules;
    }

    public int[] getSlotsForFace(EnumFacing side) {
        return CONTAINER_FACTORY.getAccessibleSlots();
    }

    public boolean canExtractItem(int index, ItemStack stack, EnumFacing direction) {
        return CONTAINER_FACTORY.isOutputSlot(index);
    }

    public boolean canInsertItem(int index, ItemStack itemStackIn, EnumFacing direction) {
        return CONTAINER_FACTORY.isInputSlot(index);
    }

    public ItemStack decrStackSize(int index, int amount) {
        this.environmentModules = null;
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public void setInventorySlotContents(int index, ItemStack stack) {
        this.inventoryHelper.setInventorySlotContents(this.getInventoryStackLimit(), index, stack);
        this.environmentModules = null;
    }

    public int getInventoryStackLimit() {
        return 1;
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return true;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.totalRfPerTick = tagCompound.getInteger("rfPerTick");
        this.active = tagCompound.getBoolean("active");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.radius = tagCompound.getInteger("radius");
        this.miny = tagCompound.getInteger("miny");
        this.maxy = tagCompound.getInteger("maxy");
        this.volume = -1;
        if (tagCompound.hasKey("whitelist")) {
            boolean wl = tagCompound.getBoolean("whitelist");
            this.mode = wl ? EnvironmentalMode.MODE_WHITELIST : EnvironmentalMode.MODE_BLACKLIST;
        } else {
            int m = tagCompound.getInteger("mode");
            this.mode = EnvironmentalMode.values()[m];
        }
        this.players.clear();
        NBTTagList playerList = tagCompound.getTagList("players", 8);
        if (playerList != null) {
            for (int i = 0; i < playerList.tagCount(); ++i) {
                String player = playerList.getStringTagAt(i);
                this.players.add(player);
            }
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.setInteger("rfPerTick", this.totalRfPerTick);
        tagCompound.setBoolean("active", this.active);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.setInteger("radius", this.radius);
        tagCompound.setInteger("miny", this.miny);
        tagCompound.setInteger("maxy", this.maxy);
        tagCompound.setInteger("mode", this.mode.ordinal());
        NBTTagList playerTagList = new NBTTagList();
        for (String player : this.players) {
            playerTagList.appendTag((NBTBase)new NBTTagString(player));
        }
        tagCompound.setTag("players", (NBTBase)playerTagList);
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_ADDPLAYER.equals(command)) {
            this.addPlayer((String)params.get(PARAM_NAME));
            return true;
        }
        if (CMD_DELPLAYER.equals(command)) {
            this.delPlayer((String)params.get(PARAM_NAME));
            return true;
        }
        if (CMD_RSMODE.equals(command)) {
            this.setRSMode(RedstoneMode.values()[(Integer)params.get(ImageChoiceLabel.PARAM_CHOICE_IDX)]);
            return true;
        }
        if (CMD_SETRADIUS.equals(command)) {
            this.setRadius((Integer)params.get(ScrollableLabel.PARAM_VALUE));
            return true;
        }
        if (CMD_SETMODE.equals(command)) {
            this.setMode(EnvironmentalMode.values()[(Integer)params.get(PARAM_MODE)]);
            return true;
        }
        if (CMD_SETBOUNDS.equals(command)) {
            this.setMiny((Integer)params.get(PARAM_MIN));
            this.setMaxy((Integer)params.get(PARAM_MAX));
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, TypedMap args, Type<T> type) {
        List rc = super.executeWithResultList(command, args, type);
        if (!rc.isEmpty()) {
            return rc;
        }
        if ("getPlayers".equals(command)) {
            return type.convert(this.getPlayersAsList());
        }
        return Collections.emptyList();
    }

    public <T> boolean receiveListFromServer(String command, List<T> list, Type<T> type) {
        boolean rc = super.receiveListFromServer(command, list, type);
        if (rc) {
            return true;
        }
        if ("getPlayers".equals(command)) {
            this.players = new HashSet<String>(Type.STRING.convert(list));
            return true;
        }
        return false;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public void onBlockBreak(World world, BlockPos pos, IBlockState state) {
        this.deactivate();
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        int rfPerTick = this.getTotalRfPerTick();
        int volume = this.getVolume();
        if (this.isActive()) {
            probeInfo.text(TextFormatting.GREEN + "Active " + rfPerTick + " RF/tick (" + volume + " blocks)");
        } else {
            probeInfo.text(TextFormatting.GREEN + "Inactive (" + volume + " blocks)");
        }
        int radius = this.getRadius();
        int miny = this.getMiny();
        int maxy = this.getMaxy();
        probeInfo.text(TextFormatting.GREEN + "Area: radius " + radius + " (between " + miny + " and " + maxy + ")");
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public void addWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.addWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tagCompound = accessor.getNBTData();
        if (tagCompound != null) {
            int rfPerTick = this.getTotalRfPerTick();
            int volume = this.getVolume();
            if (this.isActive()) {
                currenttip.add(TextFormatting.GREEN + "Active " + rfPerTick + " RF/tick (" + volume + " blocks)");
            } else {
                currenttip.add(TextFormatting.GREEN + "Inactive (" + volume + " blocks)");
            }
            int radius = this.getRadius();
            int miny = this.getMiny();
            int maxy = this.getMaxy();
            currenttip.add(TextFormatting.GREEN + "Area: radius " + radius + " (between " + miny + " and " + maxy + ")");
        }
    }

    public static enum EnvironmentalMode {
        MODE_BLACKLIST,
        MODE_WHITELIST,
        MODE_HOSTILE,
        MODE_PASSIVE,
        MODE_MOBS,
        MODE_ALL;

    }
}

