/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.environmental;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.TeleportationTools;
import mcjty.lib.varia.WorldTools;
import mcjty.rftools.blocks.environmental.EnvironmentalControllerTileEntity;
import mcjty.rftools.blocks.environmental.modules.EnvironmentModule;
import mcjty.rftools.blocks.environmental.modules.NoTeleportEModule;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class NoTeleportAreaManager {
    private static final Map<GlobalCoordinate, NoTeleportArea> areas = new HashMap<GlobalCoordinate, NoTeleportArea>();

    public static void markArea(GlobalCoordinate coordinate, int radius, int miny, int maxy) {
        if (areas.containsKey(coordinate)) {
            areas.get(coordinate).touch().setArea(radius, miny, maxy);
        } else {
            NoTeleportArea area = new NoTeleportArea(radius, miny, maxy);
            areas.put(coordinate, area);
        }
    }

    public static boolean isTeleportPrevented(Entity entity, GlobalCoordinate coordinate) {
        if (areas.isEmpty()) {
            return false;
        }
        ArrayList<GlobalCoordinate> toRemove = new ArrayList<GlobalCoordinate>();
        boolean noTeleport = false;
        long curtime = System.currentTimeMillis() - 10000L;
        for (Map.Entry<GlobalCoordinate, NoTeleportArea> entry : areas.entrySet()) {
            BlockPos c;
            World world;
            TileEntity te;
            GlobalCoordinate entryCoordinate;
            NoTeleportArea area = entry.getValue();
            if (area.in(coordinate, entryCoordinate = entry.getKey()) && (te = (world = TeleportationTools.getWorldForDimension((int)entryCoordinate.getDimension())).getTileEntity(entryCoordinate.getCoordinate())) instanceof EnvironmentalControllerTileEntity) {
                EnvironmentalControllerTileEntity controllerTileEntity = (EnvironmentalControllerTileEntity)te;
                noTeleport = controllerTileEntity.isEntityAffected(entity);
            }
            if (area.getLastTouched() >= curtime || (world = DimensionManager.getWorld((int)entryCoordinate.getDimension())) == null || !WorldTools.chunkLoaded((World)world, (BlockPos)(c = entryCoordinate.getCoordinate()))) continue;
            boolean removeArea = true;
            TileEntity te2 = world.getTileEntity(c);
            if (te2 instanceof EnvironmentalControllerTileEntity) {
                EnvironmentalControllerTileEntity controllerTileEntity = (EnvironmentalControllerTileEntity)te2;
                for (EnvironmentModule module : controllerTileEntity.getEnvironmentModules()) {
                    if (!(module instanceof NoTeleportEModule) || !((NoTeleportEModule)module).isActive()) continue;
                    removeArea = false;
                    break;
                }
            }
            if (!removeArea) continue;
            toRemove.add(entryCoordinate);
        }
        for (GlobalCoordinate globalCoordinate : toRemove) {
            areas.remove(globalCoordinate);
        }
        return noTeleport;
    }

    public static class NoTeleportArea {
        private float sqradius;
        private int miny;
        private int maxy;
        private long lastTouched;

        public NoTeleportArea(float radius, int miny, int maxy) {
            this.sqradius = radius * radius;
            this.miny = miny;
            this.maxy = maxy;
            this.touch();
        }

        public NoTeleportArea setArea(float radius, int miny, int maxy) {
            this.sqradius = radius * radius;
            this.miny = miny;
            this.maxy = maxy;
            return this;
        }

        public String toString() {
            return "NoTeleportArea{sqradius=" + this.sqradius + ", miny=" + this.miny + ", maxy=" + this.maxy + ", lastTouched=" + this.lastTouched + '}';
        }

        public long getLastTouched() {
            return this.lastTouched;
        }

        public NoTeleportArea touch() {
            this.lastTouched = System.currentTimeMillis();
            return this;
        }

        public boolean in(GlobalCoordinate coordinate, GlobalCoordinate thisCoordinate) {
            double pz;
            if (coordinate.getDimension() != thisCoordinate.getDimension()) {
                return false;
            }
            double py = coordinate.getCoordinate().getY();
            if (py < (double)this.miny || py > (double)this.maxy) {
                return false;
            }
            double px = coordinate.getCoordinate().getX() - thisCoordinate.getCoordinate().getX();
            double sqdist = px * px + (pz = (double)(coordinate.getCoordinate().getZ() - thisCoordinate.getCoordinate().getZ())) * pz;
            return sqdist < (double)this.sqradius;
        }
    }
}

