/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.itemfilter;

import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemFilterInvWrapper
implements IItemHandlerModifiable {
    private final ISidedInventory inv;
    private final EnumFacing side;

    public ItemFilterInvWrapper(ISidedInventory inv) {
        this(inv, null);
    }

    public ItemFilterInvWrapper(ISidedInventory inv, EnumFacing side) {
        this.inv = inv;
        this.side = side;
    }

    public static int getSlot(ISidedInventory inv, int slot, EnumFacing side) {
        int[] slots = inv.getSlotsForFace(side);
        if (slot < slots.length) {
            return slots[slot];
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemFilterInvWrapper that = (ItemFilterInvWrapper)o;
        if (!this.inv.equals(that.inv)) {
            return false;
        }
        return this.side == that.side;
    }

    public int hashCode() {
        int result = this.inv.hashCode();
        result = 31 * result + (this.side != null ? this.side.hashCode() : 0);
        return result;
    }

    public int getSlots() {
        return this.inv.getSlotsForFace(this.side).length;
    }

    public ItemStack getStackInSlot(int slot) {
        int i = ItemFilterInvWrapper.getSlot(this.inv, slot, this.side);
        return i == -1 ? ItemStack.EMPTY : this.inv.getStackInSlot(i);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int slot1 = ItemFilterInvWrapper.getSlot(this.inv, slot, this.side);
        if (slot1 == -1) {
            return stack;
        }
        if (!this.inv.isItemValidForSlot(slot1, stack) || !this.inv.canInsertItem(slot1, stack, this.side)) {
            return stack;
        }
        ItemStack stackInSlot = this.inv.getStackInSlot(slot1);
        if (!stackInSlot.isEmpty()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stackInSlot)) {
                return stack;
            }
            int m = Math.min(stack.getMaxStackSize(), this.inv.getInventoryStackLimit()) - stackInSlot.getCount();
            if (stack.getCount() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.copy();
                    copy.grow(stackInSlot.getCount());
                    this.inv.setInventorySlotContents(slot1, copy);
                }
                return ItemStack.EMPTY;
            }
            stack = stack.copy();
            if (!simulate) {
                ItemStack copy = stack.splitStack(m);
                copy.grow(stackInSlot.getCount());
                this.inv.setInventorySlotContents(slot1, copy);
                return stack;
            }
            int amount = -m;
            stack.grow(amount);
            return stack;
        }
        int m = Math.min(stack.getMaxStackSize(), this.inv.getInventoryStackLimit());
        if (m < stack.getCount()) {
            stack = stack.copy();
            if (!simulate) {
                this.inv.setInventorySlotContents(slot1, stack.splitStack(m));
                return stack;
            }
            int amount = -m;
            stack.grow(amount);
            return stack;
        }
        if (!simulate) {
            this.inv.setInventorySlotContents(slot1, stack);
        }
        return ItemStack.EMPTY;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.inv.setInventorySlotContents(slot, stack);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        int slot1 = ItemFilterInvWrapper.getSlot(this.inv, slot, this.side);
        if (slot1 == -1) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = this.inv.getStackInSlot(slot1);
        if (stackInSlot.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (!this.inv.canExtractItem(slot1, stackInSlot, this.side)) {
            return ItemStack.EMPTY;
        }
        if (simulate) {
            if (stackInSlot.getCount() < amount) {
                return stackInSlot.copy();
            }
            ItemStack copy = stackInSlot.copy();
            if (amount <= 0) {
                copy.setCount(0);
            } else {
                copy.setCount(amount);
            }
            return copy;
        }
        int m = Math.min(stackInSlot.getCount(), amount);
        return this.inv.decrStackSize(slot1, m);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }
}

